<%-- 费用申请列表页
 引入vue ,elementui
 打算使用es6,所以需要引入polyfill和babel转换
 引入文件
 elementui css
 elementui js
 babel.min.js
 vue.js
 polyfill.js

--%>

<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<!DOCTYPE html>
<html>
<head>
    <title>费用申请</title>
    <t:base type="jquery"></t:base>
    <!-- 引入样式 -->
    <link rel="stylesheet" href="https://unpkg.com/element-ui/lib/theme-chalk/index.css">
    <style>
        #feeApply_app .el-collapse-item__header {
            font-weight: bold;
            /*background: #f5f5f5;*/
            text-indent: 1em;
        }

        #feeApply_app .basic_info .el-input__inner {
            height: 32px;
            line-height: 32px;
        }

        #feeApply_app .key_index .el-input__inner {
            height: 32px;
        }

        #feeApply_app .key_index .el-form-item__label, #feeApply_app .basic_info .el-form-item__label {
            line-height: 16px;
        }

        #feeApply_app .title_icon_group {
            font-weight: bold;
        }

        #feeApply_app .title_icon_group > span {
            display: inline-block;
            margin: 0 10px;
            font-size: 14px;
            font-weight: normal;
            color: #666;
        }

        #feeApply_app .required_title {
            position: relative;
        }

        #feeApply_app .required_title:before {
            position: absolute;
            content: '*';
            display: block;
            width: 10px;
            height: 10px;
            color: red;
            left: -10px;
            top: -5px;
        }

        #feeApply_app td .el-form-item, #feeApply_app td .el-form {
            margin-bottom: 0;
        }

        #feeApply_app .el-dialog__header {
            margin-bottom: -40px;
        }

        /*#feeApply_app .title_icon_group>span:hover{*/
        /*    color:#666;*/
        /*}*/
    </style>
</head>
<body style="overflow-y: hidden" scroll="no">
<%--vue作用域--%>
<div id="feeApply_app">
    <%--    外部使用手风琴包裹--%>

    <el-collapse accordion v-model="activeName">
        <el-collapse-item title="基本信息">
            <el-form ref="basicInfo" :inline="true" :model="obj" :rules="basicInfoRules" label-width="122px"
                     label-position="right" size="small" class="basic_info">
                <el-row>
                    <el-col :span="6">
                        <el-form-item label="申请人" prop="head.createName">
                            <el-input v-model="obj.head.createName" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="申请人职位" prop="head.positionName">
                            <el-input v-model="obj.head.positionName" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="申请人所属公司" prop="head.extChar2">
                            <el-input v-model="obj.head.extChar2" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="申请人所在大区" prop="extChar4">
                            <el-input v-model="obj.head.extChar4" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                </el-row>
                <el-row>
                    <el-col :span="6">
                        <el-form-item label="申请人所在区域" prop="extChar6">
                            <el-input v-model="obj.head.extChar6" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="申请人所在办事处" prop="extChar8">
                            <el-input v-model="obj.head.extChar8" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="申请人所在城市" prop="extChar10">
                            <el-input v-model="obj.head.extChar10" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="申请人所在部门" prop="extChar49">
                            <el-input v-model="obj.head.extChar49" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                </el-row>
                <el-row>
                    <el-col :span="6">
                        <el-form-item label="活动名称" prop="head.actName">
                            <el-input v-model="obj.head.actName" placeholder="活动名称"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="销售组织" prop="head.extChar20">
                            <el-input v-model="obj.head.extChar20" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="客户名称" prop="head.extChar12">
                            <el-autocomplete
                                    size="mini"
                                    v-model="obj.head.extChar12"
                                    :fetch-suggestions="(queryStr,callback)=>getDropdownList(queryStr,callback,'head.extChar12')"
                                    @select="(row)=> {handlePickDropdown(row,'head.extChar12')}">
                                <i slot="suffix" class="el-input__icon el-icon-search"
                                   @click="openModal('head.extChar12')"></i>
                            </el-autocomplete>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="客户分组" prop="extChar14">
                            <el-input v-model="obj.head.extChar14" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                </el-row>
                <el-row>
                    <el-col :span="6">
                        <el-form-item label="系统" prop="head.extChar18">
                            <el-autocomplete
                                    size="mini"
                                    v-model="obj.head.extChar18"
                                    @select="(row)=> handlePickDropdown(row,'head.extChar18')"
                                    :fetch-suggestions="(queryStr,callback)=>getDropdownList(queryStr,callback,'head.extChar18')">
                                <i slot="suffix" class="el-input__icon el-icon-search"
                                   @click="openModal('head.extChar18')"></i>
                            </el-autocomplete>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="一级品类" prop="head.extChar16">
                            <el-autocomplete
                                    size="mini"
                                    v-model="obj.head.extChar16"
                                    :fetch-suggestions="(queryStr,callback)=>getDropdownList(queryStr,callback,'head.extChar16')"
                                    @select="(row)=> handlePickDropdown(row,'head.extChar16')">
                                <i slot="suffix" class="el-input__icon el-icon-search"
                                   @click="openModal('head.extChar16')"></i>
                            </el-autocomplete>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="是否计入费比" prop="extChar22">
                            <el-input v-model="obj.head.extChar22" readonly></el-input>
                        </el-form-item>
                    </el-col>
                </el-row>
            </el-form>
        </el-collapse-item>
        <el-collapse-item title="关键指标">
            <el-form ref="keyIndex" :inline="true" :model="obj" label-width="120px" size="small"
                     label-position="right" class="key_index">
                <el-row>
                    <el-col :span="6">
                        <el-form-item label="客户门店数量" prop="extChar23">
                            <el-input v-model="obj.head.extChar23" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="已卖入产品数量" prop="extChar27">
                            <el-input v-model="obj.head.extChar27" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="年度销售目标（元）" prop="extChar31">
                            <el-input v-model="obj.head.extChar31" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="年度预算费用总额（元）" prop="extChar35">
                            <el-input v-model="obj.head.extChar35" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                </el-row>
                <el-row>
                    <el-col :span="6">
                        <el-form-item label="年度预算费比（%）" prop="extChar40">
                            <el-input v-model="obj.head.extChar40" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="申请前可用预算余额（元）" prop="extChar39">
                            <el-input v-model="obj.head.extChar39" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="申请前实际累计出货额（元）" prop="extChar24">
                            <el-input v-model="obj.head.extChar24" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="实际申请费用额（元）" prop="annualBudgetTotal">
                            <el-input v-model="obj.annualBudgetTotal" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                </el-row>
                <el-row>
                    <el-col :span="6">
                        <el-form-item label="本次申请总额（元)" prop="extChar32">
                            <el-input v-model="obj.head.extChar32" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="申请前费比（%）" prop="extChar25">
                            <el-input v-model="obj.head.extChar25" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="申请后费比（%）" prop="extChar29">
                            <el-input v-model="obj.head.extChar29" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="申请后可用费用" prop="extChar36">
                            <el-input v-model="obj.head.extChar36" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                </el-row>
                <el-row>
                    <el-col :span="6">
                        <el-form-item label="本次申请费用率（%）" prop="extChar33">
                            <el-input v-model="obj.head.extChar33" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="本次申请净供货折扣率（%）" prop="appliedDiscountRatio">
                            <el-input v-model="obj.appliedDiscountRatio" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="YTD费率（%）" prop="extChar37">
                            <el-input v-model="obj.head.extChar37" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="YTD净供货折扣率" prop="extChar30">
                            <el-input v-model="obj.head.extChar30" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                </el-row>
                <el-row>
                    <el-col :span="6">
                        <el-form-item label="YTD费率（含预估%）" prop="extChar41">
                            <el-input v-model="obj.head.extChar41" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="YTD净供货折扣率（含预估%）" prop="extChar26">
                            <el-input v-model="obj.head.extChar26" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="标准净供货折扣（%)" prop="extChar34">
                            <el-input v-model="obj.head.extChar34" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                    <el-col :span="6">
                        <el-form-item label="净供货折扣率是否超红线" prop="extChar38">
                            <el-input v-model="obj.head.extChar38" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                </el-row>
                <el-row>
                    <el-col :span="6">
                        <el-form-item label="是否预算内" prop="isWithinBudget">
                            <el-input v-model="obj.isWithinBudget" readonly="true"></el-input>
                        </el-form-item>
                    </el-col>
                </el-row>
            </el-form>

        </el-collapse-item>

        <el-collapse-item name="1">
            <template slot="title">
                <h3 class="collapse_title">费用明细</h3>
                <p class="title_icon_group">
                    <span @click="addRow">
                         <i class="el-icon-plus"></i>新增
                    </span>
                    <span>
                        <i class="el-icon-plus"></i>复制新增
                    </span>
                    <span>
                        <i class="el-icon-plus"></i>编辑
                    </span>
                    <span>
                        <i class="el-icon-plus"></i>分摊
                    </span>
                    <span>
                        <i class="el-icon-plus"></i>暂存
                    </span>
                </p>
            </template>
            <%--                表格部分 --%>
            <el-table
                    ref="multipleTable"
                    :data="tableData"
                    size="small"
                    style="wdith:100%"
                    @selection-change="handleSelect">
                <template slot-scope="scope">
                    <el-table-column
                            type="selection"
                            width="55">
                    </el-table-column>
                    <el-table-column v-for="(item,index) in tableColumns"
                                     :label="item.label"
                                     :type="item.type"
                                     :width="item.width"
                                     :fixed="item.prop==='operationGroup' ? 'right': null"
                                     :render-header="item.isRenderHeader? renderHeader : null"
                                     :key="index">
                        <template slot-scope="scope">
                            <%--                            分别处理可编辑不可编辑--%>
                            <template v-if="!item.isEdit">
                                <span v-if="item.prop === 'operationGroup'">
                                      <a href="javascript:;" style="color:red;">删除</a>
                                </span>
                                <span v-else>
                                      {{scope.row[item.prop]}}
                                </span>


                            </template>
                            <el-form :model="scope.row" :rules="rules" v-if="item.isEdit">
                                <el-form-item :prop="scope.row[item.prop]">

                                    <el-autocomplete
                                            size="mini"
                                            v-model="scope.row[item.prop]"
                                            :fetch-suggestions="(queryStr,callback)=>getDropdownList(queryStr,callback,'')"
                                            @select="(row)=> {handlePickDropdown(row,scope.row[item.prop])}">
                                        <i slot="suffix" class="el-input__icon el-icon-search"
                                           @click="openModal(item.prop)"></i>
                                    </el-autocomplete>
                                </el-form-item>
                            </el-form>
                        </template>
                    </el-table-column>
                </template>
            </el-table>
        </el-collapse-item>
    </el-collapse>
</div>

<!-- 引入组件库 -->
<script type="text/javascript" src="https://unpkg.com/@babel/standalone/babel.min.js"></script>
<script type="text/javascript" src="https://cdn.bootcss.com/babel-polyfill/7.8.7/polyfill.js"></script>
<script src="https://cdn.bootcss.com/vue/2.6.11/vue.min.js"></script>
<script type="text/javascript" src="https://unpkg.com/element-ui/lib/index.js"></script>

<script type="text/babel">

    const vm = new Vue({
            el: '#feeApply_app',

            data() {
                return {
                    activeName: '1', // 手风琴默认第一个打开；
                    //需要校验的form表单对象, 分为三个部分，basicInfo,keyIndex,feeDetail
                    obj: {head: {}},
                    basicInfoRules: {
                        //basicInfo
                        'head.createName': {required: true, message: '申请人不能为空', trigger: 'blur'},
                        'head.positionName': {required: true, message: '申请人职位不能为空', trigger: 'blur'},
                        'head.extChar2': {required: true, message: '申请人所属公司不能为空', trigger: 'blur'},
                        'head.actName': {required: true, message: '活动名称不能为空', trigger: 'blur'},
                        'head.extChar20': {required: true, message: '销售组织不能为空', trigger: 'blur'},
                        'head.extChar12': {required: true, message: '客户名称不能为空', trigger: 'change'},
                        'head.extChar18': {required: true, message: '系统不能为空', trigger: 'change'},
                        'head.extChar16': {required: true, message: '一级品类不能为空', trigger: 'change'}
                    },
                    tableData: [{
                        budgetCode: 'sssda',
                        activeCat: '聚餐',
                        storeName: '旗舰店',
                        subSeries: '耳机系列',
                        activeTime: '2012-11-11',
                        belongToMonth: '二月',
                        applyAmount: '申请金额',
                        preSale: '11221',
                        preSaleOut: '1111',
                        leftAvailable: 222,
                        patchStatus: '未分摊',
                        notes: '这个是备注',
                    }],
                    //动态定义表头
                    tableColumns: [
                        {
                            prop: 'budgetCode',
                            label: '预算编码',
                            isRenderHeader: true,
                            width: '200px',

                        }, {
                            prop: 'activeCat',
                            label: '活动细类',
                            isRenderHeader: true,
                            width: '200px',
                            isEdit: true,
                        }, {
                            prop: 'storeName',
                            label: '门店名称',
                            width: '200px',
                            isEdit: true,
                        }, {
                            prop: 'subSeries',
                            label: '二级系列',
                            width: '200px',
                            isEdit: true,

                        }, {
                            prop: 'activeTime',
                            label: '活动时间',
                            isRenderHeader: true,
                            width: '200px',
                            isEdit: true,
                        }, {
                            prop: 'belongToMonth',
                            label: '费用所属月份',
                            isRenderHeader: true,
                            width: '200px'
                        }, {
                            prop: 'applyAmount',
                            label: '申请金额（元）',
                            isRenderHeader: true,
                            width: '200px',
                            isEdit: true,
                        }, {
                            prop: 'preSale',
                            label: '预估销售额（元）',
                            isRenderHeader: true,
                            width: '200px',
                            isEdit: true,
                        }, {
                            prop: 'preSaleOut',
                            label: '预估出库额（元)',
                            isRenderHeader: true,
                            width: '200px',
                            isEdit: true,
                        }, {
                            prop: 'leftAvailable',
                            label: '可用余额（元）',
                            width: '200px'

                        }, {
                            prop: 'patchStatus',
                            label: '分摊状态',
                            width: '200px'

                        }, {
                            prop: 'notes',
                            label: '备注',
                            width: '200px',
                            isEdit: true,
                        }, {
                            prop: 'upload',
                            label: '附件上传',
                            width: '200px',
                            isEdit: true,
                        }, {
                            prop: 'operationGroup',
                            label: '操作',
                            fixed: 'right',
                            width: '100px',
                        }],
                    rules: {},
                    dialogTitle: '', // 弹窗的标题
                    dropDownData: [], // 下拉的数据；
                }

            },
            mounted() {
                this.getData();
            },
            methods: {
                //新增
                addRow() {

                },
                getData() {
                    let id = '';
                    let self = this;
                    $.ajax({
                        type: "GET",
                        url: "/act/feeapplyController/getFeeapplyDetail",
                        data: {id},
                        success: function (data) {
                            console.log(data)
                            if (data.success) {
                                self.obj = data.obj;
                            }
                        },

                        complete: function () {

                        }
                    })
                },
                //自定义表头
                renderHeader(h, {column, $index}) {
                    return h('span', {
                        attrs: {
                            class: 'cell',
                        },
                        domProps: {
                            innerHTML: '<span class="required_title">' + column.label + '</span>'
                        }
                    })

                },
                //复选框勾选
                handleSelect() {

                },
                // 用户输入拉取下拉列表，根据传入的url进行选择，并赋值给dropDowndata,每次在请求之前重置，以免缓存；
                getDropdownList(queryStr, callback, type) {
                    console.log('input')
                    let ajaxUrls = [{
                        field: 'head.extChar12',
                        url: '/kernel/mdmCustomerController/getTmActCustomerList?clickFunctionId=${clickFunctionId}',
                        queryStr: 'customerName',
                    }, {
                        field: 'head.extChar18',
                        url: '/kernel/tmApiOrganController/findOrgListMainPage?clickFunctionId=${clickFunctionId}',
                        queryStr: 'nameText',
                    }, {
                        field: 'head.extChar16',
                        url: '/mdm-api/mdmApi/productLevelApiCotroller/findProductListByPage?clickFunctionId=${clickFunctionId}',
                        queryStr: 'productName',
                    }, {
                        field: 'head.extChar20',
                        url: '',
                        queryStr: '',
                    }];
                    let index = ajaxUrls.findIndex(item => item.field === type);

                    let self = this;
                    $.ajax({
                        type: "POST",
                        url: ajaxUrls[index].url,
                        data: {
                            [ajaxUrls[index].queryStr]: queryStr,
                            page: 1,
                            rows: 15,

                        },
                        success: function (data) {
                            if (data.success) {
                                data.rows.map(item => {
                                    if (index > -1) {
                                        item.value = item[ajaxUrls[index].queryStr];
                                    } else {
                                        item.value = '';
                                    }

                                })
                                console.log( data.rows, 111)
                                callback(data.rows)
                            }
                        },

                        complete: function () {

                        }
                    })

                },
                // 选中下拉列表一项,选中后赋值给对应的输入框
                handlePickDropdown(currentRow, type) {
                    console.log(currentRow)
                    console.log(type)
                    let self = this;

                    if (type === 'head.extChar12') {
                        self.obj.head.extChar11 = currentRow.customerCode;
                        self.obj.head.extChar12 = currentRow.customerName;
                        self.obj.head.extChar13 = currentRow.extChar17;
                        self.obj.head.extChar14 = currentRow.extChar17;// 待转化dealer ： 间供 term：直供 self：自营 qt：总部其他客户
                    } else if (type === 'head.extChar18') {
                        self.obj.head.extChar18 = currentRow.nameText; // 名称
                        self.obj.head.extChar17 = currentRow.codeText; // 编码
                    } else if (type === 'head.extChar16') {

                        self.obj.head.extChar16 = currentRow.productName; // 名称
                        self.obj.head.extChar15 = currentRow.productCode; // 编码
                    }
                    let combineObj = Object.assign({}, self.obj);
                    self.obj = combineObj;
                },
                // 公共方法，在打开时候，根据传入的参数，获取不同数据，进行渲染；
                openModal(type) {
                    let self = this;
                    let ajaxUrls = {
                        'head.extChar12': '/page/tmApiCustomerController/goActCustomerListMain?clickFunctionId=${clickFunctionId}', // 客户
                        'head.extChar18': '/page/tmApiOrgController/goOrgListMainPage?singleSelect=false&clickFunctionId=${clickFunctionId}', // 系统
                        'head.extChar16': '/page/tmApiProductLevelController/goProductListMain?clickFunctionId=${clickFunctionId}', // 一级分类
                        'head.extChar20': '', // 销售组织
                    }
                    //获取客户组织（编号，名称）
                    // let triggerId = "#custOrgCode";
                    // let triggerName = "#custOrgName";
                    let url = ajaxUrls[type];
                    let width = 1100;
                    let height = 700;
                    safeShowDialog({
                        content: "url:" + url,
                        lock: true,
                        title: "选择",
                        width: width == null ? 700 : width,
                        height: height == null ? 400 : height,
                        cache: false,
                        ok: function () {
                            let id;
                            if (type === 'head.extChar12') {
                                id = 'customerList'
                            } else if (type === 'head.extChar18') {
                                id = 'orgListMain';
                            } else if (type === 'head.extChar16') {
                                id = 'productLevelList';
                            }

                            iframe = this.iframe.contentWindow;
                            var rowsData = iframe.$('#' + id).datagrid('getSelections');
                            if (rowsData.length !== 1) {
                                iframe.tip('请选择一条数据');
                                return false;
                            } else {
                                self.handlePickDropdown(rowsData[0], type)
                                return true;
                            }
                        },
                        cancelVal: '关闭',
                        cancel: true
                    });
                }
            }

        }
    )
</script>
</body>

</html>