<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>添加活动</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        .layout-split-north {
            border-bottom: 1px solid #0072ae00;
        }
        #content{
            padding:0px !important;
        }
    </style>
</head>
<body class="easyui-layout" fit="true">
<div data-options="region:'north',split:true" style="height:200px;">
    <div class="form-group" id="app">
        <%--关键指标html开始--%>
        <target-table ref="targetTable" :id="id" :page="page" :show-target="isActiviti" :view-status="viewStatus"
                      @refresh="handleRefresh"></target-table>
        <%--关键指标html结束--%>
    </div>
    <t:formvalid action="/act/ttActDepartUseController/saveOrUpdate" beforeSubmit="checkproductSubmit" layout="div"
                 dialog="true" formid="detailId">
        <t:dgFormList layoutStyle="horizontal" expandParam="${clickFunctionId}" tagConf="${clickFunctionId}">
            <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                            defaultVal="${vo.id }"/>
            <t:dgFormColumn field="headTarget" hidden="true" formClass="form" labelName="headTarget" optionType="input" required="false"
            />
            <t:dgFormColumn field="processKeyTemp" hidden="true" formClass="form" labelName="processKeyTemp" optionType="input" required="false"
            />
            <t:dgFormColumn field="itemTarget" hidden="true" formClass="form" labelName="itemTarget" optionType="input" required="false"
            />
            <t:dgFormColumn field="tempUuid" hidden="true" formClass="form" labelName="tempUuid" optionType="input" required="false"
                            defaultVal="${tempUuid }"/>
            <t:dgFormColumn field="productJson" hidden="true" formClass="form" labelName="productJson" optionType="input" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="actName" hidden="false" formClass="biz-col-50 mb5 form" labelName="活动名称" optionType="input"  required="true"
                            defaultVal="${vo.actName}"/>
            <t:dgFormColumn field="beginDate" extendField="endDate" extendFieldVal="${vo.endDate}" hidden="false" formClass="biz-col-50 mb5 form" labelName="起止时间" optionType="date_begin_end"  required="true"
                            defaultVal="${vo.beginDate}"/>
            <t:dgFormColumn field="budgetCode" hidden="false" formClass="biz-col-50 mb5 form" labelName="预算选择" optionType="choseDialog" required="true"
                            onclick="selectbudget()" defaultVal="${vo.budgetCode}" />
            <t:dgFormColumn field="budgetSubjectsCode" hidden="true" formClass="biz-col-50 mb5 form" labelName="预算科目编码" optionType="input" required="false"
                            defaultVal="${vo.budgetSubjectsCode}"/>
            <t:dgFormColumn field="budgetSubjectsName" hidden="true" formClass="biz-col-50 mb5 form" labelName="预算科目名称" optionType="input" required="false"
                            defaultVal="${vo.budgetSubjectsName}"/>
            <t:dgFormColumn field="categoriesName" hidden="false" formClass="biz-col-50 mb5 form" labelName="活动大类" optionType="choseDialog" required="true"
                            onclick="selectCategories()" defaultVal="${vo.categoriesName}" />
            <t:dgFormColumn field="categoriesCode" hidden="true" formClass="biz-col-33 mb5 form" labelName="活动大类名称" optionType="input" required="false"
                            defaultVal="${vo.categoriesCode }"/>
            <t:dgFormColumn field="receiptor" hidden="false" formClass="biz-col-50 mb5 form" labelName="领用人" optionType="choseDialog"  required="true"
                            onclick="selectreceiptor()" defaultVal="${vo.receiptor}" />
            <t:dgFormColumn field="receiptorPositionCode" hidden="true" formClass="biz-col-33 mb5 form" labelName="领用人职位编码" optionType="input" required="false"
                            defaultVal="${vo.receiptorPositionCode }"/>
            <t:dgFormColumn field="receiptorUsername" hidden="true" formClass="biz-col-33 mb5 form" labelName="领用人登录账号" optionType="input" required="false"
                            defaultVal="${vo.receiptorUsername }"/>

            <t:dgFormColumn field="remarks" hidden="false" formClass="biz-col-100 mb5 form" labelName="备注" optionType="textarea"  required="false"
                            rows="3" cols="5"    defaultVal="${vo.remarks}" style="width: 94%"/>
        </t:dgFormList>
    </t:formvalid>
</div>
<div data-options="region:'center'" style="padding:5px;">
    <t:datagrid name="departUseDetailList" checkbox="true" fitColumns="false" idField="id" fit="true"
                queryMode="group"
                actionUrl="/act/ttActDepartUseController/findTtActDepartUseDetailPage?tempUuid=${tempUuid}&id=${vo.id}"
                pagination="true" onLoadSuccess="onloadSuccess"
    >
        <t:dgCol title="id" field="id" hidden="true"/>
        <t:dgCol title="活动细类" field="actSubclassName" sortable="false"/>
        <t:dgCol title="组织名称" field="orgName" sortable="false"/>
        <t:dgCol title="物料编码" field="matnr" sortable="false"/>
        <t:dgCol title="物料名称" field="maktx" sortable="false"/>
        <t:dgCol title="单价" field="price" sortable="false" hidden="${price}"/>
        <t:dgCol title="数量" field="productNum" sortable="false"/>
        <t:dgCol title="单位" field="unit"  sortable="false" dictionary="basic_unit"/>
        <t:dgCol title="最小包装量" field="miniPack" sortable="false" hidden="true"/>
        <t:dgCol title="申请金额" field="amount" sortable="false" hidden="${amount}"/>
        <t:dgCol title="备注" field="remarks" sortable="false"/>
        <t:dgToolBar detail="false" title="新增"  funname="addDetail" icon="icon-add"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="编辑" detail="false" funname="updateDetail" icon="icon-edit"
                     url=""></t:dgToolBar>
        <c:if test="${isDisplay == '1' }">
            <t:dgToolBar title="导入"  detail="false" icon="icon-dataIn"
                     onclick="detailExcel()"></t:dgToolBar>
        </c:if>
        <t:dgToolBar title="删除" detail="false" funname="deleteALLSelect" icon="icon-remove"
                 url="/act/ttActDepartUseController/delDetail"></t:dgToolBar>

        <t:dgToolBar title="附件" onclick="addAttach('${tempUuid}','${attachmentType}','${load}')" url="" icon="icon-attach"></t:dgToolBar>
    </t:datagrid>
</div>

<script src="/resources/act/attachment/js/attachment.js"></script>

<script type="text/javascript">

    function onloadSuccess() {
        setTimeout(function(){
            $("#departUseDetailList").datagrid("resize");
        },400);
    }

    //关键指标js开始
    let vm = new Vue({
        el: "#app",
        data: function () {
            return {
                id: "${vo.id}",
                page: "bmly",
                viewStatus: "${viewStatus}",
                isActiviti: "${isActiviti}"
            }
        },
        methods: {
            handleRefresh: function (target) {
                let this_ = this;
                checkproductSubmit();
            },
        }
    })
    //关键指标js结束

    $.fn.parseForm=function(){
        var serializeObj={};
        var array=this.serializeArray();
        var str=this.serialize();
        $(array).each(function(){
            if(serializeObj[this.name]){
                if($.isArray(serializeObj[this.name])){
                    serializeObj[this.name].push(this.value);
                }else{
                    serializeObj[this.name]=[serializeObj[this.name],this.value];
                }
            }else{
                serializeObj[this.name]=this.value;
            }
        });
        return serializeObj;
    };

    function createData(){
        checkproductSubmit();
        var data = $("#detailId").parseForm();
        data.target = vm.$refs.targetTable.getTargetData();
        return data;
    }

    function addDetail(){
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        if (categoriesCode == "") {
            tip("请先选择活动大类");
            return false;
        }else{
            id = "departUseDetailList";
            gridname = id;
            var addurl = "/page/ttActDepartUseController/goUpdateOrAddDetail?clickFunctionId=${clickFunctionId}&tempUuid=${tempUuid}&categoriesCode="+categoriesCode+"&budgetCode="+budgetCode;
            createwindow("新增", addurl,  400, 400, {});
        }
    }
    function updateDetail() {
        var rowsData = $('#departUseDetailList').datagrid('getSelections');
        var myobj=eval(rowsData);
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        if (categoriesCode == "") {
            tip("请先选择活动大类");
            return false;
        }else{
            id = "departUseDetailList";
            gridname = id;
            var addurl = "/page/ttActDepartUseController/goUpdateOrAddDetail?1=1&clickFunctionId=${clickFunctionId}&tempUuid=${tempUuid}&categoriesCode="+categoriesCode+"&id="+myobj[0].id+"&budgetCode="+budgetCode;
            createwindow("编辑", addurl,  400, 400, {});
        }
    }

    $(document.body).css({
        "overflow-x": "auto",
        "overflow-y": "auto"
    });
    var trId = 0;
    var cloneTrTemp = "";
    $(function () {
        setTimeout(function(){
            $("#departUseDetailList").datagrid("resize");
        },500)
    });

    //提交前处理
    function checkproductSubmit() {
        var b=checkTable()
        if("${isActiviti}"=="1"){
            var postParams = $("#detailId").parseForm();
            postParams.target = vm.$refs.targetTable.getTargetData();
            $.ajax({
                url: "/act/ttActDepartUseController/refresh",
                type: "post",
                async : false,
                dataType: "json",
                data: JSON.stringify(postParams),
                contentType: "application/json",
                complete: function () {
                },
                success: function (res) {
                    closeProgressTop();
                    if (res.success) {
                        vm.$refs.targetTable.setTargetData(res.obj);
                    } else {
                        tip(res.msg);
                    }
                },
                error: function () {
                    closeProgressTop();
                }
            })
            var target = vm.$refs.targetTable.getTargetData();
            $("#headTarget").val(JSON.stringify(target.headTarget));
            $("#itemTarget").val(JSON.stringify(target.itemTarget));
            $("#processKeyTemp").val(target.processKey);
        }
        return b;
    }

    //校验table
    function checkTable() {
        var canSubmit = true;
        var tableData = [];
        $("#showTable tbody tr").each(function () {
            if (canSubmit) {
                var obj = {};
                $(this).find("td").each(function (index) {
                    if (canSubmit) {
                        $(this).find("input[field=formtable]").each(function () {
                            var inputName = $(this).attr("name");
                            obj[inputName] = $(this).val()
                            if (!$(this).val() && $(this).attr("type") !== "hidden") {
                                canSubmit = false;
                                $(this).focus();
                                var name = $("#showTable thead tr th").eq(index).text();
                                tip(name + "不能为空");
                                return false;
                            }
                        })

                    } else {
                        return false;
                    }
                });
                tableData.push(obj);
            } else {
                return false;
            }

        });
        if (canSubmit) {
            $("#productJson").val(JSON.stringify(tableData))
        }
        return canSubmit;
    }

    function selectbudget(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        triggerId = "budgetCode";
        triggerName = "budgetName";
        url = "/page/ttApiBudgetController/goApiBudgetMain?tableType=departuse";
        width = 1000;
        height = 450;
        id = "ttApibudgetList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#budgetCode").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].budgetCode);
                    $("#budgetSubjectsCode").val(myobj[0].budgetSubjectsCode);
                    $("#budgetSubjectsName").val(myobj[0].budgetSubjectsName);
                    var budgetCode = myobj[0].budgetCode;
                    $.ajax({
                        url:"/budget/ttApiCostTypeCategoriesController/getCategoriesListByBudgetCode?budgetCode="+budgetCode+"&clickFunctionId=${clickFunctionId}",
                        dataType:'json',
                        type:'post',
                        async:false,
                        success:function(data){
                            if (data.length == 1) {
                                $("#categoriesCode").val(data[0].categoriesCode);
                                $("#categoriesName").val(data[0].categoriesName);
                            }else{
                                $("#categoriesCode").val("");
                                $("#categoriesName").val("");
                            }
                        }
                    })
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
    function selectCategories() {
        var budgetCode = $("#budgetCode").val();
        if (budgetCode == "") {
            tip("请先选择预算");
            return;
        }
        triggerId = "categoriesCode";
        triggerName = "categoriesName";
        url = "/page/ttApiCostTypeCategoriesController/goApiActSelectCategoriesMain?budgetCode="+budgetCode+"&clickFunctionId=${clickFunctionId}";
        width = 600;
        height = 500;
        id = "categoriesList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#categoriesCode").focus();
                if (rowsData.length == 0) {
                    iframe.tip("请至少选择一条数据");
                    return false;
                } else {
                    var myobj=eval(rowsData);
                    $("#" + triggerId).val(myobj[0].categoriesCode);
                    $("#" + triggerName).val(myobj[0].categoriesName);
                    $("#categoriesName").focus();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function impot() {
        departUseDetailListsearch();
    }


    function detailExcel() {
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode =$("#budgetCode").val();
        var clickFunctionId='${clickFunctionId}';
        if (categoriesCode==''){
            tip("请先选择活动大类");
            return false;
        }else {
            var tempId = "${tempUuid}";
            <c:if test="${not empty importUploadUrl}">
            var data = ${importUploadUrl};
            data.strExtend1 = tempId;
            data.strExtend2 = categoriesCode;
            data.strExtend3 = budgetCode;
            data.strExtend4 = clickFunctionId;
            importExcel(data,impot)
            </c:if>
        }
    }

    function selectreceiptor(){
        url = "/page/tmApiUserController/goUserListMain";
        width = 600;
        height = 450;
        id = "userList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#receiptor").focus();
                if (rowsData.length == 0) {
                    iframe.tip("请至少选择一条数据");
                    return false;
                } else {
                    var myobj=eval(rowsData);
                    $("#receiptor").val(myobj[0].fullname);
                    $("#receiptorPositionCode").val(myobj[0].posCode);
                    $("#receiptorUsername").val(myobj[0].username);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

</script>
</body>
</html>