<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>考勤详情</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <style>
        body {
            background: #f3f3f3;
        }

        .goods-list-title {
            padding: 10px 0;
            color: #333333;
            font-size: 16px;
        }

        .attendance-note .list-cell-title {
            color: #333333;
        }

        .upload-img {
            padding: 0 16px;
            background: #ffffff;
        }

        .upload-img img {
            width: 60px;
            height: 60px;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="attendance-detail">
            <list-cell title="签到组名称" v-if="attendance.freesignName" :value="attendance.freesignName"></list-cell>
            <list-cell title="签到类型" :value="attendance.signType"></list-cell>
            <list-cell title="签到时间" :value="attendance.signDate"></list-cell>
            <list-cell title="签到人" :value="attendance.createName"></list-cell>
            <list-info title="签到地点" :value="attendance.addressIn" type="textarea"></list-info>
            <div class="upload-img">
                <div class="goods-list-title">签到照片</div>
                <img :src="img.imgUrl" alt="" v-for="img in attendance.imgList" :key="img.id">
            </div>
            <div class="attendance-note">
                <list-info title="补充说明" :value="attendance.remarks" type="textarea"></list-info>
            </div>

        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>
    <script>
        var vm = new Vue({
            el: "#app",
            name: "AttendanceDetail",
            data: function () {
                return {
                    token: "",
                    id: "",
                    attendance: {}
                }
            },
            created: function () {
                this.token = getParameterByName("token");
                this.id = getParameterByName("id");
                this.loadData();
            },
            computed: {

            },
            methods: {
                loadData: function () {
                    var this_ = this;
                    $.ajax({
                        url: SERVER +
                            "/sfaapi/sfaApi/tsWorkSignApiController/getSignInfoById?id=" + this_.id,
                        type: "post",
                        dataType: "json",
                        contentType: 'application/x-www-form-urlencoded',
                        headers: {
                            'loginUserToken': this_.token
                        },
                        success: function (res) {
                            if (res.success) {
                                this_.attendance = res.obj;
                            }else{
                                showError(res.msg)
                            }
                        }
                    })
                },
            }
        })
    </script>
</body>

</html>