<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>公告列表</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <link rel="stylesheet" href="/resources/sfa/css/mescroll.min.css">
    <link rel="stylesheet" href="/resources/sfa/fontawesome/css/font-awesome.min.css">
    <style>
        body {
            background: #f3f3f3;
        }

        .search-bar {
            height: 40px;
            padding: 0 15px;
            margin: 10px 0;
            width: 100%;
            box-sizing: border-box;
            position: absolute;
            top: 0;
            z-index: 50;
        }

        .search-input {
            width: 100%;
            position: relative;
        }

        .search-input > input {
            width: 100%;
            box-sizing: border-box;
            border: 1px solid #eee;
            height: 35px;
            line-height: 35px;
            border-radius: 5px;
            font-size: 14px;
            padding: 0 10px 0 30px;
            outline: none;
        }

        .search-icon {
            position: absolute;
            left: 10px;
            top: 7px;
        }

        .search-icon > span {
            color: #aaa;
        }

        .list-wrapper {
            height: calc(100vh - 40px);
            overflow-y: hidden;
        }

        .list-content {
            list-style: none;
            padding: 0 10px;
            margin: 0;
            box-sizing: border-box;
        }

        .list-item {
            margin-bottom: 10px;
            padding: 10px;
            font-size: 14px;
            color: #333333;
            background: #ffffff;
            border-radius: 5px;
        }

        .list-item-title {
            width: 0;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            font-weight: 600;
        }

        .list-item-date {
            margin-left: 10px;
        }

        .list-item-content {
            margin: 10px 0;
            line-height: 1.2;
            text-indent: 2em;
            overflow: hidden;
            display: -webkit-box;
            -webkit-box-orient: vertical;
            -webkit-line-clamp: 3;
            text-overflow: ellipsis;

        }

        .list-item-status {
            color: #1890ff;
        }

        .mescroll {
            position: fixed;
            top: 55px;
            bottom: 0;
            height: auto;
        }
    </style>
</head>

<body>
<div id="app" v-cloak>
    <div class="search-bar">
        <form @submit.prevent="handleSearch">
            <div class="search-input">
                <input type="text" v-model="key" placeholder="请输入关键字">
                <div class="search-icon">
                    <span class="fa fa-search"></span>
                </div>
            </div>
        </form>
    </div>
    <div ref="wrapper" class="mescroll">
        <ul class="list-content">
            <li @click="clickItem(item)" class="list-item" v-for="item in noticeList">
                <div class="flex flex-align-items-center">
                    <div class="list-item-title flex-auto">{{item.noticeTitle}}</div>
                    <div class="list-item-date flex-none">{{item.createDate|formatDate}}</div>
                </div>
                <div class="list-item-content">
                    {{item.noticeContent}}
                </div>
                <div class="flex flex-align-items-center flex-justify-content-between">
                    <!-- <div class="list-item-status flex-auto">未读</div> -->
                    <div class="flex-none">发布人：{{item.createName}}</div>
                </div>
            </li>
        </ul>
    </div>
</div>

<script src="/resources/sfa/js/vue.min.js"></script>
<script src="/resources/sfa/js/common.js"></script>
<script src="/resources/sfa/js/jquery.min.js"></script>
<script src="/resources/sfa/js/mescroll.min.js"></script>

<script>
    function onJsJumpWithUrl(url) {
        js.onJsJumpWithUrl(url);
    }

    var vm = new Vue({
        el: "#app",
        name: "noticeList",
        data: function () {
            return {
                key: "",
                page: 1,
                rows: 10,
                token: "",
                noticeList: [],
                scroll: null
            }
        },
        created: function () {
            this.token = getParameterByName("token");
            this.loadData();
        },
        mounted: function () {
            let this_ = this;
            setTimeout(function () {
                this_.scroll = new MeScroll(this_.$refs.wrapper, {
                    down: {
                        callback: this_.downCallback
                    },
                    up: {
                        callback: this_.upCallback,
                        scrollbar: false
                    }
                });
            }, 20)

        },
        computed: {},
        filters:{
            formatDate:function(date){
                if (!date) return;
                date = date.replace(/-/g,"/");
                date = new Date(date);
                let year = date.getFullYear();
                let month = date.getMonth() + 1;
                let day = date.getDate();
                month = month + '';
                month = month[1] ? month : '0' + month;
                day = day + '';
                day = day[1] ? day : '0' + day;
                return [year, month, day].join("-");
            }
        },
        methods: {
            downCallback: function () {
                this.page = 1;
                this.loadData();
            },
            upCallback: function (page, mescroll) {
                this.page = page.num;
                this.loadData()
            },
            handleSearch: function () {
                this.page = 1;
                this.loadData();
            },
            loadData() {
                var this_ = this;
                $.ajax({
                    url: SERVER + "/sfaapi/sfaApi/tsNoticeApiController/getKnlNoticeByPage?page=" +
                    this_.page + "&rows=" + this_.rows,
                    type: "post",
                    data: JSON.stringify({
                        key: this_.key
                    }),
                    dataType: "json",
                    contentType: "application/json",
                    headers: {
                        'loginUserToken': this_.token
                    },
                    success: function (res) {
                        if (res.success) {
                            if (this_.page>1) {
                                this_.noticeList = this_.noticeList.concat(res.obj.list || []);
                                this_.scroll && this_.scroll.endByPage(res
                                    .obj.list.length, res.obj.total)
                            } else {
                                this_.noticeList = res.obj.list || []
                                this_.scroll && this_.scroll.endByPage(res
                                    .obj.list.length, res.obj.total)
                            }
                        }else{
                            showError(res.msg)
                            this_.scroll && this_.scroll.endErr();
                        }
                    },
                    error: function (error) {
                        this_.scroll && this_.scroll.endErr();
                    }
                })
            },
            clickItem(item) {
                let url = "/page/sfaWebController/noticeDetail?id=" + item.id;
                var u = navigator.userAgent;
                var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
                var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
                if(isAndroid){
                    onJsJumpWithUrl(url);
                }
                if(isiOS){
                    window.webkit.messageHandlers.onJsJumpWithUrl.postMessage(url);
                }
            }
        }
    })
</script>
</body>

</html>