<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>买赠_产品+价格组</title>
    <t:base type="jquery,easyui,tools,actPrice"></t:base>
    <style>
        #content {
            padding :0!important;
        }
        .layout-split-north {
            border-bottom: 1px solid #ffffff;
        }
        .biz-tags-box {
            width: 1000px;
            min-height: 100px;
        }
        .form-group {
            padding: 10px;
            box-sizing: border-box;
        }

        .form-input label {
            display: inline-block;
            width: 130px;
            text-align: right;
            line-height: 24px;
        }
        .form-input input {
            height: 24px;
            border: 1px solid #ddd;
            -moz-border-radius: 2px;
            -webkit-border-radius: 2px;
            border-radius: 2px;
            outline: none;
            padding: 3px 2px;
            width: 150px;
            box-sizing: border-box;
        }
    </style>
</head>
<body class="easyui-layout">
<input type="hidden" id="startTime" value="${startTime}">
<div data-options="region:'north',split:true" style="height:200px;">
    <t:formvalid action="null" layout="div"
                 dialog="true" formid="buyProductForm" beforeSubmit="saveDataEnd()">
        <input id="id" name="id" type="hidden" required="false" >
        <input id="categoriesCode" name="categoriesCode" value="${categoriesCode}" type="hidden" required="false" >
        <input id="budgetCode" name="budgetCode" type="hidden" value="${budgetCode}" required="false" >
        <div class="form-group">
            <div class="flex flex-align-items-center mb10">
                <div class="form-input flex-1">
                    <label>活动细类:<span style="color:red;">*</span></label>
                    <input id="actSubclassName" name="actSubclassName" value="${vo.actSubclassName}" required="true" dataType="*" readonly="readonly" onclick="selectActSubClass();">
                    <input id="actSubclassCode" name="actSubclassCode" value="${vo.actSubclassCode}" type="hidden"/>
                    <input id="isMultipleAudit" name="isMultipleAudit" value="${vo.isMultipleAudit}" type="hidden"/>
                </div>
                <div class="form-input flex-1">
                    <t:dictSelect field="actPriceBuyType" typeGroupCode="act_price_buy_type" >

                    </t:dictSelect>
                    <span style="color:red;">*</span>
                    <input id="typeProductInput" type="text" value="">
                </div>
                <div class="form-input flex-1">
                    <t:dictSelect field="actPriceGiftType" typeGroupCode="act_price_gift_type"  >

                    </t:dictSelect>
                    <span style="color:red;">*</span>
                    <input id="typeGiftInput" type="text" value=""><span id="semicolon" style="display: none">%</span>
                </div>
            </div>
        </div>
        <t:dgFormList layoutStyle="horizontal" tagConf="${clickFunctionId}_buyGroupProductForm">
            <t:dgFormColumn field="extChar1" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar1" optionType="optionType" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="extChar2" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar2" optionType="optionType" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="extChar3" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar3" optionType="optionType" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="extChar4" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar4" optionType="optionType" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="extChar5" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar5" optionType="optionType" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="extChar6" hidden="true" formClass="biz-col-33 mb5 form" labelName="extChar6" optionType="optionType" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="priceGroup" hidden="false" formClass="biz-col-33 mb5 form" labelName="价格组" optionType="select" required="true"
                            typeGroupCode="price_group" />
            <t:dgFormColumn field="isStack" hidden="false" formClass="biz-col-33 mb5 form" labelName="是否叠加" optionType="radio" typeGroupCode="is_no" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="isLimit" hidden="false" formClass="biz-col-33 mb5 form" labelName="限额限量" optionType="radio" typeGroupCode="is_no" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="isAdd" hidden="false" formClass="biz-col-33 mb5 form" labelName="是否累计" optionType="radio" typeGroupCode="is_no" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="giftName_1" hidden="false"  formClass="form" labelName="赠品" optionType="tags"  required="false"
                            formTags="${vo.orgFormTags}"  onclick="selectProductGiftCheck();"  />
            <t:dgFormColumn field="giftCostPrice" hidden="true" formClass="biz-col-33 mb5 form" labelName="赠品最高成本价" optionType="input" required="false"
            />
        </t:dgFormList>
    </t:formvalid>
</div>
<div data-options="region:'center'" style="padding:5px;">
    <t:datagrid name="productDetailList" checkbox="true" fitColumns="false" idField="id" fit="true" singleSelect="false"
                queryMode="group"
                actionUrl=""
                pagination="false" autoLoadData="false"
    >
        <t:dgCol title="id" field="id" hidden="true"/>
        <t:dgToolBar title="选择商品" funname="selectProductCheck" icon="icon-add"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="编辑" funname="updateProductDetail" icon="icon-edit"
                     url=""></t:dgToolBar>
        <t:dgToolBar title="删除" funname="delProductDetail" icon="icon-remove"
                     url=""></t:dgToolBar>
    </t:datagrid>
</div>
</body>

</html>

<script>
    $('input[name=isStack][value="0"]').attr("checked",true);
    $('input[name=isLimit][value="0"]').attr("checked",true);
    $('input[name=isAdd][value="1"]').attr("checked",true);

    $("select[name=actPriceBuyType]").bind('input propertychange',function () {
        var actPriceBuyType = $("select[name=actPriceBuyType]").val();
        if (actPriceBuyType == "product_num") {
            var rowsData = $('#productDetailList').datagrid('getRows');
            for(var i=rowsData.length-1;i>=0;i--){
                var index = $("#productDetailList").datagrid("getRowIndex",rowsData[i]);
                $("#productDetailList").datagrid("deleteRow",index);
            }
            $('#productDetailList').datagrid({
                columns:[[
                    {field: 'id', title:'id',hidden: true,width:50},
                    {field: 'productInfoCode', title:'商品编码',width:150},
                    {field: 'productInfoName', title:'商品名称',width:250},
                    {field: 'standPrice', title:'标准价',width:150},
                    {
                        field: 'forecastSalesNum', title: '预计销量', width:150,
                        editor: {
                            type: 'numberbox',
                            options: {
                                min: 0,
                                value: '',
                                missingMessage: '预计销量必填',
                                required: 'true'
                            }
                        }
                    },
                    {field: 'forecastSalesAmount', title:'预计销售额',width:150},
                    {field: 'amount', title:'申请费用金额',hidden: true,width:150},
                    {field: 'scale', title:'比例',hidden: true,width:180}
                ]],
                onDblClickCell: function(index,field,value){
                    if(field=="forecastSalesNum"){
                        initNumEditor(index);
                    }else{
                        endEidtProductDetail();
                        forecastSalesNumblurAll();
                    }

                }
            });
        }else if (actPriceBuyType == "product_amount") {
            var rowsData = $('#productDetailList').datagrid('getRows');
            for(var i=rowsData.length-1;i>=0;i--){
                var index = $("#productDetailList").datagrid("getRowIndex",rowsData[i]);
                $("#productDetailList").datagrid("deleteRow",index);
            }
            $('#productDetailList').datagrid({
                columns:[[
                    {field: 'id', title:'id',hidden: true,width:50},
                    {field: 'productInfoCode', title:'商品编码',width:150},
                    {field: 'productInfoName', title:'商品名称',width:250},
                    {
                        field: 'forecastSalesAmount', title: '预计销售额', width:150,
                        editor: {
                            type: 'numberbox',
                            options: {
                                min: 0,
                                value: '',
                                missingMessage: '预计销售额必填',
                                required: 'true'
                            }
                        }
                    },
                    {field: 'amount', title:'申请费用金额',hidden: true,width:150},
                    {field: 'scale', title:'比例',hidden: true,width:180}
                ]],
                onDblClickCell: function(index,field,value){
                    if(field=="forecastSalesAmount"){
                        initAmountEditor(index);
                    }else{
                        endEidtProductDetail();
                        forecastSalesNumblurAll();
                    }

                }
            });
        }
    })


    //赠品array
    var giftArray = [];
    $(function () {
        $("#giftName_1").on('click', '.biz-tag-close', function () {

            //删除了复选框中的某一个对象后重新获得赠品的价格
            $(this).parent().remove();
            var wareCode = $(this).parent().attr("code");
            giftArray.forEach(function (item,index) {
                if (item.code == wareCode) {
                    giftArray.splice(index,1);
                }
            })
            console.log(giftArray);
            if (giftArray.length > 0) {
                giftArray.sort(function (a, b) {
                    return b.costPrice - a.costPrice;
                });
                console.log(giftArray[0].costPrice);
                $("#giftCostPrice").val(giftArray[0].costPrice);
            }else{
                $("#giftCostPrice").val("");
            }
            //重新计算产品明细中的值
            forecastSalesNumblurAll();
        });

        //本品数量or本品金额修改之后重新计算
        $("#typeProductInput").bind('input propertychange',function () {
            forecastSalesNumblurAll();
        })
        //赠品金额or赠品数量or赠品比例做出修改之后重新计算
        $("#typeGiftInput").bind('input propertychange',function () {
            forecastSalesNumblurAll();
        })
        $('input[type=radio][name=isAdd]').change(function () {
            forecastSalesNumblurAll();
        });

        var edit = '${edit}';
        if(edit=="0"){
            var rows = parent.getPaData();
            setValueForPage(rows);
            $("#actSubclassName").val(rows[0].actSubclassName);
            $("#actSubclassCode").val(rows[0].actSubclassCode);
            $("#isMultipleAudit").val(rows[0].isMultipleAudit);
            $("#giftCostPrice").val(rows[0].giftCostPrice);
            $("select[name=actPriceBuyType]").val(rows[0].actPriceBuyType);
            $("select[name=actPriceGiftType]").val(rows[0].actPriceGiftType);
            $("#priceGroup").val(rows[0].priceGroup);
            if (rows[0].actPriceBuyType == "product_num") {
                $("#typeProductInput").val(rows[0].productNum);
                if (rows[0].actPriceGiftType == "gift_num") {
                    $("#typeGiftInput").val(rows[0].giftNum);
                }
                if (rows[0].actPriceGiftType == "gift_amount") {
                    $("#typeGiftInput").val(rows[0].giftAmount);
                }
                if (rows[0].actPriceGiftType == "gift_scale") {
                    $("#typeGiftInput").val(rows[0].giftScale);
                }
                $('#productDetailList').datagrid({
                    columns:[[
                        {field: 'id', title:'id',hidden: true,width:50},
                        {field: 'productInfoCode', title:'商品编码',width:150},
                        {field: 'productInfoName', title:'商品名称',width:250},
                        {field: 'standPrice', title:'标准价',width:150},
                        {
                            field: 'forecastSalesNum', title: '预计销量', width:150,
                            editor: {
                                type: 'numberbox',
                                options: {
                                    min: 0,
                                    value: '',
                                    missingMessage: '预计销量必填',
                                    required: 'true'
                                }
                            }
                        },
                        {field: 'forecastSalesAmount', title:'预计销售额',width:150},
                        {field: 'amount', title:'申请费用金额',hidden: true,width:150},
                        {field: 'scale', title:'比例',hidden: true,width:180}
                    ]]
                });
                $('#productDetailList').datagrid('insertRow',{
                    index: 0,
                    row: {
                        id:rows[0].id,
                        productInfoCode: rows[0].productCode,
                        productInfoName: rows[0].productName,
                        standPrice:rows[0].standPrice,
                        forecastSalesNum:rows[0].forecastSalesNum,
                        forecastSalesAmount:rows[0].forecastSalesAmount,
                        amount:rows[0].amount,
                        scale:rows[0].scale
                    }
                });
            }else if (rows[0].actPriceBuyType == "product_amount") {
                $("#typeProductInput").val(rows[0].productAmount);
                if (rows[0].actPriceGiftType == "gift_num") {
                    $("#typeGiftInput").val(rows[0].giftNum);
                }
                if (rows[0].actPriceGiftType == "gift_amount") {
                    $("#typeGiftInput").val(rows[0].giftAmount);
                }
                if (rows[0].actPriceGiftType == "gift_scale") {
                    $("#typeGiftInput").val(rows[0].giftScale);
                }
                $('#productDetailList').datagrid({
                    columns:[[
                        {field: 'id', title:'id',hidden: true,width:50},
                        {field: 'productInfoCode', title:'商品编码',width:150},
                        {field: 'productInfoName', title:'商品名称',width:250},
                        {
                            field: 'forecastSalesAmount', title: '预计销售额', width:150,
                            editor: {
                                type: 'numberbox',
                                options: {
                                    min: 0,
                                    value: '',
                                    missingMessage: '预计销售额必填',
                                    required: 'true'
                                }
                            }
                        },
                        {field: 'amount', title:'申请费用金额',hidden: true,width:150},
                        {field: 'scale', title:'比例',hidden: true,width:180}
                    ]]
                });
                $('#productDetailList').datagrid('insertRow',{
                    index: 0,
                    row: {
                        id:rows[0].id,
                        productInfoCode: rows[0].productCode,
                        productInfoName: rows[0].productName,
                        forecastSalesAmount:rows[0].forecastSalesAmount,
                        amount:rows[0].amount,
                        scale:rows[0].scale
                    }
                });
            }

            $('input[name=isStack][value="' + rows[0].isStack + '"]').attr("checked",true);
            $('input[name=isLimit][value="' + rows[0].isLimit + '"]').attr("checked",true);
            $('input[name=isAdd][value="' + rows[0].isAdd + '"]').attr("checked",true);
            var giftJson = rows[0].giftJson;
            if(!isEmpty(giftJson)){
                var myobj = JSON.parse(giftJson);
                var tagArray = [];
                $(myobj).each(function(index,item){
                    var tag = {};
                    tag["name"] = item.name;
                    tag["code"] = item.code;
                    tagArray.push(tag);
                });
                renderTag("giftName_1", tagArray);
            }

            editorAll();
        }

        //切换赠品类型的时候计算
        $('select[name=actPriceBuyType]').change(function(){
            forecastSalesNumblurAll();
        });
        //切换赠品类型的时候计算
        $('select[name=actPriceGiftType]').change(function(){
            forecastSalesNumblurAll();
            var actPriceGiftType = $('select[name=actPriceGiftType]').val();
            if (actPriceGiftType == "gift_scale") {
                $("#semicolon").show();
            }else{
                $("#semicolon").hide();
            }
        });
    });
    //选择活动细类
    function selectActSubClass(){
        var tableType = "act_price";
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        triggerId = "actSubclassCode";
        triggerName = "actSubclassName";
        url = "/page/ttApiFineController/goApiActFineMain?tableType="+tableType+"&categoriesCode="+categoriesCode+"&budgetCode="+budgetCode;
        width = 1000;
        height = 450;
        id = "actSubclassList";
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: width,
            height: height,
            title: '新增',
            opacity: 0.3,
            zIndex:2600,
            parent:'addProductDetailDialog',
            id:'addProductDetailDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#' + id).datagrid('getSelections');
                    if (rowsData.length==0 ) {
                        iframe.tip("请至少选择一条数据");
                    } else {
                        var myobj=eval(rowsData);
                        $("#" + triggerId).val(myobj[0].fineCode);
                        $("#" + triggerName).val(myobj[0].fineName);
                        $("#isMultipleAudit").val(myobj[0].isMultipleAudit);
                        $("#actSubclassName").focus();
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    //选择产品
    function selectProductCheck() {
        selectProduct();
    }
    /* 选择赠品 */
    function selectProductGiftCheck() {
        selectgiftProduct();
    }

    function selectgiftProduct(){
        //查询带成本价的商品
        url = "/page/tmApiWareController/goCostPriceWareListMain?check=false";
        width = 1000;
        height = 450;
        id = "wareCostList";
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: width,
            height: height,
            title: '新增',
            opacity: 0.3,
            zIndex:2600,
            parent:'selectProductDialog',
            id:'selectProductDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#' + id).datagrid('getSelections');
                    if (rowsData.length==0 ) {
                        iframe.tip("请至少选择一条数据");
                    } else {
                        var myobj=eval(rowsData);

                        $(myobj).each(function(index,item){
                            var tag = {};
                            tag["name"] = item.wareName;
                            tag["code"] = item.wareCode;
                            tag["costPrice"] = item.costPrice;
                            giftArray.push(tag);
                        });

                        renderTag("giftName_1", giftArray);

                        if (giftArray.length > 0) {
                            giftArray.sort(function (a, b) {
                                return b.costPrice - a.costPrice;
                            });
                            console.log(giftArray[0].costPrice);
                            $("#giftCostPrice").val(giftArray[0].costPrice);
                            //重新计算产品明细中的值
                            forecastSalesNumblurAll();
                        }
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    //按照升序排列
    function up(x,y){
        return x.DATA_DATE-y.DATA_DATE
    }

    //清空复选框
    function clearTags(event) {
        $("#giftCostPrice").val("");
        $(event).parents(".biz-tags-box").find(".biz-tags-content").html("");
        giftArray = [];
        //重新计算产品明细中的值
        forecastSalesNumblurAll();
    }

    function selectProduct(){
        var startTime = $("#startTime").val();
        var dictValue = '${dictValue}';
        var rowsDatas = $('#productDetailList').datagrid('getRows');
        //赠品成本价
        var giftCostPrice = $("#giftCostPrice").val();
        var typeProductInput = $("#typeProductInput").val();
        if (typeProductInput == "") {
            var actPriceBuyType = $("select[name=actPriceBuyType]").val();
            if (actPriceBuyType == "product_num") {
                tip("请填写本品数量");
                return;
            }else if (actPriceBuyType == "product_amount") {
                tip("请填写本品金额");
                return;
            }
        }
        var typeGiftInput = $("#typeGiftInput").val();
        if (typeGiftInput == "") {
            var actPriceGiftType = $("select[name=actPriceGiftType]").val();
            if (actPriceGiftType == "gift_num") {
                tip("请填写赠品数量");
                return;
            } else if (actPriceGiftType == "gift_amount"){
                tip("请填写赠品金额");
                return;
            } else if (actPriceGiftType == "gift_scale") {
                tip("请填写赠品金额比例");
                return;
            }else{
                tip("请选择赠品类型");
                return;
            }
        }
        var priceGroup =  $("#priceGroup").val();
        if(isEmpty(priceGroup)){
            tip("请选择价格组");
            return;
        }
        if (giftCostPrice == "") {
            tip("请选择赠品");
            return;
        }
        var budgetCode = $("#budgetCode").val();
        url = "/page/tmApiWareController/goWareListMain?check=false&priceGroup="+priceGroup+"&budgetCode="+budgetCode+"&startTime="+startTime;
        width = 1000;
        height = 450;
        id = "wareList";
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: width,
            height: height,
            title: '新增',
            opacity: 0.3,
            zIndex:2600,
            parent:'selectProductDialog',
            id:'selectProductDialogId',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.$('#' + id).datagrid('getSelections');
                    if (rowsData.length==0 ) {
                        iframe.tip("请至少选择一条数据");
                    } else {
                        //检查选择的数据价格是否存在
                        var priceParamVo = new Object();
                        /**价格定价组*/
                        priceParamVo.priceGroup = priceGroup;
                        /**客户编码*/
                        priceParamVo.custCode = "";
                        var productCodes = new Array();
                        for(var i=0;i<rowsData.length;i++){
                            productCodes.push(rowsData[i].wareCode);
                        }
                        priceParamVo.productCodes = productCodes;
                        priceParamVo.priceDate = $("#startTime").val();
                        var map = getpriceForMap(priceParamVo);
                        if(map==null){
                            return true;
                        }
                        var msg = "";
                        if (dictValue == "Y") {
                            for(var i=0;i<rowsData.length;i++){
                                if(map.has(rowsData[i].wareCode)&&map.get(rowsData[i].wareCode)!=""){
                                    $('#productDetailList').datagrid('insertRow',{
                                        index: 0,
                                        row: {
                                            id:generateUUID(),
                                            productInfoCode: rowsData[i].wareCode,
                                            productInfoName: rowsData[i].wareName,
                                            standPrice: map.get(rowsData[i].wareCode)
                                        }
                                    });
                                }else{
                                    msg += rowsData[i].wareCode+",";
                                }
                            }
                        }else{
                            rowsData.forEach(function(item,index){
                                if(!isContain(item,rowsDatas)){
                                    if(map.has(rowsData[index].wareCode)&&map.get(rowsData[index].wareCode)!=""){
                                        $('#productDetailList').datagrid('insertRow',{
                                            index: 0,
                                            row: {
                                                id:generateUUID(),
                                                productInfoCode: rowsData[index].wareCode,
                                                productInfoName: rowsData[index].wareName,
                                                standPrice: map.get(rowsData[index].wareCode)
                                            }
                                        });
                                    }else{
                                        msg += rowsData[index].wareCode+",";
                                    }
                                }
                            });
                        }
                        if(msg!=""){
                            msg = "价格不存在,商品编码为：<br>"+msg;
                            tip(msg);
                        }
                        editorAll();
                        return true;
                    }
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    function isContain(obj,arr2) {
        let contain = false;
        arr2.forEach(function(item2){
            if(obj.wareCode==item2.productInfoCode){
                contain = true;
                return false;
            }
        })
        return contain;
    }

    function forecastSalesNumblurAll() {
        var rows = $('#productDetailList').datagrid('getRows');
        for(var i=0;i<rows.length;i++){
            var index = i;
            var rows = $('#productDetailList').datagrid('getRows');
            var row = rows[index];

            var actPriceBuyType = $("select[name=actPriceBuyType]").val();
            if (actPriceBuyType == "product_num") {
                //标准价
                var standPrice = row.standPrice;
                //预计销量
                var forecastSalesNum = row.forecastSalesNum;
                //预计销售额(标准价*预计销量)
                var forecastSalesAmount = numMulti(standPrice,forecastSalesNum);
                //赠品最高成本价
                var giftCostPrice = $("#giftCostPrice").val();

                //本品数量or本品金额
                var typeProductInput = $("#typeProductInput").val();
                //赠品金额or赠品比例or赠品数量
                var typeGiftInput = $("#typeGiftInput").val();
                var actPriceGiftType = $("select[name=actPriceGiftType]").val();
                var isAdd = $('input:radio[name="isAdd"]:checked').val();

                $('#productDetailList').datagrid('endEdit' ,index);
                if (!isEmpty(forecastSalesNum) && !isEmpty(typeGiftInput) && !isEmpty(actPriceGiftType) && !isEmpty(typeProductInput)) {
                    if (isAdd == "1") {
                        //倍数=预计销量/本品数量（向下取整）
                        var multiple = Math.floor(numDiv(forecastSalesNum,typeProductInput));
                        if (actPriceGiftType == "gift_num") {//赠品数量
                            //申请费用金额(赠品最高成本*赠品数量*倍数)
                            var amount = numMulti(numMulti(multiple,typeGiftInput),giftCostPrice);
                            amount = returnFloat(amount);
                            var scale = numDiv(amount,forecastSalesAmount);
                            scale = returnFloatThree(scale);
                            $('#productDetailList').datagrid('updateRow',{
                                index: index,
                                row: {
                                    amount:amount,
                                    forecastSalesAmount:forecastSalesAmount,
                                    scale:scale,
                                    forecastSalesNum:forecastSalesNum
                                }
                            });
                        }else if (actPriceGiftType == "gift_amount") {//赠品金额
                            //申请费用金额（倍数*赠品金额）
                            var amount = numMulti(typeGiftInput,multiple);
                            amount = returnFloat(amount);
                            var scale = numDiv(amount,forecastSalesAmount);
                            scale = returnFloatThree(scale);
                            $('#productDetailList').datagrid('updateRow',{
                                index: index,
                                row: {
                                    amount:amount,
                                    forecastSalesAmount:forecastSalesAmount,
                                    scale:scale,
                                    forecastSalesNum:forecastSalesNum
                                }
                            });
                        }else if (actPriceGiftType == "gift_scale") {
                            //申请费用金额＝预计销售额*赠品金额比例
                            var amount = numMulti(numMulti(numDiv(typeGiftInput,100),forecastSalesAmount),multiple);
                            var scale = numDiv(amount,forecastSalesAmount);
                            scale = returnFloatThree(scale);
                            amount = returnFloat(amount);
                            $('#productDetailList').datagrid('updateRow',{
                                index: index,
                                row: {
                                    amount:amount,
                                    forecastSalesAmount:forecastSalesAmount,
                                    scale:scale,
                                    forecastSalesNum:forecastSalesNum
                                }
                            });
                        }
                    }else{
                        if (actPriceGiftType == "gift_num") {//赠品数量
                            //申请费用金额(赠品最高成本*赠品数量)
                            var amount = numMulti(typeGiftInput,giftCostPrice);
                            amount = returnFloat(amount);
                            var scale = numDiv(amount,forecastSalesAmount);
                            scale = returnFloatThree(scale);
                            $('#productDetailList').datagrid('updateRow',{
                                index: index,
                                row: {
                                    amount:amount,
                                    forecastSalesAmount:forecastSalesAmount,
                                    scale:scale,
                                    forecastSalesNum:forecastSalesNum
                                }
                            });
                        }else if (actPriceGiftType == "gift_amount") {//赠品金额
                            //申请费用金额（赠品金额）
                            var amount = typeGiftInput;
                            amount = returnFloat(amount);
                            var scale = numDiv(amount,forecastSalesAmount);
                            scale = returnFloatThree(scale);
                            $('#productDetailList').datagrid('updateRow',{
                                index: index,
                                row: {
                                    amount:amount,
                                    forecastSalesAmount:forecastSalesAmount,
                                    scale:scale,
                                    forecastSalesNum:forecastSalesNum
                                }
                            });
                        }else if (actPriceGiftType == "gift_scale") {
                            //申请费用金额＝预计销售额*赠品金额比例
                            var amount = numMulti(numDiv(typeGiftInput,100),forecastSalesAmount);
                            var scale = numDiv(amount,forecastSalesAmount);
                            scale = returnFloatThree(scale);
                            amount = returnFloat(amount);
                            $('#productDetailList').datagrid('updateRow',{
                                index: index,
                                row: {
                                    amount:amount,
                                    forecastSalesAmount:forecastSalesAmount,
                                    scale:scale,
                                    forecastSalesNum:forecastSalesNum
                                }
                            });
                        }
                    }
                }
            }else if (actPriceBuyType == "product_amount") {
                //预计销售额
                var forecastSalesAmount = row.forecastSalesAmount;
                //赠品最高成本价
                var giftCostPrice = $("#giftCostPrice").val();
                //本品金额
                var typeProductInput = $("#typeProductInput").val();
                //赠品金额or赠品比例or赠品数量
                var typeGiftInput = $("#typeGiftInput").val();
                var actPriceGiftType = $("select[name=actPriceGiftType]").val();
                var isAdd = $('input:radio[name="isAdd"]:checked').val();
                $('#productDetailList').datagrid('endEdit', index);
                if (!isEmpty(forecastSalesAmount) && !isEmpty(typeGiftInput) && !isEmpty(actPriceGiftType) && !isEmpty(typeProductInput)) {
                    forecastSalesAmount = Number(forecastSalesAmount);
                    typeProductInput = Number(typeProductInput);
                    //当预计销售额 小于 本品金额的时候，申请金额应该也是0
                    if (forecastSalesAmount < typeProductInput) {
                        // var amount = 0;
                        // var scale = numDiv(amount, forecastSalesAmount);
                        // scale = returnFloatThree(scale);
                        // amount = returnFloat(amount);
                        // $('#productDetailList').datagrid('updateRow', {
                        //     index: index,
                        //     row: {
                        //         amount: amount,
                        //         forecastSalesAmount: forecastSalesAmount,
                        //         scale: scale
                        //     }
                        // });
                        // return;
                        tip("预计销售额必须大于本品金额");
                    }
                    if (isAdd == "1") {
                        //倍数=预计销售额/本品金额（向下取整）
                        var multiple = Math.floor(numDiv(forecastSalesAmount,typeProductInput));
                        if (actPriceGiftType == "gift_num") {//赠品数量
                            //申请费用金额＝倍数*赠品数量*赠品最高成本价
                            var amount = numMulti( numMulti(typeGiftInput, giftCostPrice),multiple);
                            var scale = numDiv(amount, forecastSalesAmount);
                            scale = returnFloatThree(scale);
                            amount = returnFloat(amount);
                            $('#productDetailList').datagrid('updateRow', {
                                index: index,
                                row: {
                                    amount: amount,
                                    forecastSalesAmount: forecastSalesAmount,
                                    scale: scale
                                }
                            });
                        } else if (actPriceGiftType == "gift_amount") {//赠品金额
                            //申请费用金额＝倍数*赠品金额
                            var amount =numMulti(typeGiftInput,multiple);
                            var scale = numDiv(amount, forecastSalesAmount);
                            scale = returnFloatThree(scale);
                            amount = returnFloat(amount);
                            $('#productDetailList').datagrid('updateRow', {
                                index: index,
                                row: {
                                    amount: amount,
                                    forecastSalesAmount: forecastSalesAmount,
                                    scale: scale
                                }
                            });
                        } else if (actPriceGiftType == "gift_scale") {
                            //申请费用金额＝倍数*（赠品金额比例*本品金额）
                            var amount = numMulti(numMulti(numDiv(typeGiftInput,100), typeProductInput),multiple);
                            var scale = numDiv(amount, forecastSalesAmount);
                            scale = returnFloatThree(scale);
                            amount = returnFloat(amount);
                            $('#productDetailList').datagrid('updateRow', {
                                index: index,
                                row: {
                                    amount: amount,
                                    forecastSalesAmount: forecastSalesAmount,
                                    scale: scale
                                }
                            });
                        }
                    }else{
                        if (actPriceGiftType == "gift_num") {//赠品数量
                            //申请费用金额＝赠品数量*赠品成本价
                            var amount = numMulti(typeGiftInput, giftCostPrice);
                            var scale = numDiv(amount, forecastSalesAmount);
                            scale = returnFloatThree(scale);
                            amount = returnFloat(amount);
                            $('#productDetailList').datagrid('updateRow', {
                                index: index,
                                row: {
                                    amount: amount,
                                    forecastSalesAmount: forecastSalesAmount,
                                    scale: scale
                                }
                            });
                        } else if (actPriceGiftType == "gift_amount") {//赠品金额
                            //申请费用金额＝赠品金额
                            var amount = typeGiftInput;
                            var scale = numDiv(amount, forecastSalesAmount);
                            scale = returnFloatThree(scale);
                            amount = returnFloat(amount);
                            $('#productDetailList').datagrid('updateRow', {
                                index: index,
                                row: {
                                    amount: amount,
                                    forecastSalesAmount: forecastSalesAmount,
                                    scale: scale
                                }
                            });
                        } else if (actPriceGiftType == "gift_scale") {
                            //申请费用金额＝赠品金额比例*本品金额
                            var amount = numMulti(numDiv(typeGiftInput,100), typeProductInput);
                            var scale = numDiv(amount, forecastSalesAmount);
                            scale = returnFloatThree(scale);
                            amount = returnFloat(amount);
                            $('#productDetailList').datagrid('updateRow', {
                                index: index,
                                row: {
                                    amount: amount,
                                    forecastSalesAmount: forecastSalesAmount,
                                    scale: scale
                                }
                            });
                        }
                    }
                }
            }
        }
        editorAll();
    }

    function forecastSalesNumblur(index,newValue) {
        if(isEmpty(newValue)){
            return;
        }
        endEidtProductDetail();
        forecastSalesNumblurAll();
    }

    //初始化编辑
    function initNumEditor(index) {
        $("#productDetailList").datagrid('beginEdit',index);
        var forecastSalesNumEd = $('#productDetailList').datagrid('getEditor', {index:index,field:'forecastSalesNum'});
        console.log(forecastSalesNumEd);
        forecastSalesNumEd.target.numberbox({
            onChange:function(newValue,oldValue){
                forecastSalesNumblur(index,newValue);
            }
        })
    }

    //初始化编辑
    function initAmountEditor(index) {
        $("#productDetailList").datagrid('beginEdit',index);
        var forecastSalesAmountEd = $('#productDetailList').datagrid('getEditor', {index:index,field:'forecastSalesAmount'});
        forecastSalesAmountEd.target.numberbox({
            onChange:function(newValue,oldValue){
                forecastSalesNumblur(index,newValue);
            }
        })
    }

    //修改产品
    function updateProductDetail() {
        var rowsData = $('#productDetailList').datagrid('getSelections');
        if (rowsData.length==0 ) {
            tip("请至少选择一条数据");
        }else{
            var actPriceBuyType = $("select[name=actPriceBuyType]").val();
            if (actPriceBuyType == "product_num") {
                for(var i=0;i<rowsData.length;i++){
                    var index = $("#productDetailList").datagrid("getRowIndex",rowsData[i]);
                    initNumEditor(index);
                }
            }else if (actPriceBuyType == "product_amount") {
                for(var i=0;i<rowsData.length;i++){
                    var index = $("#productDetailList").datagrid("getRowIndex",rowsData[i]);
                    initAmountEditor(index);
                }
            }
        }
    }

    //删除产品
    function delProductDetail() {
        var rowsData = $('#productDetailList').datagrid('getSelections');
        if (rowsData.length==0 ) {
            tip("请至少选择一条数据");
        }else{
            for(var i=rowsData.length-1;i>=0;i--){
                var index = $("#productDetailList").datagrid("getRowIndex",rowsData[i]);
                $("#productDetailList").datagrid("deleteRow",index);
            }
        }
    }

    //减法
    function accSub(arg1, arg2) {
        var r1, r2, m, n;
        try { r1 = arg1.toString().split(".")[1].length } catch (e) { r1 = 0}
        try { r2 = arg2.toString().split(".")[1].length } catch (e) { r2 = 0}
        m = Math.pow(10, Math.max(r1, r2));
        n = (r1 >= r2) ? r1 : r2;
        return ((arg1 * m - arg2 * m) / m).toFixed(n);
    }
    /**
     * 乘法运算，避免数据相乘小数点后产生多位数和计算精度损失。
     *
     * @param num1被乘数 | num2乘数
     */
    function numMulti(num1, num2) {
        var baseNum = 0;
        try {
            baseNum += num1.toString().split(".")[1].length;
        } catch (e) {
        }
        try {
            baseNum += num2.toString().split(".")[1].length;
        } catch (e) {
        }
        return Number(num1.toString().replace(".", "")) * Number(num2.toString().replace(".", "")) / Math.pow(10, baseNum);
    };
    /**
     * 除法运算，避免数据相除小数点后产生多位数和计算精度损失。
     *
     * @param num1被除数 | num2除数
     */
    function numDiv(num1, num2) {
        var baseNum1 = 0, baseNum2 = 0;
        var baseNum3, baseNum4;
        var baseNum5;
        try {
            baseNum1 = num1.toString().split(".")[1].length;
        } catch (e) {
            baseNum1 = 0;
        }
        try {
            baseNum2 = num2.toString().split(".")[1].length;
        } catch (e) {
            baseNum2 = 0;
        }
        with (Math) {
            baseNum3 = Number(num1.toString().replace(".", ""));
            baseNum4 = Number(num2.toString().replace(".", ""));
            baseNum5 = (baseNum3 / baseNum4) * pow(10, baseNum2 - baseNum1);
            return baseNum5;
        }
    };

    /**
     * 保留两位小数
     * @param value
     * @returns {number}
     */
    function returnFloat(value){
        var value = Math.round(parseFloat(value) * 100) / 100;
        var s = value.toString().split(".");
        if(s.length== 1){
            value = value.toString() + ".00";
            return value;
        }
        if (s.length > 1) {
            if (s[1].length < 2) {
                value = value.toString() + "0";
            }
            return value;
        }
    }

    /**
     * 保留三位小数
     * @param value
     * @returns {number}
     */
    function returnFloatThree(value){
        var value = Math.round(parseFloat(value) * 1000) / 1000;
        return value.toFixed(3);
    }

    function getpriceForMap(priceParamVo) {

        var map = new Map();
        for(var i=0;i<priceParamVo.productCodes.length;i++){
            map.set(priceParamVo.productCodes[i],"");
        }
        $.ajax({
            url: "/kernel/mdmWareController/getWareStandPriceCommon",
            type: "post",
            dataType: "json",
            async : false,
            data: JSON.stringify(priceParamVo),
            contentType: "application/json",
            complete: function () {
            },
            success: function (res) {
                if (res.success) {
                    if(res.objList){
                        for(var i=0;i<res.objList.length;i++){
                            if(map.has(res.objList[i].wareCode)){
                                map.set(res.objList[i].wareCode,res.objList[i].priceAmount);
                            }
                        }
                    }
                    return map;
                } else {
                    tip(res.msg);
                }
            },
            error: function () {
            }
        });
        return map;
    }


</script>