<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<html>
<head>
    <title>商品管理</title>
    <t:base type="jquery,easyui,tools,DatePicker,ckeditor5,ckfinder"/>
    <link rel="stylesheet" href="/resources/fontawesome/css/font-awesome.min.css">
    <style>
        body {
            background: #fff;
        }

        .mr {
            margin-left: 20px;
        }

        .form, .form .form-group {
            margin-top: 5px;
        }

        .form-add-content {
            border-top: 1px solid #333333;
            border-bottom: 1px solid #333333;
        }

        .form-group .control-label {
            width: 80px;
            display: inline-block;
            text-align: right;
            white-space: nowrap;
        }

        .form .form-group input:not([type='radio']),
        .form .form-group select {
            height: 25px;
            border-width: 1px;
            -webkit-box-sizing: border-box;
            -moz-box-sizing: border-box;
            box-sizing: border-box;
        }

        .radio-group {
            margin-right: 45px;
            display: inline-block;
        }

        .radio-group label {
            margin-left: 10px;
        }

        .link-button {
            color: #0e78c9;
        }

        .form-group-left {
            float: left;
            margin-right: 40px;
            display: inline;
        }

        .form-group-right {
            float: left;
            display: inline;
        }

        .clude-container {
            padding: 10px 40px;
        }

        .clude-row {
            display: block;
            width: 100%;
            height: 200px;
            clear: left;
        }

        .clude-row h4 {
            display: inline;
            padding-right: 10px;
            float: left;
            line-height: 3;
            width: 6%;
        }

        .clude-row .form-group {
            float: left;
        }

        .select-container {
            background: #ffffff;
            border: 1px solid #000;
            width: 300px;
            height: 150px;
            overflow-y: auto;
        }

        .select-label-item {
            padding: 5px;
            background: #dddddd;
            color: #000000;
            position: relative;
            margin-top: 10px;
            margin-left: 10px;
            display: inline-block;
            border-radius: 10px;
        }

        .select-label-item:hover {
            background-color: #b3b2b2;
        }

        .select-label-item i {
            opacity: .8;
            margin-left: 8px;
            margin-right: 5px;
            cursor: pointer;
        }

        .select-label-item i:hover {
            opacity: 1;
        }

        .form-group-2 {
            width: 20%;
            box-sizing: border-box;
            float: left;
        }

        .form-group-8 {
            width: 80%;
            margin-left: 20%;
            box-sizing: border-box;
        }

        .upload-img-con {
            width: 100%;
        }

        .upload-img-item {
            text-align: center;
            width: 25%;
            float: left;
            position: relative;
        }

        .upload-img-item a {
            cursor: pointer;
        }

        .upload-img-item-index {
            width: 100%;
        }

        .click-upload-label {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .click-delete-label {
            position: absolute;
            top: 10%;
            right: 10%;
            transform: translate(-50%, -50%);
        }

        .click-upload-pic {
            cursor: pointer;
        }

        .click-upload-pic:hover {
            opacity: 0.6;
        }

        .upload-img-item img {
            width: 120px;
            height: 120px;
        }

        .ck-editor__editable {
            min-height: 100px;
        }

        select {
            width: 148px;
            background-color: white;
        }
        #content{
            height: 35% !important;
        }
    </style>
</head>
<body>
<t:formvalid action="null" layout="div" beforeSubmit="saveDate()"
             dialog="true" formid="tmWareForm">
<t:dgFormList layoutStyle="horizontal" tagConf="${clickFunctionId}">
    <t:dgFormColumn field="id" hidden="true" formClass="biz-col-33 mb5 form" labelName="id" optionType="input" required="false"
                    defaultVal="${vo.id}"
    />
    <t:dgFormColumn field="wareCode" hidden="false" formClass="biz-col-33 mb5 form" labelName="商品编码" optionType="input"  required="true"
      defaultVal="${vo.wareCode}"
      />
    <t:dgFormColumn field="wareName" hidden="false" formClass="biz-col-33 mb5 form" labelName="商品名称" optionType="input"  required="true"
                    defaultVal="${vo.wareName}"
    />
    <t:dgFormColumn field="specification" hidden="false" formClass="biz-col-33 mb5 form" labelName="规格" optionType="input"  required="true"
                    defaultVal="${vo.specification}"
    />
    <t:dgFormColumn field="barCode" hidden="false" formClass="biz-col-33 mb5 form" labelName="条码编码" optionType="input"  required="false"
                    defaultVal="${vo.barCode}"
    />
    <t:dgFormColumn field="isMarketMateriel" hidden="false" formClass="biz-col-33 mb5 form" typeGroupCode="is_no" labelName="任务标记" optionType="radio"  required="true"
                    defaultVal="${vo.isMarketMateriel}"
    />
    <t:dgFormColumn field="shelfStatus" hidden="false" formClass="biz-col-33 mb5 form" typeGroupCode="is_no" labelName="是否上架" optionType="radio"  required="true"
                    defaultVal="${vo.shelfStatus}"
    />
    <t:dgFormColumn field="rebateStatus" hidden="false" formClass="biz-col-33 mb5 form" typeGroupCode="is_no" labelName="返利标记" optionType="radio"  required="true"
                    defaultVal="${vo.rebateStatus}"
    />
    <t:dgFormColumn field="warePriority" hidden="false" formClass="biz-col-33 mb5 form" typeGroupCode="ware_priority" labelName="商品优先级" optionType="select"  required="true"
                    defaultVal="${vo.warePriority}"
    />
    <t:dgFormColumn field="meterUnit" hidden="false" formClass="biz-col-33 mb5 form" typeGroupCode="meter_unit" labelName="计量单位" optionType="select"  required="true"
                    defaultVal="${vo.meterUnit}"
    />
    <t:dgFormColumn field="saleUnit" hidden="false" formClass="biz-col-33 mb5 form" typeGroupCode="sale_unit" labelName="销售单位" optionType="select"  required="true"
                    defaultVal="${vo.saleUnit}"
    />
    <t:dgFormColumn field="beginTime" hidden="false" formClass="biz-col-33 mb5 form" labelName="开始时间" optionType="date" dateFormat="yyyy-MM-dd HH:mm:ss"  required="false"
                    defaultVal="${vo.beginTime}"
    />
    <t:dgFormColumn field="endTime" hidden="false" formClass="biz-col-33 mb5 form" labelName="结束时间" optionType="date" dateFormat="yyyy-MM-dd HH:mm:ss"  required="false"
                    defaultVal="${vo.endTime}"
    />
    <t:dgFormColumn field="composeType" hidden="false" formClass="biz-col-33 mb5 form" typeGroupCode="compose_type" labelName="组合类型" optionType="select"  required="true"
                    defaultVal="${vo.composeType}"
    />
    <t:dgFormColumn field="productLevelName" hidden="false" formClass="biz-col-33 mb5 form"  labelName="产品层级" optionType="choseDialog"
                    required="true" defaultVal="${vo.productLevelName}" onclick="selectProductLevel()"
    />

    <t:dgFormColumn field="productLevelCode" hidden="true" formClass="biz-col-33 mb5 form" labelName="编码" optionType="input"  required="false"
                    defaultVal="${vo.productLevelCode}"
    />
    <t:dgFormColumn field="extChar1" hidden="false" formClass="biz-col-33 mb5 form" labelName="extChar1" optionType="optionType" required="false"
                    defaultVal="${vo.extChar1 }"/>
    <t:dgFormColumn field="extChar2" hidden="false" formClass="biz-col-33 mb5 form" labelName="extChar2" optionType="optionType" required="false"
                    defaultVal="${vo.extChar2 }"/>
    <t:dgFormColumn field="extChar3" hidden="false" formClass="biz-col-33 mb5 form" labelName="extChar3" optionType="optionType" required="false"
                    defaultVal="${vo.extChar3 }"/>
    <t:dgFormColumn field="extChar4" hidden="false" formClass="biz-col-33 mb5 form" labelName="extChar4" optionType="optionType" required="false"
                    defaultVal="${vo.extChar4 }"/>
    <t:dgFormColumn field="extChar5" hidden="false" formClass="biz-col-33 mb5 form" labelName="extChar5" optionType="optionType" required="false"
                    defaultVal="${vo.extChar5 }"/>
    <t:dgFormColumn field="extChar6" hidden="false" formClass="biz-col-33 mb5 form" labelName="extChar6" optionType="optionType" required="false"
                    defaultVal="${vo.extChar6 }"/>
    <t:dgFormColumn field="extChar7" hidden="false" formClass="biz-col-33 mb5 form" labelName="extChar7" optionType="optionType" required="false"
                    defaultVal="${vo.extChar7 }"/>
    <t:dgFormColumn field="extChar8" hidden="false" formClass="biz-col-33 mb5 form" labelName="extChar8" optionType="optionType" required="false"
                    defaultVal="${vo.extChar8 }"/>
    <t:dgFormColumn field="extChar9" hidden="false" formClass="biz-col-33 mb5 form" labelName="extChar9" optionType="optionType" required="false"
                    defaultVal="${vo.extChar9 }"/>
    <t:dgFormColumn field="extChar10" hidden="false" formClass="biz-col-33 mb5 form" labelName="extChar10" optionType="optionType" required="false"
                    defaultVal="${vo.extChar10 }"/>
</t:dgFormList>
</t:formvalid>
<%--销售公司--%>
<div id="info-container">
    <div class="form form-add-content">
        <table id="templeteTable" style="width: 100%;" cellpadding="0" cellspacing="1"
               class="formtable">
            <tbody>
            <tr>
                <td>
                               <span style="position: relative;">

                                    <input field="formtable" name="productInfoCode" id="productInfoCode" type="text"
                                           style="width: 150px" class="inputxt">
                                    <a href="javascript:void(0);"
                                       onclick="selectProductInfo(this)" class="easyui-linkbutton"
                                       style="position: absolute;right:0;height: 24px;box-sizing: border-box;margin-right: 0;"
                                       plain="true" iconCls="icon-search"></a>
                                </span>

                </td>
                <td>
                    <input field="formtable" name="productInfoName"
                           type="text"
                           style="width: 150px" class="inputxt">
                </td>
                <td>
                    <input field="formtable" name="productNum"
                           type="text"
                           style="width: 150px" class="inputxt">
                </td>
                <td>
                    <input field="formtable" name="scale"
                           type="text"
                           style="width: 150px" class="inputxt" onblur="checkScale(this);">
                </td>
                <td>
                    <a iconCls="icon-remove" href="#" onclick="deleteTrTable(this)">删除</a>
                </td>
            </tr>
            </tbody>
        </table>
        <div id="actproduct" class="form-group flex">
            <label class="control-label flex-none">物料:</label>
            <div class="flex-auto">
                <a class="toolbar-btn" id="addTrBtn" href="#" onclick="addTrTable()">添加一行</a>
                <table id="showTable" class="table-dynamic mt10">
                    <thead>
                    <tr>
                        <th>物料编码</th>
                        <th>物料名称</th>
                        <th>数量</th>
                        <th>比例</th>
                        <th>操作</th>
                    </tr>
                    </thead>
                    <tbody>
                    <c:forEach items="${vo.tmWareProductVos}" var="item">
                        <tr id='trId___'>
                            <td>
                               <span style="position: relative;">
                                    <input field="formtable" name="productInfoCode" type="text"
                                           value="${item.productInfoCode}"
                                           style="width: 150px" class="inputxt">
                                    <a href="javascript:void(0);"
                                       onclick="selectProductInfo(this)" class="easyui-linkbutton"
                                       style="position: absolute;right:0;height: 24px;box-sizing: border-box;margin-right: 0;"
                                       plain="true" iconCls="icon-search"></a>
                                </span>

                            </td>
                            <td>
                                <input field="formtable" name="productInfoName" value="${item.productInfoName}"
                                       type="text"
                                       style="width: 150px" class="inputxt">
                            </td>
                            <td>
                                <input field="formtable" name="productNum" value="${item.productNum}"
                                       type="text"
                                       style="width: 150px" class="inputxt">
                            </td>
                            <td>
                                <input field="formtable" name="scale" value="${item.scale}"
                                       type="text"
                                       style="width: 150px" class="inputxt" onblur="checkScale(this);">
                            </td>
                            <td>
                                <a iconCls="icon-remove" href="#" onclick="deleteTrTable(this)">删除</a>
                            </td>
                        </tr>
                    </c:forEach>
                    </tbody>
                </table>
            </div>
        </div>
        <%--销售范围--%>
        <div class="form-group item-detail">
            <label class="control-label">销售范围:</label>
            <div class="clude-container">
                <div class="clude-row">
                    <h4>包含:</h4>
                    <div class="form-group">
                        <%--包含组织--%>
                        <div class="form-group-left">
                            <a class="easyui-linkbutton add-group" iconCls="icon-add" plain="true">添加组织</a>
                            <div class="include-selected-group select-container">
                                <c:forEach step="1" begin="0" items="${vo.tmWareSalerangeVos}" var="wareSalerange">
                                    <c:if test="${wareSalerange.containStatus == '1' && wareSalerange.containObjType == '0' && wareSalerange.orgCode != 'ALL'}">
                                        <label class="select-label-item">${wareSalerange.orgName}<i
                                                class="remove-item fa fa-close"></i></label>
                                        <input type="hidden" value="${wareSalerange.orgCode}" name="orgCode">
                                    </c:if>
                                </c:forEach>
                            </div>
                        </div>
                        <%--包含客户--%>
                        <div class="form-group-right">
                            <a class="easyui-linkbutton add-customer" iconCls="icon-add" plain="true">添加客户</a>
                            <div class="include-selected-customer select-container">
                                <c:forEach step="1" begin="0" items="${vo.tmWareSalerangeVos}" var="wareSalerange">
                                    <c:if test="${wareSalerange.containStatus == '1' && wareSalerange.containObjType == '1'}">
                                        <label class="select-label-item">${wareSalerange.custName}<i
                                                class="remove-item fa fa-close"></i></label>
                                        <input type="hidden" value="${wareSalerange.custCode}" name="custCode">
                                    </c:if>
                                </c:forEach>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="clude-row">
                    <h4>非包含:</h4>
                    <div class="form-group">
                        <%--非包含组织--%>
                        <div class="form-group-left">
                            <a class="easyui-linkbutton add-group" iconCls="icon-add" plain="true">添加组织</a>
                            <div class="exclude-selected-group select-container">
                                <c:forEach step="1" begin="0" items="${vo.tmWareSalerangeVos}" var="wareSalerange">
                                    <c:if test="${wareSalerange.containStatus == '0' && wareSalerange.containObjType == '0'}">
                                        <label class="select-label-item">${wareSalerange.orgName}<i
                                                class="remove-item fa fa-close"></i></label>
                                        <input type="hidden" value="${wareSalerange.orgCode}" name="orgCode">
                                    </c:if>
                                </c:forEach>
                            </div>
                        </div>
                        <%--非包含客户--%>
                        <div class="form-group-right">
                            <a class="easyui-linkbutton add-customer" iconCls="icon-add" plain="true">添加客户</a>
                            <div class="exclude-selected-customer select-container">
                                <c:forEach step="1" begin="0" items="${vo.tmWareSalerangeVos}" var="wareSalerange">
                                    <c:if test="${wareSalerange.containStatus == '0' && wareSalerange.containObjType == '1'}">
                                        <label class="select-label-item">${wareSalerange.custName}<i
                                                class="remove-item fa fa-close"></i></label>
                                        <input type="hidden" value="${wareSalerange.custCode}" name="custCode">
                                    </c:if>
                                </c:forEach>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<%--物料图片--%>
<div class="form">
    <input type="file" style="display: none" id="upload" accept="image/jpeg" onchange="uploadPicture();">
    <div class="form-group" style="padding:10px 40px;">
        <div class="form-group-2">
            <label class="control-label">首页展示图片：</label>
            <div class="upload-img-con" id="index_pic">
                <div class="upload-img-item upload-img-item-index">
                    <c:if test="${vo.urlPath == ''}">
                        <a class="link-button click-upload-label">点击上传</a>
                        <img id="pic0">
                    </c:if>
                    <c:if test="${vo.urlPath != ''}">
                        <img src="${vo.urlPath}" alt="" id="pic0" class="click-upload-pic" aria-required="true">
                        <a class="click-delete-label"><i class="fa fa-close remove-pic"></i></a>
                    </c:if>
                </div>
            </div>
        </div>
        <div class="form-group-8">
            <label class="control-label">详情页展示图片：</label>
            <div class="upload-img-con" id="detail_pic">
                <c:forEach var="i" begin="1" end="4">
                    <c:set var="existFlag" value="0"/>
                    <div class="upload-img-item">
                            <%--循环列表，把图片放入1-4对应的序号内--%>
                        <c:forEach items="${vo.tmWarePicVos}" var="detailPic" varStatus="index" begin="0">
                            <c:if test="${detailPic.sortNum == i }">
                                <input type="hidden" name="picId" value="${detailPic.id}">
                                <img src="${detailPic.urlPath}" alt="" id="pic${i}" class="click-upload-pic">
                                <a class="click-delete-label">
                                    <i class="fa fa-close remove-pic"></i>
                                </a>
                                <c:set var="existFlag" value="1"/>
                            </c:if>
                        </c:forEach>
                            <%--如果上面循环没有创建img标签--%>
                        <c:if test="${existFlag != 1}">
                            <a class="link-button click-upload-label">点击上传</a>
                            <img id="pic${i}">
                        </c:if>
                    </div>
                </c:forEach>
                <div style="clear: both"></div>
            </div>

        </div>
        <div style="clear: both"></div>
    </div>
</div>
<%--商品介绍--%>
<div class="form">
    <div class="form-group">
        <label class="control-label">商品介绍:</label>

        <textarea id="wareText" rows="10">${vo.wareText}</textarea>
    </div>
</div>

<!-- 配置文件 -->
<%--<script type="text/javascript" src="/resources/ueditor/ueditor.config.js"></script>--%>
<%--<!-- 编辑器源码文件 -->--%>
<%--<script type="text/javascript" src="/resources/ueditor/ueditor.all.js"></script>--%>

<!-- 注册选择组织、选择客户按钮的事件 -->
<script type="text/javascript">
    //移除组合类型中的单品选项，如果不选择的话默认就是单品
    $("select[name=composeType] option[value='30']").remove();

    //比例控制在0-1之间保留两位小数
    function checkScale(obj) {

        var re=/^(1|0(\.\d{1,2})?)$/;
        if(!re.test($(obj).val())){
            tip("请输入0-1之间数字，保留两位小数");
            $(obj).val("");
        }
    }

    composeChange();
    //选择组织类型对物料数量的影响
    function composeChange(){
        var composeType =$('select[name=composeType]').val();
        if (composeType == "20") {//范围
            $("#addTrBtn").show();
            $('input[name="productNum"]').attr("disabled","disabled");
            $('input[name="productNum"]').attr("nocheck",true);
            $('input[name="productNum"]').val("");
            $('input[name="scale"]').attr("nocheck",true);
            $('input[name="scale"]').attr("disabled",false);
        }else if (composeType == "10"){
            $("#addTrBtn").show();
            $('input[name="productNum"]').attr("disabled",false);
            $('input[name="productNum"]').attr("nocheck",false);
            $('input[name="scale"]').attr("disabled","disabled");
            $('input[name="scale"]').attr("nocheck",true);
        }else{
            $('input[name="productNum"]').attr("disabled",false);
            $('input[name="productNum"]').attr("nocheck",true);
            $('input[name="scale"]').attr("disabled",false);
            $('input[name="scale"]').attr("nocheck",true);
            var len = $ ("#showTable tbody tr").length;
            if (len<1) {
                $("#addTrBtn").show();
            }else{
                $("#addTrBtn").hide();
            }

        }
    }

    $('select[name=composeType]').change(function(){
        var composeType =$('select[name=composeType]').val();
        if (composeType == "20") {//范围
            $("#addTrBtn").show();
            var wareProductDetails = getWareProductDetails();
            if (wareProductDetails.length != 0) {
                $.messager.confirm('操作提示',"若切换组合类型，当前已填的物料数量数据将清空，确定？",function(r){
                    if (r){
                        $('input[name="productNum"]').attr("disabled","disabled");
                        $('input[name="productNum"]').attr("nocheck",true);
                        $('input[name="productNum"]').val("");
                        $('input[name="scale"]').attr("nocheck",true);
                        $('input[name="scale"]').attr("disabled",false);
                    }
                });
            }
        }else if (composeType == "10"){//礼包
            $("#addTrBtn").show();
            var wareProductDetails = getWareProductDetails();
            if (wareProductDetails.length != 0) {
                $.messager.confirm('操作提示',"若切换组合类型，当前已填的物料比例数据将清空，确定？",function(r){
                    if (r){
                        $('input[name="productNum"]').attr("disabled",false);
                        $('input[name="productNum"]').attr("nocheck",false);
                        $('input[name="scale"]').attr("disabled","disabled");
                        $('input[name="scale"]').attr("nocheck",true);
                    }
                });
            }
        }else{
            $('input[name="productNum"]').attr("disabled",false);
            $('input[name="productNum"]').attr("nocheck",true);
            $('input[name="scale"]').attr("disabled",false);
            $('input[name="scale"]').attr("nocheck",true);
            var wareProductDetails = getWareProductDetails();
            if (wareProductDetails.length > 1) {
                $("#addTrBtn").hide();
                var len = $ ("#showTable tbody tr").length;
                $("#showTable tbody tr").each(function (i,dom) {
                    if (i<1) {
                        return ;
                    }
                    $(this).remove();
                });
            }

        }
    })


    $('.add-product').on('click', function () {
        var url = '/page/tmApiProductInfoController/goProductInfoAndLevelListMain?check=false';
        var dom = $(this);
        createwindowExt("选择物料", url, 500, 400, {
            id: 'productinfoList',
            okVal: '确定',
            ok: function () {
                var iframe = this.iframe.contentWindow;
                //调用子页面的方法
                var rows = iframe.getChecked();
                // console.log(rows);
                //最近的容器
                var container = dom.next();
                //获取容器中已有的
                var exists = getExistItem(container);
                //添加选择的组织
                $.each(rows, function (index, row) {
                    if (exists.indexOf(row.companyCode) < 0) {
                        var item = '<label class="select-label-item">' + row.productInfoName + '<i class="remove-item fa fa-close"></i></label>';
                        var input = '<input type="hidden" value="' + row.productInfoCode + '" name="orgCode">';
                        container.append(item);
                        container.append(input);
                    }
                });
            }
        })
    });

    $('.add-group').on('click', function () {
        var url = '/page/tmApiOrgController/goOrgListMain?singleSelect=false';
        var dom = $(this);
        createwindowExt("选择组织", url, 500, 400, {
            id: 'orgList',
            okVal: '确定',
            ok: function () {
                var iframe = this.iframe.contentWindow;
                //调用子页面的方法
                var rows = iframe.getChecked();
                // console.log(rows);
                //最近的容器
                var container = dom.next();
                //获取容器中已有的
                var exists = getExistItem(container);
                //添加选择的组织
                $.each(rows, function (index, row) {
                    if (exists.indexOf(row.text) < 0) {
                        var item = '<label class="select-label-item">' + row.src + '<i class="remove-item fa fa-close"></i></label>';
                        var input = '<input type="hidden" value="' + row.text + '" name="orgCode">';
                        container.append(item);
                        container.append(input);
                    }
                });
            }
        })
    });

    $('.add-customer').on('click', function () {
        var dom = $(this);
        var url = '/page/tmApiCustomerController/goCustomerListMain?check=false';
        createwindowExt("选择客户", url, 500, 400, {
            id: 'customerList',
            okVal: '确定',
            ok: function () {
                //嵌套对话框时，对话框实际都在顶级页面中，所以这里在父页面中查找
                var iframe = this.iframe.contentWindow;
                //调用子页面的方法
                var rows = iframe.getChecked();
                //获取最近的容器
                var container = dom.next();
                //获取容器中已有的
                var exists = getExistItem(container);
                //添加选择的客户
                $.each(rows, function (index, row) {
                    //如果不含已存在的
                    if (exists.indexOf(row.customerCode) < 0) {
                        var item = '<label class="select-label-item">' + row.customerName + '<i class="remove-item fa fa-close"></i></label>';
                        var input = '<input type="hidden" value="' + row.customerCode + '" name="custCode">';
                        container.append(item);
                        container.append(input);
                    }
                });
            }
        })
    });
    /**
     * 销售范围的删除按钮事件
     */
    $('.select-container').on('click', '.remove-item', function () {
        //去除隐藏的input
        $(this).parent().next().remove();
        //去除label
        $(this).parent().remove();
    });

    $('.remove-pic').on('click', function () {
        var img = $(this).parent().prev();
        img.removeClass();
        img.removeAttr('src').removeAttr('alt');
        img.before('<a class="link-button click-upload-label">点击上传</a>')
        // $('#detail_pic').on('click', '.click-upload-label', function () {
        //     currentPicPosition = $(this).next().prop('id');
        //     $('#upload').click();
        // });
        $(this).parent().remove();
    });
    //当前点击的上传图片的id，用于定位更新上传后图片缩略图
    var currentPicPosition;
    $('#index_pic').on('click', '.click-upload-label', function () {
        currentPicPosition = 'pic0';
        $('#upload').click();
    });
    $('#detail_pic').on('click', '.click-upload-label', function () {
        currentPicPosition = $(this).next().prop('id');
        $('#upload').click();
    });

    $('.click-upload-pic').on('click', function () {
        currentPicPosition = $(this).prop('id');
        $('#upload').click();
    });
</script>
<script>
    var isView = '${isView}';
    if (isView == 2) {
        $('input').prop('disabled', true);
        $('a').css('display', 'none');
        $('select').prop('disabled', true);
        $('.remove-item').remove();
        //不可编辑
    }
    var editor = null;
    ClassicEditor.create(document.querySelector('#wareText'), {
        language: 'zh-cn',
        placeholder: '请输入商品介绍',
        ckfinder: {
            uploadUrl: '/upload/uploadController/uploadFileold'
        }
        // plugins:[Alignment]
        // ,toolbar: ['heading', '|', 'bulletedList', 'numberedList', 'alignment', 'undo', 'redo']
    }).then(function (editor) {
        this.editor = editor;
        editor.setData('${vo.wareText}');
        if (isView == 2) {
            editor.isReadOnly = true;
        } else {
            editor.isReadOnly = false;
        }
    });
</script>

<script>
    let canSubmit = true;
    /**
     * 获取页面的表单元素对象，用于父页面提交时调用
     * @returns Object/boolean
     */
    function getFormData() {

        if (!valid()) {
            tip('请检查必填项');
            return false;
        }
        var head = {};
        var headItems = [];
        var headPics = [];
        //组装基础属性
        head.id = '${vo.id}';
        head.extChar1 = $("#extChar1").val();
        head.extChar2 = $("#extChar2").val();
        head.extChar3 = $("#extChar3").val();
        head.extChar4 = $("#extChar4").val();
        head.extChar5 = $("#extChar5").val();
        head.extChar6 = $("#extChar6").val();
        head.extChar7 = $("#extChar7").val();
        head.extChar8 = $("#extChar8").val();
        head.extChar9 = $("#extChar9").val();
        head.extChar10 = $("#extChar10").val();
        var wareId = '${vo.id}';
        head.wareCode = $('input[name=wareCode]').val();
        var wareCode = $('input[name=wareCode]').val();
        head.wareName = $('input[name=wareName]').val();
        var wareName = $('input[name=wareName]').val();
        head.barCode = $('input[name=barCode]').val();
        head.productLevelName = $('input[name=productLevelName]').val();
        head.productLevelCode = $('input[name=productLevelCode]').val();
        head.urlPath = $('#pic0').prop('src');
        head.wareText = editor.getData();
        //上下架
        var shelfStatus = $('input[name=shelfStatus]:checked').val();
        head.shelfStatus = shelfStatus;
        //返利
        var rebateStatus = $('input[name=rebateStatus]:checked').val();
        head.rebateStatus = rebateStatus;
        //商品优先级
        var warePriority = $('select[name=warePriority]').val();
        head.warePriority = warePriority
        head.isMarketMateriel = $('input[name=isMarketMateriel]:checked').val();
        // head.brand = $('input[name=brand]').val();
        // head.category = $('input[name=category]').val();
        head.saleUnit = $('select[name=saleUnit]').val();
        head.meterUnit = $('select[name=meterUnit]').val();
        head.specification = $('input[name=specification]').val();
        head.deleteStatus = $('input[name=deleteStatus]:checked').val();
        var composeType =$('select[name=composeType]').val();
        head.composeType = composeType;
        head.beginTime = $('input[name=beginTime]').val();
        head.endTime = $('input[name=endTime]').val();

        var includeProduct = $('.include-selected-product').children('input');
        var includeCompany = $('.include-selected-group').children('input');
        var includeCustomer = $('.include-selected-customer').children('input');
        var excludeCompany = $('.exclude-selected-group').children('input');
        var excludeCustomer = $('.exclude-selected-customer').children('input');

        // var wareProductDetails = [];
        // //包含的物料
        // $.each(includeProduct, function (dindex, company) {
        //     var headItemDetail = {};
        //     headItemDetail.wareId = wareId;
        //     headItemDetail.wareCode = wareCode;
        //     headItemDetail.wareName = wareName;
        //     headItemDetail.productInfoCode = $(company).val();
        //     headItemDetail.productInfoName = $(company).prev().text();
        //
        //     wareProductDetails.push(headItemDetail);
        // });

        var wareProductDetails = getWareProductData();
        if (!canSubmit) {
            return false;
        }
        head.tmWareProductVos = wareProductDetails;

        if (wareProductDetails.length == 0) {
            tip("请选择物料");
            return false;
        }

        var headItemDetails = [];
        $.each(includeCompany, function (dindex, company) {
            var headItemDetail = {};
            headItemDetail.wareId = wareId;
            headItemDetail.wareCode = wareCode;
            headItemDetail.wareName = wareName;
            headItemDetail.orgCode = $(company).val();
            headItemDetail.orgName = $(company).prev().text();
            headItemDetail.containStatus = '1';
            headItemDetail.containObjType = '0';

            headItemDetails.push(headItemDetail);
        });
        $.each(includeCustomer, function (dindex, customer) {
            var headItemDetail = {};
            headItemDetail.wareId = wareId;
            headItemDetail.wareCode = wareCode;
            headItemDetail.wareName = wareName;
            headItemDetail.custCode = $(customer).val();
            headItemDetail.custName = $(customer).prev().text();
            headItemDetail.containStatus = '1';
            headItemDetail.containObjType = '1';

            headItemDetails.push(headItemDetail);
        });
        $.each(excludeCompany, function (dindex, company) {
            var headItemDetail = {};
            headItemDetail.wareId = wareId;
            headItemDetail.wareCode = wareCode;
            headItemDetail.wareName = wareName;
            headItemDetail.orgCode = $(company).val();
            headItemDetail.orgName = $(company).prev().text();
            headItemDetail.containStatus = '0';
            headItemDetail.containObjType = '0';

            headItemDetails.push(headItemDetail);
        });
        $.each(excludeCustomer, function (dindex, customer) {
            var headItemDetail = {};
            headItemDetail.wareId = wareId;
            headItemDetail.wareCode = wareCode;
            headItemDetail.wareName = wareName;
            headItemDetail.custCode = $(customer).val();
            headItemDetail.custName = $(customer).prev().text();
            headItemDetail.containStatus = '0';
            headItemDetail.containObjType = '1';

            headItemDetails.push(headItemDetail);
        });

        head.tmWareSalerangeVos = headItemDetails;

        //组装详情图片
        var $imgs = $('#detail_pic').find('img');
        $.each($imgs, function (index, img) {
            var urlPath = $(img).prop('src');
            //没有上传图片时
            if (urlPath === '') {
                //continue;
                return true;
            }
            var idInput = $(img).prev();
            var id;
            //表示此图片是原有的
            if (idInput.is('input')) {
                //获取原有的图片id
                id = idInput.val();
            } else {
                //新上传的图片，id设为空
                id = null;
            }
            var sortNum = parseInt($(img).prop('id').replace('pic', ''));

            var headPic = {
                id: id,
                wareId: '${vo.id}',
                wareCode: '${vo.wareCode}',
                wareName: '${vo.wareName}',
                urlPath: urlPath,
                sortNum: sortNum
            };
            headPics.push(headPic);
        });
        head.tmWarePicVos = headPics;
        //返回对象
        return head;
    }

    /**
     * 检查必填项
     *
     */
    function valid() {
        var returnflag = true;

        var inputs = $('input[required]');
        $.each(inputs, function (index, input) {
            var inputVal = $(input).val();
            if (inputVal == '' || inputVal == null) {
                returnflag = false;
                //break
                return false;
            }
        });

        var shelfStatuss = $('input[name^=shelfStatus]');
        $.each(shelfStatuss, function (index, shelfStatus) {
            var inputVal = $(shelfStatus).val();
            if (inputVal == '' || inputVal == null) {
                returnflag = false;
                //break
                return false;
            }
        });

        // var pic0 = $('#pic0').prop('src');
        // if (pic0 == '' || pic0 == undefined) {
        //     returnflag = false;
        // }
        return returnflag;
    }

    /**
     * 获取容器中已存在的code
     * @param $dom 容器jquery对象
     * @return array 字符串数组
     */
    function getExistItem($dom) {
        var array = [];
        var inputs = $dom.children('input');
        $.each(inputs, function (index, input) {
            array.push($(input).val());
        });
        return array;
    }

    /**
     * 上传图片
     */
    function uploadPicture() {
        var file = document.getElementById("upload").files[0];
        if (file == null || file == undefined) {
            return;
        }
        var formData = new FormData();

        formData.append("picture", file);
        formData.append("pointFolder", "product");
        $.ajax({
            url: "/upload/uploadController/uploadFileold",
            type: "POST",
            data: formData,
            dataType: 'json',
            contentType: false,
            processData: false,
            success: function (data) {
                if (data.success) {
                    var image = $('#' + currentPicPosition);
                    //显示缩略图
                    image.prop('src', data.obj[0].urlPath);
                    image.prop('alt', data.obj[0].fileName);
                    //添加点击可重新上传的class，事件
                    image.addClass('click-upload-pic');
                    $('.click-upload-pic').on('click', function () {
                        currentPicPosition = $(this).prop('id');
                        $('#upload').click();
                    });
                    //隐藏上传按钮
                    image.prev().css('display', 'none');
                    image.parent().append('<a class="click-delete-label"><i class="fa fa-close remove-pic" ></i></a>');
                    //重新添加删除按钮事件
                    $('.remove-pic').on('click', function () {
                        var img = $(this).parent().prev();
                        img.removeClass();
                        img.removeAttr('src').removeAttr('alt');
                        img.before('<a class="link-button click-upload-label">点击上传</a>')
                        $(this).parent().remove();
                    });
                    //清空上传文件域
                    var obj = document.getElementById('upload');
                    obj.outerHTML = obj.outerHTML;
                    // obj.files = null;
                } else {
                    tip(data.msg);
                }
            },
            error: function () {
                tip('上传失败');
            }
        });
    }

    //选择产品层级
    function selectProductLevel(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "productLevelCode";
        triggerName = "productLevelName";
        url = "/page/tmApiProductLevelController/goProductListMain";
        width = 500;
        height = 450;
        id = "productLevelList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#productLevelName").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    if (myobj[0].productCode !=null && myobj[0].productCode!=''){
                        $("#" + triggerId).val(myobj[0].productCode);
                        $("#" + triggerName).val(myobj[0].productName);
                    }else {
                        $("#" + triggerId).val(myobj[0].text);
                        $("#" + triggerName).val(myobj[0].src);
                    }
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    var trId = 0;
    var cloneTrTemp = "";
    $(function () {
        $('#templeteTable').hide();
        $('#addTrBtn').linkbutton({
            iconCls: 'icon-add'
        });
        var detail = '${load}';
        if (detail == "detail") {
            $('#addTrBtn').hide();
        }
        // addTrTable();
    });

    function addTrTable() {
        var tr = $("#templeteTable tbody").html();
        cloneTrTemp = tr;
        var replaceName = tr.replace(/___/g, trId);
        $("#showTable tbody").append(replaceName);
        composeChange();
        trId++;
    }

    function deleteTrTable(event) {
        $(event).parents("tr").remove();
    }

    //选择产品
    function selectProductInfo(obj) {
        var check = false;
        var composeType =$('select[name=composeType]').val();
        if (composeType == "") {//如果没有选择组合类型则为单品，单品则只能单选物料
            check = true;
        }
        var url = "/page/tmApiProductInfoController/goProductInfoAndLevelListMain?check="+check;
        var width = 900;
        var height = 500;
        id = "productinfoList";
        var gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData == '' || rowsData == null) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    var myobj = eval(rowsData);
                    $(obj).parent().find("input[name='productInfoCode']").val(myobj[0].productInfoCode);
                    $(obj).parent().parent().next().find("input[name='productInfoName']").val(myobj[0].productInfoName);
                    for (var i=1;i<rowsData.length;i++){
                        addTrTable();
                        var len = $("#showTable tbody tr").length;
                        var len2 = len-1;
                        $("#showTable tbody tr").each(function (index,dom) {
                            if (index == len2) {
                                $(this).children().find("input[name='productInfoCode']").val(myobj[i].productInfoCode);
                                $(this).children().find("input[name='productInfoName']").val(myobj[i].productInfoName);
                            }
                        });
                    }
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
    
    function getWareProductData() {

        canSubmit = true;
        var wareProductDetails = [];
        $("#showTable tbody tr").each(function () {
            if (canSubmit) {
                var headItemDetail = {};
                $(this).find("td").each(function (index) {
                    if (canSubmit) {
                        $(this).find("input[field=formtable]").each(function () {
                            var inputName = $(this).attr("name");
                            headItemDetail[inputName] = $(this).val();
                            if (!$(this).val() && $(this).attr("type") !== "hidden" && $(this).attr("nocheck") !== "true") {
                                canSubmit = false;
                                $(this).focus();
                                var name = $("#showTable thead tr th").eq(index).text();
                                tip(name + "不能为空");
                                return false;
                            }
                        })
                    } else {
                        return false;
                    }
                });
                wareProductDetails.push(headItemDetail);
            } else {
                return false;
            }
        });

        return wareProductDetails;
    }

    function getWareProductDetails() {

        var wareProductDetails = [];
        if ($("#showTable tbody tr").length > 0) {
            $("#showTable tbody tr").each(function () {
                var headItemDetail = {};
                $(this).find("td").each(function (index) {
                    $(this).find("input[field=formtable]").each(function () {
                        var inputName = $(this).attr("name");
                        headItemDetail[inputName] = $(this).val();
                    })

                });
                wareProductDetails.push(headItemDetail);
            });
        }
        return wareProductDetails;
    }
    function saveDate() {
        var head = getFormData();
        if(!head){
            return false;
        }
        $.ajax({
            url:'/kernel/mdmWareController/saveWareProduct',
            type:'POST',
            data:JSON.stringify(head),
            contentType: "application/json; charset=utf-8",
            dataType:'json',
            // beforeSend:function () {
            //     loadingTips.add("更新中……");
            // },
            success:function(data){
                var api = frameElement.api, W = api.opener;
                if (data.success) {
                    W.tip(data.msg);
                    W.wareListsearch();
                    api.close();
                } else {
                    tip(data.msg);
                }
            },
            error:function (result) {
                tip('服务器错误');
            },
            // complete:function () {
            //     loadingTips.remove();
            // }
        })
        return false;
    }

    
</script>
</body>
</html>
