<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>库存详情</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <style>
        body {
            background: #f3f3f3;
        }

        .goods-list {
            background: #ffffff;
            padding: 16px;
        }

        .goods-list-title {
            margin-bottom: 10px;
            color: #333333;
            font-size: 16px;
        }

        .goods-item {
            padding: 10px;
            background: #f6f6f6;
            color: #333333;
            border-radius: 5px;
        }

        .store-note .list-cell-title {
            color: #333333;
        }

        .upload-img {
            padding: 0 16px;
            background: #ffffff;
        }

        .upload-img img {
            width: 60px;
            height: 60px;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="store-detail">
            <list-cell title="客户" :value="store.terminalName"></list-cell>
            <div class="goods-list mt10">
                <div class="goods-list-title">商品清单</div>
                <div class="goods-item mb10" v-for="p in store.proList" :key="p.id">
                    <div class="goods-title mb10">产品名称：{{p.productInfoName}}</div>
                    <div class="flex flex-align-items-center flex-justify-content-between">
                        <div>产品编码：{{p.productInfoCode}}</div>
                        <div>数量：{{p.num}}</div>
                    </div>
                </div>
            </div>
            <div class="upload-img">
                <div class="goods-list-title">上传图片</div>
                <img :src="img.imgUrl" alt="" v-for="img in store.picList" :key="img.id">
            </div>
            <div class="store-note">
                <list-info title="备注" :value="store.remark" type="textarea"></list-info>
            </div>

        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>
    <script>
        var vm = new Vue({
            el: "#app",
            name: "StoreDetail",
            data: function () {
                return {
                    token: "",
                    id: "",
                    store: {}
                }
            },
            created: function () {
                this.token = getParameterByName("token");
                this.id = getParameterByName("id");
                this.loadData();
            },
            computed: {

            },
            methods: {

                loadData: function () {
                    var this_ = this;
                    $.ajax({
                        url: SERVER +
                            "/sfaapi/sfaApi/tsDataReportApiController/findDataReportInfo",
                        type: "post",
                        dataType: "json",
                        contentType: 'application/json',
                        headers: {
                            'loginUserToken': this_.token
                        },
                        data: JSON.stringify({
                            id: this_.id
                        }),
                        success: function (res) {
                            if (res.success) {
                                this_.store = res.obj;
                            }else{
                                showError(res.msg)
                            }
                        }
                    })
                }
            }
        })
    </script>
</body>

</html>