<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>拜访统计</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <style>
        body {
            padding: 0;
            margin: 0;
            background: #ffffff;
        }

        .visit-data select {
            border: none;
            background: transparent;
            outline: none;
        }

        .visit-data span {
            font-size: 14px;
        }

        .visit-data span.times {
            padding: 0 3px;
            color: orange;
        }

        .panel-title {
            font-weight: 600;
        }

        .detail-item {
            border: 1px solid #d8d8d8;
        }

        .detail-item-info span {
            font-size: 14px;
        }

        .detail-item-info span:last-child {
            color: #c5c5c5;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="visit">
            <div class="p10 visit-data flex flex-align-items-center flex-justify-content-between">
                <select v-model="range">
                    <option value="week">最近7天</option>
                </select>
                <span>今日拜访<span class="times">1700</span>次</span>
            </div>
            <div class="pv10">
                <div ref="visitLine" style="width: 100%;height:250px;box-sizing: border-box;"></div>
            </div>
            <div class="panel-title pl10 pb10">
                下级部门
            </div>
            <div class="detail-tree">
                <div class="detail-item ph10 pv5 flex flex-align-items-center flex-justify-content-between">
                    <span>华北大区销售部</span>
                    <span class="detail-item-info flex flex-column flex-align-items-center">
                        <span>1400次拜访</span>
                        <span>2000个客户</span>
                    </span>
                </div>
            </div>
        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>
    <script src="/resources/sfa/js/echarts.min.js"></script>

    <script>
        var vm = new Vue({
            el: "#app",
            name: "",
            data: function () {
                return {
                    range: "week",
                    visitLine: null
                }
            },
            created: function () {

            },
            mounted: function () {
                this.initVisitLine();
            },
            methods: {
                initVisitLine: function () {
                    this.visitLine = echarts.init(this.$refs.visitLine);
                    var option = {
                        xAxis: {
                            type: 'category',
                            boundaryGap: false,
                            data: ['08-21', '08-22', '08-23', '08-24', '08-25', '08-26',
                                '08-27'
                            ]
                        },
                        yAxis: {
                            type: 'value'
                        },
                        series: [{
                            data: [100, 500, 200, 150, 110, 800, 100],
                            type: 'line',
                            lineStyle: {
                                color: "#1890ff",
                            },
                            areaStyle: {
                                color: "#ffffff",
                                shadowColor: '#1890ff',
                                shadowBlur: 15
                            }
                        }]
                    };
                    this.visitLine.setOption(option);
                }
            }
        })
    </script>
</body>

</html>