<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div id="estimate_extract_List" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="estimateExtractList" tagConf="${clickFunctionId}" controllerTarget="ttEstimateExtractController" methedTarget="findTtEstimateExtractPage" idField="id" queryMode="group" fit="true" fitColumns="false"
                    actionUrl="/pay/ttEstimateExtractController/findTtEstimateExtractPage?clickFunctionId=${clickFunctionId}" pagination="true">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="预提类型" field="estimateType" formatterjs="tansType" query="true" dictionary="estimate_type"></t:dgCol>
            <t:dgCol title="预提明细编号" field="estimateCode" query="true"></t:dgCol>
            <t:dgCol title="预提年月" field="year" query="true" dictionary="financial_year"></t:dgCol>
            <t:dgCol title="活动年月" field="actYear" query="true" dictionary="financial_year"></t:dgCol>
            <t:dgCol title="活动总单号" field="actCode" ></t:dgCol>
            <t:dgCol title="活动明细编号" field="actDetailCode" ></t:dgCol>
            <t:dgCol title="活动名称" field="actName" ></t:dgCol>
            <t:dgCol title="组织" field="orgName" ></t:dgCol>
            <t:dgCol title="客户" field="custName" ></t:dgCol>
            <t:dgCol title="预算科目" field="budgetSubjectsName" ></t:dgCol>
            <t:dgCol title="活动大类" field="categoriesName" ></t:dgCol>
            <t:dgCol title="活动细类" field="fineName" ></t:dgCol>
            <t:dgCol title="产品层级" field="productLevelName" ></t:dgCol>
            <t:dgCol title="物料" field="productName" ></t:dgCol>
            <t:dgCol title="活动开始时间" field="beginTime"  formatter="yyyy-MM-dd"></t:dgCol>
            <t:dgCol title="活动结束时间" field="endTime"  formatter="yyyy-MM-dd"></t:dgCol>
            <t:dgCol title="支付方式" field="payType" dictionary="pay_type"></t:dgCol>
            <t:dgCol title="活动申请金额" field="actAmount" ></t:dgCol>
            <t:dgCol title="预提金额" field="estimateAmount" ></t:dgCol>

            <t:dgToolBar operationCode="applyEstimate" title="预提" icon="icon-add" width="400" height="500" url="/page/ttActAdvanceController/goTtActAdvanceProgressMain?1=1"
                         funname="addALL"></t:dgToolBar>
            <t:dgToolBar title="手工预提" operationCode="add" icon="icon-add" width="400" height="500" url="/page/ttEstimateExtractController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="add"></t:dgToolBar>
            <t:dgToolBar title="编辑" operationCode="edit" icon="icon-edit" width="400" height="500" url="/page/ttEstimateExtractController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="manualUpdate" ></t:dgToolBar>
<%--            <t:dgToolBar title="申请预提" operationCode="applyEstimate" icon="icon-edit" width="400" height="250" url=""--%>
<%--                         funname="applyEstimate" ></t:dgToolBar>--%>
            <%--<t:dgToolBar title="合同费用" operationCode="edit" icon="icon-edit" width="400" height="250" url=""
                         funname="contractCostEstimate" ></t:dgToolBar>--%>
            <t:dgToolBar title="费用池余额" operationCode="feePoolAmount" icon="icon-edit" width="400" height="250" url=""
                         funname="feePoolAmount" ></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look" icon="icon-edit" width="400" height="500" url="/page/ttEstimateExtractController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="detail"></t:dgToolBar>
            <t:dgToolBar operationCode="remove" title="删除" icon="icon-remove" url="/pay/ttEstimateExtractController/deleteTtEstimateExtract"
                         funname="deleteALLSelect"></t:dgToolBar>
            <t:dgToolBar operationCode="log" title="日志" icon="icon-log" url="/page/knlLogController/goShowLog"
                         width="1000" height="500"     funname="detail"></t:dgToolBar>
            <t:dgToolBar operationCode="style" title="个性设置" icon="icon-add" url="/page/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500"     funname="addSelect"></t:dgToolBar>

        </t:datagrid>
    </div>
</div>
<script>
    function manualUpdate() {
        var rowsData = $('#estimateExtractList').datagrid('getSelections');
        var myobj=eval(rowsData);
        //修改只允许修改手工预提
        if (myobj[0].estimateType != "Manual") {
            tip("只有手工预提可以编辑！");
            return false;
        }else{
            var addurl = "/page/ttEstimateExtractController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}&id="+myobj[0].id;
            createwindow("编辑", addurl,  400, 400, {});
        }
    }


    /**
     * 替換類型值
     */
    function tansType(value, row, index) {
        if(value == 'CostPool'){
            return "费用池预提";
        }
        if(value == 'ApplyNoExamine'){
            return "已申请未核销";
        }
        if(value == 'ExamineNobooks'){
            return "完全核销未上账";
        }
        if(value == 'PartExamineNobooks'){
            return "部分核销未上账";
        }
        if(value == 'Manual'){
            return "手工预提";
        }
    }

    function applyEstimate() {
        getSafeJq().dialog.confirm("你确定申请预提吗?", function (r) {
            if (r) {
                $.ajax({
                    url: "/pay/ttEstimateExtractController/applyEstimate",
                    type: 'post',
                    dataType: 'json',
                    data: {
                    },
                    cache: false,
                    success: function (data) {
                        tip(data.msg);
                        if (data.success) {
                            $("#estimateExtractList").datagrid("reload");
                        }
                    },
                    error: function () {
                    }
                });
            }
        });
    }
    function feePoolAmount() {
        getSafeJq().dialog.confirm("你确定费用池余额预提吗?", function (r) {
            if (r) {
                $.ajax({
                    url: "/pay/ttEstimateExtractController/feePoolAmountEstimate",
                    type: 'post',
                    dataType: 'json',
                    data: {
                    },
                    cache: false,
                    success: function (data) {
                        tip(data.msg);
                        if (data.success) {
                            $("#estimateExtractList").datagrid("reload");
                        }
                    },
                    error: function () {
                    }
                });
            }
        });
    }

    //预提
    function addALL(title, url, id, width, height, params) {
        var day = new Date();
        var time = day.format("yyyy-MM");
        title = time + "预提进度";
        height="400";
        width="700";
        var _char ="&";
        if (url.indexOf("?")==-1) {
            _char = "?";
        }
        url += _char;
        createwindowSmallOver(title, url, width, height);
    }

    function createwindowSmallOver(title, addurl, width, height, options) {
        var offsetW = window.top.document.body.offsetWidth;
        var offsetH = window.top.document.body.offsetHeight;
        width = (width && width != 'null') ? width : 700;
        height = (height && height != 'null') ? height : 400;
        if (width == "100%" || width > offsetW) {
            width = offsetW;
        }
        if (height == "100%" || height > (offsetH - 100)) {
            height = offsetH - 100;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: parseInt(width),
            height: parseInt(height),
            title: title,
            opacity: 0.3,
            parent:'yuti',
            zIndex:1500,
            cache: false,
            /* 为true等价于function(){} */
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    iframe.saveData("009");
                    return false;
                },
                cancelVal: '关闭',
                cancel: true,
                okVal:"提交"
            });
        }
        $.dialog(myOptions);
    }

</script>
