<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,autocomplete"></t:base>
<div id="tmMaintainPositionMain" class="easyui-layout" fit="true">
    <div data-options="region:'west',border:false,split:true" style="width:500px">
        <div class="easyui-layout" fit="true">

            <div data-options="region:'north',border:false,split:true" style="height:125px">
                <div style="width:80%;margin:  0 auto;margin-top: 20px;">
                    <div class="form" style="margin-bottom:15px">
                        <label class="Validform_label">区域编码:</label>
                        <input name="specialAreaCode" id="specialAreaCode" readonly class="inputxt" value=""
                               onClick="selectSpecialAreaCode();"
                               onClean="cleanSpecialArea();">
                        <a href="#" class="easyui-linkbutton" plain="true" icon="icon-search"
                           onClick="selectSpecialAreaCode();"></a>
                    </div>
                    <div class="form">
                        <label class="Validform_label">区域名称:</label>
                        <input name="specialAreaName" id="specialAreaName" readonly class="inputxt" value=""
                               onClick="selectSpecialAreaCode();"
                               onClean="cleanSpecialArea();">
                        <a href="#" class="easyui-linkbutton" plain="true" icon="icon-search"
                           onClick="selectSpecialAreaCode();"></a>
                    </div>
                </div>
            </div>

            <div data-options="region:'center',split:true,border:false">
                <t:datagrid name="noThisSpecialAreaList" title="未关联该区域的预算" fit="true" fitColumns="true" checkbox="true"
                            autoLoadData="false"
                            actionUrl="/budget/ttFeeBudgetController/findFeeBudgetBySpecialAreaCodeList"
                            idField="id" queryMode="single" singleSelect="false" pagination="true">
                    <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
                    <t:dgCol title="预算编码" field="budgetCode" query="true"></t:dgCol>
                    <t:dgCol title="年份" field="budgetYear" query="true"></t:dgCol>
                    <t:dgCol title="月份" field="budgetMonth" dictionary="month" query="true"></t:dgCol>
                    <t:dgCol title="组织" field="budgetDepartName" query="true"></t:dgCol>
                    <t:dgCol title="产品层级" field="productLevelName" query="true"></t:dgCol>
                    <t:dgCol title="科目" field="budgetSubjectsName" query="true"></t:dgCol>
                    <t:dgCol title="分组" field="subjectsGroupCode" dictionary="budget_group" query="true"></t:dgCol>
                    <t:dgCol title="物料" field="productName" query="false"></t:dgCol>
                    <t:dgCol title="客户编码" field="custCode" query="true"></t:dgCol>
                    <t:dgCol title="客户名称" field="custName" query="true"></t:dgCol>
                    <t:dgCol title="客户组织" field="custOrgName" query="true"></t:dgCol>
                    <t:dgCol title="门店" field="terminalName" query="false"></t:dgCol>
                    <t:dgCol title="区域编码" field="specialAreaCode" query="true"></t:dgCol>
                    <t:dgCol title="区域名称" field="specialAreaName" query="true"></t:dgCol>
                    <t:dgCol title="状态" field="enableStatus" dictionary="enable_status" query="true"></t:dgCol>
                    <t:dgToolBar title="添加关联" icon="icon-add" url="/budget/ttFeeBudgetController/addReloation"
                                 funname="addReloation"></t:dgToolBar>
                </t:datagrid>
            </div>

        </div>
    </div>

    <div data-options="region:'center',split:true,border:false">
        <t:datagrid name="thisSpecialAreaList" title="已关联该范围的预算" fit="true" fitColumns="true" checkbox="true"
                    autoLoadData="false"
                    singleSelect="false" actionUrl="/budget/ttFeeBudgetController/findFeeBudgetBySpecialAreaCodeList"
                    idField="id" pagination="true" queryMode="single">
            <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="预算编码" field="budgetCode" query="true"></t:dgCol>
            <t:dgCol title="年份" field="budgetYear" query="true"></t:dgCol>
            <t:dgCol title="月份" field="budgetMonth" dictionary="month" query="true"></t:dgCol>
            <t:dgCol title="分组" field="subjectsGroupCode" dictionary="budget_group" query="true"></t:dgCol>
            <t:dgCol title="物料" field="productName" query="true"></t:dgCol>
            <t:dgCol title="客户编码" field="custCode" query="true"></t:dgCol>
            <t:dgCol title="客户名称" field="custName" query="true"></t:dgCol>
            <t:dgCol title="客户组织" field="custOrgName" query="true"></t:dgCol>
            <t:dgCol title="门店" field="terminalName" query="true"></t:dgCol>
            <t:dgCol title="状态" field="enableStatus" dictionary="enable_status" query="true"></t:dgCol>
            <t:dgToolBar title="解除关联" icon="icon-remove" url="/budget/ttFeeBudgetController/deleteReloation"
                         funname="deleteReloation"></t:dgToolBar>
        </t:datagrid>
    </div>

</div>
<script type="text/javascript">
    /**
     * 添加关联
     * @param title
     * @param url
     * @param gname
     * @param width
     * @param height
     * @param params
     * @returns {boolean}
     */
    function addReloation(title, url, gname, width, height, params) {
        var specialAreaCode = $("#specialAreaCode").val();
        if (isEmpty(specialAreaCode)) {
            tip("请选择区域!", 'error');
            return false;
        }
        var rows = $("#" + gname).datagrid("getSelections");
        if (rows == null || rows == "") {
            tip("请至少选择一条数据");
            return false;
        }

        var budgetCodes = [];
        for (var i = 0; i < rows.length; i++) {
            budgetCodes.push(rows[i].budgetCode);
        }

        $.ajax({
            url: url,
            type: 'post',
            dataType: 'json',
            data: {
                budgetCodes: budgetCodes.join(','),
                specialAreaCode: specialAreaCode
            },
            cache: false,
            success: function (data) {
                var msg = data.msg;
                if (data.success) {
                    tip(msg, 'info');
                    reloadDataGrid();
                } else {
                    tip(msg, 'error');
                    return;
                }
            },
            error: function () {
                tip("请求错误", 'error');
                return false;
            }
        });
    }

    /**
     * 解除关联
     * @param title
     * @param url
     * @param gname
     * @param width
     * @param height
     * @param params
     * @returns {boolean}
     */
    function deleteReloation(title, url, gname, width, height, params) {

        var specialAreaCode = $("#specialAreaCode").val();
        if (isEmpty(specialAreaCode)) {
            tip("请选择区域!", 'error');
            return false;
        }
        var rows = $("#" + gname).datagrid("getSelections");
        if (rows == null || rows == "") {
            tip("请至少选择一条数据");
            return false;
        }

        var budgetCodes = [];
        for (var i = 0; i < rows.length; i++) {
            budgetCodes.push(rows[i].budgetCode);
        }

        getSafeJq().dialog.confirm("你确定移除该数据吗?", function (r) {
            if (r) {
                $.ajax({
                    url: url,
                    type: 'post',
                    dataType: 'json',
                    data: {
                        budgetCodes: budgetCodes.join(','),
                        specialAreaCode: specialAreaCode
                    },
                    cache: false,
                    success: function (data) {
                        var msg = data.msg;
                        if (data.success) {
                            tip(msg, 'info');
                            reloadDataGrid();
                        } else {
                            tip(msg, 'error');
                            return;
                        }
                    },
                    error: function () {
                        tip("职位端请求错误", 'error');
                        return false;
                    }
                });
            }
        });
    }

    /**
     * 重新加载别表数据
     * @param gname
     */
    function reloadDataGrid(gname) {
        var specialAreaCode = $("#specialAreaCode").val();
        if (isEmpty(specialAreaCode)) {
            tip("请选择区域!", 'error');
            return;
        }
        var noQueryParams = $("#noThisSpecialAreaList").datagrid('options').queryParams;
        $("#noThisSpecialAreaListtb_r").find('*').each(
            function () {
                noQueryParams[$(this).attr('name')] = $(this).val();
            }
        );
        noQueryParams.notSpecialAreaCodesStr = specialAreaCode;//设置查询参数
        $('#noThisSpecialAreaList').datagrid('options').queryParams = noQueryParams;

        // var thisQueryParams = $("#thisSpecialAreaList").datagrid("options").queryParams;//获取 option设置对象
        // thisQueryParams.inSpecialAreaCodesStr = specialAreaCode;//设置查询参数
        // $("#thisSpecialAreaList").datagrid("options").queryParams = thisQueryParams;//获取 option设置对象

        if (isEmpty(gname)) {
            $("#noThisSpecialAreaList").datagrid("reload");
            $("#thisSpecialAreaList").datagrid("reload");
        } else {
            $("#" + gname).datagrid("reload");
        }
    }

    /**
     * 查询已关联
     */
    function thisSpecialAreaListsearch() {
        var specialAreaCode = $("#specialAreaCode").val();
        if (isEmpty(specialAreaCode)) {
            tip("请选择区域!", 'error');
            return;
        }
        reloadDataGrid("thisSpecialAreaList");
    }

    /**
     * 查询未关联
     */
    function noThisSpecialAreaListsearch() {
        var specialAreaCode = $("#specialAreaCode").val();
        if (isEmpty(specialAreaCode)) {
            tip("请选择区域!", 'error');
            return;
        }
        reloadDataGrid("noThisSpecialAreaList");
    }


    /**
     * 选择特殊区域
     */
    function selectSpecialAreaCode(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "specialAreaCode";
        triggerName = "specialAreaName";
        url = "/page/ttSpecialAreaController/goSelectSpecialAreaMain?type=10";
        width = 460;
        height = 450;
        id = "specialAreaList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].code);
                    $("#" + triggerName).val(myobj[0].name);
                    reloadDataGrid();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /**
     * 清空选择的区域
     */
    function cleanSpecialArea() {
        $("#specialAreaCode").val("");
        $("#specialAreaName").val("");
    }
</script>