<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<head>
    <t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
</head>
<body class="easyui-layout" fit="true" id="region">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="functionList" tagConf="${clickFunctionId}"  idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/kernel/KnlFunctionController/findKnlFunctionPage" pagination="true" onClick="configLevePage" onLoadSuccess="loadFunLeveList">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="菜单名称" field="functionName" query="true"></t:dgCol>
            <t:dgCol title="菜单地址" field="functionUrl"></t:dgCol>

            <t:dgToolBar operationCode="addList" title="列表配置" icon="icon-edit" url="/page/knlTableConfigController/goKnlTableConfigMain"
                         width="850" height="450"    funname="detail"></t:dgToolBar>
            <t:dgToolBar operationCode="addForm" title="表单配置" icon="icon-edit" url="/page/knlFormConfigController/goKnlFormConfigMain"
                         width="1000" height="500"     funname="detail"></t:dgToolBar>
        </t:datagrid>
    </div>
<div data-options="region:'east',title:'下级页面配置',split:true" style="width:600px;">
    <t:datagrid name="funLeveList"  idField="id" queryMode="group" fit="true" fitColumns="true"
                actionUrl="/kernel/knlFunConfigController/findMdmFunConfigPage" pagination="false" autoLoadData="false">
        <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
        <t:dgCol title="菜单id" field="funId"  hidden="true"></t:dgCol>
        <t:dgCol title="下级菜单编码" field="pageCode"></t:dgCol>
        <t:dgCol title="下级菜单名称" field="functionName"></t:dgCol>
        <t:dgCol title="备注" field="notes"></t:dgCol>
        <t:dgToolBar title="新增" operationCode="add"  icon="icon-add" url="/page/knlFunConfigPageController/goSaveOrUpdateForm"
                     funname="add"  height="300" width="450"></t:dgToolBar>
        <t:dgToolBar title="编辑" operationCode="add" icon="icon-edit" url="/page/knlFunConfigPageController/goSaveOrUpdateForm"
                     funname="update" height="300" width="450"></t:dgToolBar>
        <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="/kernel/knlFunConfigController/deleteByIds"
                     funname="deleteALLSelect"></t:dgToolBar>
        <t:dgToolBar operationCode="addList" title="列表配置" icon="icon-edit" url="/page/knlTableConfigController/goKnlTableConfigMain"
                     width="850" height="450"    funname="detailLeve"></t:dgToolBar>
        <t:dgToolBar operationCode="addForm" title="表单配置" icon="icon-edit" url="/page/knlFormConfigController/goKnlFormConfigMain"
                     width="1000" height="500"     funname="detailLeve"></t:dgToolBar>

    </t:datagrid>
</div>
    <script type="text/javascript">
        function configLevePage(rowIndex, rowData) {
            loadFunLeveList();
        }
        function loadFunLeveList() {
            var id="";
            var rowsData = $('#functionList').datagrid('getSelections');
            if(rowsData.length>0){
                id = rowsData[0].id;
            }
            $('#funLeveList').datagrid({
                url: '/kernel/knlFunConfigController/findMdmFunConfigPage?funId='+id
            });
        }
        function add(title, addurl, gname, width, height, params) {
            var rowsData = $('#functionList').datagrid('getSelections');
            if(rowsData.length!=1){
                tip("请选择一个菜单");
                return false;
            }
            var id = rowsData[0].id;
            addurl = addurl+"?funId="+id;
            gridname = gname;
            if (typeof(gridname) != "undefined") {
                var rowData = $('#' + gridname).datagrid('getSelected');
                if (!checkAndExecallBack_before(params, rowData)) {
                    return;
                }
                if (params &&rowData) {
                    var paramsArr ;
                    if(Array.prototype.toString.call(params)=="[object Object]"){
                        if(params.params!=null&&params.params!=''){
                            paramsArr = params.params.split(",");
                        }
                    }else{
                        paramsArr = params.split(",");
                    }
                    for (var i = 0; i < paramsArr.length; i++) {
                        var _char = "&";
                        if (i == 0) {
                            if (addurl.indexOf("?") == -1) {
                                _char = "?";
                            }
                        }
                        addurl += _char + paramsArr[i] + "=" + rowData[paramsArr[i]];
                    }
                }
            }

            if (!width || width == "" || width == 'null' || !height || height == "" || height == 'null')
                createwindowSmall(title, addurl, width, height);
            else
                createwindow(title, addurl, width, height);
        }

        function detailLeve(title, url, id, width, height) {
            var rowsData = $('#' + id).datagrid('getSelections');
            // if (rowData.id == '') {
            // tip('请选择查看项目');
            // return;
            // }

            if (!rowsData || rowsData.length == 0) {
                tip('请选择查看项目');
                return;
            }
            if (rowsData.length > 1) {
                tip('请选择一条记录再查看');
                return;
            }
            var funId = rowsData[0].funId;
            var pageCode = rowsData[0].pageCode;
            var id = funId+"_"+pageCode;
            var _char = "&";

            if (url.indexOf("?") == -1) {
                _char = "?";
            }
            url += _char + 'load=detail&id=' + id;
            createdetailwindow(title, url, width, height);
        }


    </script>
</body>


