Vue.component('list-cell', {
    name: "ListCell",
    template: '<div class="list-cell" @click="handleClick" :class="link?\'clickable\':\'\'"><div class="list-cell-left">{{title}}</div><div v-if="!link"><span>{{value}}</span> </div><span v-else class="list-cell-arrow fa fa-angle-right"></span></div>',
    props: {
        title: "",
        value: "",
        link: {
            type: Boolean,
            default: false
        }
    },
    data: function () {
        return {

        }
    },
    methods: {
        handleClick: function () {
            if (this.link) {
                this.$emit("click")
            }
        }
    }
})

Vue.component('list-info', {
    name: "ListInfo",
    template: '<div class="list-info"><div class="list-cell-title"><span v-if="require" class="list-cell-require">*</span><span>{{title}}</span></div><div class="list-cell-value" v-if="type===\'textarea\'"><textarea readonly rows="3">{{value}}</textarea></div><div class="list-cell-value" v-else>{{value}}</div></div>',
    props: {
        title: "",
        value: "",
        type: "text",
        require: {
            type: Boolean,
            default: false
        }
    },
    data: function () {
        return {

        }
    },
    methods: {

    }
})

Vue.component('goods-cell', {
    name: "GoodsCell",
    template: '<div class="goods-cell flex flex-align-items-center" @click="handleClick" :class="link?\'clickable\':\'\'"><div class="goods-cell-img flex-none"><img src="" alt=""></div><div class="goods-cell-info flex-auto"><div class="goods-cell-title">{{title}}</div><div class="goods-cell-des">{{des}}</div></div><div class="goods-cell-arrow flex-none"><span class="list-cell-arrow fa fa-angle-right"></span></div></div>',
    props: {
        title: "",
        des: "",
        link: {
            type: Boolean,
            default: true
        }
    },
    data: function () {
        return {

        }
    },
    methods: {
        handleClick: function () {
            if (this.link) {
                this.$emit("click")
            }
        }
    }
})

Vue.filter('formateDate', function (date) {
    if (!date) return;
    date = date.replace(/-/g,"/");
    date = new Date(date);
    let year = date.getFullYear();
    let month = date.getMonth() + 1;
    let day = date.getDate();
    month = month + '';
    month = month[1] ? month : '0' + month;
    day = day + '';
    day = day[1] ? day : '0' + day;
    return [year, month, day].join("-");
}),
    Vue.filter('typeString', function (type) {
        let str = "";
        switch (type) {
            case "0":
                str = "日报"; break;
            case "1":
                str = "周报"; break;
            case "2":
                str = "月报"; break;
        }
        return str;
    })

var SERVER = '';

function getParameterByName(name) {
        name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
        var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
            results = regex.exec(location.search);
        return results == null ? "" : decodeURIComponent(results[1]);
}

function jsShowError(message) {
    js.jsShowError(message);
}

function showError(message){
    var u = navigator.userAgent;
    var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
    var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
    if (isAndroid) {
        jsShowError(message);
    }
    if (isiOS) {
        window.webkit.messageHandlers.jsShowError.postMessage(message);
    }
}

