/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.tag.tags;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.common.util.SelectExtend;
import com.biz.eisp.base.common.util.StringReplace;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.FreemarkerParseUtils;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.tools.DictUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang3.StringUtils;

public class DictSelectTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private String typeGroupCode;
    private String field;
    private String id;
    private String defaultVal;
    private String divClass;
    private String labelClass;
    private String inputClass;
    private String title;
    private boolean hasLabel = true;
    private String type = "select";
    private String dictTable;
    private String dictField;
    private String dictText;
    private String extendJson;
    private String dataType;
    private String ignore;
    private String selectPrompt;
    private String extend;
    private boolean isView;
    private Integer lineNum;
    private String list;
    private String selectValue;
    private String selectText;

    public int doStartTag() throws JspTagException {
        return 6;
    }

    public int doEndTag() throws JspTagException {
        try {
            JspWriter out = this.pageContext.getOut();
            out.print(this.end().toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 6;
    }

    public StringBuffer end() {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isBlank((CharSequence)this.divClass)) {
            this.divClass = "form";
        }
        if (StringUtils.isBlank((CharSequence)this.labelClass)) {
            this.labelClass = "Validform_label";
        }
        if (StringUtil.isNotEmpty((CharSequence)this.typeGroupCode)) {
            Map map = DictUtil.getDictMap((String)this.typeGroupCode);
            if (map != null && map.size() > 0) {
                this.chooseTheDoLine(map, sb);
            }
        } else if (StringUtil.isNotEmpty((CharSequence)this.list)) {
            Object obj = this.pageContext.getRequest().getAttribute(this.list);
            if (obj instanceof List) {
                this.createListLabel((List)obj, sb);
            } else if (obj instanceof Map) {
                this.createListMapLabel((Map)obj, sb);
            }
        }
        return sb;
    }

    private void createListMapLabel(Map<Object, Object> maps, StringBuffer sb) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (maps != null && maps.size() > 0) {
            for (Map.Entry<Object, Object> entry : maps.entrySet()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("TEXT", entry.getValue());
                map.put("FIELD", entry.getKey());
                mapList.add(map);
            }
        }
        this.chooseListTheDoLine(mapList, sb);
    }

    private void createListLabel(List objs, StringBuffer sb) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)objs)) {
            Object objTemp = objs.get(0);
            if (objTemp instanceof Map) {
                if (!StringUtil.isNotEmpty((CharSequence)this.selectText)) {
                    this.selectText = "value";
                }
                if (!StringUtil.isNotEmpty((CharSequence)this.selectValue)) {
                    this.selectValue = "key";
                }
                for (Object obj : objs) {
                    Map map = (Map)obj;
                    map.put("TEXT", map.get(this.selectText));
                    map.put("FIELD", map.get(this.selectValue));
                    mapList.add(map);
                }
            } else {
                ReflectHelper helper = new ReflectHelper(objs.get(0));
                for (Object obj : objs) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("TEXT", helper.getMethodValue(obj, this.selectText));
                    map.put("FIELD", helper.getMethodValue(obj, this.selectValue));
                    mapList.add(map);
                }
            }
        }
        this.chooseListTheDoLine(mapList, sb);
    }

    private void chooseListTheDoLine(List<Map<String, Object>> mapList, StringBuffer sb) {
        switch (this.type) {
            case "radio": {
                this.createListToRadioLabel(mapList, sb);
                break;
            }
            case "checkbox": {
                this.createListToCheckboxLabel(mapList, sb);
                break;
            }
            case "text": {
                this.createListToTextLabel(mapList, sb);
                break;
            }
            default: {
                this.select("---\u8bf7\u9009\u62e9---", mapList, sb);
            }
        }
    }

    private void chooseTheDoLine(Map<Object, Object> datasmap, StringBuffer sb) {
        switch (this.type) {
            case "radio": {
                this.createRadioLabel(datasmap, sb);
                break;
            }
            case "checkbox": {
                this.createCheckboxLabel(datasmap, sb);
                break;
            }
            case "text": {
                this.createTextLabel(datasmap, sb);
                break;
            }
            default: {
                this.createDefaultLabel(datasmap, sb);
            }
        }
    }

    private void createDefaultLabel(Map<Object, Object> datasmap, StringBuffer sb) {
        ArrayList mapList = new ArrayList();
        if (datasmap != null && datasmap.size() > 0) {
            ArrayList entities = new ArrayList();
            datasmap.forEach((k, v) -> {
                KnlDictDataEntity entity = (KnlDictDataEntity)v;
                if (StringUtils.isBlank((CharSequence)entity.getOrderNum())) {
                    entity.setOrderNum("0");
                }
                entities.add(entity);
            });
            entities.sort((ord1, ord2) -> Integer.valueOf(ord1.getOrderNum()).compareTo(Integer.valueOf(ord2.getOrderNum())));
            entities.forEach(item -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("TEXT", item.getDictValue());
                map.put("FIELD", item.getDictCode());
                mapList.add(map);
            });
        }
        this.select("---\u8bf7\u9009\u62e9---", mapList, sb);
    }

    private void createTextLabel(Map<Object, Object> datasmap, StringBuffer sb) {
        if (datasmap != null && datasmap.size() > 0) {
            datasmap.forEach((k, v) -> {
                KnlDictDataEntity entity = (KnlDictDataEntity)v;
                this.text(entity.getDictValue(), entity.getDictCode(), sb);
            });
        }
    }

    private void createListToTextLabel(List<Map<String, Object>> mapList, StringBuffer sb) {
        for (Map<String, Object> map : mapList) {
            this.text(map.get("TEXT"), map.get("FIELD"), sb);
        }
    }

    private void createCheckboxLabel(Map<Object, Object> datasmap, StringBuffer sb) {
        Map defaultValMap = MyBeanUtils.changeStringArrayToMap((String[])this.defaultVal.split(","));
        AtomicInteger i = new AtomicInteger();
        if (datasmap != null && datasmap.size() > 0) {
            datasmap.forEach((k, v) -> {
                KnlDictDataEntity entity = (KnlDictDataEntity)v;
                this.checkIsNeedTheNextTr(i.get(), sb);
                this.checkbox(entity.getDictValue(), entity.getDictCode(), defaultValMap, sb);
                i.getAndIncrement();
            });
        }
    }

    private void createListToCheckboxLabel(List<Map<String, Object>> mapList, StringBuffer sb) {
        Map defaultValMap = MyBeanUtils.changeStringArrayToMap((String[])this.defaultVal.split(","));
        int i = 0;
        for (Map<String, Object> map : mapList) {
            this.checkIsNeedTheNextTr(i, sb);
            this.checkbox(map.get("TEXT"), map.get("FIELD"), defaultValMap, sb);
            ++i;
        }
    }

    private void createRadioLabel(Map<Object, Object> datasmap, StringBuffer sb) {
        AtomicInteger i = new AtomicInteger();
        if (datasmap != null && datasmap.size() > 0) {
            datasmap.forEach((k, v) -> {
                KnlDictDataEntity entity = (KnlDictDataEntity)v;
                this.checkIsNeedTheNextTr(i.get(), sb);
                this.radio(entity.getDictValue(), entity.getDictCode(), sb);
                i.getAndIncrement();
            });
        }
    }

    private void createListToRadioLabel(List<Map<String, Object>> mapList, StringBuffer sb) {
        int i = 0;
        for (Map<String, Object> map : mapList) {
            this.checkIsNeedTheNextTr(i, sb);
            this.radio(map.get("TEXT"), map.get("FIELD"), sb);
            ++i;
        }
    }

    private void checkIsNeedTheNextTr(int i, StringBuffer sb) {
        if (this.lineNum != null && this.lineNum != 0 && i % this.lineNum == 0 && i > 0) {
            sb.append("</br>");
        }
    }

    private void text(Object name, Object code, StringBuffer sb) {
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> textMap = new HashMap<String, Object>();
        textMap.put("flag", "text");
        textMap.put("field", this.field);
        textMap.put("code", code);
        textMap.put("name", name);
        textMap.put("defaultVal", this.defaultVal);
        textMap.put("extend", this.extend);
        textMap.put("dataType", this.dataType);
        textMap.put("isView", this.isView);
        textMap.put("inputClass", this.inputClass);
        param.put("param", textMap);
        param.put("StringReplace", new StringReplace());
        sb.append(freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/DictSelect.ftl", param));
    }

    private void radio(Object name, Object code, StringBuffer sb) {
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> radioMap = new HashMap<String, Object>();
        radioMap.put("flag", "radio");
        radioMap.put("field", this.field);
        radioMap.put("code", code);
        radioMap.put("dataType", this.dataType);
        radioMap.put("name", name);
        radioMap.put("defaultVal", this.defaultVal);
        radioMap.put("extend", this.extend);
        radioMap.put("dataType", this.dataType);
        radioMap.put("isView", this.isView);
        radioMap.put("lineNum", this.lineNum);
        radioMap.put("inputClass", this.inputClass);
        param.put("param", radioMap);
        param.put("StringReplace", new StringReplace());
        sb.append(freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/DictSelect.ftl", param));
    }

    private void checkbox(Object name, Object code, Map<String, String> defaultValMap, StringBuffer sb) {
        Boolean checked = false;
        if (StringUtil.isNotEmpty((CharSequence)defaultValMap.get(code))) {
            checked = true;
        }
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> checkboxMap = new HashMap<String, Object>();
        checkboxMap.put("flag", "checkbox");
        checkboxMap.put("field", this.field);
        checkboxMap.put("code", code);
        checkboxMap.put("id", this.id);
        checkboxMap.put("checked", checked);
        checkboxMap.put("name", name);
        checkboxMap.put("extend", this.extend);
        checkboxMap.put("dataType", this.dataType);
        checkboxMap.put("isView", this.isView);
        checkboxMap.put("lineNum", this.lineNum);
        checkboxMap.put("inputClass", this.inputClass);
        param.put("param", checkboxMap);
        param.put("StringReplace", new StringReplace());
        sb.append(freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/DictSelect.ftl", param));
    }

    private void select(String name, List map, StringBuffer sb) {
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Object> selectMap = new HashMap<String, Object>();
        selectMap.put("flag", "select");
        selectMap.put("field", this.field);
        selectMap.put("extendJson", this.extendJson);
        selectMap.put("id", this.id);
        selectMap.put("dataType", this.dataType);
        selectMap.put("ignore", this.ignore);
        selectMap.put("map", map);
        selectMap.put("name", name);
        selectMap.put("defaultVal", this.defaultVal);
        selectMap.put("extend", this.extend);
        selectMap.put("isView", this.isView);
        param.put("param", selectMap);
        param.put("StringReplace", new StringReplace());
        param.put("SelectExtend", new SelectExtend());
        sb.append(freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/DictSelect.ftl", param));
    }

    public String getTypeGroupCode() {
        return this.typeGroupCode;
    }

    public void setTypeGroupCode(String typeGroupCode) {
        this.typeGroupCode = typeGroupCode;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDefaultVal() {
        return this.defaultVal;
    }

    public void setDefaultVal(String defaultVal) {
        this.defaultVal = defaultVal;
    }

    public String getDivClass() {
        return this.divClass;
    }

    public void setDivClass(String divClass) {
        this.divClass = divClass;
    }

    public String getLabelClass() {
        return this.labelClass;
    }

    public void setLabelClass(String labelClass) {
        this.labelClass = labelClass;
    }

    public String getInputClass() {
        return this.inputClass;
    }

    public void setInputClass(String inputClass) {
        this.inputClass = inputClass;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isHasLabel() {
        return this.hasLabel;
    }

    public void setHasLabel(boolean hasLabel) {
        this.hasLabel = hasLabel;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDictTable() {
        return this.dictTable;
    }

    public void setDictTable(String dictTable) {
        this.dictTable = dictTable;
    }

    public String getDictField() {
        return this.dictField;
    }

    public void setDictField(String dictField) {
        this.dictField = dictField;
    }

    public String getDictText() {
        return this.dictText;
    }

    public void setDictText(String dictText) {
        this.dictText = dictText;
    }

    public String getExtendJson() {
        return this.extendJson;
    }

    public void setExtendJson(String extendJson) {
        this.extendJson = extendJson;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getIgnore() {
        return this.ignore;
    }

    public void setIgnore(String ignore) {
        this.ignore = ignore;
    }

    public String getSelectPrompt() {
        return this.selectPrompt;
    }

    public void setSelectPrompt(String selectPrompt) {
        this.selectPrompt = selectPrompt;
    }

    public String getExtend() {
        return this.extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public boolean getIsView() {
        return this.isView;
    }

    public void setIsView(boolean isView) {
        this.isView = isView;
    }

    public Integer getLineNum() {
        return this.lineNum;
    }

    public void setLineNum(Integer lineNum) {
        this.lineNum = lineNum;
    }

    public String getList() {
        return this.list;
    }

    public void setList(String list) {
        this.list = list;
    }

    public String getSelectValue() {
        return this.selectValue;
    }

    public void setSelectValue(String selectValue) {
        this.selectValue = selectValue;
    }

    public String getSelectText() {
        return this.selectText;
    }

    public void setSelectText(String selectText) {
        this.selectText = selectText;
    }
}

