<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <style>
        [v-cloak]{
            display: none;
        }
        .chart-column {
            width: 50%;
            height: 500px;
            box-sizing: border-box;
        }
    </style>
</head>

<body>
<div id="app" v-cloak>
    <div class="flex flex-wrap">
        <div class="chart-column" v-for="(item,index) in list" :key="index">
            <div ref="chart" style="width: 100%;height: 100%;">
            </div>
        </div>
    </div>
</div>
<script src="/resources/tools/vue.min.js"></script>
<script src="/resources/echarts/echarts.min.js"></script>
<script>
    function BizSocket(options) {
        var socket = null;
        if (window.location.href.indexOf("http://") > -1) {
            var url = "ws://" + options.url + (options.uuid || '');
            socket = new WebSocket(url);
        } else if (window.location.href.indexOf("https://") > -1) {
            var url = "wss://" + options.url + (options.uuid || '');
            socket = new WebSocket(url);
        }
        return socket;
    }

    let vm = new Vue({
        el: "#app",
        data: function () {
            return {
                socket: null,
                isFirstConnect: true,
                list: []
            }
        },
        mounted: function () {
            this.initSocket();
        },
        methods: {
            initSocket: function () {
                let uuid = Math.random();
                let socketOptions = {url:window.location.host + '${ramWebsocketUrl}', uuid: uuid};
                this.socket = BizSocket(socketOptions);
                let this_ = this;
                if (this.socket) {
                    this_.socket.onopen = function (ev) {
                    };
                    this_.socket.onmessage = function (ev) {
                        if (this_.isFirstConnect) {
                            this_.list = JSON.parse(ev.data);
                            this_.isFirstConnect = false;
                            this_.$nextTick(function () {
                                this_.list.forEach(function (item, index) {
                                    this_.initException(item, index);
                                });
                            })
                        } else {
                            this_.renderDynamic(JSON.parse(ev.data))
                        }
                    };
                    this_.socket.onerror = function (ev) {
                    };
                    this_.socket.onclose = function (ev) {
                        console.log("Closed");
                    };
                }
            },
            initException: function (item, index) {
                let this_ = this;
                let ref = this_.replaceLine(item.sysModular);
                this_[ref] = echarts.init(this_.$refs.chart[index]);
                let option = {
                    title: {
                        x: 'center',
                        top: 0,
                        text: item.sysModular + '实时监控',
                        subtext: "总的内存量：" + (item.allMemory || 0) + "M 空闲的内存量：" + (item.freeMemory || 0) + "M 最大的内存量：" + (item.maxMemory || 0) + "M"
                    },
                    tooltip: {
                        trigger: 'axis'
                    },
                    grid: {
                        top: 100,
                    },
                    legend: {
                        top: 50,
                        data: ['堆内存信息', '方法区内存信息']
                    },
                    xAxis: [{
                        type: 'category',
                        boundaryGap: true,
                        data: (function (item) {
                            var res = [];
                            for (let i = 0; i < item.ramMonitorVos.length; i++) {
                                res.unshift(item.ramMonitorVos[i].currentTime.split(" ")[1])
                            }
                            return res;
                        })(item)
                    }],
                    yAxis: [{
                        type: 'value',
                        scale: true,
                        name: '堆内存信息',
                        boundaryGap: [0.2, 0.2]
                    },
                        {
                            type: 'value',
                            scale: true,
                            name: '方法区内存信息',
                            boundaryGap: [0.2, 0.2]
                        }
                    ],
                    series: [{
                        name: '堆内存信息',
                        type: 'line',
                        smooth: true,
                        areaStyle: {},
                        data: (function (item) {
                            var res = [];
                            for (let i = 0; i < item.ramMonitorVos.length; i++) {
                                res.unshift(item.ramMonitorVos[i].heapUsed)
                            }
                            return res;
                        })(item)
                    },
                        {
                            name: '方法区内存信息',
                            type: 'line',
                            smooth: true,
                            yAxisIndex: 1,
                            areaStyle: {
                                color: '#1890ff'
                            },
                            data: (function (item) {
                                var res = [];
                                for (let i = 0; i < item.ramMonitorVos.length; i++) {
                                    res.unshift(item.ramMonitorVos[i].methodAreaUsed)
                                }
                                return res;
                            })(item)
                        }
                    ]
                };
                this_[ref].setOption(option);
            },
            renderDynamic: function (list) {
                let this_ = this;
                list.forEach(function (item, index) {
                    let ref = this_.replaceLine(item.sysModular);
                    let option = this_[ref].getOption();
                    let xData = [];
                    for (let i = 0; i < item.ramMonitorVos.length; i++) {
                        xData.unshift(item.ramMonitorVos[i].currentTime.split(" ")[1])
                    }
                    let yHeap = [];
                    for (let i = 0; i < item.ramMonitorVos.length; i++) {
                        yHeap.unshift(item.ramMonitorVos[i].heapUsed)
                    }
                    let yMethod = [];
                    for (let i = 0; i < item.ramMonitorVos.length; i++) {
                        yMethod.unshift(item.ramMonitorVos[i].methodAreaUsed)
                    }
                    option.xAxis[0].data = xData;
                    option.series[0].data = yHeap;
                    option.series[1].data = yMethod;
                    this_[ref].setOption(option);
                })
            },
            replaceLine: function (str) {
                return str.replace(/-/g, "");
            }
        },
    })
</script>
</body>

</html>