<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div class="easyui-layout" fit="true">
	<div region="west" style="width:500px;">
		<t:formvalid formid="formobj" layout="div" dialog="true" action="/sfaapi/tsDirectoryConfigController/saveTsDirectoryConfig" beforeSubmit="addInputInfo" refresh="true">
			<input type="hidden" id="inputConfigInfo" name="inputConfigInfo">
			<input type="hidden" id="id" name="id" value="${vo.id}">
				<div class="form">
					<label class="Validform_label">步骤名称: </label>
					<input type="text"  name="directoryName" id="directoryName" datatype="*" value="${vo.directoryName}" />
					<span style="color: red;">*</span>
				</div>
			<div class="form">
				<label class="Validform_label">拜访类型: </label>
				<t:dictSelect id="visitType" field="visitType" type="select" defaultVal="${vo.visitType}"
							  typeGroupCode="visit_type" dataType="*" >
				</t:dictSelect>
				<span style="color: red;">*</span>
			</div>
            <div class="form">
                <label class="Validform_label">类别: </label>
                <t:dictSelect id="sfacusType" field="sfacusType" type="select" defaultVal="${vo.sfacusType}"
                              typeGroupCode="sfacust_type" dataType="*" >
                </t:dictSelect>
                <span style="color: red;">*</span>
            </div>
            <div class="form"
					<c:if test="${vo.sfacusType==''}">
				     style='display: none'
			        </c:if> id="ctn">
                <label class="Validform_label" >分类: </label>
				<c:choose>
					<c:when test="${vo.sfacusType=='01'}">
						<t:dictSelect   id="classification1" field="classification" type="select" defaultVal="${vo.classification}"
									  typeGroupCode="channel" dataType="*" >
						</t:dictSelect>
						<t:dictSelect extend="style='display: none' disabled='disabled'"  id="classification2" field="classification" type="select" defaultVal="${vo.classification}"
									  typeGroupCode="terminal_type"  >
						</t:dictSelect>
					</c:when>
					<c:when test="${vo.sfacusType=='02'}">
						<t:dictSelect extend="style='display: none'  disabled='disabled'"  id="classification1" field="classification" type="select" defaultVal="${vo.classification}"
									  typeGroupCode="channel"  >
						</t:dictSelect>
						<t:dictSelect  id="classification2" field="classification" type="select" defaultVal="${vo.classification}"
									  typeGroupCode="terminal_type" dataType="*" >
						</t:dictSelect>
					</c:when>
					<c:otherwise>
						<t:dictSelect extend="style='display: none' disabled='disabled'"  id="classification1" field="classification" type="select" defaultVal="${vo.classification}"
									  typeGroupCode="channel" dataType="*" >
						</t:dictSelect>
						<t:dictSelect extend="style='display: none' disabled='disabled'"  id="classification2" field="classification" type="select" defaultVal="${vo.classification}"
									   typeGroupCode="terminal_type" dataType="*" >
						</t:dictSelect>
					</c:otherwise>
				</c:choose>
                <span style="color: red;">*</span>
            </div>
			<div class="form">
				<label class="Validform_label">有效开始时间: </label>
				<input name="beginDate" id="beginDate" datatype="*" class="Wdate" style="width: 150px;"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',maxDate:'#F{$dp.$D(\'endDate\')}'})"
					   readonly="readonly"  value="${vo.beginDate}" />
				<span style="color: red;">*</span>
			</div>
			<div class="form">
				<label class="Validform_label">有效结束时间: </label>
				<input name="endDate" id="endDate" datatype="*" class="Wdate" style="width: 150px;"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',minDate:'#F{$dp.$D(\'beginDate\')}'})"
					   readonly="readonly"  value="${vo.endDate}" />
				<span style="color: red;">*</span>
			</div>
			<div class="form">
				<label class="Validform_label">是否启用: </label>
				<t:dictSelect id="enableStatus" field="enableStatus" type="radio" defaultVal="${vo.enableStatus}"
							  typeGroupCode="enable_status" dataType="*">
				</t:dictSelect>
				<span style="color: red;">*</span>
			</div>
			<div class="form">
				<label class="Validform_label">备注: </label>
				<textarea rows="3" cols="20"  name="remarks" id="remarks" >${vo.remarks}</textarea>
			</div>
		</t:formvalid>
	</div>
	<div region="center">
		<t:datagrid name="tsInputConfigList" title="拜访步骤表单控件"  actionUrl="/sfaapi/tsDirectoryConfigController/findTsInputConfigListByDirectId?directId=${vo.id}"
					idField="id" fit="true"  fitColumns="false" pagination="false" queryMode="group"  >
			<t:dgCol title="id"  field="id"  hidden="true"  queryMode="single"  ></t:dgCol>

			<t:dgCol title="控件编码"  field="lableCode"  hidden="false"  queryMode="single"  ></t:dgCol>
			<t:dgCol title="控件名称"  field="lableName"  hidden="false"  queryMode="single"  ></t:dgCol>
			<t:dgCol title="控件类型"  field="inputType"  hidden="false" dictionary="input_type"  queryMode="single"  ></t:dgCol>
			<t:dgCol title="控件值对应数据字典编码"  field="dictionaryCode"  hidden="false"  queryMode="single"  ></t:dgCol>
			<t:dgCol title="后缀"  field="postfix"  hidden="false"  queryMode="single"  ></t:dgCol>
			<t:dgCol title="备注"  field="remark"  hidden="false"  queryMode="single"  ></t:dgCol>
			<t:dgCol title="是否必填"  field="isNeed" dictionary="is_no" hidden="false"  queryMode="single" editor="combobox"></t:dgCol>
			<t:dgCol title="排序"  field="sort"  hidden="false"  queryMode="single" editor="{type:'numberbox',options:{min:0}}"></t:dgCol>
			<c:if test='${type!="detail"}'>
			<t:dgToolBar title="添加" icon="icon-add" url="" funname="addInputConfig" ></t:dgToolBar>
			<t:dgToolBar title="移除" icon="icon-remove" id="removeBar" url="" funname="removeInputConfig" ></t:dgToolBar>
			</c:if>
		</t:datagrid>
    </div>
</div>
<script type="text/javascript">
	$(document).ready(function (){
		//初始化编码器，及添加单击行事件开始编辑
		$("#tsInputConfigList").datagrid({
			onClickRow: function (rowIndex, rowData){
				$(this).datagrid('beginEdit', rowIndex);
				//
				var editors = $(this).datagrid('getEditors', rowIndex);
				$.each(editors, function (index, editor){
					if (editor.type == "combobox") {
						var ed = $("#tsInputConfigList").datagrid('getEditor', { index: rowIndex, field: editor.field });
						if (editor.field == "isNeed") {
							$(ed.target).combobox('reload', "/tmTableConfigController.do?dictCombox&dictCode=is_no");
						}
					}
				});
			}
		});
	});

	$("#sfacusType").change(function(i,name){
        var vl=$(this).children('option:selected').val();
        if (vl==""){  //未选择
			$("#ctn").css("display","none");
			$("#classification1").attr("disabled","disabled");
			$("#classification2").attr("disabled","disabled");
        } else if(vl=="01"){  //经销商  channel classification1
            $("#ctn").css("display","");
			$("#classification1").css("display","");
			$("#classification1").attr("dataType","*");
			$("#classification2").removeAttr("dataType");
			$("#classification1").removeAttr("disabled");
			$("#classification2").css("display","none");
			$("#classification2").attr("disabled","disabled");


        } else if(vl=="02"){  //门店  terminal_type  classification2
			$("#ctn").css("display","");
			$("#classification2").css("display","");
			$("#classification2").removeAttr("disabled");
			$("#classification2").attr("dataType","*");
			$("#classification1").removeAttr("dataType");
			$("#classification1").css("display","none");
			$("#classification1").attr("disabled","disabled");
        }
    });
	function starEdit(rowData){
        var rows = rowData.rows;
        var gridObj = $("#tsInputConfigList");
	    $.each(rows,function (index,row) {
            openEdit(gridObj,index);
        });
	}
	function openEdit(gridObj,index){
        // gridObj.datagrid('endEdit', index);
        // gridObj.datagrid('beginEdit', index);
	}
    function sortInput(value) {
        if(value==null){
            value="";
		}
		var str = "<input type='text' onkeyup='verifyNum(this)'  value='"+value+"' name='sort'>";
		return str;
    }

    function verifyNum(obj) {
        obj.value = obj.value.replace(/[^\d]/g,""); // 清除"数字"以外的字符
    }

	//拜访对象名称
	function changeObj() {
        var checkText=$("#visitObjectCode").find("option:selected").text();
        $("#visitObjectName").val(checkText);
    }
    //主目录名称
    function changePrimary(){
	    var name=$("#primaryDirectoryCode").find("option:selected").text();
	    $("#primaryDirectoryName").val(name);
	}
    //添加控件
    function addInputConfig() {
        var dg = $('#tsInputConfigList');
        var ids="";
        var rows = $("#tsInputConfigList").datagrid("getRows");
        var ids="";
        if(rows!=null){
            for(var i=0;i<rows.length;i++) {
                if(ids==""){
                    ids+=rows[i].id;
                }else{
                    ids+=","+rows[i].id;
                }
            }
		}

        var myOptions = {
            content : "url:/page/tsInputConfigController/selectInputConfig?ids="+ids ,
            lock : true,
            width : 800,
            height : 600,
            title : "添加控件",
            opacity : 0.3,
            cache : true,
            async: false,
            ok : function() {
                iframe = this.iframe.contentWindow;
                var datas = iframe.checkQuoAct();
                if(datas!=""){
                    for(i in datas){
                        var dataObj = datas[i];
                        dataObj.sort="";
						dg.datagrid("appendRow",dataObj);
                        toOpenEdit(dg,dataObj);
                    }
                    return true;
                }else{
                    return false;
                }
            },
            cancelVal : '关闭',
            cancel : true
        };
        safeShowDialog(myOptions);
    }
    function toOpenEdit(grObj,row){
        var index = grObj.datagrid("getRowIndex",row);
        openEdit(grObj,index);
	}
    //移除
    function removeInputConfig(){
        var obj = $('#tsInputConfigList');
        var rows = obj.datagrid("getSelections");
        if (rows.length <= 0) {
            tip("请选择要移除的控件","error");
            return ;
        }
        //移除数据
        var selectRows = [];
        for (var i = 0; i < rows.length; i++) {
            var dataTemp = rows[i];
            selectRows.push(dataTemp);
        }
        for(var j =0;j<selectRows.length;j++){
            var index = $('#tsInputConfigList').datagrid('getRowIndex',selectRows[j]);
            obj.datagrid('deleteRow',index);
        }
    }
    function change(obj){
        var checks = document.getElementsByName("type");
        var types = "";
        if(checks&&checks.length>0){
            for(var i=0;i<checks.length;i++){
                if(checks[i].checked){
                    if(types.length>0){
                        types += "," + checks[i].value;
                    }else{
                        types += checks[i].value;
                    }
                }
            }
        }
        $("#collectionType").val(types);
	}

    //提交前验证
    function addInputInfo() {

        var r=document.getElementsByName("businessUnitCode");
        var name="";
        for(var i=0;i<r.length;i++){
            if(r[i].checked){
                if(name==""){
                    name+=r[i].nextSibling.nodeValue;
				}else{
                    name+=","+r[i].nextSibling.nodeValue;
				}
            }
        }
        $("#businessUnitName").val(name);
		var rows = $("#tsInputConfigList").datagrid("getRows");
		var rt=true;

		$.each(rows, function (index, row){
			var rowIndex = $("#tsInputConfigList").datagrid("getRowIndex", row);

			$("#tsInputConfigList").datagrid('endEdit', rowIndex);
		});
		var rows_ = $("#tsInputConfigList").datagrid("getRows");
		$.each(rows_, function (index, row){
			if(row.isNeed === undefined || row.isNeed === null ||row.isNeed === ""){
				tip("第"+(Number(index)+1)+"行请选择是否必填");
				rt=false;
				return false;
			}
			if(row.sort === undefined || row.sort === null ||row.sort === ""){
				tip("第"+(Number(index)+1)+"行请输入排序");
				rt=false;
				return false;
			}
		});

		var dg=$('#tsInputConfigList');
		var rows = dg.datagrid("getRows");
        var inputInfo=JSON.stringify(rows);
		$("#inputConfigInfo").val(inputInfo);
		return rt;
    }

    // 获取输入框编辑器对象
    function getEditorObj(gridObj,index,clomnName){
        // 获取输入框编辑器对象
        return gridObj.datagrid('getEditor', {index:index,field:clomnName});
    }
    //返回数据
    function returnEditorValueByEditorObj(ed){
        return $(ed.target).val();
    }
    //获取编辑器的值
    function getEditorValue(gridObj,index,clomnName){
        // 获取输入框编辑器的值
        var ed = getEditorObj(gridObj,index,clomnName);
        return $(ed.target).val();
    }

</script>