<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>公告详情</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <style>
        body {
            background: #f3f3f3;
        }

        #app {
            padding: 10px;

        }

        .notice-detail {
            padding: 10px;
            box-sizing: border-box;
            border-radius: 5px;
            background: #ffffff;
        }

        .notice-title {
            text-align: center;
            font-weight: 600;
        }

        .notice-date {
            text-align: right;
            font-size: 14px;
            margin-top: 5px;
        }

        .notice-content {
            line-height: 1.5;
            box-sizing: border-box;
            padding: 5px;
            margin-top: 10px;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="notice-detail">
            <div class="notice-title">{{notice.noticeTitle}}</div>
            <div class="notice-date">{{notice.createDate|formatDate}}</div>
            <div class="notice-content">
                {{notice.noticeContent}}
            </div>
        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>

    <script>
        var vm = new Vue({
            el: "#app",
            name: "NoticeDetail",
            data: function () {
                return {
                    token: "",
                    id: "",
                    notice: {}
                }
            },
            created: function () {
                this.token = getParameterByName("token");
                this.id = getParameterByName("id");
                this.loadData();
            },
            computed: {

            },
            filters:{
                formatDate:function(date){
                    if (!date) return;
                    date = date.replace(/-/g,"/");
                    date = new Date(date);
                    let year = date.getFullYear();
                    let month = date.getMonth() + 1;
                    let day = date.getDate();
                    month = month + '';
                    month = month[1] ? month : '0' + month;
                    day = day + '';
                    day = day[1] ? day : '0' + day;
                    return [year, month, day].join("-");
                }
            },
            methods: {
                loadData: function () {
                    var this_ = this;
                    $.ajax({
                        url: SERVER +
                            "/sfaapi/sfaApi/tsNoticeApiController/getKnlNoticeByParamObj?id=" +
                            this_
                            .id,
                        type: "post",
                        dataType: "json",
                        contentType: 'application/x-www-form-urlencoded',
                        headers: {
                            'loginUserToken': this_.token
                        },
                        success: function (res) {
                            if (res.success) {
                                this_.notice = res.obj;
                            }else{
                                showError(res.msg)
                            }
                        }
                    })
                },
            }
        })
    </script>
</body>

</html>