<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,DatePicker"></t:base>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <style>
        .chart-column {
            width: 50%;
            height: 500px;
            box-sizing: border-box;
        }
        .search {
            background: #0D3349;
            color: #ffffff;
            font-size: 12px;
            border: none;
            outline: none;
            height: 22px;
        }
    </style>
</head>

<body>
<div id="app" v-cloak>
    <div>
        <span style="font-size: 12px">开始时间</span>
        <input name="beginTime" id="beginTime" class="Wdate" style="width: 150px;font-size: 12px"
               onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',minDate:'%y-%M-%d 00:00:00',maxDate:'%y-%M-{%d+1} 23:59:59'})"
               readonly="readonly" >
        <span style="font-size: 12px">结束时间</span>
        <input name="endTime" id="endTime" class="Wdate" style="width: 150px;font-size: 12px"
               onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',minDate:'%y-%M-%d 00:00:00',maxDate:'%y-%M-{%d+1} 23:59:59'})"
               readonly="readonly"/>
        <button class="search" @click="initSocket">查询</button>
    </div>
    <div class="flex flex-wrap">
        <div class="chart-column" v-for="(item,index) in list" :key="index">
            <div ref="chart" style="width: 100%;height: 100%;">
            </div>
        </div>
    </div>
</div>
<script src="/resources/tools/vue.min.js"></script>
<script src="/resources/echarts/echarts.min.js"></script>
<script>

    let vm = new Vue({
        el: "#app",
        data: function () {
            return {
                socket: null,
                beginTime:"",
                endTime:"",
                list: []
            }
        },
        mounted: function () {
            this.initSocket();
        },
        methods: {
            initSocket: function () {
                let this_ = this;
                var beginTime = $("#beginTime").val();
                var endTime = $("#endTime").val();
                $.ajax({
                    url:"/kernel/knlRamMonitorController/getHistoryRamMonitorList?beginTime="+beginTime+"&endTime="+endTime,
                    data:{
                    },
                    type:'post',
                    success:function(data){
                        this_.list = data.objList;
                        this_.$nextTick(function () {
                            data.objList.forEach(function (item, index) {
                                this_.initException(item, index);
                            });
                        })
                    }
                })
            },
            initException: function (item, index) {
                let this_ = this;
                let ref = this_.replaceLine(item.sysModular);
                this_[ref] = echarts.init(this_.$refs.chart[index]);
                let option = {
                    title: {
                        x: 'center',
                        top: 0,
                        text: item.sysModular + '实时监控',
                        subtext: "总的内存量：" + (item.allMemory || 0) + "M 空闲的内存量：" + (item.freeMemory || 0) + "M 最大的内存量：" + (item.maxMemory || 0) + "M"
                    },
                    tooltip: {
                        trigger: 'axis'
                    },
                    grid: {
                        top: 100,
                    },
                    legend: {
                        top: 50,
                        data: ['堆内存信息', '方法区内存信息']
                    },
                    xAxis: [{
                        type: 'category',
                        boundaryGap: true,
                        data: (function (item) {
                            var res = [];
                            for (let i = 0; i < item.ramMonitorVos.length; i++) {
                                res.unshift(item.ramMonitorVos[i].currentTime.split(" ")[1])
                            }
                            return res;
                        })(item)
                    }],
                    yAxis: [{
                        type: 'value',
                        scale: true,
                        name: '堆内存信息',
                        boundaryGap: [0.2, 0.2]
                    },
                        {
                            type: 'value',
                            scale: true,
                            name: '方法区内存信息',
                            boundaryGap: [0.2, 0.2]
                        }
                    ],
                    series: [{
                        name: '堆内存信息',
                        type: 'line',
                        smooth: true,
                        areaStyle: {},
                        data: (function (item) {
                            var res = [];
                            for (let i = 0; i < item.ramMonitorVos.length; i++) {
                                res.unshift(item.ramMonitorVos[i].heapUsed)
                            }
                            return res;
                        })(item)
                    },
                        {
                            name: '方法区内存信息',
                            type: 'line',
                            smooth: true,
                            yAxisIndex: 1,
                            areaStyle: {
                                color: '#1890ff'
                            },
                            data: (function (item) {
                                var res = [];
                                for (let i = 0; i < item.ramMonitorVos.length; i++) {
                                    res.unshift(item.ramMonitorVos[i].methodAreaUsed)
                                }
                                return res;
                            })(item)
                        }
                    ]
                };
                this_[ref].setOption(option);
            },
            replaceLine: function (str) {
                return str.replace(/-/g, "");
            }
        },
    })
</script>
</body>

</html>