<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>历史总结详情</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
</head>

<body>
    <div id="app" v-cloak>
        <div class="history-detail">
            <list-cell title="提报人" :value="history.createName"></list-cell>
            <list-cell title="类型" :value="history.summaryTypeStr"></list-cell>
            <list-cell title="提报日期" :value="formatDate(history.createDate)"></list-cell>
            <list-info title="今日工作总结" :value="history.currentContent"></list-info>
            <list-info title="明日工作计划" :value="history.nextContent"></list-info>
            <list-cell title="可见范围" :value="history.protTypeStr"></list-cell>
        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>

    <script>
        var vm = new Vue({
            el: "#app",
            name: "HistoryDetail",
            data: function () {
                return {
                    token: "",
                    id: "",
                    history: {}
                }
            },
            created: function () {
                this.token = getParameterByName("token");
                this.id = getParameterByName("id");
                this.loadData();
            },
            computed: {

            },
            methods: {
                loadData: function () {
                    var this_ = this;
                    $.ajax({
                        url: SERVER +
                            "/sfaapi/sfaApi/tsWorkSummaryApiController/findWorkSummaryById?id=" +
                            this_.id,
                        type: "post",
                        dataType: "json",
                        contentType: 'application/x-www-form-urlencoded',
                        headers: {
                            'loginUserToken': this_.token
                        },
                        success: function (res) {
                            if (res.success) {
                                this_.history = res.obj;
                            }else{
                                showError(res.msg)
                            }
                        }
                    })
                },
                formatDate: function (date) {
                    if (!date) return;
                    date = date.replace(/-/g,"/");
                    date = new Date(date);
                    let year = date.getFullYear();
                    let month = date.getMonth() + 1;
                    let day = date.getDate();
                    month = month + '';
                    month = month[1] ? month : '0' + month;
                    day = day + '';
                    day = day[1] ? day : '0' + day;
                    return [year, month, day].join("-");
                }
            }
        })
    </script>
</body>

</html>