<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <t:base type="jquery,easyui,tools,DatePicker"></t:base>
    <title>AI陈列配置</title>
    <style>
        .display-form-label {
            width: 100px;
            text-align: right;
            white-space: nowrap;
            margin-right: 15px;
        }

        .display-form-input {
            width: 300px;
            height: 32px;
            border: 1px solid #d8d8d8;
            padding: 0 5px;
            border-radius: 5px;
            box-sizing: border-box;
        }

        .display-form-date {
            width: 300px;
        }

        .display-form-date input {
            width: 100%;
            height: 32px;
            border: 1px solid #d8d8d8;
            box-sizing: border-box;
            padding: 0 5px;
            border-radius: 5px;
        }

        .display-selected {
            width: 600px;
        }

        .display-add-btn {
            display: block;
            margin-bottom: 5px;
            margin-left: 20px;
            text-decoration: none;
        }

        .group-selected-container,
        .customer-selected-container {
            width: 100%;
            height: 200px;
            box-sizing: border-box;
            border: 1px solid #333333;
            overflow-y: auto;
        }

        .display-normal {
            margin-left: 115px;
            margin-bottom: 10px;
            width: 700px;
        }

        .display-select-btn {
            display: inline-block;
            text-decoration: none;
            border: 1px solid #d8d8d8;
            height: 32px;
            box-sizing: border-box;
            text-align: center;
            line-height: 32px;
            padding: 0 10px;
            margin: 5px 0;
            border-radius: 5px;
        }

        .display-product-table {
            border-collapse: collapse;
            table-layout: fixed;
            width: 100%;
        }

        .display-product-table th {
            white-space: nowrap;
            line-height: 32px;
            border: 1px solid #666;
            background: #ddd;
        }

        .display-product-table td {
            line-height: 32px;
            white-space: nowrap;
            border: 1px solid #666;
            text-align: center;
            overflow: hidden;
        }

        .display-product-table td input {
            width: 70%;
            height: 100%;
            border-radius: 5px;
            outline: none;
            border: 1px solid #aaa;
            padding: 0 5px;
        }

        .display-judge {
            width: 700px;
        }

        .display-judge-table {
            border-collapse: collapse;
            table-layout: fixed;
            width: 100%;
        }

        .display-judge-table th {
            white-space: nowrap;
            line-height: 32px;
            border: 1px solid #666;
            background: #ddd;
        }

        .display-judge-table td {
            line-height: 32px;
            white-space: nowrap;
            border: 1px solid #666;
            text-align: center;
            overflow: hidden;
        }

        .display-judge-table td input {
            width: 70%;
            height: 100%;
            border-radius: 5px;
            outline: none;
            border: 1px solid #aaa;
            padding: 0 5px;
        }

        .range-tag {
            background: #d8d8d8;
            padding: 3px 10px;
            border-radius: 10px;
            font-size: 14px;
            display: inline-block;
        }

        .range-tag span {
            cursor: pointer;
        }

        .range-tag span:hover {
            color: #1890ff;
        }
    </style>
</head>

<body>
<div id="app" class="dispaly-container p10">
    <div class="display-form mb10 flex flex-align-items-center" v-show="displayCode">
        <label class="display-form-label">编号：</label>
        <span>{{displayCode}}</span>
    </div>
    <div class="display-form mb10 flex flex-align-items-center">
        <label class="display-form-label">陈列标准名称：</label>
        <input type="text" v-model="displayName" class="display-form-input"/>
    </div>
    <div class="display-form mb10 flex flex-align-items-center">
        <label class="display-form-label">陈列要求描述：</label>
        <input type="text" v-model="displayDesc" class="display-form-input"/>
    </div>
    <div class="display-form mb10 flex flex-align-items-center">
        <label class="display-form-label">有效期：</label>
        <div class="display-form-date flex flex-align-items-center">
            <input type="text" v-model="beginDate" placeholder="开始日期" id="beginDate" @click="selectDate('beginDate')"
                   readonly
                   class="flex-1"/>
            <span class="mh5 flex-none">-</span>
            <input type="text" v-model="endDate" placeholder="结束日期" id="endDate" @click="selectDate('endDate')"
                   readonly class="flex-1"/>
        </div>
    </div>
    <div class="display-form mb10 flex flex-align-items-center">
        <label class="display-form-label">执行对象：</label>
        <div>
            <label class="mr20"><input v-model="execObj" type="radio" name="execObj" value="0"
                                       @change="hanldeExecObj('0')">经销商</label>
            <label class="ml20"><input v-model="execObj" type="radio" name="execObj" value="1"
                                       @change="hanldeExecObj('1')">门店</label>
        </div>
    </div>
    <div class="display-form mb10 flex flex-align-items-start">
        <label class="display-form-label">客户范围：</label>
        <div class="flex display-selected">
            <div class="flex-1 mr20">
                <a href="javascript:void(0)" class="display-add-btn" @click="selectOrgs"><span
                        class="fa fa-plus"></span>添加组织</a>
                <div class="group-selected-container">
                        <span v-for="o in orgs" :key="o.id" class="range-tag mt5 ml5">{{o.name}}<span
                                class="ml10 fa fa-remove" @click="handleRemoveGroupTag(o)"></span></span>
                </div>
            </div>
            <div class="flex-1 ml20">
                <a href="javascript:void(0)" class="display-add-btn" @click="selectCustomer" v-if="execObj==0"><span
                        class="fa fa-plus"></span>添加客户</a>
                <a href="javascript:void(0)" class="display-add-btn" @click="selectStore" v-if="execObj==1"><span
                        class="fa fa-plus"></span>添加门店</a>
                <div class="customer-selected-container" v-if="execObj==0">
                        <span v-for="o in customers" :key="o.id" class="range-tag mt5 ml5">{{o.name}}<span
                                class="ml10 fa fa-remove" @click="handleRemoveCustomersTag(o)"></span></span>
                </div>
                <div class="customer-selected-container" v-if="execObj==1">
                        <span v-for="o in stores" :key="o.id" class="range-tag mt5 ml5">{{o.name}}<span
                                class="ml10 fa fa-remove" @click="handleRemoveStoresTag(o)"></span></span>
                </div>
            </div>
        </div>
    </div>
    <div class="display-form mb10 flex flex-align-items-start">
        <label class="display-form-label">陈列标准：</label>
        <div>
            <label class="mr20"><input v-model="displayNormal" type="radio" name="runObj" value="0"
                                       @change="hanldeDisplayNormal(0)">产品层级</label>
            <label class="ml20"><input v-model="displayNormal" type="radio" name="runObj" value="1"
                                       @change="hanldeDisplayNormal(1)">产品</label>
        </div>
    </div>
    <div class="display-normal">
        <div v-if="displayNormal==0">
            <a href="javascript:void(0)" class="display-select-btn" @click="selectLevel">选择产品层级</a>
            <table class="display-product-table">
                <thead>
                <tr>
                    <th>层级编码</th>
                    <th>层级名称</th>
                    <th>排面数</th>
                    <th>层数</th>
                    <th>操作</th>
                </tr>
                </thead>
                <tbody>
                <tr v-for="(l,index) in levels" :key="index">
                    <td>{{l.code}}</td>
                    <td>{{l.name}}</td>
                    <td><input v-model="l.surfaceNum" type="text"></td>
                    <td><input v-model="l.layerNum" type="text"></td>
                    <td><span class="fa fa-trash-o fa-fw" @click="removeLevelRow(index)"></span></td>
                </tr>
                </tbody>
            </table>
        </div>
        <div v-if="displayNormal==1">
            <a href="javascript:void(0)" class="display-select-btn" @click="selectProduct">选择产品</a>
            <table class="display-product-table">
                <thead>
                <tr>
                    <th>层级编码</th>
                    <th>层级名称</th>
                    <th>排面数</th>
                    <th>层数</th>
                    <th>操作</th>
                </tr>
                </thead>
                <tbody>
                <tr v-for="(p,index) in products" :key="index">
                    <td>{{p.code}}</td>
                    <td>{{p.name}}</td>
                    <td><input v-model="p.surfaceNum" type="text"></td>
                    <td><input v-model="p.layerNum" type="text"></td>
                    <td><span class="fa fa-trash-o fa-fw" @click="removeProductRow(index)"></span></td>
                </tr>
                </tbody>
            </table>
        </div>

    </div>
    <div class="display-form mb10 flex flex-align-items-center">
        <label class="display-form-label">陈列场景：</label>
        <div>
            <label class="mr20"><input type="checkbox" v-model="scene" value="货架" name="huojia">货架</label>
            <label class="ml20"><input type="checkbox" v-model="scene" value="堆头" name="duitou">堆头</label>
            <label class="ml20"><input type="checkbox" v-model="scene" value="冰箱" name="bingxiang">冰箱</label>
        </div>
    </div>
    <div class="display-form mb10 flex flex-align-items-center">
        <label class="display-form-label">促销物料：</label>
        <div>
            <label class="mr20"><input type="radio" name="haveProm" v-model="haveProm" value="0">不必须有</label>
            <label class="ml20"><input type="radio" name="haveProm" v-model="haveProm" value="1">必须有</label>
        </div>
    </div>
    <div class="display-form mb10 flex flex-align-items-start">
        <label class="display-form-label">评判标准：</label>
        <div class="display-judge">
            <table class="display-judge-table">
                <thead>
                <tr>
                    <th>评判结果</th>
                    <th>分销率%</th>
                    <th>排面达成率%</th>
                    <th>层数达成率%</th>
                </tr>
                </thead>
                <tbody>
                <tr v-for="(j,index) in rulues" :key="index">
                    <td>{{j.judgeResult}}</td>
                    <td><span>{{j.operSign}}</span><input v-model="j.distributionRate" type="text"></td>
                    <td><span>{{j.operSign}}</span><input v-model="j.surfaceRate" type="text"></td>
                    <td><span>{{j.operSign}}</span><input v-model="j.layerRate" type="text"></td>
                </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<script src="/resources/sfa/js/vue.min.js"></script>
<script>
    // 获取数组下标
    function getIndexArray(array, key, value) {
        let index = -1;
        if (Object.prototype.toString.call(array) === "[object Array]") {
            array.forEach(function (element, i) {
                if (element[key] === value) {
                    index = i;
                }
            });
            return index;
        } else {
            return index;
        }
    }

    //对象数组去重
    function objectArrayDeWeight(array, objectKey) {
        let hash = {};
        array = array.reduce(function (arr, current) {
            hash[current[objectKey]] ?
                "" :
                (hash[current[objectKey]] = true && arr.push(current));
            return arr;
        }, []);
        return array;
    }

    Vue.filter('formateLabel', function (type) {
        return type == 0 ? "添加客户" : "添加门店";
    });
    var vm = new Vue({
        el: "#app",
        name: "",
        data: function () {
            return {
                displayCode: "", //编号
                displayName: "", //标准名称
                displayDesc: "", //要求描述
                beginDate: "",
                endDate: "",
                execObj: 0, //0:经销商，1：门店
                orgs: [], //组织
                customers: [], //客户
                stores: [], //门店
                displayNormal: 0,//0:产品层级，1：产品
                levels: [], //产品层级
                products: [], //产品
                scene: [], //陈列场景
                haveProm: 0, //促销物料
                rulues: [{
                    judgeResult: "完成",
                    operSign: ">=",
                    distributionRate: "",
                    surfaceRate: "",
                    layerRate: ""
                }, {
                    judgeResult: "优秀",
                    operSign: ">=",
                    distributionRate: "",
                    surfaceRate: "",
                    layerRate: ""
                }, {
                    judgeResult: "合格",
                    operSign: ">=",
                    distributionRate: "",
                    surfaceRate: "",
                    layerRate: ""
                }, {
                    judgeResult: "不合格",
                    operSign: "<",
                    distributionRate: "",
                    surfaceRate: "",
                    layerRate: ""
                }]
            }
        },
        created: function () {
            var id = '${id}';
            if (id) {
                this.loadData();
            }
        },
        methods: {
            loadData: function () {
                var this_ = this;
                $.ajax({
                    url: "/sfaapi/tsAiDisPlayConfController/getDisplayDetail?id=" + '${id}',
                    type: "post",
                    dataType: "json",
                    success: function (res) {
                        if (res.success) {
                            this_.displayCode = res.obj.displayCode;
                            this_.displayName = res.obj.displayName;
                            this_.displayDesc = res.obj.displayDesc;
                            this_.beginDate = res.obj.beginDate;
                            this_.endDate = res.obj.endDate;
                            this_.execObj = res.obj.execObj;
                            this_.haveProm = res.obj.haveProm;
                            if (res.obj.scopeVos) {
                                $.each(res.obj.scopeVos, function (index, item) {
                                    if (item.type === "03") {
                                        this_.orgs.push(item);
                                    }
                                    if (item.type === "01") {
                                        this_.customers.push(item);
                                    }
                                    if (item.type === "02") {
                                        this.stores.push(item);
                                    }
                                })
                            }
                            if (res.obj.standardVos) {
                                $.each(res.obj.standardVos, function (index, item) {
                                    if (item.type === "01") {
                                        this_.displayNormal = 0;
                                        this_.levels.push(item);
                                    } else {
                                        this_.displayNormal = 1;
                                        this_.products.push(item);
                                    }
                                })
                            }
                            //将陈列场景转化为数组
                            this_.scene = res.obj.displayScene.split(",");
                            this_.rulues = res.obj.rulues;
                        } else {
                            tip(res.msg);
                        }
                    }
                })
            },
            hanldeExecObj: function (type) {
                this.execObj = type;
                this.orgs = [];
                if (this.execObj == 0) {
                    this.customers = [];
                } else {
                    this.stores = [];
                }
            },
            hanldeDisplayNormal: function (type) {
                this.displayNormal = type;
                if (this.displayNormal == 0) {
                    this.levels = [];
                } else {
                    this.products = [];
                }
            },
            selectDate: function (elementId) {
                var this_ = this;
                WdatePicker({
                    el: elementId,
                    dateFmt: 'yyyy-MM-dd',
                    onpicked: function () {
                        var value = $("#" + elementId).val();
                        this_[elementId] = value;
                    }
                })
            },
            selectOrgs: function () {
                var this_ = this;
                safeShowDialog({
                    content: 'url:/page/tmApiOrgController/goOrgListMain',
                    title: "添加组织",
                    lock: true,
                    opacity: 0.3,
                    button: [{
                        name: "确定",
                        callback: function () {
                            iframe = this.iframe.contentWindow;
                            var selectedRows = iframe.getSelectRows();
                            var newSelectedRows = [];
                            $.each(selectedRows, function (index, item) {
                                newSelectedRows.push({
                                    code: item.text,
                                    name: item.src,
                                    type: "03"
                                });
                            });
                            this_.addGroupTag(newSelectedRows);
                            return true;
                        }
                    }, {
                        name: "取消",
                        callback: function () {
                        }
                    }]

                });
            },
            addGroupTag: function (tag) {
                var newArray = this.orgs.concat(tag);
                this.orgs = objectArrayDeWeight(newArray, "code");
            },
            selectCustomer: function () {
                var this_ = this;
                safeShowDialog({
                    content: 'url:/page/tmApiCustomerController/goCustomerListMain',
                    title: "添加客户",
                    lock: true,
                    opacity: 0.3,
                    button: [{
                        name: "确定",
                        callback: function () {
                            iframe = this.iframe.contentWindow;
                            var selectedRows = iframe.getSelectRows();
                            var newSelectedRows = [];
                            $.each(selectedRows, function (index, item) {
                                newSelectedRows.push({
                                    code: item.customerCode,
                                    name: item.customerName,
                                    type: "01"
                                });
                            });

                            this_.addCustomersTag(newSelectedRows);
                            return true;
                        }
                    }, {
                        name: "取消",
                        callback: function () {
                        }
                    }]

                });
            },
            addCustomersTag: function (tag) {
                var newArray = this.customers.concat(tag);
                this.customers = objectArrayDeWeight(newArray, "code");
            },
            selectStore: function () {
                var this_ = this;
                safeShowDialog({
                    content: 'url:/page/tmApiTerminalController/goTerminalListMain',
                    title: "添加门店",
                    lock: true,
                    opacity: 0.3,
                    button: [{
                        name: "确定",
                        callback: function () {
                            iframe = this.iframe.contentWindow;
                            var selectedRows = iframe.getSelectRows();
                            var newSelectedRows = [];
                            $.each(selectedRows, function (index, item) {
                                newSelectedRows.push({
                                    code: item.terminalCode,
                                    name: item.terminalName,
                                    type: "02"
                                });
                            });
                            this_.addStoresTag(selectedRows);
                            return true;
                        }
                    }, {
                        name: "取消",
                        callback: function () {
                        }
                    }]

                });
            },
            addStoresTag: function (tag) {
                var newArray = this.stores.concat(tag);
                this.stores = objectArrayDeWeight(newArray, "code");
            },
            selectLevel: function () {
                var this_ = this;
                safeShowDialog({
                    content: 'url:/page/tmApiProductLevelController/goProductListMain',
                    title: "添加产品层级",
                    lock: true,
                    opacity: 0.3,
                    button: [{
                        name: "确定",
                        callback: function () {
                            iframe = this.iframe.contentWindow;
                            var selectedRows = iframe.getSelectRows();
                            var newSelectedRows = [];
                            $.each(selectedRows, function (index, item) {
                                newSelectedRows.push({
                                    code: item.text,
                                    name: item.src,
                                    type: "01",
                                    surfaceNum: "",
                                    layerNum: ""
                                });
                            });
                            this_.addLevel(newSelectedRows);
                            return true;
                        }
                    }, {
                        name: "取消",
                        callback: function () {
                        }
                    }]

                });
            },
            addLevel: function (level) {
                var newArray = this.levels.concat(level);
                this.levels = objectArrayDeWeight(newArray, "code");
            },
            removeLevelRow: function (index) {
                this.levels.splice(index, 1)
            },
            selectProduct: function () {
                var this_ = this;
                safeShowDialog({
                    content: 'url:/page/tmApiProductInfoController/goProductInfoListMain',
                    title: "添加产品",
                    lock: true,
                    opacity: 0.3,
                    button: [{
                        name: "确定",
                        callback: function () {
                            iframe = this.iframe.contentWindow;
                            var selectedRows = iframe.getSelectRows();
                            var newSelectedRows = [];
                            $.each(selectedRows, function (index, item) {
                                newSelectedRows.push({
                                    code: item.productInfoCode,
                                    name: item.productInfoName,
                                    type: "02",
                                    surfaceNum: "",
                                    layerNum: ""
                                });
                            });
                            this_.addProduct(newSelectedRows);
                            return true;
                        }
                    }, {
                        name: "取消",
                        callback: function () {
                        }
                    }]

                });
            },
            addProduct: function (product) {
                var newArray = this.products.concat(product);
                this.products = objectArrayDeWeight(newArray, "code");
            },
            removeProductRow: function (index) {
                this.products.splice(index, 1)
            },
            handleRemoveGroupTag: function (tag) {
                var index = getIndexArray(this.orgs, "id", tag.id);
                this.orgs.splice(index, 1);
            },
            handleRemoveCustomersTag: function (tag) {
                var index = getIndexArray(this.customers, "id", tag.id);
                this.customers.splice(index, 1);
            },
            handleRemoveStoresTag: function (tag) {
                var index = getIndexArray(this.stores, "id", tag.id);
                this.stores.splice(index, 1);
            },
            handleRemoveLevels: function (level) {
                var index = getIndexArray(this.levels, "id", level.id);
                this.levels.splice(index, 1);
            },
            handleRemoveProducts: function (product) {
                var index = getIndexArray(this.products, "id", product.id);
                this.products.splice(index, 1);
            },
            save: function (cb) {
                //将陈列场景转化为字符串
                var displayScene = this.scene.join(",");
                //构造客户范围
                var scopeVos = [];
                scopeVos = scopeVos.concat(this.orgs);
                this.execObj == 0 ? scopeVos = scopeVos.concat(this.customers) : scopeVos = scopeVos.concat(this.stores);
                //构造陈列产品
                var standardVos = [];
                this.displayNormal == 0 ? standardVos = this.levels : standardVos = this.products;
                var postData = {
                    id:'${id}',
                    displayCode: this.displayCode,
                    displayName: this.displayName,
                    displayDesc: this.displayDesc,
                    beginDate: this.beginDate,
                    endDate: this.endDate,
                    execObj: this.execObj,
                    scopeVos: scopeVos,
                    standardVos: standardVos,
                    displayScene: displayScene,
                    haveProm: this.haveProm,
                    rulues: this.rulues
                };
                $.ajax({
                    url: "/sfaapi/tsAiDisPlayConfController/saveOrderUpdate",
                    type: "post",
                    dataType: "json",
                    contentType: "application/json",
                    data: JSON.stringify(postData),
                    success: function (res) {
                        if (res.success) {
                            cb();
                        } else {
                            tip(res.msg);
                        }
                    }
                })
            }
        },
    })
</script>
</body>

</html>
