<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>添加活动</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        #content{
            height: auto!important;
        }
    </style>
</head>
<body class="easyui-layout" fit="true">
    <div region="center" style="overflow: auto;">
        <t:formvalid action=""  layout="div"
                     dialog="true" formid="detailId">
            <t:dgFormList layoutStyle="horizontal">
                <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                                defaultVal="${vo.id }"/>
                <t:dgFormColumn field="updatedJsonData" hidden="true" formClass="form" labelName="updatedJsonData" optionType="input" required="false"
                                defaultVal=""/>
                <t:dgFormColumn field="tempUuid" hidden="true" formClass="form" labelName="tempUuid" optionType="input" required="false"
                                defaultVal="${tempUuid}"/>
                <t:dgFormColumn field="auditCode" hidden="false" formClass="biz-col-50 mb5 form" labelName="核销总单编码" optionType="input"  required="false"
                             readOnly="true"   defaultVal="${vo.auditCode}"/>
                <t:dgFormColumn field="auditName" hidden="false" formClass="biz-col-50 mb5 form" labelName="核销总单名称" optionType="input"  required="true"
                              dataType="*"  defaultVal="${vo.auditName}"/>

                <t:dgFormColumn field="remarks" hidden="false" formClass="biz-col-100 mb5 form" labelName="备注" optionType="textarea"  required="false"
                                rows="3" cols="5" defaultVal="${vo.remarks}" style="width: 77%"/>
            </t:dgFormList>
        </t:formvalid>
        <t:datagrid name="ttAuditActDetaillist"   idField="id" queryMode="group" fit="true" fitColumns="true"
                specialSearch="true"    actionUrl="/pay/ttAuditActDetailController/findTtAuditActDetailPage?tempUuid=${tempUuid}" pagination="false">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="核销明细编号" field="auditDetailCode" query="false"></t:dgCol>
            <t:dgCol title="申请明细编号" field="actDetailCode" query="false"></t:dgCol>
            <t:dgCol title="客户" field="customerName" query="true"></t:dgCol>
            <t:dgCol title="门店" field="terminalName"  query="false"></t:dgCol>
            <t:dgCol title="活动细类编码" field="actSubclassCode"  query="true" hidden="true"></t:dgCol>
            <t:dgCol title="活动细类" field="actSubclassName"  query="true"></t:dgCol>
            <t:dgCol title="活动大类编码" field="categoriesCode"   hidden="true"></t:dgCol>
            <t:dgCol title="活动大类" field="categoriesName" ></t:dgCol>
            <t:dgCol title="是否允许多次核销" field="isMultipleAudit" hidden="true"  ></t:dgCol>
            <t:dgCol title="支付方式" field="payType" dictionary="pay_type"  query="false"></t:dgCol>
            <t:dgCol title="申请金额" field="amount" ></t:dgCol>
            <t:dgCol title="已核销金额(含核销中)" field="auditAmount"  ></t:dgCol>
            <t:dgCol title="超额核销比例" field="extraAuditRatio" hidden="true"  ></t:dgCol>
            <t:dgCol title="最大核销金额" field="maxAuditAmount" hidden="true" ></t:dgCol>

            <t:dgCol title="修改前本次核销金额" field="oldCurrentAmount" hidden="true"></t:dgCol>
            <t:dgCol title="本次核销金额" field="currentAmount" editor="{type:'numberbox',options:{min:0,value:''}}"></t:dgCol>
            <t:dgCol title="完全核销" field="auditStatus" dictionary="is_no" editor="{type:'combobox',options:{valueField:'id',textField:'text',panelHeight:45,required:true,editable:false,data:[{'id':'1','text':'是'},{'id':'0','text':'否'}]}}"></t:dgCol>
            <t:dgCol title="申请备注" field="actRemarks"  ></t:dgCol>
            <t:dgCol title="核销备注" field="auditRemarks" editor="text"></t:dgCol>

            <t:dgToolBar title="新增" icon="icon-add" width="1200" height="600" url="/page/ttApiActController/goApiActDetailMain"
                         funname="selectActDetail" detail="${!\"lookdetail\".equals(lookdetail)}"></t:dgToolBar>
            <t:dgToolBar title="删除" icon="icon-delete" width="1200" height="600" url="/pay/ttAuditActDetailController/delActDetail"
                         funname="deleteALLSelect_" detail="${!\"lookdetail\".equals(lookdetail)}"></t:dgToolBar>
            <t:dgToolBar title="导入" icon="icon-dataIn" width="1200" height="600" url="/pay/ttAuditActDetailController/dataIn"
                         funname="detail" detail="${!\"lookdetail\".equals(lookdetail)}"></t:dgToolBar>
            <t:dgToolBar title="核销资料" icon="icon-upload" width="600" height="600" url=""
                         funname="selectActDetailUpload"></t:dgToolBar>
        </t:datagrid>
    </div>
<script type="text/javascript">

    var lookdetail = '${lookdetail}';
    lookdetail = ""
    if (lookdetail == "lookdetail") {
        /*if (location.href.indexOf("lookdetail=lookdetail") != -1) {
            $("#attachList").find("span.attach-remove").css("display","none");
            $(":input").attr("disabled", "true");
            $(":input").css({"border": "0", "border-bottom": "1px solid #efefef", "background": "none", "color": "black"});
            $(":input").each(function () {
                $(this).closest(".form").find(".combo").css({
                    "border": "0",
                    "border-bottom": "1px solid #efefef",
                    "background": "none",
                    "color": "black"
                });
                $(this).closest(".form").find(".combo input").css({"border": "0"});
                $(this).closest(".form").find(".combo-arrow").remove();
                $(this).closest(".form").find(".easyui-linkbutton").remove();
            });
            $(":input:not([type='radio'],[type='checkbox'])").css({"appearance": "none"});//select::-ms-expand{display:none;}
            $(".biz-tag-toolbar").css("display", "none");
            $(".biz-tag-close").css("display", "none");
            $(".choose-remove").remove();
        }*/
        /*if (parent.location.href.indexOf("lookdetail=lookdetail") != -1) {
            $(".removebtn").css('display', "none");
        }*/
    }

    var tempUuid='${tempUuid}';
    function selectActDetail(){
        var url = "/page/ttApiActController/goApiActDetailMain?tempUuid="+tempUuid;
        var width = 1000;
        var height = 450;
        id = "actDetailSelectlist";
        var gridname = id;
        var myOptions = {
            opacity : 0.3,
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData == '' || rowsData == null) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }
                } else {
                    //提交数据到后台表里
                    $.ajax({
                        url : "/pay/ttAuditActDetailController/saveAuditActDetail",
                        type : 'post',
                        data : {"tempUuid":tempUuid,"acts":JSON.stringify(rowsData)},
                        cache : false,
                        success : function(data) {
                            tip(data.msg);
                            if (!data.success) {
                                tip(data.msg);
                                return false;
                            }
                            $('#ttAuditActDetaillist').datagrid('reload');
                        }
                    });
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        };
        safeShowDialogParent(myOptions);
    }

    /*核销明细打开编辑*/
    function editorALl() {
        var rowsDetailDatas = $('#ttAuditActDetaillist').datagrid('getRows');
        for(var i=0;i<rowsDetailDatas.length;i++){
            var index = $('#ttAuditActDetaillist').datagrid('getRowIndex',rowsDetailDatas[i]);
            initEditor(index,rowsDetailDatas[index]);
        }
    }

    //初始化编辑
    function initEditor(index,row) {
        $("#ttAuditActDetaillist").datagrid('beginEdit',index);
        //是否允许多次核销
        var isMultipleAudit = row.isMultipleAudit;
        //已核销金额
        var auditAmount = row.auditAmount;
        //申请金额
        var amount = row.amount;
        //本次核销金额
        var currentAmount = row.currentAmount;
        var maxAuditAmount = row.maxAuditAmount;

        if (isMultipleAudit == "0") {
            //单次核销，完全核销字段只能为是，不可修改
            endEditorALl_(index)
            $('#ttAuditActDetaillist').datagrid('updateRow',{
                index: index,
                row: {
                    auditStatus:1
                }
            });
            var ed2 = $('#ttAuditActDetaillist').datagrid('beginEdit', index);
            var ed = $('#ttAuditActDetaillist').datagrid('getEditor', {index:index,field:'auditStatus'});
            $(ed.target).combobox('loadData',[{'id':'1','text':'是'}]);
        }else {
            if(Number(maxAuditAmount)<=Number(currentAmount)){
                endEditorALl_(index);
                $('#ttAuditActDetaillist').datagrid('updateRow',{
                    index: index,
                    row: {
                        auditStatus:1
                    }
                });
                var ed2 = $('#ttAuditActDetaillist').datagrid('beginEdit', index);
                var ed = $('#ttAuditActDetaillist').datagrid('getEditor', {index:index,field:'auditStatus'});
                $(ed.target).combobox('loadData',[{'id':'1','text':'是'}]);
            }else {
                endEditorALl_(index);
                var ed2 = $('#ttAuditActDetaillist').datagrid('beginEdit', index);
                var ed = $('#ttAuditActDetaillist').datagrid('getEditor', {index:index,field:'auditStatus'});
                $(ed.target).combobox('loadData',[{'id':'1','text':'是'},{'id':'0','text':'否'}]);
            }
        }
        var forecastNumEd = $('#ttAuditActDetaillist').datagrid('getEditor', {index:index,field:'currentAmount'});
        forecastNumEd.target.numberbox({
            onChange:function(newValue){
                setAuditStatus(newValue,index);
            }
        });
    }

    /*上账明细结束编辑*/
    function endEditorALl() {
        var rowsDetailDatas = $('#ttAuditActDetaillist').datagrid('getRows');
        for(var i=0;i<rowsDetailDatas.length;i++){
            var index = $('#ttAuditActDetaillist').datagrid('getRowIndex',rowsDetailDatas[i]);
            $('#ttAuditActDetaillist').datagrid('endEdit' ,index);
        }
    }

    /*上账明细结束编辑*/
    function endEditorALl_(index_) {
        $('#ttAuditActDetaillist').datagrid('endEdit' ,index_);
    }

    function setAuditStatus(newValue,index) {
        if(isEmpty(newValue)){
            return;
        }
        endEditorALl_(index);
        setAuditStatusAll(index);
    }

    function setAuditStatusAll(index) {
        var rows = $('#ttAuditActDetaillist').datagrid('getRows');
        var row = rows[index];
        //已核销金额
        var auditAmount = row.auditAmount;
        //申请金额
        var amount = row.amount;
        //本次核销金额
        var currentAmount = row.currentAmount;
        var maxAuditAmount = row.maxAuditAmount;
        var isMultipleAudit = row.isMultipleAudit;
        console.log("---"+isMultipleAudit)
        if(isMultipleAudit=="0"){
            $('#ttAuditActDetaillist').datagrid('updateRow',{
                index: index,
                row: {
                    auditStatus:1
                }
            });
            var ed2 = $('#ttAuditActDetaillist').datagrid('beginEdit', index);
            var ed = $('#ttAuditActDetaillist').datagrid('getEditor', {index:index,field:'auditStatus'});
            $(ed.target).combobox('loadData',[{'id':'1','text':'是'}]);
            endEditorALl_(index);
        }else{
            if(Number(maxAuditAmount)<=Number(currentAmount)){
                $('#ttAuditActDetaillist').datagrid('updateRow',{
                    index: index,
                    row: {
                        auditStatus:1
                    }
                });
            }

            var ed2 = $('#ttAuditActDetaillist').datagrid('beginEdit', index);
            var ed = $('#ttAuditActDetaillist').datagrid('getEditor', {index:index,field:'auditStatus'});
            if(Number(maxAuditAmount)>Number(currentAmount)){
                $(ed.target).combobox('loadData',[{'id':'1','text':'是'},{'id':'0','text':'否'}]);
            }else {
                $(ed.target).combobox('loadData',[{'id':'1','text':'是'}]);
            }
            endEditorALl_(index);
        }
    }

    function deleteALLSelect_(title, url, gname, deleteCallback) {
        gridname = gname;
        var ids = [];
        var rows = $("#" + gname).datagrid('getSelections');
        if (rows.length > 0) {
            $.dialog.setting.zIndex = 3000;
            getSafeJq().dialog.confirm("你确定永久删除该数据吗?", function (r) {
                if (r) {
                    for (var i = 0; i < rows.length; i++) {
                        ids.push(rows[i].id);
                    }
                    $.ajax({
                        url: url,
                        type: 'post',
                        dataType: 'json',
                        data: {
                            ids: ids.join(',')
                        },
                        cache: false,
                        success: function (data) {
                            var msg = data.msg;
                            if (data.success) {
                                tip(msg, 'info');
                                reloadTable();
                                if (deleteCallback) {
                                    deleteCallback();
                                }
                                $("#" + gname).datagrid('unselectAll');
                                ids = '';
                            } else {
                                tip(msg, 'error');

                            }
                        },
                        error: function () {
                            tip("客户端请求错误", 'error');
                            return false;
                        }
                    });
                }
            });
        } else {
            tip("请选择需要删除的数据");
        }
    }

    $(document).ready(function(){
        //初始化编码器，及添加单击行事件开始编辑
        $("#ttAuditActDetaillist").datagrid({
            onClickRow:function(rowIndex, rowData){
                initEditor(rowIndex,rowData);
            }
        });
    });
    //保存修改操作
    function doSave(){
        var b=true;
        if(formName_detailId.check()){
            // var updated=$("#ttAuditActDetaillist").datagrid("getChanges","updated");
            var rows=$("#ttAuditActDetaillist").datagrid("getRows");
            var lineNo;
            //最大可核销金额
            var maxAmountTemp = 0;
            for(var index = 0;index<rows.length;index++){
                row = rows[index];
                var rowIndex=$("#ttAuditActDetaillist").datagrid("getRowIndex",row);
                $("#ttAuditActDetaillist").datagrid('endEdit', rowIndex);
                var maxAuditAmount = row.maxAuditAmount;
                var auditAmount = row.auditAmount;
                var currentAmount = row.currentAmount;
                if(parseFloat(maxAuditAmount)<parseFloat(auditAmount)+parseFloat(currentAmount)){
                    maxAmountTemp = parseFloat(maxAuditAmount)-parseFloat(auditAmount);
                    lineNo = rowIndex;
                    b = false;
                    break;
                }
            }
            if(!b){
                tip("第"+(lineNo+1)+"行超过允许最大核销金额："+maxAmountTemp);
                return b;
            }
            if (!(rows==null || rows==undefined|| rows.length==0)){  //有修改时需要提交一次方法
                $("#updatedJsonData").val(JSON.stringify(rows));
                b=sub();
            }else{
                $("#updatedJsonData").val('[]');
                b=sub();
            }
        }else{
            b = false;
        }
        return b;
    }

    function sub(){
        var b=false;
        $.ajax({
            url : "/pay/ttAuditController/saveAudit",
            type : 'post',
            async: false,
            data : $("#detailId").serialize(),
            cache : false,
            success : function(data) {
                if (data.success) { //提交form数据
                    b= data.success;
                }
                tip(data.msg)
            }
        });
        return b;
    }
    function accAdd(arg1,arg2){
        var r1,r2,m;
        try{r1=arg1.toString().split(".")[1].length}catch(e){r1=0}
        try{r2=arg2.toString().split(".")[1].length}catch(e){r2=0}
        m=Math.pow(10,Math.max(r1,r2))
        return (arg1*m+arg2*m)/m
    }
    //上传核销资料明细
    function selectActDetailUpload(){
        if(tempUuid==null || tempUuid==undefined || tempUuid==""){
            tip("活动数据关系未知！");
            return;
        }
        var rows=$("#ttAuditActDetaillist").datagrid("getRows");
        if(rows.length <= 0){
            tip("没有可上传的核销明细数据");
            return;
        }
        var ids = null;
        rows.forEach(function(item){
            item.id
            if(null == ids)
                ids = item.id;
            else
                ids += ',' + item.id;
        });
        var url = "/page/ttAuditActDetailController/goTtAuditActDetailUpload?ids=" + ids + "&tempUuid="+tempUuid + "&lookdetail=" + "${lookdetail}";
        var width = 1000;
        var height = 500;
        id = "actDetailSelectlist";
        var gridname = id;
        var myOptions = {
            opacity : 0.3,
            content: "url:" + url,
            lock: true,
            parent:windowapi,
            zIndex:10000,
            id:'uploaddetailid_',
            title: "核销资料上传",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                iframe.saveData_();
                return false;
            },
            cancelVal: '关闭',
            cancel: true
        };
        $.dialog(myOptions);
    }
</script>
</body>
</html>
