<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>任务详情</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <style>
        .goods-list-title {
            padding: 10px 0;
            color: #333333;
            font-size: 16px;
        }

        .task-note .list-cell-title {
            color: #333333;
        }

        .upload-img {
            padding: 0 16px;
            background: #ffffff;
        }

        .upload-img img {
            width: 60px;
            height: 60px;
            margin-right: 10px;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="task-detail">
            <list-info title="任务内容" :value="task.taskContent"></list-info>
            <list-info title="发起人" :value="task.createName"></list-info>
            <list-info title="截止日期" :value="task.endTime"></list-info>
            <list-info title="抄送人" :value="task.copierBy"></list-info>
            <div class="upload-img">
                <div class="goods-list-title">任务图片</div>
                <img :src="img.imgUrl" alt="" v-for="img in task.imgList" :key="img.id">
            </div>
            <div class="task-note">
                <list-info title="备注" :value="task.remark" type="textarea"></list-info>
            </div>
        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>

    <script>
        var vm = new Vue({
            el: "#app",
            name: "TaskDetail",
            data: function () {
                return {
                    token: "",
                    id: "",
                    task: {
                        imgList:[]
                    }
                }
            },
            created: function () {
                this.token = getParameterByName("token");
                this.id = getParameterByName("id");
                this.loadData();
            },
            computed: {

            },
            methods: {
                loadData: function () {
                    var this_ = this;
                    $.ajax({
                        url: SERVER + "/sfaapi/sfaApi/tsWorkTasApiController/getWorkTaskInfo",
                        type: "post",
                        dataType: "json",
                        contentType: 'application/json',
                        headers: {
                            'loginUserToken': this_.token
                        },
                        data: JSON.stringify({
                            id: this_.id
                        }),
                        success: function (res) {
                            if (res.success) {
                                this_.task = res.obj;
                            }else{
                                showError(res.msg)
                            }
                        }
                    })
                },
            }
        })
    </script>
</body>

</html>