/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.tag.tags;

import com.biz.eisp.base.common.tag.bean.FormColumn;
import com.biz.eisp.base.common.tag.params.FormParams;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DealTableCofUtil;
import com.biz.eisp.base.common.util.FormEnum;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringReplace;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.FreemarkerParseUtils;
import com.biz.eisp.config.SpringApplicationContextUtil;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.tools.DictUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang3.StringUtils;

public class FormListTag
extends TagSupport {
    private RedisService redisService;
    private String tagConf;
    private String expandParam;
    private String layoutStyle = ConstantEnum.layoutStyle.vertical.name();
    protected List<FormColumn> columnList = new ArrayList<FormColumn>();

    public FormListTag() {
        this.redisService = (RedisService)SpringApplicationContextUtil.getApplicationContext().getBean("redisService");
    }

    public int doEndTag() throws JspException {
        try {
            JspWriter out = this.pageContext.getOut();
            out.print(this.end().toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 6;
    }

    public void setColumn(FormColumn column) {
        if (column != null) {
            this.columnList.add(column);
        }
    }

    public StringBuffer end() {
        StringBuffer sb = new StringBuffer();
        ArrayList params = new ArrayList();
        this.dealConf();
        this.columnList.forEach(item -> {
            String type = item.getOptionType();
            if (FormEnum.input.name().equals(type)) {
                this.commonuse(params, (FormColumn)item, FormEnum.input.name());
            } else if (FormEnum.date_begin_end.name().equals(type)) {
                this.commonuse(params, (FormColumn)item, FormEnum.date_begin_end.name());
            } else if (FormEnum.date.name().equals(type)) {
                this.commonuse(params, (FormColumn)item, FormEnum.date.name());
            } else if (FormEnum.tags.name().equals(type)) {
                this.commonuse(params, (FormColumn)item, FormEnum.tags.name());
            } else if (FormEnum.radio.name().equals(type) || FormEnum.checkbox.name().equals(type) || FormEnum.text.name().equals(type)) {
                Map map = DictUtil.getDictMap((String)item.getTypeGroupCode());
                if (map != null && map.size() > 0) {
                    this.chooseTheDoLine(params, map, sb, (FormColumn)item);
                }
            } else if (FormEnum.select.name().equals(type)) {
                if (StringUtil.isNotEmpty((CharSequence)item.getTypeGroupCode())) {
                    Map map = DictUtil.getDictMap((String)item.getTypeGroupCode());
                    if (map != null && map.size() > 0) {
                        this.chooseTheDoLine(params, map, sb, (FormColumn)item);
                    }
                } else {
                    this.createSelectForLisy(params, sb, (FormColumn)item);
                }
            } else if (FormEnum.choseDialog.name().equals(type)) {
                this.commonuse(params, (FormColumn)item, FormEnum.choseDialog.name());
            } else if (FormEnum.textarea.name().equals(type)) {
                this.commonuse(params, (FormColumn)item, FormEnum.textarea.name());
            } else if (FormEnum.areaSelect.name().equals(type)) {
                this.commonuse(params, (FormColumn)item, FormEnum.input.name());
            } else if (FormEnum.selectComponent.name().equals(type)) {
                this.selectComponent(params, (FormColumn)item, FormEnum.selectComponent.name());
            }
        });
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("params", params);
        map.put("layoutStyle", this.layoutStyle);
        sb.append(freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/Form.ftl", map));
        return sb;
    }

    public void dealConf() {
        if (StringUtils.isNotEmpty((CharSequence)this.tagConf)) {
            if (StringUtil.isNotEmpty((CharSequence)this.expandParam) && StringUtil.isNotEmpty((CharSequence)this.tagConf)) {
                DealTableCofUtil.createColumn(this.columnList, (RedisService)this.redisService, (String)this.expandParam);
            }
            DealTableCofUtil.setFormExtendColumn(this.columnList, (RedisService)this.redisService, (String)this.tagConf);
        }
    }

    private void commonuse(List<FormParams> params, FormColumn column, String flag) {
        FormParams param = new FormParams();
        param.setFormClass(column.getFormClass());
        param.setLabelName(column.getLabelName());
        param.setRequired(column.isRequired());
        param.setHidden(column.isHidden());
        param.setOnclick(column.getOnclick());
        param.setHiddenId(column.getHiddenId());
        param.setFlag(flag);
        param.setRows(column.getRows());
        param.setCols(column.getCols());
        param.setField(column.getField());
        param.setDefaultVal(column.getDefaultVal());
        param.setDataType(this.makeDataType(column.isRequired(), column.getDataType()));
        param.setChecktip(column.getChecktip());
        param.setAjaxUrl(column.getAjaxurl());
        param.setReadOnly(column.getReadOnly());
        param.setFormTags(column.getFormTags());
        param.setExtendField(column.getExtendField());
        param.setExtendFieldVal(column.getExtendFieldVal());
        param.setStyle(column.getStyle());
        param.setMaxDate(column.getMaxDate());
        param.setMinDate(column.getMinDate());
        param.setDateFormat(column.getDateFormat());
        param.setOnClean(column.getOnClean());
        params.add(param);
    }

    private void selectComponent(List<FormParams> params, FormColumn column, String flag) {
        FormParams param = new FormParams();
        param.setFormClass(column.getFormClass());
        param.setLabelName(column.getLabelName());
        param.setRequired(column.isRequired());
        param.setHidden(column.isHidden());
        param.setOnclick(column.getOnclick());
        param.setHiddenId(column.getHiddenId());
        param.setFlag(flag);
        param.setRows(column.getRows());
        param.setCols(column.getCols());
        param.setField(column.getField());
        param.setDefaultVal(column.getDefaultVal());
        param.setDataType(this.makeDataType(column.isRequired(), column.getDataType()));
        param.setChecktip(column.getChecktip());
        param.setAjaxUrl(column.getAjaxurl());
        param.setReadOnly(column.getReadOnly());
        param.setFormTags(column.getFormTags());
        param.setExtendField(column.getExtendField());
        param.setExtendFieldVal(column.getExtendFieldVal());
        param.setStyle(column.getStyle());
        param.setMaxDate(column.getMaxDate());
        param.setMinDate(column.getMinDate());
        param.setDateFormat(column.getDateFormat());
        param.setOnClean(column.getOnClean());
        param.setKeyopInput(column.getKeyopInput());
        params.add(param);
    }

    private void chooseTheDoLine(List<FormParams> params, Map<Object, Object> datasmap, StringBuffer sb, FormColumn column) {
        switch (column.getOptionType()) {
            case "radio": {
                this.createRadioLabel(params, datasmap, sb, column);
                break;
            }
            case "checkbox": {
                this.createCheckboxLabel(params, datasmap, sb, column);
                break;
            }
            case "text": {
                this.createTextLabel(params, datasmap, sb, column);
                break;
            }
            default: {
                this.createDefaultLabel(params, datasmap, sb, column);
            }
        }
    }

    private void createDefaultLabel(List<FormParams> params, Map<Object, Object> datasmap, StringBuffer sb, FormColumn column) {
        ArrayList mapList = new ArrayList();
        if (datasmap != null && datasmap.size() > 0) {
            datasmap.forEach((k, v) -> {
                KnlDictDataEntity entity = (KnlDictDataEntity)v;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("TEXT", entity.getDictValue());
                map.put("FIELD", entity.getDictCode());
                map.put("order", StringUtil.isEmpty((String)entity.getOrderNum()) ? Integer.valueOf(0) : entity.getOrderNum());
                mapList.add(map);
            });
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(mapList)) {
            mapList.sort((ord2, ord1) -> Integer.valueOf(ord2.get("order").toString()).compareTo(Integer.valueOf(ord1.get("order").toString())));
        }
        this.select(params, "---\u8bf7\u9009\u62e9---", mapList, sb, column);
    }

    private void createSelectForLisy(List<FormParams> params, StringBuffer sb, FormColumn column) {
        ArrayList mapList = new ArrayList();
        List formTags = column.getFormTags();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)formTags)) {
            formTags.forEach(item -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("TEXT", item.getName());
                map.put("FIELD", item.getCode());
                mapList.add(map);
            });
        }
        this.select(params, "---\u8bf7\u9009\u62e9---", mapList, sb, column);
    }

    private void createTextLabel(List<FormParams> params, Map<Object, Object> datasmap, StringBuffer sb, FormColumn column) {
        if (datasmap != null && datasmap.size() > 0) {
            datasmap.forEach((k, v) -> {
                KnlDictDataEntity entity = (KnlDictDataEntity)v;
                this.text(params, entity.getDictValue(), entity.getDictCode(), sb, column);
            });
        }
    }

    private void createCheckboxLabel(List<FormParams> params, Map<Object, Object> datasmap, StringBuffer sb, FormColumn column) {
        Map defaultValMap = MyBeanUtils.changeStringArrayToMap((String[])column.getDefaultVal().split(","));
        AtomicInteger i = new AtomicInteger();
        if (datasmap != null && datasmap.size() > 0) {
            ArrayList params_ = new ArrayList();
            FormParams param = new FormParams();
            param.setFormClass(column.getFormClass());
            param.setLabelName(column.getLabelName());
            param.setRequired(column.isRequired());
            param.setHidden(column.isHidden());
            param.setFlag("checkbox");
            param.setField(column.getField());
            param.setDefaultVal(column.getDefaultVal());
            param.setDataType(this.makeDataType(column.isRequired(), column.getDataType()));
            param.setView(column.isHidden());
            param.setLineNum(column.getLineNum());
            param.setId(this.id);
            param.setChecktip(column.getChecktip());
            param.setStringReplace(new StringReplace());
            datasmap.forEach((k, v) -> {
                KnlDictDataEntity entity = (KnlDictDataEntity)v;
                this.checkbox(params_, entity.getDictValue(), entity.getDictCode(), defaultValMap, sb, column);
                i.getAndIncrement();
            });
            param.setList(params_);
            params.add(param);
        }
    }

    private void createRadioLabel(List<FormParams> params, Map<Object, Object> datasmap, StringBuffer sb, FormColumn column) {
        FormParams param = new FormParams();
        param.setFormClass(column.getFormClass());
        param.setLabelName(column.getLabelName());
        param.setRequired(column.isRequired());
        param.setHidden(column.isHidden());
        param.setFlag("radio");
        param.setField(column.getField());
        param.setDefaultVal(column.getDefaultVal());
        param.setDataType(this.makeDataType(column.isRequired(), column.getDataType()));
        param.setView(column.isHidden());
        param.setLineNum(column.getLineNum());
        param.setChecktip(column.getChecktip());
        param.setStringReplace(new StringReplace());
        AtomicInteger i = new AtomicInteger();
        ArrayList params_ = new ArrayList();
        if (datasmap != null && datasmap.size() > 0) {
            datasmap.forEach((k, v) -> {
                KnlDictDataEntity entity = (KnlDictDataEntity)v;
                this.checkIsNeedTheNextTr(i.get(), sb, column.getLineNum());
                this.radio(params_, entity.getDictValue(), entity.getDictCode(), sb, column);
                i.getAndIncrement();
            });
        }
        param.setList(params_);
        params.add(param);
    }

    private String makeDataType(boolean required, String dataType) {
        if (StringUtils.isNotBlank((CharSequence)dataType)) {
            return dataType;
        }
        if (required) {
            return "*";
        }
        return dataType;
    }

    private void checkIsNeedTheNextTr(int i, StringBuffer sb, Integer lineNum) {
        if (lineNum != null && lineNum != 0 && i % lineNum == 0 && i > 0) {
            sb.append("</br>");
        }
    }

    private void text(List<FormParams> params, String name, String code, StringBuffer sb, FormColumn column) {
        FormParams param = new FormParams();
        param.setFormClass(column.getFormClass());
        param.setLabelName(column.getLabelName());
        param.setRequired(column.isRequired());
        param.setHidden(column.isHidden());
        param.setFlag("text");
        param.setField(column.getField());
        param.setDefaultVal(column.getDefaultVal());
        param.setDataType(this.makeDataType(column.isRequired(), column.getDataType()));
        param.setCode(code);
        param.setView(column.isHidden());
        param.setName(name);
        param.setChecktip(column.getChecktip());
        params.add(param);
    }

    private void radio(List<FormParams> params, String name, String code, StringBuffer sb, FormColumn column) {
        FormParams param = new FormParams();
        param.setFormClass(column.getFormClass());
        param.setLabelName(column.getLabelName());
        param.setRequired(column.isRequired());
        param.setHidden(column.isHidden());
        param.setFlag("radio");
        param.setField(column.getField());
        param.setDefaultVal(column.getDefaultVal());
        param.setDataType(this.makeDataType(column.isRequired(), column.getDataType()));
        param.setCode(code);
        param.setView(column.isHidden());
        param.setName(name);
        param.setLineNum(column.getLineNum());
        param.setChecktip(column.getChecktip());
        param.setStringReplace(new StringReplace());
        params.add(param);
    }

    private void checkbox(List<FormParams> params, String name, String code, Map<String, String> defaultValMap, StringBuffer sb, FormColumn column) {
        Boolean checked = false;
        if (StringUtil.isNotEmpty((CharSequence)defaultValMap.get(code))) {
            checked = true;
        }
        FormParams param = new FormParams();
        param.setFormClass(column.getFormClass());
        param.setLabelName(column.getLabelName());
        param.setRequired(column.isRequired());
        param.setHidden(column.isHidden());
        param.setFlag("checked");
        param.setField(column.getField());
        param.setDefaultVal(column.getDefaultVal());
        param.setDataType(this.makeDataType(column.isRequired(), column.getDataType()));
        param.setCode(code);
        param.setView(column.isHidden());
        param.setName(name);
        param.setLineNum(column.getLineNum());
        param.setChecked(checked.booleanValue());
        param.setId(this.id);
        param.setChecktip(column.getChecktip());
        params.add(param);
    }

    private void select(List<FormParams> params, String name, List map, StringBuffer sb, FormColumn column) {
        FormParams param = new FormParams();
        param.setFormClass(column.getFormClass());
        param.setLabelName(column.getLabelName());
        param.setRequired(column.isRequired());
        param.setHidden(column.isHidden());
        param.setFlag(FormEnum.select.name());
        param.setField(column.getField());
        param.setDefaultVal(column.getDefaultVal());
        param.setDataType(this.makeDataType(column.isRequired(), column.getDataType()));
        param.setView(column.isHidden());
        param.setName(name);
        param.setLineNum(column.getLineNum());
        param.setId(this.id);
        param.setMap(map);
        param.setChecktip(column.getChecktip());
        params.add(param);
    }

    public int doStartTag() throws JspTagException {
        this.columnList.clear();
        return 6;
    }

    public RedisService getRedisService() {
        return this.redisService;
    }

    public String getTagConf() {
        return this.tagConf;
    }

    public String getExpandParam() {
        return this.expandParam;
    }

    public String getLayoutStyle() {
        return this.layoutStyle;
    }

    public List<FormColumn> getColumnList() {
        return this.columnList;
    }

    public void setRedisService(RedisService redisService) {
        this.redisService = redisService;
    }

    public void setTagConf(String tagConf) {
        this.tagConf = tagConf;
    }

    public void setExpandParam(String expandParam) {
        this.expandParam = expandParam;
    }

    public void setLayoutStyle(String layoutStyle2) {
        this.layoutStyle = layoutStyle2;
    }

    public void setColumnList(List<FormColumn> columnList) {
        this.columnList = columnList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormListTag)) {
            return false;
        }
        FormListTag other = (FormListTag)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        RedisService this$redisService = this.getRedisService();
        RedisService other$redisService = other.getRedisService();
        if (this$redisService == null ? other$redisService != null : !this$redisService.equals(other$redisService)) {
            return false;
        }
        String this$tagConf = this.getTagConf();
        String other$tagConf = other.getTagConf();
        if (this$tagConf == null ? other$tagConf != null : !this$tagConf.equals(other$tagConf)) {
            return false;
        }
        String this$expandParam = this.getExpandParam();
        String other$expandParam = other.getExpandParam();
        if (this$expandParam == null ? other$expandParam != null : !this$expandParam.equals(other$expandParam)) {
            return false;
        }
        String this$layoutStyle = this.getLayoutStyle();
        String other$layoutStyle = other.getLayoutStyle();
        if (this$layoutStyle == null ? other$layoutStyle != null : !this$layoutStyle.equals(other$layoutStyle)) {
            return false;
        }
        List<FormColumn> this$columnList = this.getColumnList();
        List<FormColumn> other$columnList = other.getColumnList();
        return !(this$columnList == null ? other$columnList != null : !((Object)this$columnList).equals(other$columnList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FormListTag;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RedisService $redisService = this.getRedisService();
        result = result * 59 + ($redisService == null ? 43 : $redisService.hashCode());
        String $tagConf = this.getTagConf();
        result = result * 59 + ($tagConf == null ? 43 : $tagConf.hashCode());
        String $expandParam = this.getExpandParam();
        result = result * 59 + ($expandParam == null ? 43 : $expandParam.hashCode());
        String $layoutStyle = this.getLayoutStyle();
        result = result * 59 + ($layoutStyle == null ? 43 : $layoutStyle.hashCode());
        List<FormColumn> $columnList = this.getColumnList();
        result = result * 59 + ($columnList == null ? 43 : ((Object)$columnList).hashCode());
        return result;
    }

    public String toString() {
        return "FormListTag(redisService=" + this.getRedisService() + ", tagConf=" + this.getTagConf() + ", expandParam=" + this.getExpandParam() + ", layoutStyle=" + this.getLayoutStyle() + ", columnList=" + this.getColumnList() + ")";
    }
}

