<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0,maximum-scale=1.0, user-scalable=0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>流程详情</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <style>
        body {
            font-size: 14px;
            background: #f3f3f3;
        }

        .tabbar {
            box-sizing: border-box;
            border-bottom: 1px solid #ddd;
            height: 40px;
        }

        .tabbar-item span {
            box-sizing: content-box;
            display: inline-block;
            border-bottom-width: 2px;
            border-bottom-style: solid;
            border-bottom-color: transparent;
        }

        .tabbar-item span.active {
            color: #1890ff;
            border-bottom-color: #1890ff;
        }

        .basic-content {
            box-sizing: border-box;
            padding: 10px;
        }

        .approve-info {
            font-size: 14px;
        }

        .approve-textarea {
            width: 100%;
            box-sizing: border-box;
            border-radius: 5px;
            resize: none;
            font-size: 14px;
        }

        .approve-btn {
            background: #1890ff;
            color: #fff;
            padding: 5px 10px;
            outline: none;
            border: none;
            border-radius: 5px;
            font-size: 14px;
        }

        .approve-btn:active {
            opacity: .8;
        }

        .list-content {
            list-style: none;
            padding: 0;
            margin: 0;
            box-sizing: border-box;
        }

        .list-item {
            margin-bottom: 10px;
            padding: 10px;
            font-size: 14px;
            color: #333333;
            background: #ffffff;
            border-radius: 5px;
        }

        .list-item-title {
            width: 100%;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            font-weight: 600;
        }

        .item-label {
            font-weight: 600;
        }

        .item-value {
            color: #666666;
        }

        .iframe-business {
            width: 100%;
            height: calc(100vh - 40px);
        }
    </style>
</head>

<body>
<div id="app" v-cloak>
    <div class="tabbar flex flex-align-items-center">
        <div class="tabbar-item flex-1 text-center">
            <span @click="handleTab('summary')" class="p5" :class="active==='summary'?'active':''">摘要</span>
        </div>
        <div class="tabbar-item flex-1 text-center p5">
            <span @click="handleTab('basic')" class="p5" :class="active==='basic'?'active':''">基本信息</span>
        </div>
        <div class="tabbar-item flex-1 text-center p5">
            <span @click="handleTab('business')" class="p5" :class="active==='business'?'active':''">业务数据</span>
        </div>
    </div>
    <div v-show="active==='summary'">
        <list-info title="流程名称" :value="process.processDefinitionName"></list-info>
        <list-info title="申请人" :value="process.createUserName"></list-info>
        <list-info title="流程编号" :value="process.processInstanceId"></list-info>
        <list-info title="部门" :value="process.orgName"></list-info>
        <list-info title="创建时间" :value="process.createTime"></list-info>
        <list-info title="主题" :value="process.processTitle"></list-info>
        <list-info title="详情" :value="process.processDetail" type="textarea"></list-info>
    </div>
    <div class="basic-content" v-show="active==='basic'">
        <div class="flex flex-align-items-center">
            <div class="flex-1 text-center">
                <span class="approve-info">申请人：{{process.createUserName}}</span>
            </div>
            <div class="flex-1 text-center">
                <span class="approve-info">提交时间：{{process.createTime|formatDate}}</span>
            </div>
        </div>
        <div class="mt10">
            <ul class="list-content">
                <li class="list-item" v-for="item in dynamicObj.items" :key="item.id">
                    <div class="pv5" v-for="head in dynamicObj.head" :key="head.id">
                        <span class="item-label">{{head.name}}：</span>
                        <span class="item-value">{{item[head.filed]}}</span>
                    </div>
                </li>
            </ul>
        </div>
        <ul class="list-content">
            <li class="list-item" v-for="(log,index) in logs" :key="index">
                <div class="pv5">
                    <span class="item-label">审批人：</span>
                    <span class="item-value">{{log.account}}</span>
                </div>
                <div class="pv5 flex flex-align-items-center">
                    <div class="flex-1">
                        <span class="item-label">时间：</span>
                        <span class="item-value">{{log.createDate}}</span>
                    </div>
                    <div class="flex-1">
                        <span class="item-label">类型：</span>
                        <span class="item-value">{{log.type}}</span>
                    </div>
                </div>
                <div class="pv5">
                    <span class="item-label">审批意见：</span>
                    <span class="item-value">{{log.content}}</span>
                </div>
            </li>
        </ul>
    </div>
    <div v-show="active==='business'">
        <%--<iframe v-if="dataView" :src="dataView" frameborder="0" class="iframe-business"></iframe>--%>
    </div>
</div>

<script src="/resources/sfa/js/vue.min.js"></script>
<script src="/resources/sfa/js/common.js"></script>
<script src="/resources/sfa/js/jquery.min.js"></script>

<script>
    function onJsJumpWithUrl(url) {
        js.onJsJumpWithUrl(url);
    }

    function pop(step) {
        js.pop(step);
    }

    function backPop(step) {
        var u = navigator.userAgent;
        var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
        var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
        if (isAndroid) {
            pop(step);
        }
        if (isiOS) {
            window.webkit.messageHandlers.pop.postMessage(step);
        }
    }

    var vm = new Vue({
        el: "#app",
        name: "",
        data: function () {
            return {
                token: "",
                id: "",
                contentId: "",
                processInstanceId: "",
                type: "",
                inOutType: "",
                active: "basic",
                dataView: "",
                process: {},
                dynamicObj: {
                    head: [],
                    items: []
                },
                logs: [],//记录
            }
        },
        created: function () {
            this.token = getParameterByName("token");
            this.id = getParameterByName("id");
            this.contentId = getParameterByName("contentId");
            this.processInstanceId = getParameterByName("processInstanceId");
            this.type = getParameterByName("type");
            this.inOutType = getParameterByName("inOutType");
            this.loadData();
        },
        filters: {
            formatDate: function (date) {
                if (!date) return;
                date = date.replace(/-/g, "/");
                date = new Date(date);
                let year = date.getFullYear();
                let month = date.getMonth() + 1;
                let day = date.getDate();
                month = month + '';
                month = month[1] ? month : '0' + month;
                day = day + '';
                day = day[1] ? day : '0' + day;
                return [year, month, day].join("-");
            }
        },
        methods: {
            handleTab: function (type) {
                this.active = type
            },
            loadData: function () {
                let this_ = this;
                $.ajax({
                    url: "/activiti/taCarbonCopyController/getMyCarbonCopayMobileDetail",
                    type: "post",
                    dataType: "json",
                    data: {
                        id: this.id,
                        contentId: this.contentId,
                        type: this.type,
                        inOutType: this.inOutType,
                        processInstanceId: this.processInstanceId,
                    },
                    headers: {
                        'loginUserToken': this_.token
                    },
                    success: function (res) {
                        if (res.success) {
                            this_.dataView = res.obj.dataView;
                            this_.process = res.obj.processVo;
                            this_.dynamicObj = res.obj.object || {
                                head: [],
                                items: []
                            };
                            this_.logs = res.obj.log || [];
                        } else {
                            showError(res.msg)
                        }
                    }
                })
            },
        }
    })
</script>
</body>

</html>