<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>客户物料</title>
    <t:base type="jquery,easyui,tools"></t:base>
</head>
<body style="overflow-y: hidden" scroll="no">
<t:formvalid action="/mdm-api/custProductController/saveOrUpdate" layout="div" dialog="true" formid="fiscalForm">
    <t:dgFormList expandParam="${clickFunctionId}" tagConf="${clickFunctionId}">
        <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                        defaultVal="${vo.id }"/>
        <t:dgFormColumn field="extChar1" hidden="false" formClass="biz-col-50 mb5 form" labelName="extChar1"
                        optionType="optionType" required="false"
                        defaultVal="${vo.extChar1 }"/>
        <t:dgFormColumn field="extChar2" hidden="false" formClass="biz-col-50 mb5 form" labelName="extChar2"
                        optionType="optionType" required="false"
                        defaultVal="${vo.extChar2 }"/>
        <t:dgFormColumn field="extChar3" hidden="false" formClass="biz-col-50 mb5 form" labelName="extChar3"
                        optionType="optionType" required="false"
                        defaultVal="${vo.extChar3 }"/>
        <t:dgFormColumn field="extChar4" hidden="false" formClass="biz-col-50 mb5 form" labelName="extChar4"
                        optionType="optionType" required="false"
                        defaultVal="${vo.extChar4 }"/>
        <t:dgFormColumn field="extChar5" hidden="false" formClass="biz-col-50 mb5 form" labelName="extChar5"
                        optionType="optionType" required="false"
                        defaultVal="${vo.extChar5 }"/>

        <t:dgFormColumn field="custOrgName" hidden="false" formClass="form"
                        defaultVal="${vo.custOrgName}"
                        labelName="客户组织" optionType="choseDialog" required="true" readOnly="true"
                        onclick="goCustomer();"
                        onClean="cleanOrg();"/>
        <t:dgFormColumn field="custOrgCode" hidden="false" formClass="form"
                        defaultVal="${vo.custOrgCode}"
                        labelName="客户组织编码" optionType="choseDialog" required="true" readOnly="true"
                        onclick="goCustomer();"
                        onClean="cleanOrg();"/>
        <t:dgFormColumn field="customerCode" hidden="false" formClass="form"
                        defaultVal="${vo.customerCode}"
                        labelName="客户产品编号" optionType="input" required="true"/>
        <t:dgFormColumn field="customerName" hidden="false" formClass="form"
                        defaultVal="${vo.customerName}"
                        labelName="客户产品名称" optionType="input" required="false"/>
        <t:dgFormColumn field="productCode" hidden="false" formClass="form"
                        defaultVal="${vo.productCode}"
                        labelName="产品编号" optionType="choseDialog" required="true" readOnly="true"
                        onclick="getProduct();"
                        onClean="cleanProduct();"/>
        <t:dgFormColumn field="productName" hidden="false" formClass="form"
                        defaultVal="${vo.productName}"
                        labelName="产品名称" optionType="choseDialog" required="true" readOnly="true"
                        onclick="getProduct();"
                        onClean="cleanProduct();"/>

    </t:dgFormList>
</t:formvalid>
<script type="text/javascript">

    //获取客户组织（编号，名称）
    function goCustomer() {
        triggerId = "#custOrgCode";
        triggerName = "#custOrgName";
        url = "/page/tmApiCustOrgController/goCustOrgSelectMain?clickFunctionId=${clickFunctionId}";
        width = 1000;
        height = 450;
        id = "customerList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData.length !== 1) {
                    iframe.tip('请选择一条数据');
                    return false;
                } else {
                    $(triggerId).val(rowsData[0].custOrgCode);
                    $(triggerName).val(rowsData[0].customerOrgName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }


    function getProduct() {
        triggerId = "#productCode";
        triggerName = "#productName";
        url = "/page/tmApiProductInfoController/goProductInfoAndCostPriceListMain?check=false&costPriceGreaterZero=false&clickFunctionId=${clickFunctionId}";
        width = 1000;
        height = 450;
        id = "productinfoList";
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData.length !== 1) {
                    iframe.tip('请选择一条数据');
                    return false;
                } else {
                    $(triggerId).val(rowsData[0].productInfoCode);
                    $(triggerName).val(rowsData[0].productInfoName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    // 清除客户组织()
    function cleanOrg() {
        $("#custOrgName").val("");
        $("#custOrgCode").val("");
    }

    //    清除产品信息（名称，编号）
    function cleanProduct() {
        $("#productName").val("");
        $("#productCode").val("");
    }

</script>
</body>

</html>