<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>添加活动</title>
    <t:base type="jquery,easyui,tools" extendUrlKey="TtActQuotaForm"></t:base>
    <style>
        #content {
            height: auto !important;
            padding: 0px !important;
        }

        .layout-split-north {
            border-bottom: 1px solid #0072ae00;
        }

        .datagrid-header, .datagrid-toolbar, .datagrid-footer-inner {
            border-color: transparent;
        }
    </style>
</head>
<body class="easyui-layout" fit="true" id="region">
<div data-options="region:'north'" style="height: 210px">
    <div class="form-group" id="app">
        <%--关键指标html开始--%>
        <target-table ref="targetTable" :id="id" :page="page" :show-target="isActiviti" :view-status="viewStatus"
                      @refresh="handleRefresh"></target-table>
        <%--关键指标html结束--%>
    </div>
    <t:formvalid action="/act/ttActQuotaController/saveOrUpdate" beforeSubmit="checkproductSubmit" layout="div"
                 dialog="true" formid="detailId">
        <t:dgFormList layoutStyle="horizontal" tagConf="${clickFunctionId}">
            <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                            defaultVal="${vo.id }"/>
            <t:dgFormColumn field="headTarget" hidden="true" formClass="form" labelName="headTarget" optionType="input"
                            required="false"
            />
            <t:dgFormColumn field="workFlowKey" hidden="true" formClass="form" labelName="workFlowKey"
                            optionType="input"
                            required="false" defaultVal="${vo.workFlowKey}"/>
            <t:dgFormColumn field="workFlowName" hidden="true" formClass="form" labelName="workFlowName"
                            optionType="input"
                            required="false" defaultVal="${vo.workFlowName}"/>
            <t:dgFormColumn field="itemTarget" hidden="true" formClass="form" labelName="itemTarget" optionType="input"
                            required="false"/>
            <t:dgFormColumn field="tempUuid" hidden="true" formClass="biz-col-50 mb5 form" labelName="tempUuid"
                            optionType="input" required="false"
                            defaultVal="${tempUuid }"/>
            <t:dgFormColumn field="productJson" hidden="true" formClass="form" labelName="productJson"
                            optionType="input" required="false"
                            defaultVal=""/>
            <t:dgFormColumn field="actType" hidden="true" formClass="biz-col-50 mb5 form" labelName="活动类型"
                            optionType="input"
                            required="false" defaultVal="${vo.actType}"/>
            <t:dgFormColumn field="actCode" hidden="true" formClass="biz-col-50 mb5 form" labelName="活动编码"
                            optionType="input" required="false"
                            defaultVal="${vo.actCode}"/>
            <t:dgFormColumn field="actName" hidden="false" formClass="biz-col-50 mb5 form" labelName="活动名称"
                            optionType="input" required="true"
                            defaultVal="${vo.actName}"/>
            <t:dgFormColumn field="beginDate" extendField="endDate" extendFieldVal="${vo.endDate}" hidden="false"
                            formClass="biz-col-50 mb5 form" labelName="起止时间" optionType="date_begin_end" required="true"
                            defaultVal="${vo.beginDate}"/>
            <t:dgFormColumn field="budgetCode" hidden="false" formClass="biz-col-50 mb5 form" labelName="预算选择"
                            optionType="choseDialog" required="true"
                            onclick="selectbudget()" defaultVal="${vo.budgetCode}"/>
            <t:dgFormColumn field="budgetSubjectsCode" hidden="true" formClass="biz-col-50 mb5 form" labelName="预算科目编码"
                            optionType="input" required="false"
                            defaultVal="${vo.budgetSubjectsCode}"/>
            <t:dgFormColumn field="budgetSubjectsName" hidden="true" formClass="biz-col-50 mb5 form" labelName="预算科目名称"
                            optionType="input" required="false"
                            defaultVal="${vo.budgetSubjectsName}"/>
            <t:dgFormColumn field="orderBeginDate" extendField="orderEndDate" extendFieldVal="${vo.orderEndDate}"
                            hidden="false" formClass="biz-col-50 mb5 form" labelName="订货期间" optionType="date_begin_end"
                            required="true"
                            defaultVal="${vo.orderBeginDate}"/>
            <t:dgFormColumn field="categoriesName" hidden="false" formClass="biz-col-50 mb5 form" labelName="活动大类"
                            optionType="choseDialog" required="true"
                            onclick="selectCategories()" defaultVal="${vo.categoriesName}"/>
            <t:dgFormColumn field="categoriesCode" hidden="true" formClass="biz-col-33 mb5 form" labelName="活动大类名称"
                            optionType="input" required="false"
                            defaultVal="${vo.categoriesCode }"/>
            <t:dgFormColumn field="extChar1" hidden="false" formClass="biz-col-50 mb5 form" labelName="extChar1"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar1 }"/>
            <t:dgFormColumn field="extChar2" hidden="false" formClass="biz-col-50 mb5 form" labelName="extChar2"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar2 }"/>
            <t:dgFormColumn field="extChar3" hidden="false" formClass="biz-col-50 mb5 form" labelName="extChar3"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar3 }"/>
            <t:dgFormColumn field="extChar4" hidden="false" formClass="biz-col-50 mb5 form" labelName="extChar4"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar4 }"/>
            <t:dgFormColumn field="extChar5" hidden="false" formClass="biz-col-50 mb5 form" labelName="extChar5"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar5 }"/>
            <t:dgFormColumn field="extChar6" hidden="false" formClass="biz-col-50 mb5 form" labelName="extChar6"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar6 }"/>
            <t:dgFormColumn field="extChar7" hidden="false" formClass="biz-col-50 mb5 form" labelName="extChar7"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar7 }"/>
            <t:dgFormColumn field="extChar8" hidden="false" formClass="biz-col-50 mb5 form" labelName="extChar8"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar8 }"/>
            <t:dgFormColumn field="extChar9" hidden="false" formClass="biz-col-50 mb5 form" labelName="extChar9"
                            optionType="optionType" required="false"
                            defaultVal="${vo.extChar9 }"/>
            <t:dgFormColumn field="remarks" hidden="false" formClass="biz-col-100 mb5 form" labelName="备注"
                            optionType="textarea" required="false"
                            rows="2" cols="5" defaultVal="${vo.remarks}" style="width: 93%"/>
        </t:dgFormList>
    </t:formvalid>
</div>
<div data-options="region:'center'" style="padding:5px;">
    <t:datagrid tagConf="${clickFunctionId}_TtActQuotaDetailForm" name="quotaDetailList" checkbox="true"
                fitColumns="false" idField="id"
                fit="true"
                queryMode="group"
                actionUrl="/act/ttActQuotaController/findTtActQuotaDetailPage?tempUuid=${tempUuid}&id=${vo.id}"
                pagination="false"
                onLoadSuccess="loadSuccess"
    >
        <t:dgCol title="id" field="id" hidden="true"/>
        <t:dgCol title="活动细类" field="actSubclassCode" hidden="true"/>
        <t:dgCol title="是否产品分摊" field="needShare" hidden="true"/>
        <t:dgCol title="活动细类" field="actSubclassName" sortable="false" width="100"/>
        <t:dgCol title="客户名称" field="customerName" query="false" sortable="false" width="100"/>
        <t:dgCol title="门店名称" field="terminalName" sortable="false" width="100"/>
        <t:dgCol title="申请金额" field="amount" sortable="false" width="100"/>
        <t:dgCol title="支付方式" field="payType" dictionary="pay_type" sortable="false" width="100"/>
        <t:dgCol title="预估销售额(客户)" field="fsalesAmountCustomer" sortable="false" width="100"/>
        <t:dgCol title="预估销售额(门店)" field="fsalesAmountTerminal" sortable="false" width="100"/>
        <t:dgCol title="备注" field="remarks" width="100" sortable="false"/>
        <t:dgCol title="核销资料" field="fineStr" hidden="true" width="100" sortable="false"/>
        <t:dgCol title="核销资料" field="fineName" width="200" sortable="false"/>
        <t:dgCol title="资料修改人" field="fineUpdateBy" width="100" sortable="false"/>
        <t:dgCol title="资料修改时间" field="fineUpdateDate" formatter="yyyy-MM-dd HH:mm:ss" width="100" sortable="false"/>
        <t:dgCol title="活动开始时间" field="beginDate" formatter="yyyy-MM-dd" width="100" sortable="false"/>
        <t:dgCol title="活动结束时间" field="endDate" formatter="yyyy-MM-dd" width="100" sortable="false"/>
        <t:dgToolBar title="新增" funname="addDetail" detail="false" icon="icon-add"
                     url=""></t:dgToolBar>

        <t:dgToolBar title="编辑" funname="updateDetail" detail="false" icon="icon-edit"
                     url=""></t:dgToolBar>
        <c:if test="${isDisplay == '1' }">
            <t:dgToolBar title="导入" detail="false" icon="icon-dataIn"
                         onclick="detailExcel()"></t:dgToolBar>
        </c:if>
        <t:dgToolBar title="删除" funname="deleteALLSelect" detail="false" icon="icon-remove"
                     url="/act/ttActQuotaController/delDetail"></t:dgToolBar>
        <t:dgToolBar title="附件" onclick="addAttach('${tempUuid}','${attachmentType}','${load}')" url=""
                     icon="icon-attach"></t:dgToolBar>
        <c:if test="${not empty isdetail}">
            <t:dgToolBar title="核销资料" funname="actfineDetail" icon="icon-edit"
                         url=""></t:dgToolBar>
        </c:if>
        <t:dgToolBar title="分组" funname="devideGroup" detail="false" icon="icon-remove"
                     url=""></t:dgToolBar>
    </t:datagrid>
    <div class="p10 mb20" id="productDiv" style="display:none;">
        <table id="templeteTable" style="width: 100%;" cellpadding="0" cellspacing="1"
               class="formtable">
            <tbody>
            <tr>
                <td>
                               <span style="position: relative;">
                                   <input field="formtable" name="productLevelCode" id="productLevelCode"
                                          type="hidden"
                                          style="width: 150px">
                                    <input field="formtable" name="productLevelName" id="productLevelName" type="text"
                                           style="width: 150px" class="inputxt">
                                    <a href="javascript:void(0);"
                                       onclick="selectProductLevel(this)" class="easyui-linkbutton"
                                       style="position: absolute;right:0;height: 24px;box-sizing: border-box;margin-right: 0;"
                                       plain="true" iconCls="icon-search"></a>
                                </span>

                </td>
                <%--<td>
                               <span style="position: relative;">
                                   <input field="formtable" name="productCode" id="productCode"
                                          type="hidden"
                                          style="width: 150px">
                                    <input field="formtable" name="productName" id="productName" type="text"
                                           style="width: 150px" class="inputxt" nocheck="true">
                                    <a href="javascript:void(0);"
                                       onclick="selectProductInfo(this)" class="easyui-linkbutton"
                                       style="position: absolute;right:0;height: 24px;box-sizing: border-box;margin-right: 0;"
                                       plain="true" iconCls="icon-search"></a>
                                </span>

                </td>--%>
                <td>
                    <input field="formtable" name="scale"
                           type="text"
                           style="width: 150px" class="inputxt">
                </td>
                <td>
                    <input field="formtable" name="remarks"
                           type="text"
                           nocheck="true"
                           style="width: 150px" class="inputxt">
                </td>
                <td>
                    <a iconCls="icon-remove" href="#" onclick="deleteTrTable(this)">删除</a>
                </td>
            </tr>
            </tbody>
        </table>
        <div id="actproduct"
                <c:if test="${needShare!=null and needShare == 0}">
                    class="hidden"
                </c:if> >
            <div class="p5">
                <span class="mr20">产品分摊信息</span>
                <a class="toolbar-btn" id="addTrBtn" href="#" onclick="addTrTable()">添加一行</a>
            </div>
            <table id="showTable" class="table-dynamic">
                <thead>
                <tr>
                    <th>产品层级</th>
                    <%--<th>产品</th>--%>
                    <th>比例%</th>
                    <th>备注</th>
                    <th>操作</th>
                </tr>
                </thead>
                <tbody>
                <c:if test="${needShare!=null and needShare == 1}">
                    <c:forEach items="${vo.products}" var="item">
                        <tr id='trId___'>
                            <td>
                               <span style="position: relative;">
                                   <input field="formtable" name="productLevelCode"
                                          type="hidden" value="${item.productLevelCode}"
                                          style="width: 150px">
                                    <input field="formtable" name="productLevelName" type="text"
                                           value="${item.productLevelName}"
                                           style="width: 150px" class="inputxt">
                                    <a href="javascript:void(0);"
                                       onclick="selectProductLevel(this)" class="easyui-linkbutton"
                                       style="position: absolute;right:0;height: 24px;box-sizing: border-box;margin-right: 0;"
                                       plain="true" iconCls="icon-search"></a>
                                </span>

                            </td>
                            <td>
                                <input field="formtable" name="scale" value="${item.scale}"
                                       type="text"
                                       style="width: 150px" class="inputxt">
                            </td>
                            <td>
                                <input field="formtable" name="remarks" value="${item.remarks}"
                                       type="text"
                                       nocheck="true"
                                       style="width: 150px" class="inputxt">
                            </td>
                            <td>
                                <a iconCls="icon-remove" href="#" onclick="deleteTrTable(this)">删除</a>
                            </td>
                        </tr>
                    </c:forEach>
                </c:if>
                </tbody>
            </table>
        </div>
    </div>
</div>
</body>
</html>

<script src="/resources/act/attachment/js/attachment.js"></script>

<script type="text/javascript">
    var productShare = false;
    var productDiv = "";
    //关键指标js开始
    let vm = new Vue({
        el: "#app",
        data: function () {
            return {
                id: "${vo.id}",
                page: "dehd",
                viewStatus: "${viewStatus}",
                isActiviti: "${isActiviti}"
            }
        },
        methods: {
            handleRefresh: function (target) {
                let this_ = this;
                canSubmit = true;
                let data = createData();
                if (canSubmit) {
                    let postParams = data;
                    $.ajax({
                        url: "/act/ttActQuotaController/refresh",
                        type: "post",
                        dataType: "json",
                        data: JSON.stringify(postParams),
                        contentType: "application/json",
                        complete: function () {
                        },
                        success: function (res) {
                            closeProgressTop();
                            if (res.success) {
                                this_.$refs.targetTable.setTargetData(res.obj);
                            } else {
                                tip(res.msg);
                            }
                        },
                        error: function () {
                            closeProgressTop();
                        }
                    })
                }
            },
        }
    })
    //关键指标js结束

    $.fn.parseForm = function () {
        var serializeObj = {};
        var array = this.serializeArray();
        $(array).each(function () {
            if (serializeObj[this.name]) {
                if ($.isArray(serializeObj[this.name])) {
                    serializeObj[this.name].push(this.value);
                } else {
                    serializeObj[this.name] = [serializeObj[this.name], this.value];
                }
            } else {
                serializeObj[this.name] = this.value;
            }
        });
        return serializeObj;
    };

    function createData() {
        checkproductSubmit();
        var data = $("#detailId").parseForm();
        data.target = vm.$refs.targetTable.getTargetData();
        return data;
    }

    function addDetail() {
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        if (categoriesCode == "") {
            tip("请先选择活动大类");
            return false;
        } else {
            id = "quotaDetailList";
            gridname = id;
            var clickFunctionId = '${clickFunctionId}';
            var addurl = "/page/ttActQuotaController/goUpdateOrAddDetail?1=1&tempUuid=${tempUuid}&categoriesCode=" + categoriesCode + "&budgetCode=" + budgetCode + "&clickFunctionId=" + clickFunctionId;
            createwindow("新增", addurl, 400, 400, {});
        }
    }

    function updateDetail() {
        var rowsData = $('#quotaDetailList').datagrid('getSelections');
        var myobj = eval(rowsData);
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        if (categoriesCode == "") {
            tip("请先选择活动大类");
            return false;
        } else {
            id = "quotaDetailList";
            var clickFunctionId = '${clickFunctionId}';
            gridname = id;
            var addurl = "/page/ttActQuotaController/goUpdateOrAddDetail?1=1&tempUuid=${tempUuid}&categoriesCode=" + categoriesCode + "&id=" + myobj[0].id + "&budgetCode=" + budgetCode + "&clickFunctionId=" + clickFunctionId;
            createwindow("编辑", addurl, 400, 400, {});
        }
    }

    function productShareInit() {
        var needShareAll = checkNeedShare();
        if (productShare) {
            if (needShareAll == 1) {
            } else {
                $('#region').layout('remove', 'south');
                productShare = false;
            }
        } else if (needShareAll == 1) {
            productShare = true;
            addPanel("south");
            if (productDiv == "") {
                var load = '${load}';
                if (!isEmpty(load) && load == 'detail') {
                    $('#actproduct tbody tr td a').remove();
                }
                productDiv = $("#productDiv").html();
                $("#productDiv").remove();
            }
            $('#region').layout('panel', 'south').append(productDiv);
        }
    }

    function addPanel(region) {
        var options = {
            region: region
        };
        if (region == 'north') {
            options.height = 100;
        } else if (region == 'south') {
            options.height = 100;
        } else {
            options.width = 100;
            options.split = true;
            options.title = $('#region option:selected').text();
        }
        $('#region').layout('add', options);
    }

    var trId = 0;
    var cloneTrTemp = "";
    $(function () {
        $('#templeteTable').hide();
        $('#addTrBtn').linkbutton({
            iconCls: 'icon-add'
        });
        var detail = '${load}';
        if (detail == "detail") {
            $('#addTrBtn').hide();
        }
        // addTrTable();
    });

    function loadSuccess() {
        setTimeout(function () {
            $("#quotaDetailList").datagrid("resize");
        }, 400);
        productShareInit();
    }

    function addTrTable() {
        var tr = $("#templeteTable tbody").html();
        cloneTrTemp = tr;
        var replaceName = tr.replace(/___/g, trId);
        $("#showTable tbody").append(replaceName);
        trId++;
    }

    function deleteTrTable(event) {
        $(event).parents("tr").remove();
    }

    function removeTempLete() {
        $('#templeteTable').remove();
    }

    //提交前处理
    function checkproductSubmit() {
        var b = true;
        <%--var needShare = ${needShare};--%>
        <%--if (needShare == 1) {--%>
        <%--    settingStatus();--%>
        <%--}--%>
        var needShareAll = checkNeedShare();
        if (needShareAll == 1) {
            settingStatus();
        }
        if (ischeckProduct) {
            b = checkTable();
        }
        if ("${isActiviti}" == "1") {
            var target = vm.$refs.targetTable.getTargetData();
            $("#headTarget").val(JSON.stringify(target.headTarget));
            $("#itemTarget").val(JSON.stringify(target.itemTarget));
            $("#workFlowKey").val(target.processKey);
        }
        return b;
    }

    //检查是否需要分摊
    function checkNeedShare() {

        var needShareAll = 0;
        var rowsData = $('#quotaDetailList').datagrid('getRows');
        for (var i = 0; i < rowsData.length; i++) {
            if (rowsData[i].needShare == "1") {
                needShareAll = 1;
            }
        }

        return needShareAll;
    }

    //校验table
    function checkTable() {
        var canSubmit = true;
        var tableData = [];

        $("#showTable tbody tr").each(function () {
            if (canSubmit) {
                var obj = {};
                /*var productLevelName = $(this).find("input[name=productLevelName]").val();
                var productName = $(this).find("input[name=productName]").val();
                if (productLevelName == "" && productName == "") {
                    canSubmit = false;
                    tip("产品层级和产品需要选择一种");
                    return false;
                }*/
                $(this).find("td").each(function (index) {
                    if (canSubmit) {
                        $(this).find("input[field=formtable]").each(function () {
                            var inputName = $(this).attr("name");
                            obj[inputName] = $(this).val();
                            if (!$(this).val() && $(this).attr("type") !== "hidden" && $(this).attr("nocheck") !== "true") {
                                canSubmit = false;
                                $(this).focus();
                                var name = $("#showTable thead tr th").eq(index).text();
                                tip(name + "不能为空");
                                return false;
                            }
                        })

                    } else {
                        return false;
                    }
                });
                tableData.push(obj);
            } else {
                return false;
            }
        });
        let total = 0;
        tableData.forEach(function (item) {
            total = (parseFloat(total) * 1000 + parseFloat(item.scale) * 1000) / 1000
        });
        if (total > 100) {
            canSubmit = false;
            tip("比例超过100%");
        }
        if (total < 100) {
            canSubmit = false;
            tip("比例之和必须为100%");
        }
        if (canSubmit) {
            $("#productJson").val(JSON.stringify(tableData))
        }
        return canSubmit;
    }

    var ischeckProduct = false;

    //该方法表示需要分摊产品 打开 产品分摊显示
    function settingStatus() {
        $("#actproduct").removeClass("hidden");
        ischeckProduct = true;
    }

    //选择产品层级
    function selectProductLevel(obj) {
        var budgetCode = $("#budgetCode").val();
        url = "/page/tmApiProductLevelController/goProductListMain?budgetCode=" + budgetCode + "&clickFunctionId=${clickFunctionId}";
        width = 1000;
        height = 450;
        id = "productLevelList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData == '' || rowsData == null) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    var myobj = eval(rowsData);
                    $(obj).parent().find("input[name='productLevelCode']").val(myobj[0].productCode);
                    $(obj).parent().find("input[name='productLevelName']").val(myobj[0].productName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    //选择产品
    function selectProductInfo(obj) {
        var url = "/page/tmApiProductInfoController/goProductInfoListMain";
        var width = 900;
        var height = 500;
        id = "productinfoList";
        var gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {

                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData == '' || rowsData == null) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    var myobj = eval(rowsData);
                    $(obj).parent().find("input[name='productCode']").val(myobj[0].productInfoCode);
                    $(obj).parent().find("input[name='productName']").val(myobj[0].productInfoName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function selectbudget(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "budgetCode";
        triggerName = "budgetName";
        url = "/page/ttApiBudgetController/goApiBudgetMain?clickFunctionId=${clickFunctionId}&tableType=act_quota";
        width = 900;
        height = 500;
        id = "ttApibudgetList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#budgetCode").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].budgetCode);
                    $("#budgetSubjectsCode").val(myobj[0].budgetSubjectsCode);
                    $("#budgetSubjectsName").val(myobj[0].budgetSubjectsName);
                    var budgetCode = myobj[0].budgetCode;
                    $.ajax({
                        url: "/budget/ttApiCostTypeCategoriesController/getCategoriesListByBudgetCode?budgetCode=" + budgetCode + "&clickFunctionId=${clickFunctionId}",
                        dataType: 'json',
                        type: 'post',
                        async: false,
                        success: function (data) {
                            if (data.length == 1) {
                                $("#categoriesCode").val(data[0].categoriesCode);
                                $("#categoriesName").val(data[0].categoriesName);
                            } else {
                                $("#categoriesCode").val("");
                                $("#categoriesName").val("");
                            }
                        }
                    })
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function selectCategories() {
        var budgetCode = $("#budgetCode").val();
        if (budgetCode == "") {
            tip("请先选择预算");
            return;
        }
        triggerId = "categoriesCode";
        triggerName = "categoriesName";
        url = "/page/ttApiCostTypeCategoriesController/goApiActSelectCategoriesMain?budgetCode=" + budgetCode + "&clickFunctionId=${clickFunctionId}";
        width = 600;
        height = 500;
        id = "categoriesList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#categoriesCode").focus();
                if (rowsData.length == 0) {
                    iframe.tip("请至少选择一条数据");
                    return false;
                } else {
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].categoriesCode);
                    $("#" + triggerName).val(myobj[0].categoriesName);
                    $("#categoriesName").focus();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function impot() {
        quotaDetailListsearch();
    }

    function detailExcel() {
        var tempId = "${tempUuid}";
        var categoriesCode = $("#categoriesCode").val();
        var budgetCode = $("#budgetCode").val();
        var clickFunctionId = '${clickFunctionId}';
        <c:if test="${not empty importUploadUrl}">
        var data = ${importUploadUrl};
        data.strExtend1 = tempId;
        data.strExtend2 = categoriesCode;
        data.strExtend3 = budgetCode;
        data.strExtend4 = clickFunctionId;
        importExcel(data, impot)
        </c:if>
    }

    //选择核销资料
    function actfineDetail() {

        var rowsData = $('#quotaDetailList').datagrid('getSelections');
        if (rowsData == null || rowsData.length == 0 || rowsData.length > 1) {
            tip("请选择一条数据");
            return false;
        } else {
            var actSubclassCode = rowsData[0].actSubclassCode;
            var actCode = $("#actCode").val();
            var id_ = rowsData[0].id;
            id = "quotaDetailList";
            var clickFunctionId = '${clickFunctionId}';
            var fineStr = rowsData[0].fineStr;
            gridname = id;
            $.dialog.setting.zIndex = 99999;
            var addurl = "/page/ttActQuotaController/goActFineForm?actCode=" + actCode + "&actSubclassCode=" + actSubclassCode + "&id=" + id_ + "&actType=3&fineStr=" + fineStr;
            if ("${vo.bpmStatus}" == "2") {
                createwindow("编辑", addurl, 400, 400, {});
            } else {
                createdetailwindow("查看", addurl, 400, 400);
            }


        }
    }

    //分摊分组
    function devideGroup() {
        var rowsData = $('#quotaDetailList').datagrid('getSelections');
        if (rowsData == null || rowsData.length == 0 || rowsData.length > 1) {
            tip("请选择一条数据");
            return false;
        } else {
            var tId = rowsData[0].id;
            let beginTime = $("#beginDate").val();
            let endTime = $("#endDate").val();
            var addurl = "/act/ttActQuotaController/group";
            var data={id:tId,beginTime:beginTime,endTime:endTime};
            console.log(data);
            $.ajax({
                url: addurl,
                dataType: 'json',
                contentType: "application/json",
                type: 'post',
                async: false,
                data: JSON.stringify(data),
                success: function (data) {
                    if(data.success){
                        quotaDetailListsearch();
                    }else {
                        tip(data.msg);
                    }
                }
            })


        }
    }

</script>