<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title>费用上账</title>
    <t:base type="jquery,easyui,tools" extendUrlKey="accountMainForm"></t:base>
</head>
<body class="easyui-layout" fit="true" id="region">
<div id="fromTable">
    <t:formvalid action="/act/ttActQuotaController/saveOrUpdate" beforeSubmit="checkproductSubmit" layout="div"
                 dialog="true" formid="detailId">
        <t:dgFormList layoutStyle="horizontal" >
            <t:dgFormColumn field="name" hidden="false" formClass="biz-col-33 mb5 form" labelName="抬头文本" optionType="input"  required="false"
                            />
            <t:dgFormColumn field="billNum" hidden="false" formClass="biz-col-33 mb5 form" labelName="附件张数" optionType="input"  required="false"
            />
            <t:dgFormColumn field="voucherCode" hidden="false" formClass="biz-col-33 mb5 form" labelName="凭证编号" optionType="input" readOnly="true" required="false"
            />
            <t:dgFormColumn field="remarks" hidden="false" formClass="biz-col-100 mb5 form" labelName="备注" optionType="textarea"  required="false"
                            rows="2" cols="2"  style="width: 868px; height: 39px;"/>
        </t:dgFormList>
    </t:formvalid>
</div>
<div data-options="region:'center' " style="padding:5px;">
    <t:datagrid tagConf="${clickFunctionId}_accountAddList" name="accountAddList"   idField="id" queryMode="group" fit="true" fitColumns="false"
                actionUrl="/fee/ttAccountController/getListForUpdatePage?groupId=${groupId}" pagination="false" checkbox="true"
                singleSelect="false" onLoadSuccess="initBill" >
        <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
        <t:dgCol title="上账总单号" field="accountCode" ></t:dgCol>
        <t:dgCol title="活动名称" field="actName" ></t:dgCol>
        <t:dgCol title="活动编号" field="actCode" ></t:dgCol>
        <t:dgCol title="活动明细编号" field="actDetailCode" ></t:dgCol>
        <t:dgCol title="核销编号" field="auditCode" ></t:dgCol>
        <t:dgCol title="核销明细编号" field="auditDetailCode" ></t:dgCol>
        <t:dgCol title="活动细类" field="fineName" ></t:dgCol>
        <t:dgCol title="活动细类" field="fineCode" hidden="true"></t:dgCol>
        <t:dgCol title="客户编码" field="custCode" ></t:dgCol>
        <t:dgCol title="客户名称" field="custName" ></t:dgCol>
        <t:dgCol title="门店" field="terminalName" ></t:dgCol>
        <t:dgCol title="门店编码" field="terminalCode" hidden="true"></t:dgCol>
        <t:dgCol title="组织" field="departName" ></t:dgCol>
        <t:dgCol title="组织编码" field="departCode" ></t:dgCol>
        <t:dgCol title="核销金额" field="currentAmount" hidden="true"></t:dgCol>
        <t:dgCol title="已上账金额" field="feeUsed" hidden="true"></t:dgCol>
        <t:dgCol title="可上账金额" field="auditAmount" ></t:dgCol>
        <t:dgCol title="本次上账金额" field="accountAmount"  editor="{type:'numberbox',options:{precision:2,required:true}}"></t:dgCol>
        <t:dgCol title="支付方式" field="paymentCode" dictionary="pay_type"></t:dgCol>
        <t:dgCol title="货补产品编码" field="accountProductCode" hidden="true" ></t:dgCol>
        <t:dgCol title="货补产品" field="accountProductName" hidden="true" style="color:red!important;_请选择" ></t:dgCol>
        <t:dgCol title="货补产品层级编码" field="productLevel" hidden="true" ></t:dgCol>
        <t:dgCol title="货补产品" field="productLevelName" style="color:red!important;_请选择" ></t:dgCol>
        <%--<t:dgCol title="财务凭证编号" field="credentialsCode" editor="{type:'text'}"></t:dgCol>--%>
        <t:dgCol title="财务凭证编号" field="credentialsCode" ></t:dgCol>
        <t:dgCol title="核销科目编号" field="budgetSubjectsCode" ></t:dgCol>
        <t:dgCol title="核销科目" field="budgetSubjectsName" ></t:dgCol>
        <t:dgCol title="活动开始时间" field="beginDate" ></t:dgCol>
        <t:dgCol title="活动结束时间" field="endDate" ></t:dgCol>
        <t:dgCol title="支付方式类型类型" field="payTypeCode" hidden="true"></t:dgCol>
        <t:dgCol title="活动类型" field="actType" hidden="true"></t:dgCol>
        <t:dgCol title="活动大类编码" field="categoriesCode" hidden="true"></t:dgCol>
        <t:dgCol title="活动大类名称" field="categoriesName" hidden="true"></t:dgCol>
        <t:dgCol title="extChar1" field="extChar1" hidden="true"></t:dgCol>
        <t:dgCol title="extChar2" field="extChar2" hidden="true"></t:dgCol>
        <t:dgCol title="extChar3" field="extChar3" hidden="true"></t:dgCol>
        <t:dgCol title="extChar4" field="extChar4" hidden="true"></t:dgCol>
        <t:dgCol title="extChar5" field="extChar5" hidden="true"></t:dgCol>
        <t:dgCol title="extChar6" field="extChar6" hidden="true"></t:dgCol>
        <t:dgCol title="extChar7" field="extChar7" hidden="true"></t:dgCol>
        <t:dgCol title="extChar8" field="extChar8" hidden="true"></t:dgCol>
        <t:dgCol title="extChar9" field="extChar9" hidden="true"></t:dgCol>
        <t:dgToolBar detail="false" title="选择" icon="icon-add" url="/page/ttApiAuditController/goAuditDetailSelectMain"
                     funname="selectAuditDetail" ></t:dgToolBar>
        <t:dgToolBar detail="false" title="删除" icon="icon-remove" url=""
                     funname="deleteSelect"></t:dgToolBar>
        <t:dgToolBar detail="false" title="导入"  operationCode="import" icon="icon-dataIn"
                     onclick="importDataByXml({impName:'tmAdministrativeArea', gridName:'tbaList'})"></t:dgToolBar>
        <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut"
                     url="/fee/commonExcelController/excel" funname="excelCommonExport"></t:dgToolBar>
    </t:datagrid>
</div>
</body>
<script type="text/javascript">
    //是否有发票
    var billFlag = false;
    var fromTableHtml = "";
    var groupId = '${groupId}';
    $(function () {
        $('#accountAddList').datagrid({
            onClickCell: function(index,field,value){
                var row = $('#accountAddList').datagrid('getData').rows[index];
                if(field=="accountProductName"){
                    //货补的时候选择
                    if(row.paymentCode == '30'){
                        //选择产品
                        goSelectProduct(index);
                    }
                }
                if(field=="productLevelName"){
                    //货补的时候选择
                    if(row.paymentCode == '30'){
                        //选择产品层级
                        goSelectProductLeve(index);
                    }
                }
                if(field=="accountAmount"){
                    editorALl();
                }
            }
        });
    });

    
    function initBill() {
        $.ajax({
            type: "GET",
            url: "/fee/ttAccountController/getFeeBillHead",
            data: {"groupId":groupId},
            async:false,
            success: function(data){
                if(data.success){
                    if(!isEmpty(data.obj.id)){
                        autoBill();
                        $("#name").val(data.obj.name);
                        $("#billNum").val(data.obj.billNum);
                        $("#remarks").val(data.obj.remarks);
                    }

                }else{
                    tip(data.msg);
                }
            }
        });
    }

    /** 选择产品 */
    function goSelectProduct(index) {
        var load = '${load}';
        if(!isEmpty(load)&&load=='detail'){
            return;
        }
        endEditorALl();
        triggerId = "productCode";
        triggerName = "productName";
        url = "/page/tmApiProductInfoController/goProductInfoListMain";
        width = 500;
        height = 450;
        id = "productinfoList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            parent:'auditProduct',
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }
                } else {
                    var productInfoCodes = [];
                    var productInfoNames = [];
                    for(var i=0;i<rowsData.length;i++){
                        productInfoCodes[i]=rowsData[i].productInfoCode;
                        productInfoNames[i]=rowsData[i].productInfoName;
                    }
                    $('#accountAddList').datagrid('updateRow',{
                        index: index,
                        row: {
                            accountProductCode: productInfoCodes.join(","),
                            accountProductName: productInfoNames.join(",")
                        }
                    });
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function goSelectProductLeve(index) {
        var load = '${load}';
        if(!isEmpty(load)&&load=='detail'){
            return;
        }
        endEditorALl();
        triggerId = "productLevelCode";
        triggerName = "productLevelName";
        url = "/page/tmApiProductLevelController/goProductListMain";
        width = 500;
        height = 450;
        id = "productLevelList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            parent:'auditProduct',
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }
                } else {
                    var productInfoCodes = [];
                    var productInfoNames = [];
                    for(var i=0;i<rowsData.length;i++){
                        productInfoCodes[i]=rowsData[i].productCode;
                        productInfoNames[i]=rowsData[i].productName;
                    }
                    $('#accountAddList').datagrid('updateRow',{
                        index: index,
                        row: {
                            productLevel: productInfoCodes.join(","),
                            productLevelName: productInfoNames.join(",")
                        }
                    });
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /**删除上账明细*/
    function deleteSelect() {
        var rowsDetailDatas = $('#accountAddList').datagrid('getSelections');
        if(rowsDetailDatas.length==0){
            tip("请选择待删除的数据");
            return ;
        }
        getSafeJq().dialog.confirm("你确定删除选择的数据吗?", function (r) {
            if (r) {
              for(var i=rowsDetailDatas.length-1;i>=0;i--){
                  var index = $('#accountAddList').datagrid('getRowIndex',rowsDetailDatas[i]);
                  $('#accountAddList').datagrid('deleteRow',index);
              }
                autoBill();
              setTaxOutAmount();
            }
        });
    }
    /**删除发票明细*/
    function deleteInSelect() {
        var rowsDetailDatas = $('#billAddList').datagrid('getSelections');
        if(rowsDetailDatas.length==0){
            tip("请选择待删除的数据");
            return ;
        }
        getSafeJq().dialog.confirm("你确定删除选择的数据吗?", function (r) {
            if (r) {
                for(var i=rowsDetailDatas.length-1;i>=0;i--){
                    var index = $('#billAddList').datagrid('getRowIndex',rowsDetailDatas[i]);
                    $('#billAddList').datagrid('deleteRow',index);
                }
                setTaxOutAmount();
            }
        });
    }
    //选择核销明细
    function selectAuditDetail(title, url, id, width, height, params) {
        title = "核销明细";
        url="/page/ttApiAuditController/goAuditDetailSelectMain";
        height="550";
        width="1100";
        var _char ="&";
        if (url.indexOf("?")==-1) {
            _char = "?";
        }

        url += _char;
        createwindowSmallOver(title, url, width, height);
    }

    function getrowsDetailDatas() {
        var data = new Object();
        var rowsDetailDatas = $('#accountAddList').datagrid('getSelections');
        var budgetSubjectsCode = "";
        var budgetSubjectsName ="";
        var custCode = "";
        var custName = "";
        if(rowsDetailDatas.length>=1){
            budgetSubjectsCode = getSubErpCode(rowsDetailDatas[0].budgetSubjectsCode);
            budgetSubjectsName = rowsDetailDatas[0].budgetSubjectsName;
            custCode =rowsDetailDatas[0].custCode;
            custName =rowsDetailDatas[0].custName;
        }
        data.budgetSubjectsCode = budgetSubjectsCode;
        data.budgetSubjectsName = budgetSubjectsName;
        data.custCode = custCode;
        data.custName = custName;
        return data;
    }


    function getSelectData() {
        var rowsDetailDatas = $('#accountAddList').datagrid('getSelections');
        return rowsDetailDatas;
    }
    function valiMultiBill(rowsDetailDatas) {
        if(!rowsDetailDatas || rowsDetailDatas.length == 0 ){
            tip("请选择一条上账明细");
            return false;
        }
        if(rowsDetailDatas.length == 1){
            return true;
        }
        var custCode = rowsDetailDatas[0].custCode;
        var usebill = false;
        for(var i = 0; i < rowsDetailDatas.length; i++){
            var item = rowsDetailDatas[i];
            if("BILL" == item.payTypeCode && custCode == item.custCode){
                usebill = true;
            }else{
                usebill = false;
                tip("现金，同一客户才可多条合并上账");
                break;
            }
        }
        return usebill;
    }
    /* 新增发票 */
    function addDetail() {
        //判断是否选中一条上账明细
        var rowsDetailDatas = $('#accountAddList').datagrid('getSelections');
        if(!valiMultiBill(rowsDetailDatas)){
            return;
        }
        var accountCode = rowsDetailDatas[0].accountCode;
        var budgetSubjectsCode = rowsDetailDatas[0].budgetSubjectsCode;
        var title = "新增";
        var url="/page/ttAccountInvoiceController/goSaveOrUpdate?accountCode="+accountCode+"&budgetSubjectsCode="+budgetSubjectsCode;
        var height="300";
        var width="400";
        var _char ="&";
        if (url.indexOf("?")==-1) {
            _char = "?";
        }
        url += _char;
        createwindowSmallOverAddBill(title, url, width, height);
    }
    /* 编辑发票 */
    function editDetail() {
        //判断是否选中一条上账明细
        var billAddList = $('#billAddList').datagrid('getSelections');
        if(billAddList.length!=1){
            tip("请选择一条数据");
            return;
        }
        var budgetSubjectsCode = billAddList[0].budgetSubjectsCode;
        var title = "编辑";
        var url="/page/ttAccountInvoiceController/goUpdate?budgetSubjectsCode="+budgetSubjectsCode;
        var height="300";
        var width="400";
        var _char ="&";
        if (url.indexOf("?")==-1) {
            _char = "?";
        }
        url += _char;
        createwindowSmallOverUpdateBill(title, url, width, height);
    }
    /* 编辑发票时获取数据 */
    function getDataEditDetail() {
        var billAddList = $('#billAddList').datagrid('getSelections');
        return billAddList;
    }
    /* 检查费用类型 */
    function checkPayType(rowsDatas,iframe) {
        var payTypeCodeNew = "";
        for(var i=0;i<rowsDatas.length;i++){
           if(rowsDatas[i].payTypeCode==""){
               iframe.tip("核销明细编号"+rowsDatas[i].auditDetailCode+"支付方式类型配置不对");
               return false;
           }
           if(i==0){
               payTypeCodeNew = rowsDatas[i].payTypeCode;
           }else {
               if(payTypeCodeNew!=rowsDatas[i].payTypeCode){
                   iframe.tip("现金或者账扣类型不能同时与非现金类一起操作");
                   return false;
               }
           }
        }
        var payTypeCode =  getPayType();
        if(payTypeCode!=""&&payTypeCode!=payTypeCodeNew){
            iframe.tip("现金或者账扣类型不能同时与非现金类一起操作");
            return false;
        }
        return true;
    }
    /* 得到当前支付方式类型 */
    function getPayType() {
        var rowsDetailDatas = $('#accountAddList').datagrid('getRows');
        var payTypeCode = "";
        if(rowsDetailDatas.length>0){
            payTypeCode = rowsDetailDatas[0].payTypeCode;
        }
        return payTypeCode;
    }

    
    //处理核销明细数据写入
    function createwindowSmallOver(title, addurl, width, height, options) {
        var offsetW = window.top.document.body.offsetWidth;
        var offsetH = window.top.document.body.offsetHeight;
        var id="auditDetaillist";
        width = (width && width != 'null') ? width : 700;
        height = (height && height != 'null') ? height : 400;
        if (width == "100%" || width > offsetW) {
            width = offsetW;
        }
        if (height == "100%" || height > (offsetH - 100)) {
            height = offsetH - 100;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: parseInt(width),
            height: parseInt(height),
            title: title,
            opacity: 0.3,
            parent:'auditDetailDialog',
            cache: false,
            /* 为true等价于function(){} */
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsDatas = iframe.$('#' + id).datagrid('getSelections');
                    if(rowsDatas.length==0){
                        iframe.tip("请选择数据");
                        return false;
                    }else{
                        if(!checkPayType(rowsDatas,iframe)){
                            return false;
                        }
                        //得到可以保存收数据
                        var insertDatas = [];
                        for(var i=0;i<rowsDatas.length;i++){
                            var flagTemp = getInsertDetail(rowsDatas[i]);
                            if(flagTemp!=null){
                                insertDatas.push(flagTemp);
                            }
                        }
                        if(insertDatas.length>0){
                            //获取上账编码
                            var codes = getCodes(insertDatas.length);
                            if(codes.length==0){
                                iframe.tip("系统出了点问题，请稍后再试");
                                return false;
                            }
                            for(var i=0;i<insertDatas.length;i++){
                                insertDetail(insertDatas[i],codes[i]);
                            }
                        }
                        autoBill();
                        setTaxOutAmount();
                    }
                    return true;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.extend(myOptions, options);
        safeShowDialog(myOptions);
    }

    function autoBill() {
        var rowsDetailDatas = $('#accountAddList').datagrid('getRows');
        if(rowsDetailDatas.length==0){
            billFlag = false;
            $('#region').layout('remove', 'north');
            $('#region').layout('remove', 'south');
        }else {
            if(!billFlag){
                if("BILL"==rowsDetailDatas[0].payTypeCode){
                    addPanel("north");
                    if(fromTableHtml==""){
                        fromTableHtml = $("#fromTable").html();
                        $("#fromTable").remove();
                    }
                    $('#region').layout('panel','north').append(fromTableHtml);
                    addPanel("south");
                    $('#region').layout('panel','south').append('<table id="billAddList"></table>');
                    loadbillAddList()
                    billFlag = true;
                }
            }
        }
    }

    function loadbillAddList() {
        var toolbar = null;
        var load = '${load}';
        if(!isEmpty(load)&&load=='detail'){
            toolbar = [{  text: '导出上账明细',
                iconCls: 'icon-dataOut',
                handler: function(){alert('暂未实现')}
            }
            ];
        }else{
            toolbar = [{
                text: '新增',
                iconCls: 'icon-add',
                handler: function(){addDetail()}
            },{ text: '编辑',
                iconCls: 'icon-edit',
                handler: function(){editDetail()}
            }, {  text: '删除',
                iconCls: 'icon-remove',
                handler: function(){deleteInSelect()}
            },
                {  text: '导出上账明细',
                    iconCls: 'icon-dataOut',
                    handler: function(){alert('暂未实现')}
                },
                {  text: '导入发票',
                    iconCls: 'icon-dataIn',
                    handler: function(){alert('暂未实现')}
                },
                {  text: '上传',
                    iconCls: 'icon-upload',
                    handler: function(){upload();}
                }
            ];
        }
        $('#billAddList').datagrid({
            url:'/fee/ttAccountController/getInvoiceMaiListPage?groupId='+groupId,
            columns:[[
                {field:'id',title:'id',width:100,hidden:true},
                {field:'custCode',title:'客户编码',width:100,hidden:true},
                {field:'custName',title:'客户名称',width:100,hidden:true},
                {field:'accountCode',title:'上账编号',width:100},
                {field:'invoiceCode',title:'发票编号',width:100},
                {field:'budgetSubjectsCode',title:'申请科目编号',width:100},
                {field:'budgetSubjectsName',title:'申请科目',width:100},
                {field:'accountBudgetSubjectsCode',title:'上账科目编号',width:100},
                {field:'accountBudgetSubjectsName',title:'上账科目',width:100},
                {field:'taxCode',title:'税码',width:100,hidden:true},
                {field:'taxAmount',title:'税金',width:100},
                {field:'invoiceAmount',title:'发票金额（未税）',width:100},
                {field:'taxOutAmount',title:'进项税转出金额',width:100},
                {field:'costCenters',title:'ERP成本中心',width:100},
                {field:'notes',title:'摘要',width:100},
                {field:'invoiceCount',title:'张数',width:100}
            ]],
            toolbar:toolbar,
            height:220
        });
    }
    
    
    /* 发票明细新增 */
    function createwindowSmallOverAddBill(title, addurl, width, height, options) {
        var offsetW = window.top.document.body.offsetWidth;
        var offsetH = window.top.document.body.offsetHeight;
        width = (width && width != 'null') ? width : 700;
        height = (height && height != 'null') ? height : 400;
        if (width == "100%" || width > offsetW) {
            width = offsetW;
        }
        if (height == "100%" || height > (offsetH - 100)) {
            height = offsetH - 100;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: parseInt(width),
            height: parseInt(height),
            title: title,
            opacity: 0.3,
            parent:'auditBillDialog',
            cache: false,
            /* 为true等价于function(){} */
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.getData();
                    var rowsDetailDatas = $('#accountAddList').datagrid('getSelections');
                    var taxOutAmount = taxOutAmount;
                    var reg =/^(-?\d+)(\.\d+)?$/;
                    if(!reg.test(taxOutAmount)){
                        taxOutAmount = 0;
                    }
                    var invoiceAmount = rowsData.invoiceAmount ;
                    if(!reg.test(invoiceAmount)){
                        invoiceAmount = 0;
                    }
                    var accountAmount = rowsDetailDatas[0].accountAmount;
                    if(!reg.test(accountAmount)){
                        accountAmount = 0;
                    }
                    taxOutAmount = Number(invoiceAmount)-Number(accountAmount);
                    //数据插入到发票列表
                    $('#billAddList').datagrid('insertRow',{
                        index: 0,
                        row: {
                            id: generateUUID(),
                            accountCode: rowsData.accountCode,
                            invoiceCode:rowsData.invoiceCode,
                            taxCode:rowsData.taxCode,
                            taxAmount:rowsData.taxAmount,
                            invoiceAmount:rowsData.invoiceAmount,
                            notes:rowsData.notes,
                            budgetSubjectsCode:rowsData.budgetSubjectsCode,
                            budgetSubjectsName:rowsData.budgetSubjectsName,
                            accountBudgetSubjectsCode:rowsData.accountBudgetSubjectsCode,
                            accountBudgetSubjectsName:rowsData.accountBudgetSubjectsName,
                            taxOutAmount:taxOutAmount,
                            custCode:rowsData.custCode,
                            custName:rowsData.custName
                        }
                    });
                    setTaxOutAmount();
                    return true;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions)
    }

    function getSubErpCode(budgetSubjectsCode) {
        var erpCode = "";
        $.ajax({
            type: "GET",
            async:false,
            url: "/budget/ttBudgetSubjectsController/getEntityByIdOrCode",
            data: "budgetSubjectsCode="+budgetSubjectsCode,
            success: function(data){
                if(data.obj){
                    erpCode = data.obj.budgetSubjectsErpCode;
                }
            }
        });
        return erpCode;
    }

    /** 编辑发票弹窗 */
    function createwindowSmallOverUpdateBill(title, addurl, width, height, options) {
        var offsetW = window.top.document.body.offsetWidth;
        var offsetH = window.top.document.body.offsetHeight;
        width = (width && width != 'null') ? width : 700;
        height = (height && height != 'null') ? height : 400;
        if (width == "100%" || width > offsetW) {
            width = offsetW;
        }
        if (height == "100%" || height > (offsetH - 100)) {
            height = offsetH - 100;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: parseInt(width),
            height: parseInt(height),
            title: title,
            opacity: 0.3,
            parent:'updateBillDialog',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    var rowsData = iframe.getData();
                    var billAddList = $('#billAddList').datagrid('getSelections');
                    var n_index = $('#billAddList').datagrid('getRowIndex',billAddList[0]);
                    //数据插入到发票列表
                    $('#billAddList').datagrid('updateRow',{
                        index: n_index,
                        row: {
                            accountCode: rowsData.accountCode,
                            invoiceCode:rowsData.invoiceCode,
                            taxCode:rowsData.taxCode,
                            taxAmount:rowsData.taxAmount,
                            invoiceAmount:rowsData.invoiceAmount,
                            accountBudgetSubjectsCode:rowsData.accountBudgetSubjectsCode,
                            accountBudgetSubjectsName:rowsData.accountBudgetSubjectsName,
                            notes:rowsData.notes
                        }
                    });
                    setTaxOutAmount();
                    return true;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    /*获取上账编号*/
    function getCodes(count) {
        var codes ;
        $.ajax({
            type: "POST",
            url: "/fee/ttAccountController/getCodes",
            data: {'count':count},
            dataType:"json",
            async:false,
            success: function(data){
                if(data.success){
                    codes =  data.objList;
                }else{
                    codes = [];
                }

            }
        });
        return codes;
    }

    /**将选择的细类插入列表*/
    function getInsertDetail(rowsData) {
        var rowsDetailDatas = $('#accountAddList').datagrid('getRows');
        for(var i=0;i<rowsDetailDatas.length;i++){
           var id = rowsDetailDatas[i].id;
           if(id==rowsData.id){
               return null;
           }
        }
        return rowsData;
    }
    /** 插入数据 */
    function insertDetail(rowsData,code) {
        var text_ = "";
        if('30'==rowsData.payType){
            text_ = "请选择"
        }
        $('#accountAddList').datagrid('insertRow',{
            index: 0,
            row: {
                id: rowsData.id,
                auditDetailCode: rowsData.auditDetailCode,
                accountProductName:text_,
                productLevelName:text_,
                auditAmount:rowsData.feeUseable,
                actDetailCode:rowsData.actDetailCode,
                custName:rowsData.customerName,
                custCode:rowsData.customerCode,
                terminalName:rowsData.terminalName,
                terminalCode:rowsData.terminalCode,
                fineName:rowsData.actSubclassName,
                fineCode:rowsData.actSubclassCode,
                paymentCode:rowsData.payType,
                departCode:rowsData.orgCode,
                accountCode:code,
                actName:rowsData.actName,
                actCode:rowsData.actCode,
                auditCode:rowsData.auditCode,
                budgetSubjectsCode:rowsData.budgetSubjectsCode,
                budgetSubjectsName:rowsData.budgetSubjectsName,
                accountBudgetSubjectsCode:rowsData.accountBudgetSubjectsCode,
                accountBudgetSubjectsName:rowsData.accountBudgetSubjectsName,
                beginDate:rowsData.beginDate,
                endDate:rowsData.endDate,
                departName:rowsData.orgName,
                payTypeCode:rowsData.payTypeCode,
                actType:rowsData.actType,
                categoriesCode:rowsData.categoriesCode,
                categoriesName:rowsData.categoriesName
            }
        });
        editorALl();
    }

    /*上账明细打开编辑*/
    function editorALl() {
        var load = '${load}';
        if(!isEmpty(load)&&load=='detail'){
          return;
        }
        var rowsDetailDatas = $('#accountAddList').datagrid('getRows');
        for(var i=0;i<rowsDetailDatas.length;i++){
            var index = $('#accountAddList').datagrid('getRowIndex',rowsDetailDatas[i]);
            $('#accountAddList').datagrid('beginEdit' ,index);
            var accountAmountEd = $('#accountAddList').datagrid('getEditor', {index:index,field:'accountAmount'});
            accountAmountEd.target.numberbox({
                onChange:function(newValue,oldValue){
                    setTaxOutAmount(newValue);
                }
            });
        }
    }
    /*上账明细结束编辑*/
    function endEditorALl() {
        var rowsDetailDatas = $('#accountAddList').datagrid('getRows');
        for(var i=0;i<rowsDetailDatas.length;i++){
            var index = $('#accountAddList').datagrid('getRowIndex',rowsDetailDatas[i]);
            $('#accountAddList').datagrid('endEdit' ,index);
        }
    }
    
    function setTaxOutAmount() {
        if(!billFlag){
            return;
        }
        endEditorALl();
        editorALl();
        var accountAmount = 0;
        var accountrows = $('#accountAddList').datagrid('getRows');
        for(var i=0;i<accountrows.length;i++){
            var row = accountrows[i];
            var amount = row.accountAmount;
            accountAmount = parseFloat(accountAmount)+parseFloat(amount);
        }
        var billrows = $('#billAddList').datagrid('getRows');
        for(var i=0;i<billrows.length;i++){
            var row = billrows[i];
            var index = $('#billAddList').datagrid('getRowIndex',row);
            var invoiceAmount = row.invoiceAmount;
            if(parseFloat(invoiceAmount)>parseFloat(accountAmount)){
                invoiceAmount = parseFloat(invoiceAmount) - parseFloat(accountAmount);
                accountAmount = 0;
            }else{
                accountAmount = parseFloat(accountAmount) - parseFloat(invoiceAmount);
                invoiceAmount = 0
            }
            $('#billAddList').datagrid('updateRow',{
                index: index,
                row: {
                    taxOutAmount:invoiceAmount
                }
            });
        }
    }
    
     /* 保存组装数据*/
    function saveData(status) {
        var payTypeCode =  getPayType();
        if(payTypeCode == 'BILL' && $('#billAddList').datagrid('getRows').length == 0){
            tip("请填写上账明细!");
            return false;
        }
        var data={};
        setTaxOutAmount();
        endEditorALl();
        var rowsDetailDatas = $('#accountAddList').datagrid('getRows');
        for(var i=0;i<rowsDetailDatas.length;i++){
           var accountAmount = rowsDetailDatas[i].accountAmount;
            var accountCode = rowsDetailDatas[i].accountCode;
           if(isEmpty(accountAmount)||Number(accountAmount) == 0){
               tip("上账编号:"+accountCode+"本次上账金额必须大于0");
               editorALl();
               return;
           }
           var auditAmount = rowsDetailDatas[i].auditAmount;

           if(Number(accountAmount)>Number(auditAmount)){
               tip("上账编号:"+accountCode+"超过可上账金额"+auditAmount);
               editorALl();
               return;
           }
        }
        if(billFlag){
            var billAddListDatas = $('#billAddList').datagrid('getRows');
            data.invoiceList =billAddListDatas;
            //构建发票抬头
            var feeBillHead = new Object();
            feeBillHead.name = $("#name").val();
            feeBillHead.billNum = $("#billNum").val();
            feeBillHead.remarks = $("#remarks").val();
            data.feeBillHead =feeBillHead;
        }
        if(!checkDateBillAmount(status)){
            return ;
        }
        data.detailList = rowsDetailDatas;
        data.status= status;
        openProgressTop();
        $.ajax({
            type: "POST",
            url: "/fee/ttAccountController/saveOrUpdateData",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(data),
            complete:function(){
                closeProgressTop();
            },
            success: function(data){
                closeProgressTop();
                var api = frameElement.api, W = api.opener;
                if (data.success) {
                    W.tip(data.msg);
                    W.feeListsearch();
                    api.close();
                }else{
                    tip(data.msg);
                    editorALl();
                }
            }
        });
    }

    //验证发票金额  校验逻辑：同一个客户的上账费用金额之和与发票金额之和必须相等
    function checkDateBillAmount(status) {
       if(!billFlag||status=='004'){
           return true;
       }
       //上账金额列表
       var rowsDetailDatas = $('#accountAddList').datagrid('getRows');
       //发票列表
        var billAddListDatas = $('#billAddList').datagrid('getRows');
        var custMap = new Map();
        var custNameMap = new Map();
        for(var i=0;i<rowsDetailDatas.length;i++){
            var custCode = rowsDetailDatas[i].custCode;
            var accountAmount = rowsDetailDatas[i].accountAmount;
            var custName = rowsDetailDatas[i].custName;
            custNameMap.set(custCode,custName);
            if(isEmpty(accountAmount)){
                tip("请输入上账金额");
                return false;
            }

            if(custMap.has(custCode)){
                var tempAmount = Number(custMap.get(custCode))+Number(accountAmount);
                custMap.set(custCode,tempAmount);
            }else{
                custMap.set(custCode,Number(accountAmount));
            }
        }

        var billMap = new Map();
        for(var i=0;i<billAddListDatas.length;i++){
            var custCode = billAddListDatas[i].custCode;
            var invoiceAmount = billAddListDatas[i].invoiceAmount;
            var taxAmount = billAddListDatas[i].taxAmount;
            if(isEmpty(invoiceAmount)){
                tip("请输入发票金额");
                return false;
            }
            if(isEmpty(taxAmount)){
                tip("税金不能为空");
                return false;
            }
            if(billMap.has(custCode)){
                var tempAmount = Number(billMap.get(custCode))+Number(invoiceAmount);
                billMap.set(custCode,tempAmount);
            }else{
                billMap.set(custCode,Number(invoiceAmount));
            }
        }
        return true;
        //后面暂时取消验证 交给后台
        var returnFlag = true;
        custMap.forEach(function(value, key) {
            if(!billMap.has(key)||billMap.get(key)!=value){
                tip(custNameMap.get(key)+":上账金额与发票金额不相等");
                returnFlag =  false;
            }
        });
        return returnFlag;




    }


    /* 上次图片ai识别 */
    function upload() {
        //判断是否选中一条上账明细
        var rowsDetailDatas = $('#accountAddList').datagrid('getSelections');
        if(rowsDetailDatas.length!=1){
            tip("请选择一条上账明细");
            return;
        }
        var accountCode = rowsDetailDatas[0].accountCode;
        var url="/upload/uploadController/uploadFileold?1=1";
        importAttach({uploadUrl:url,muilt:true},function (res) {
            console.log($.dialog({id: "uploadDialog"}));
            $.dialog({id: "uploadDialog"}).close();
            var arr = [];
            var obj = "";
            $.each(res,function(index,value){
                obj = value.obj[0].urlPath;
                arr.push(obj);
            });
            var rowsDetailDatas = $('#accountAddList').datagrid('getSelections');
            openProgressTop("上传成功，正在识别发票……");
            $.ajax({
                type: "POST",
                url: "/fee/ttAccountInvoiceController/getInvoice",
                contentType: "application/json; charset=utf-8",
                data:JSON.stringify(arr),
                success: function(data){
                    if(data.success){
                        $.each(data.objList,function(index,value){
                            var taxOutAmount = taxOutAmount;
                            var accountAmount = rowsDetailDatas[0].accountAmount;
                            var invoiceAmount = data.objList[0].invoiceAmount ;
                            var reg =/^(-?\d+)(\.\d+)?$/;
                            if(!reg.test(accountAmount)){
                                accountAmount = 0;
                            }
                            if(!reg.test(invoiceAmount)){
                                invoiceAmount = 0;
                            }

                            taxOutAmount = Number(invoiceAmount)-Number(accountAmount);
                            if(Number(taxOutAmount)<0){
                                taxOutAmount = 0;
                            }
                            //数据插入到发票列表
                            $('#billAddList').datagrid('insertRow',{
                                index: 0,
                                row: {
                                    id: generateUUID(),
                                    accountCode: accountCode,
                                    invoiceCode:data.objList[0].invoiceCode,
                                    taxCode:data.objList[0].taxCode,
                                    taxAmount:data.objList[0].taxAmount,
                                    invoiceAmount:data.objList[0].invoiceAmount,
                                    budgetSubjectsCode:rowsDetailDatas[0].budgetSubjectsCode,
                                    budgetSubjectsName:rowsDetailDatas[0].budgetSubjectsName,
                                    taxOutAmount:taxOutAmount,
                                    notes:data.objList[0].notes
                                }
                            });
                        });
                    }else{
                        tip(data.msg);
                    }
                    closeProgressTop();
                }
            });
        });
    }


    function addPanel(region){
        var options = {
            region: region
        };
        if (region=='north'){
            options.height = 100;
        } else if(region=='south'){
            options.height = 220;
        } else {
            options.width = 100;
            options.split = true;
            options.title = $('#region option:selected').text();
        }
        $('#region').layout('add', options);
    }

</script>
</html>