<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker" extendUrlKey="payPolicyCalculationResult"></t:base>
<div class="easyui-layout" fit="true">
    <div region="center" style="padding:1px;">
        <t:datagrid name="payPolicyCalculationResultList" checkbox="true" singleSelect="false"  fitColumns="true" title=""
                    actionUrl="/rebate/payPolicyCalculationController/findPayPolicyCalculationResultList" idField="id" fit="true" queryMode="group" tagConf="${clickFunctionId}">
            <t:dgCol title="id" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="活动编码" field="actCode" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="活动名称" field="actName" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="政策名称" field="policyProductName" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="客户名称" field="customerName" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="所属组织" field="orgName" sortable="false" query="true"></t:dgCol>
            <t:dgCol title="返利金额(元)" field="resultValue" sortable="false"></t:dgCol>
            <t:dgCol title="返利调整(元)" field="adjustValue" sortable="false"></t:dgCol>
            <t:dgCol title="实际返利金额(元)" field="finalValue" sortable="false"></t:dgCol>
            <t:dgCol title="结案周期" field="policyCycle" sortable="false" query="true" dictionary="product_policy_cycle"></t:dgCol>
            <t:dgCol title="开始时间" field="startDate" sortable="false"></t:dgCol>
            <t:dgCol title="结束时间" field="endDate" sortable="false"></t:dgCol>
            <t:dgCol title="返利计算年月" field="policyCalculationYearMonth" sortable="false"></t:dgCol>
            <t:dgCol title="返利时间" field="createDate" sortable="false" formatter="yyyy-MM-dd HH:mm:ss"></t:dgCol>
            <t:dgCol title="最近更新人" field="updateName" sortable="false" hidden="true"></t:dgCol>
            <t:dgCol title="最近更新时间" field="updateDate" sortable="false" formatter="yyyy-MM-dd HH:mm:ss" hidden="true"></t:dgCol>

            <t:dgToolBar title="返利调整" operationCode="adjust" icon="icon-edit" url="" funname="adjustPolicy" height="350" width="400"></t:dgToolBar>
            <t:dgToolBar title="确认" operationCode="confirm" icon="icon-ok" url="" funname="confirmPolicy"></t:dgToolBar>
            <t:dgToolBar title="关闭" operationCode="close" icon="icon-remove" url="" funname="closePolicy"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="/page/knlLogController/goShowLog" height="450" width="1200" funname="detail"></t:dgToolBar>
            <t:dgToolBar title="返利计算" operationCode="add" icon="icon-add" url=""  funname="calculationPolicy"></t:dgToolBar>
            <t:dgToolBar title="返利计算日志" operationCode="calclog" icon="icon-log" url="/page/payPolicyController/goPayPolicyCalculationProcessMain"  funname="detailLog" width="1200" height="600"></t:dgToolBar>
        </t:datagrid>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function(){
        //日期格式查询条件 开始日期
        //$("input[name='startDate']").attr("class","Wdate").click(function(){ WdatePicker({dateFmt:'yyyy-MM-dd'}); });
        //日期格式查询条件 结束日期
        //$("input[name='endDate']").attr("class","Wdate").click(function(){ WdatePicker({dateFmt:'yyyy-MM-dd'}); });
    });

    //确认
    function confirmPolicy(title,url,girdname,width,height,option){
        if(isExitsFunction('confirmPolicyExtend')){
            confirmPolicyExtend(title,url,girdname,width,height,option);
        }else{
            tip('项目二开......');
        }
    }

    //调整
    function adjustPolicy(title,url,girdname,width,height,option){
        if(isExitsFunction('adjustPolicyExtend')){
            adjustPolicyExtend(title,url,girdname,width,height,option);
        }else{
            tip('项目二开......');
        }
    }

    //关闭
    function closePolicy(title,url,girdname,width,height,option) {
        if(isExitsFunction('closePolicyExtend')){
            closePolicyExtend(title,url,girdname,width,height,option);
        }else{
            tip('项目二开......');
        }
    }

    //返利计算
    function calculationPolicy(title,url,girdname,width,height,option) {
        if(isExitsFunction('calculationPolicyExtend')){
            calculationPolicyExtend(title,url,girdname,width,height,option);
        }else{
            tip('项目二开......');
        }
    }

    function detailLog(title,url,girdname,width,height,options) {
        var rowsData = $('#' + girdname).datagrid('getSelections');

        if (null != rowsData && rowsData.length > 0) {
            url = url + "&reusltId="+rowsData[0].id;
        }

        var offsetW = window.top.document.body.offsetWidth;
        var offsetH = window.top.document.body.offsetHeight;
        width = (width && width != 'null') ? width : 700;
        height = (height && height != 'null') ? height : 400;
        if (width == "100%" || width > offsetW) {
            width = offsetW;
        }
        if (height == "100%" || height > (offsetH - 100)) {
            height = offsetH - 100;
        }
        var myOptions = {
            content: 'url:' + url,
            lock: true,
            width: parseInt(width),
            height: parseInt(height),
            title: title,
            opacity: 0.3,
            cache: false,
            /* 为true等价于function(){} */
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: false,
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.extend(myOptions, options);
        safeShowDialog(myOptions);
    }
</script>

