<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>年度销售数据分析</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <style>
        [v-cloak]{
            display: none;
        }
        .container {
            box-sizing: border-box;
            overflow-y: auto;
        }

        .chart-title {
            text-align: center;
        }

        .chart-left {
            height: 600px;
        }

        .chart-right {
            width: 40%;
            height: 600px;
        }

        .chart-table {
            height: 200px;
            overflow-y: auto;
        }

        .chart-table table {
            width: 100%;
            border-collapse: collapse;
        }

        .chart-table table td,
        .chart-table table th {
            height: 30px;
            border: 1px solid #eeeeee;
            box-sizing: border-box;
            position: relative;
            text-align: center;
        }

        .chart-table table th {
            background: #f6f6f6;
        }
    </style>
</head>

<body>
<div id="app" v-cloak>
    <div class="container p10">
        <h1 class="chart-title">年度销售数据分析</h1>
        <div class="flex flex-align-items-center">
            <div class="chart-left flex-auto flex flex-column mr20">
                <div class="chart-table flex-none mb20">
                    <table>
                        <thead>
                        <tr>
                            <th>年度</th>
                            <th>含税销售额</th>
                            <th>成本</th>
                            <th>毛利</th>
                            <th>费用</th>
                            <th>利润</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for="(item,index) in tableData" :key="index">
                            <td>{{item.year}}</td>
                            <td>{{item.sale}}</td>
                            <td>{{item.cost}}</td>
                            <td>{{item.gross}}</td>
                            <td>{{item.fee}}</td>
                            <td>{{item.profit}}%</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <div ref="chartClassify" class="flex-auto" style="width: 100%;height: 100%;"></div>
            </div>
            <div class="chart-right flex-none">
                <div ref="chartSale" style="width: 100%;height: 100%;"></div>
            </div>
        </div>

    </div>

</div>
<script src="/resources/sfa/js/vue.min.js"></script>
<script src="/resources/sfa/js/echarts.min.js"></script>
<script>
    let vm = new Vue({
        el: "#app",
        data: function () {
            return {
                tableData: [{
                    year: 2019,
                    sale: 19892632,
                    cost: 9946316,
                    gross: 5967789.6,
                    fee: 2983894.8,
                    profit: 1989263.2
                }, {
                    year: 2018,
                    sale: 11867632,
                    cost: 5933816,
                    gross: 3560289.6,
                    fee: 1780144.8,
                    profit: 1186763.2
                }, {
                    year: 2017,
                    sale: 16892234,
                    cost: 8446117,
                    gross: 5067670.2,
                    fee: 2533835.1,
                    profit: 1689223.4
                }, {
                    year: 2016,
                    sale: 9856432,
                    cost: 4928216,
                    gross: 2956929.6,
                    fee: 1478464.8,
                    profit: 985643.2
                }, {
                    year: 2015,
                    sale: 8867841,
                    cost: 4433920.5,
                    gross: 2660352.3,
                    fee: 1330176.15,
                    profit: 886784.1
                }, {
                    year: 2014,
                    sale: 8696723,
                    cost: 4348361.5,
                    gross: 2609016.9,
                    fee: 1304508.45,
                    profit: 869672.3
                }, {
                    year: 2013,
                    sale: 7812937,
                    cost: 4108361.5,
                    gross: 2409726.9,
                    fee: 1171940.55,
                    profit: 781293.7
                }],
                chartSale: null,
                chartClassify: null
            }
        },
        mounted: function () {
            this.initChartSale();
            this.initChartClassify();
        },
        methods: {
            initChartSale: function () {
                this.chartSale = echarts.init(this.$refs.chartSale);
                let option = {
                    title: {
                        text: '年度销售分析数据'
                    },
                    color: ['#3BA2DA', '#67E0E3', '#FDDA5C'],
                    tooltip: {
                        trigger: 'axis',
                        axisPointer: {
                            type: 'shadow'
                        }
                    },
                    legend: {
                        data: ['销售额', '成本', '费用']
                    },
                    grid: {
                        left: 100
                    },
                    xAxis: {
                        type: 'value',
                        name: '元',
                        axisLabel: {
                            formatter: '{value}'
                        }
                    },
                    yAxis: {
                        type: 'category',
                        inverse: true,
                        data: ['2019', '2018', '2017', '2016', '2015', '2014', '2013']
                    },
                    series: [{
                        name: '销售额',
                        type: 'bar',
                        data: [19892632,
                            11867632,
                            16892234,
                            9856432,
                            8867841,
                            8696723,
                            7812937
                        ],
                        label: {
                            normal: {
                                show: true,
                                textBorderColor: '#333',
                                textBorderWidth: 2
                            }
                        }
                    },
                        {
                            name: '成本',
                            type: 'bar',
                            label: {
                                normal: {
                                    show: true,
                                    textBorderColor: '#333',
                                    textBorderWidth: 2
                                }
                            },
                            data: [9946316,
                                5933816,
                                8446117,
                                4928216,
                                4433920.5,
                                4348361.5,
                                4108361.5
                            ]
                        },
                        {
                            name: '费用',
                            type: 'bar',
                            label: {
                                normal: {
                                    show: true,
                                    textBorderColor: '#333',
                                    textBorderWidth: 2
                                }
                            },
                            data: [2983894.8,
                                1780144.8,
                                2533835.1,
                                1478464.8,
                                1330176.15,
                                1304508.45,
                                1171940.55
                            ]
                        }
                    ]
                };
                this.chartSale.setOption(option);
            },
            initChartClassify: function () {
                this.chartClassify = echarts.init(this.$refs.chartClassify);
                let option = {
                    title: {
                        text: "年度品类销售数据"
                    },
                    color: ['#3BA2DA', '#67E0E3', '#FDDA5C', '#F39E7E', '#E062AE'],
                    tooltip: {
                        trigger: 'axis',
                        axisPointer: {
                            type: 'shadow'
                        }
                    },
                    legend: {
                        data: ['鲜奶', '常温奶', '酸奶', '酸酸乳']
                    },
                    grid: {
                        left: '3%',
                        right: '4%',
                        bottom: '3%',
                        containLabel: true
                    },
                    xAxis: {
                        type: 'value'
                    },
                    yAxis: {
                        type: 'category',
                        data: ['2013', '2014', '2015', '2016', '2017', '2018', '2019']
                    },
                    series: [{
                        name: '鲜奶',
                        type: 'bar',
                        stack: '总量',
                        label: {
                            normal: {
                                show: true,
                                position: 'insideRight'
                            }
                        },
                        data: [320, 302, 301, 334, 390, 330, 320]
                    },
                        {
                            name: '常温奶',
                            type: 'bar',
                            stack: '总量',
                            label: {
                                normal: {
                                    show: true,
                                    position: 'insideRight'
                                }
                            },
                            data: [120, 132, 101, 134, 90, 230, 210]
                        },
                        {
                            name: '酸奶',
                            type: 'bar',
                            stack: '总量',
                            label: {
                                normal: {
                                    show: true,
                                    position: 'insideRight'
                                }
                            },
                            data: [220, 182, 191, 234, 290, 330, 310]
                        },
                        {
                            name: '酸酸乳',
                            type: 'bar',
                            stack: '总量',
                            label: {
                                normal: {
                                    show: true,
                                    position: 'insideRight'
                                }
                            },
                            data: [150, 212, 201, 154, 190, 330, 410]
                        }
                    ]
                }
                this.chartClassify.setOption(option);
            }
        },
    })
</script>
</body>

</html>