<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>费用预算新增</title>
    <t:base type="jquery,easyui,tools" extendUrlKey="feeBudgetForm"></t:base>
</head>
<body style="overflow-y: hidden" scroll="no">
<t:formvalid action="/budget/ttFeeBudgetController/saveOrUpdate" layout="div" dialog="true" formid="fiscalForm">
    <t:dgFormList expandParam="${clickFunctionId}" tagConf="${clickFunctionId}">
        <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                        defaultVal="${vo.id }"/>
        <t:dgFormColumn field="extChar1" hidden="false" formClass="form" labelName="extChar1" optionType="optionType"
                        required="false"
                        defaultVal="${vo.extChar1 }"/>
        <t:dgFormColumn field="extChar2" hidden="false" formClass="form" labelName="extChar2" optionType="optionType"
                        required="false"
                        defaultVal="${vo.extChar2 }"/>
        <t:dgFormColumn field="extChar3" hidden="false" formClass="form" labelName="extChar3" optionType="optionType"
                        required="false"
                        defaultVal="${vo.extChar3 }"/>
        <t:dgFormColumn field="extChar4" hidden="false" formClass="form" labelName="extChar4" optionType="optionType"
                        required="false"
                        defaultVal="${vo.extChar4 }"/>
        <t:dgFormColumn field="extChar5" hidden="false" formClass="form" labelName="extChar5" optionType="optionType"
                        required="false"
                        defaultVal="${vo.extChar5 }"/>
        <t:dgFormColumn field="budgetCode" hidden="false" formClass="form"
                        defaultVal="${vo.budgetCode}"
                        labelName="预算编码" optionType="input" required="false"/>
        <t:dgFormColumn field="subjectsGroupName" hidden="true" formClass="form" labelName="id" optionType="input"
                        required="false"
                        defaultVal="${vo.subjectsGroupName }"/>
        <t:dgFormColumn field="enableStatus" hidden="false" typeGroupCode="enable_status" formClass="form"
                        defaultVal="${vo.enableStatus}"
                        labelName="状态" optionType="select" required="false"/>
        <t:dgFormColumn field="subjectsGroupCode" hidden="false" typeGroupCode="budget_group" formClass="form"
                        defaultVal="${vo.subjectsGroupCode}"
                        labelName="分组" optionType="select" required="false"/>
        <t:dgFormColumn field="budgetYear" hidden="false" formClass="form" labelName="年份" optionType="select"
                        required="false"
                        defaultVal="${vo.budgetYear}" typeGroupCode="financial_year"/>
        <t:dgFormColumn field="budgetMonth" hidden="false" typeGroupCode="month" formClass="form"
                        defaultVal="${vo.budgetMonth}"
                        labelName="月份" optionType="select" required="false"/>
        <t:dgFormColumn field="budgetDepartCode" hidden="true" formClass="form"
                        defaultVal="${vo.budgetDepartCode}"
                        labelName="组织编码" optionType="input" required="false"/>
        <t:dgFormColumn field="budgetDepartName" hidden="false" formClass="form"
                        defaultVal="${vo.budgetDepartName}"
                        labelName="组织" optionType="choseDialog" required="false" onclick="goOrg();"
                        onClean="cleanOrg();"/>
        <t:dgFormColumn field="budgetSubjectsCode" hidden="true" formClass="form"
                        defaultVal="${vo.budgetSubjectsCode}"
                        labelName="科目编码" optionType="input" required="false"/>
        <t:dgFormColumn field="budgetSubjectsName" hidden="false" formClass="form" labelName="科目"
                        optionType="choseDialog" required="false"
                        defaultVal="${vo.budgetSubjectsName}" onclick="goSbudgetSubjects();"
                        onClean="cleanSbudgetSubjects();"/>
        <t:dgFormColumn field="vkorgName" hidden="true" formClass="form" defaultVal="${vo.vkorgName}"
                        labelName="渠道" optionType="input" required="false"/>
        <t:dgFormColumn field="vkorgCode" hidden="false" typeGroupCode="channel" formClass="form"
                        defaultVal="${vo.vkorgCode}"
                        labelName="渠道" optionType="select" required="false"/>
        <t:dgFormColumn field="productLevelCode" hidden="true" formClass="form" labelName="产品编码" optionType="input"
                        required="false" defaultVal="${vo.productLevelCode}"/>
        <t:dgFormColumn field="productLevelName" hidden="false" formClass="form" labelName="产品层级"
                        optionType="choseDialog" required="false"
                        defaultVal="${vo.productLevelName }" onclick="selectProductLevel();"
                        onClean="cleanProductLevel();"/>
        <t:dgFormColumn field="productCode" hidden="true" formClass="form" labelName="物料" optionType="input"
                        required="false"
                        defaultVal="${vo.productCode}"/>
        <t:dgFormColumn field="productName" hidden="false" formClass="form" labelName="物料" optionType="choseDialog"
                        required="false"
                        defaultVal="${vo.productName}" onclick="goSelectProduct();" onClean="cleanProduct();"/>
        <t:dgFormColumn field="custCode" hidden="true" formClass="form" labelName="客户编码" optionType="input"
                        required="false"
                        defaultVal="${vo.custCode}"/>
        <t:dgFormColumn field="custName" hidden="false" formClass="form" labelName="客户" optionType="choseDialog"
                        required="false"
                        defaultVal="${vo.custName}" onclick="goCustomer();" onClean="cleanCustomer();"/>
        <t:dgFormColumn field="custOrgCode" hidden="true" readOnly="true" formClass="form" labelName="客户组织编码"
                        optionType="input" required="false"
                        defaultVal="${vo.custOrgCode}"/>
        <t:dgFormColumn field="custOrgName" hidden="false" formClass="form" labelName="客户组织" optionType="choseDialog"
                        required="false"
                        defaultVal="${vo.custOrgName}" onclick="goCustomerOrg();" onClean="cleanCustomerOrg();"/>
        <t:dgFormColumn field="terminalCode" hidden="true" formClass="form" labelName="门店编码" optionType="input"
                        required="false"
                        defaultVal="${vo.terminalCode}"/>
        <t:dgFormColumn field="terminalName" hidden="false" formClass="form" labelName="门店" optionType="choseDialog"
                        required="false"
                        defaultVal="${vo.terminalName}" onclick="selectTerminal();" onClean="cleanTerminal();"/>
        <t:dgFormColumn field="initAmount" hidden="false" formClass="form"
                        defaultVal="${vo.initAmount}"
                        labelName="期初金额" optionType="input" required="false"/>

        <t:dgFormColumn field="specialAreaCode" hidden="true" formClass="form" labelName="特殊区域类型" optionType="input"
                        required="false"/>
        <t:dgFormColumn field="specialAreaName" hidden="true" formClass="form" labelName="特殊区域类型"
                        optionType="choseDialog"
                        required="false"
                        defaultVal="${vo.specialAreaName}" onclick="selectSpecialArea();"
                        onClean="cleanSpecialArea();"/>

        <t:dgFormColumn field="notes" hidden="false" formClass="form" labelName="备注" required="false"
                        defaultVal="${vo.notes}" optionType="textarea" rows="2" cols="50"/>
    </t:dgFormList>
</t:formvalid>
</body>
<script type="text/javascript">

    $(function () {
        /** 分组添加事件 */
        $("#subjectsGroupCode").change(function () {
            $("#subjectsGroupName").val($(this).children('option:selected').text());
            groupChange();
            firstGroup();
        });
        firstGroup();
    });

    /* 设置分组为第一个必须输入项目 */
    function firstGroup() {

        var load = '${load}';
        if (load != 'detail') {
            var subjectsGroupCode = $("#subjectsGroupCode").val();
            if (isEmpty(subjectsGroupCode)) {
                $("#budgetCode").parent().parent().hide();
                $(":input").attr("disabled", "disabled");
                $("a").hide();
                $("#subjectsGroupCode").attr("disabled", false);
            } else {
                $(":input").attr("disabled", false);
                $("a").show();
                groupChange();
            }
        }
    }

    function groupChange() {
        $.ajax({
            type: "POST",
            url: "/budget/ttFeeBudgetController/getSubjectsGroupData",
            data: {dictCode: $("#subjectsGroupCode").val()},
            success: function (data) {
                $("#extChar1").parent().parent().hide();
                $("#extChar2").parent().parent().hide();
                $("#extChar3").parent().parent().hide();
                $("#extChar4").parent().parent().hide();
                $("#extChar5").parent().parent().hide();
                $("#budgetYear").parent().parent().hide();
                $("#budgetMonth").parent().parent().hide();
                $("#budgetDepartName").parent().parent().parent().hide();

                $("#budgetDepartName").removeAttr("datatype");
                $("#budgetSubjectsName").parent().parent().parent().hide();
                $("#vkorgCode").parent().parent().hide();
                $("#productLevelName").parent().parent().parent().hide();
                $("#productName").parent().parent().parent().hide();
                $("#custName").removeAttr("datatype");
                $("#custName").parent().parent().parent().hide();
                $("#custOrgName").removeAttr("datatype");
                $("#custOrgName").parent().parent().parent().hide();
                $("#initAmount").parent().parent().hide();
                $("#terminalName").parent().parent().parent().hide();
                for (var i = 0; i < data.objList.length; i++) {
                    if (data.objList[i] == "budgetYear") {
                        $("#budgetYear").parent().parent().show();
                    }
                    if (data.objList[i] == "budgetMonth") {
                        $("#budgetMonth").parent().parent().show();
                    }
                    if (data.objList[i] == "budgetDepartName") {
                        $("#budgetDepartName").parent().parent().parent().show();
                        $("#budgetDepartName").attr("datatype", "*");
                    }
                    if (data.objList[i] == "budgetSubjectsName") {
                        $("#budgetSubjectsName").parent().parent().parent().show();
                    }
                    if (data.objList[i] == "vkorgName") {
                        $("#vkorgCode").parent().parent().show();
                    }
                    if (data.objList[i] == "productLevelName") {
                        $("#productLevelName").parent().parent().parent().show();
                    }
                    if (data.objList[i] == "productName") {
                        $("#productName").parent().parent().parent().show();
                    }
                    if (data.objList[i] == "custName") {
                        $("#custName").parent().parent().parent().show();
                        $("#custName").attr("datatype", "*");
                    }
                    if (data.objList[i] == "custOrgName") {
                        $("#custOrgName").parent().parent().parent().show();
                        $("#custOrgName").attr("datatype", "*");
                    }
                    if (data.objList[i] == "initAmount") {
                        $("#initAmount").parent().parent().show();
                    }
                    if (data.objList[i] == "terminalName") {
                        $("#terminalName").parent().parent().parent().show();
                    }
                    if (data.objList[i] == "extChar1") {
                        $("#extChar1").parent().parent().show();
                    }
                    if (data.objList[i] == "extChar2") {
                        $("#extChar2").parent().parent().show();
                    }
                    if (data.objList[i] == "extChar3") {
                        $("#extChar3").parent().parent().show();
                    }
                    if (data.objList[i] == "extChar4") {
                        $("#extChar4").parent().parent().show();
                    }
                    if (data.objList[i] == "extChar5") {
                        $("#extChar5").parent().parent().show();
                    }
                }
            },
            complete: function () {
                closeProgressTop();
            }
        });
    }

    $(function () {
        /** 修改时，初始金额不能修改 */
        var updateFlag = "${updateFlag}";
        if (updateFlag == "1") {
            $("#initAmount").attr("disabled", "disabled");
        }
        /** 渠道添加事件 */
        $("#vkorgCode").change(function () {
            $("#vkorgName").val($(this).children('option:selected').text());
        });
        /** 分组添加事件 */
        $("#subjectsGroupCode").change(function () {
            $("#subjectsGroupName").val($(this).children('option:selected').text());
        });
    });

    function cleanCustomer() {
        $("#custCode").val("");
        $("#custName").val("");
    }

    /** 选择客户 */
    function goCustomer(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "custCode";
        triggerName = "custName";
        url = "/page/tmApiCustomerController/goCustomerListMain?check=true";
        width = 1000;
        height = 450;
        id = "customerList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].customerCode);
                    $("#" + triggerName).val(myobj[0].customerName);
                    //扩展js方法
                    if(isExitsFunction('autoWriteOrg')){
                        autoWriteOrg(myobj);
                    }
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function cleanCustomerOrg() {
        $("#custOrgCode").val("");
        $("#custOrgName").val("");
    }

    /** 选择客户组织 */
    function goCustomerOrg(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "custOrgCode";
        triggerName = "custOrgName";
        url = "/page/tmApiCustOrgController/goCustOrgSelectMain?check=true";
        width = 500;
        height = 450;
        id = "customerList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;

                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].custOrgCode);
                    $("#" + triggerName).val(myobj[0].customerOrgName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /**清除科目*/
    function cleanSbudgetSubjects() {
        $("#budgetSubjectsCode").val("");
        $("#budgetSubjectsName").val("");
    }

    /** 选择科目 */
    function goSbudgetSubjects(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "budgetSubjectsCode";
        triggerName = "budgetSubjectsName";
        url = "/page/ttApiBudgetController/goBudgetSubjects";
        width = 1000;
        height = 450;
        id = "budgetSubjectsList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].budgetSubjectsCode);
                    $("#" + triggerName).val(myobj[0].budgetSubjectsName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /**清除组织*/
    function cleanOrg() {
        $("#budgetDepartCode").val("");
        $("#budgetDepartName").val("");
    }

    /** 选择组织 */
    function goOrg(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "budgetDepartCode";
        triggerName = "budgetDepartName";
        // url = "/page/tmApiOrgController/goOrgListMain?singleSelect=true";
        url="/page/tmApiOrgController/goOrgListMainPage";
        width = 1000;
        height = 450;
        id = "orgListMain";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].codeText);
                    $("#" + triggerName).val(myobj[0].nameText);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function cleanProduct() {
        $("#productCode").val("");
        $("#productName").val("");
    }

    /** 选择产品 */
    function goSelectProduct() {
        triggerId = "productCode";
        triggerName = "productName";
        url = "/page/tmApiProductInfoController/goProductInfoListMain";
        width = 500;
        height = 450;
        id = "productinfoList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }
                } else {
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].productInfoCode);
                    $("#" + triggerName).val(myobj[0].productInfoName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /**
     * 清除产品层级
     */
    function cleanProductLevel() {
        $("#productLevelCode").val("");
        $("#productLevelName").val("");
    }

    //选择产品层级
    function selectProductLevel(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "productLevelCode";
        triggerName = "productLevelName";
        // valueField = "standPrice";
        url = "/page/tmApiProductLevelController/goProductListMain";
        width = 1000;
        height = 450;
        id = "productLevelList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#productLevelName").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].productCode);
                    $("#" + triggerName).val(myobj[0].productName);
                    $("#productCode").val("");
                    $("#productName").val("");
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function cleanTerminal() {
        $("#terminalCode").val("");
        $("#terminalName").val("");
    }

    //选择门店
    function selectTerminal(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "terminalCode";
        triggerName = "terminalName";
        url = "/page/tmApiTerminalController/goTerminalListMain?clickFunctionId=${clickFunctionId}";
        width = 1000;
        height = 450;
        id = "terminalList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].terminalCode);
                    $("#" + triggerName).val(myobj[0].terminalName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }


    function cleanSpecialArea() {
        $("#specialAreaCode").val("");
        $("#specialAreaName").val("");
    }

    //选择特殊区域
    function selectSpecialArea(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "specialAreaCode";
        triggerName = "specialAreaName";
        url = "/page/ttSpecialAreaController/goSelectSpecialAreaMain?type=10";
        width = 460;
        height = 450;
        id = "specialAreaList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].code);
                    $("#" + triggerName).val(myobj[0].name);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
</script>

</html>