<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ page language="java"
		 contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
<title>政策配置信息</title>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<style>
	#content .inputxt, #steps form select {
		width: 250px;
	}

	#formobj {
		padding: 0 5px;
		width:880px;
		margin:0 auto;
	}

	#steps form div.form {
		float: left;
		width: 300px;
		min-height: 22px;
	}

	#steps form div.form-2 {
		min-width: 700px;
	}

	#steps form div.form-2 textarea {
		width: 90%;
	}

	#steps form div.form .Validform_label {
		width: 85px;
		margin-right: 5px;
		font-weight: normal;
	}

	#steps form div.form .Validform_label input[type="radio"], #steps form div.form .Validform_label input[type="checkbox"]
	{
		position: absolute;
		left: 3px;
		top: 3px;
		width: 15px;
		height: 15px;
	}

	.formDiv {
		float: left;
	}

	.form {
		min-height:0px !important;
	}

	.line-title {
		font-size: 14px;
		padding: 5px;
		/* background:#b4d2ea; */
	}

	.form_label {
		float: left;
		padding-right: 20px;
		line-height: 26px;
	}

	.form_label input[type="radio"] {
		float: left;
		margin: 5px 0 0 0px;
		width: 17px;
		height: 17px;
	}

	.promotionForm_tem {
		margin-right: 10px;
		margin-bottom: 10px;
		padding: 5px;
		border: 1px solid #a5aeb6;
		background: #f5f5f5;
		line-height: 30px;
	}

	.promotionForm_tem input {
		margin: 0 10px;
		width: 60px;
		border: 0;
	}

	.promotionArea {
		border: 1px solid #ddd;
		background: #fff;
		min-height: 150px;
		padding: 5px;
		width:500px;
	}

	.promotionArea1 {
		border: 1px solid #ddd;
		background: #fff;
		min-height: 100px;
		padding: 5px;
	}

	.promotionArea a {
		margin-right: 5px;
	}

	.selectArea {
		background: #ffc6f2 !important;
	}

	.divbr {
		clear: both;
		padding-top: 12px;
	}

	select[name='policyCycle']{
		width: 250px !important;
		margin-left:0px !important;
	}

	.active-option {border-collapse:collapse;}
	.active-option tr{}
	.active-option td{width:430px;border:1px solid #666;padding:10px 0;}
</style>
<script type="text/javascript" src="/resources/tools/Map.js"></script>
</head>
<body>
	<t:formvalid formid="formobj" layout="div" dialog="true" refresh="true" beforeSubmit="buildJson()"
		action="/rebate/payPolicyController/savePayPolicy?1=1">
		<div class="line-title">基本属性</div>
		<input type="hidden" id="id" name="id" value="${vo.id}">
		<input type="hidden" name="superimpositionFlag" value="${vo.superimpositionFlag}">
		<input type="hidden" name="enableStatus" value="${vo.enableStatus}">
		<input type="hidden" name="productPolicyCode" value="${vo.productPolicyCode}">
		<input type="hidden" name="policyJson" id="policyJson">
		<input type="hidden" id="assessmentProItemsJson" value="${assessmentProItemsJson}">
		<div style="margin-top: 10px;">
			<div class="form">
                <label class="Validform_label">政策名称:</label>
				<input id="productPolicyName" name="productPolicyName" class="inputxt" style="margin-left: 0px !important;" value="${vo.productPolicyName}" <c:if test="${view}"> disabled="disabled" </c:if> datatype="*"/>
                <span style="color: red">*</span>
            </div>
			<div class="form">
				<label class="Validform_label">政策时间:</label>
				<c:if test="${view}">
					<input id="beginDate" name="beginDate"
						   class="inputxt Wdate" value="${vo.beginDate}" dataType="*"
						   style="width: 120px;"   disabled="disabled" />
					- <input id="endDate" name="endDate" class="inputxt Wdate" dataType="*"
							 value="${vo.endDate}" style="width: 120px;"   disabled="disabled" />
				</c:if>
				<c:if test="${!view}">
					<input id="beginDate" name="beginDate"
						   class="inputxt Wdate" value="${vo.beginDate}" dataType="*"
						   style="width: 120px;margin-left: 0px !important;"
						   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',maxDate:'#F{$dp.$D(\'endDate\')}'})" readonly />
					- <input id="endDate" name="endDate" class="inputxt Wdate" dataType="*"
							 value="${vo.endDate}" style="width: 120px;margin-left: 0px !important;"
							 onclick="WdatePicker({dateFmt:'yyyy-MM-dd',minDate:'#F{$dp.$D(\'beginDate\')||\'%y-%M-%d\'}'})" readonly />
				</c:if>
				<span style="color: red">*</span>
			</div>
            <div class="divbr"></div>
			<div class="form">
				<label class="Validform_label">结案周期:</label>
				<t:dictSelect id="policyCycle" field="policyCycle" typeGroupCode="product_policy_cycle" dataType="*" isView="${view}"
					defaultVal="${vo.policyCycle }"></t:dictSelect>
				<span style="color: red">*</span>
			</div>
			<div class="form">
				<label class="Validform_label">可申请时间:</label>
				<c:if test="${view}">
					<input id="applyBeginDate" name="applyBeginDate"
						   class="inputxt Wdate" value="${vo.applyBeginDate}" dataType="*"
						   style="width: 120px;" disabled="disabled" />
					- <input id="applyEndDate" name="applyEndDate" class="inputxt Wdate" dataType="*"
							 value="${vo.applyEndDate}" style="width: 120px;"  disabled="disabled" />
				</c:if>
				<c:if test="${!view}">
					<input id="applyBeginDate" name="applyBeginDate"
						   class="inputxt Wdate" value="${vo.applyBeginDate}" dataType="*"
						   style="width: 120px;margin-left: 0px !important;"
						   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',maxDate:'#F{$dp.$D(\'applyEndDate\')}'})" readonly />
					- <input id="applyEndDate" name="applyEndDate" class="inputxt Wdate" dataType="*"
							 value="${vo.applyEndDate}" style="width: 120px;margin-left: 0px !important;"
							 onclick="WdatePicker({dateFmt:'yyyy-MM-dd',minDate:'#F{$dp.$D(\'applyBeginDate\')||\'%y-%M-%d\'}'})" readonly />
				</c:if>
				<span style="color: red">*</span>
			</div>
			<div class="divbr"></div>
			<div class="form">
				<label class="Validform_label">费率:</label>
				<input id="feeRate" name="feeRate" class="inputxt" style="margin-left: 0px !important;" value="${vo.feeRate}"
						<c:if test="${view}"> disabled="disabled" </c:if> dataType="/^(([1-9]\d*)|\d)(\.\d{1,3})?$/"  />
				<span style="color: red">*</span><span>%</span>
			</div>
			<div class="divbr"></div>
            <div class="form form-2">
                <label class="Validform_label">政策描述:</label>
                <textarea rows="4" name="policyDesc" style="margin-left: 0px !important;" <c:if test="${view}"> disabled="disabled" </c:if> datatype="*">${vo.policyDesc }</textarea>
				<span style="color: red">*</span>
            </div>
			<div class="divbr"></div>
			<div class="form">
				<label class="Validform_label">返利产品:</label>
				<div id="merge_product" class="promotionArea">
					 <c:if test="${!view}">
						<a iconcls="icon-append" class="easyui-linkbutton l-btn"
						plain="true" href="javascript:;" onclick="openProduct('dg_merge_product')">添加单品</a>
						 <a iconcls="icon-remove" class="easyui-linkbutton l-btn"
							plain="true" href="javascript:;" onclick="productDelete2('dg_merge_product')">删除</a>
					 </c:if>
					<table id="dg_merge_product" style="width: 100%; height: 200px;" class="easyui-datagrid" style="height:auto" fit="true"
						   data-options="rownumbers:true,singleSelect: true,method: 'get',url:'',onClickCell:onClickCell2">
						<thead>
						<tr>
							<th data-options="field:'productCode',width:100,align:'left'">商品编码</th>
							<th data-options="field:'productName',width:300,align:'left'">商品名称</th>
							<c:if test="${!view}">
								<th data-options="field:'ratio',width:100,align:'left',editor:{type:'numberbox',options:{precision:2,min:0}}">系数</th>
							</c:if>
							<c:if test="${view}">
								<th data-options="field:'ratio',width:100,align:'left'">系数</th>
							</c:if>
						</tr>
						</thead>
					</table>
				</div>
			</div>
			<div class="divbr"></div>
			<div class="form">
				<label class="Validform_label">考核产品:</label>
				<div id = "relation_product"  class="promotionArea">
					 <c:if test="${!view}">
						<a id="relationAddId"  iconcls="icon-append" class="easyui-linkbutton l-btn"
						   plain="true" href="javascript:;" onclick="openProduct('dg_relation_product')">添加单品</a>
						 <a id="relationDelId"  iconcls="icon-remove" class="easyui-linkbutton l-btn"
							plain="true" href="javascript:;" onclick="productDelete('dg_relation_product')">删除</a>
					 </c:if>
					<table id="dg_relation_product" style="width: 100%; height: 200px;" class="easyui-datagrid" style="height:auto" fit="true"
						   data-options="rownumbers:true,singleSelect: true,method: 'get',url:'',onClickCell:onClickCell">
						<thead>
						<tr >
							<th data-options="field:'productCode',width:100,align:'left'">商品编码</th>
							<th data-options="field:'productName',width:300,align:'left'">商品名称</th>
							<c:if test="${!view}">
								<th data-options="field:'ratio',width:100,align:'left',editor:{type:'numberbox',options:{precision:2,min:0}}">系数</th>
							</c:if>
							<c:if test="${view}">
								<th data-options="field:'ratio',width:100,align:'left'">系数</th>
							</c:if>

						</tr>
						</thead>
					</table>
				</div>
			</div>
		</div>
		<div class="divbr"></div>
		<div class="line-title">政策范围</div>
		<div>
			<div class="form">
				<label class="Validform_label">包含:</label> <span>
					<div>
						<c:if test="${!view}">
							<a iconcls="icon-append" class="easyui-linkbutton l-btn"
								plain="true" href="javascript:;" onclick="openOrg('includeOrg')">添加区域</a>
							<a iconcls="icon-remove" class="easyui-linkbutton l-btn"
								plain="true" href="javascript:;"
								onclick="areaDelete('includeOrg')">删除</a>
						</c:if>
					</div>
					<div class="promotionArea1" id="includeOrg"></div>
				</span>
			</div>
			<div class="form">
				<span>
					<div>
						<c:if test="${!view}">
							<a iconcls="icon-append" class="easyui-linkbutton l-btn"
								plain="true" href="javascript:;"
								onclick="openCust('includeCust')">添加客户</a> <a
								iconcls="icon-remove" class="easyui-linkbutton l-btn"
								plain="true" href="javascript:;"
								onclick="areaDelete('includeCust')">删除</a>
						</c:if>
					</div>
					<div class="promotionArea1" id="includeCust"></div>
				</span>
			</div>
		</div>
		<div class="divbr"></div>
		<div>
			<div class="form">
				<label class="Validform_label">非包含:</label> <span>
					<div>
						<c:if test="${!view}">
							<a iconcls="icon-append" class="easyui-linkbutton l-btn"
								plain="true" href="javascript:;" onclick="openOrg('excludeOrg')">添加区域</a>
							<a iconcls="icon-remove" class="easyui-linkbutton l-btn"
								plain="true" href="javascript:;"
								onclick="areaDelete('excludeOrg')">删除</a>
						</c:if>
					</div>
					<div class="promotionArea1" id="excludeOrg"></div>
				</span>
			</div>
			<div class="form">
				<span>
					<div>
						<c:if test="${!view}">
							<a iconcls="icon-append" class="easyui-linkbutton l-btn"
							   plain="true" href="javascript:;"
							   onclick="openCust('excludeCust')">添加客户</a> <a
								iconcls="icon-remove" class="easyui-linkbutton l-btn"
								plain="true" href="javascript:;"
								onclick="areaDelete('excludeCust')">删除</a
						</c:if>
					</div>
				<div class="promotionArea1" id="excludeCust"></div>
				</span>
			</div>
		</div>
		<div class="divbr"></div>
		<div class="line-title">政策公式</div>
		<div class="form form-2" >
			<div>
				<c:if test="${!view}">
					<a iconcls="icon-append" class="easyui-linkbutton l-btn"
					   plain="true" href="javascript:;" onclick="addFormula('formula')">添加公式</a>
				</c:if>
			</div>
			<div id="formulaTplContainer"></div>
		</div>

	</t:formvalid>
</body>

<script>
	var map = new HashKey();

    function setBuyGiveCostRate() {
    }

    //设置实际费率信息
    function setActualCostRateVoInfo(dmsCostBuyQuantity, dmsCostGiveQuantity) {
        var productCode = $("#productCode").val();
        var giftProductCode = $('[name="giftProductCode"]').val();
        if(giftProductCode!=null && giftProductCode!="" && giftProductCode != productCode){

        }else{

        }
    }

    $(function () {
        initDataTypeMap();
        $.Datatype.fixed2 = function(gets, obj, curform, regxp) {
            var reg1 = /^[1-9]\d*$/;
            var reg2 = /^(-?\d*\.\d{1,2})?$/;
            var value = curform.find("input[name='" + obj.attr("name") + "']").val().trim();
            if(value.length == 0) {
                return true;
			}
			if(value == 0) {
				return "特价不可为0，请修改！";
			}
            return value.length!=0 && (reg1.test(value) || reg2.test(value)) ? true : "最多两位的小数的正浮点数";
        };

        $("#dmsCostPaymentCode").siblings("span").css("height","24px").find(".combo-text,.combo-arrow").css("height","24px");
        $("#tpmCostPaymentCode").siblings("span").css("height","24px").find(".combo-text,.combo-arrow").css("height","24px");


        $("#dmsCostGiveQuantity").blur(function (e) {
            setBuyGiveCostRate();
        });

        $("#dmsCostBuyQuantity").blur(function (e) {
            setBuyGiveCostRate();
        });

        $("#tpmCostRateStr").blur(function (e) {
            $("#tpmCostRate").val($("#tpmCostRateStr").val() / 100);
        });
        //是否手动计算选择事件
        $("input[type=radio][name=manualFlag]").change(function() {
            var v=$(this).val();
            if(v==1){
                $("#formulaDiv").css("display","none");
                changeTpmCostRateIsCouldEdit(v);
			}else{
                $("#formulaDiv").css("display","block");
                changeTpmCostRateIsCouldEdit(v);
			}
			$("#manualFlag").val(v);
        });


        $("[name='dmsCostType']").click(function (e) {
            $("[data-dmsCostType]").hide();
            $("[data-dmsCostType='"+$("[name='dmsCostType']:checked").val()+"']").show();

            if($("[name='dmsCostType']:checked").val() == "DISCOUNT") {
                $("#dmsCostRate").val(0);
                $("#dmsCostRateStr").val("0");
                $("#dmsActualCostRate").val(0);
                $("#dmsActualCostRateStr").val("0");
			} else {
                setBuyGiveCostRate();
			}
        });
        $("[name='dmsCostType']:checked").click();

        $("[name='enableDmsCost'],[name='enableTpmCost']").change(function (e) {
            if( this.checked ) {
                $(this).closest("td").find(".isDiv").show();
                $(this).closest("td").find("#dmsCostAccountName,#tpmCostAccountName").attr("datatype","*");
                $(this).closest("td").find("#dmsCostPaymentCode,#tpmCostPaymentCode").parent().find(".combo-text").attr("datatype","*");
                $(this).closest("td").find("#manualFlag").attr("datatype","*");
            } else {
                $(this).closest("td").find(".isDiv").hide();
                $(this).closest("td").find("#dmsCostAccountName,#tpmCostAccountName").removeAttr("datatype");
                $(this).closest("td").find("#dmsCostPaymentCode,#tpmCostPaymentCode").parent().find(".combo-text").removeAttr("datatype");
                $(this).closest("td").find("#manualFlag").removeAttr("datatype");
            }
        });
        $("[name='enableDmsCost'],[name='enableTpmCost']").change();

        //关联产品启用事件
        $("[name='enableRelationProduct']").change(function (e) {
            if( this.checked ) {
                $("#relationAddId").css('visibility', 'visible');
                $("#relationDelId").css('visibility', 'visible');
                $("#relation_product").css('visibility', 'visible');
                //清空列表数据
                $('#dg_relation_product').datagrid('loadData', {total:0,rows:[]});
            } else {
                $("#relationAddId").css('visibility', 'hidden');
                $("#relationDelId").css('visibility', 'hidden');
                $("#relation_product").css('visibility', 'hidden');
			}
        });

        $(".formobj").Validform({
            datatype:{
                "prdRequired":function(gets,obj,curform,regxp){

					var productLevelCode=$("#productLevelCode").val();
                    var productCode=$("#productCode").val();
                    var mergeProductData = $("#dg_merge_product").datagrid("getRows");

                    if((productCode!=null&&productCode!="")||(productLevelCode!=null&&productLevelCode!="")
								||(mergeProductData.length > 0)){
                        return true;
                    }

                    return false;
                },
				"giftType":function(gets,obj,curform,regxp){
					return true;
				},
				"policyType":function(gets,obj,curform,regxp){
					var dmsChecked =$("[name='enableDmsCost']").is(":checked");
					var tpmChecked= $("[name='enableTpmCost']").is(":checked");
					if(dmsChecked||tpmChecked){
						return true;
					}
					return false;
                },
				"requiredCostType":function(gets,obj,curform,regxp){
					var dmsChecked =$("[name='enableDmsCost']").is(":checked");
					if(!dmsChecked){
						return true;
					}
					if(dmsChecked){
						var list= $('input:radio[name="dmsCostType"]:checked').val();
                        if(list!=null&&list=='GIVE'){
						    var dmsCostBuyQuantity=$("#dmsCostBuyQuantity").val();
                            var dmsCostGiveQuantity=$("#dmsCostGiveQuantity").val();
                            if(dmsCostBuyQuantity!=null&&dmsCostBuyQuantity!=''&&dmsCostGiveQuantity!=null&&dmsCostGiveQuantity!='') {
                                return true;
                            }
                        }else if (list != null && list == 'DISCOUNT') {
                            return true;
						}
					}
					return false;
				},
                "requiredRate":function(gets,obj,curform,regxp){
                    var tpmChecked =$("[name='enableTpmCost']").is(":checked");
                    if(!tpmChecked){
                        return true;
					}
                    if(tpmChecked){
                        var tpmCostRate=$("#tpmCostRate").val();
                        var tpmCostRateStr=$("#tpmCostRateStr").val();
                        if(tpmCostRate!=null&&tpmCostRate!=""&&tpmCostRateStr!=null&&tpmCostRateStr!=""){
                            return true;
						}
                    }
                    return false;
                },
                "requiredPrice":function(gets,obj,curform,regxp){
                    var dmsChecked =$("[name='enableDmsCost']").is(":checked");
                    if(!dmsChecked){
                        return true;
                    }

                    if(dmsChecked) {
                        var list = $('input:radio[name="dmsCostType"]:checked').val();
                        if (list != null && list == 'DISCOUNT') {
                            var price = $("#dmsCostDiscountPrice").val();
                            if (price != null && price != "") {
                                if(/^(([1-9][0-9]*)+(.[0-9]{1,2})?)$|^((0.)?[0-9]{1,2})$/.test(price)){
                                    if(0 == Number(price)){
                                        return '特价不能填写0';
									}
                                    return true;
                                }else{
                                    return '特价格式不对';
								}
                            }else{
                                $("#dmsCostDiscountPrice").focus();
							}
                        }else if(list!=null&&list=='GIVE'){
                            return true;
                        }
                    }
                    return false;
                }
            },
            ajaxPost:true
        });
        initTpmCostRateIsCouldUpdate();
    });

    function initDataTypeMap() {
        map.set("tpmCostRate",$('#tpmCostRate').attr("datatype"));
        map.set("tpmCostRateStr",$('#tpmCostRateStr').attr("datatype"));
    }

    function initTpmCostRateIsCouldUpdate(){
        var manualFlagVal = $("input[type='radio'][name='manualFlag']:checked").val();
		if(typeof(manualFlagVal) != 'undefined' && manualFlagVal != ''){
            changeTpmCostRateIsCouldEdit(manualFlagVal);
		}
	}

    function changeTpmCostRateIsCouldEdit(targ){
        var widthtemp = $('#tpmCostRateStr').width();
        if(1 == targ){
            $('#tpmCostRate').removeAttr('disabled').removeAttr('class').css('background-color', '').css('width', widthtemp);
            $('#tpmCostRateStr').removeAttr('disabled').removeAttr('class').css('background-color', '').css('width', widthtemp);
            $('#tpmCostRate').nextAll('span').show();

            $('#tpmCostRate').attr("datatype",map.get("tpmCostRate"));
            $('#tpmCostRateStr').attr("datatype",map.get("tpmCostRateStr"));
        }else {
            $('#tpmCostRate').attr('disabled',true).removeAttr('class').css('background-color','gray').css('width',widthtemp);
            $('#tpmCostRateStr').attr('disabled',true).removeAttr('class').css('background-color','gray').css('width',widthtemp);
            $('#tpmCostRate').nextAll('span').hide();

            $('#tpmCostRate').val('');
            $('#tpmCostRateStr').val('');

            $('#tpmCostRate').removeAttr("datatype");
            $('#tpmCostRateStr').removeAttr("datatype");
        }
    }

	/** 政策区域 */
	var TdPolicyAreaVo = function() {
		this.id;
		/**返利id*/
		this.productPolicyId;
		/**组织id*/
		this.orgCode;
		/**组织名称**/
		this.orgName;
		//结算类型
		this.customerCode;
		this.customerName;
        /**0非包含，1包含*/
		this.protype;
	};
	/** 政策考核产品 */
	var TdAssessmentProductVo = function() {
		this.id;
		/**政策外键*/
		this.productPolicyId;
		/**产品编码*/
		this.productCode;
		/**产品名称*/
		this.productName;
		/**系数*/
		this.ratio;
	};
	/** 返利 */
    var TdPolicyFormulaVo = function() {
        this.id;
        this.rebId;
        this.formulaCon;
        this.formulaConDesc;
        this.formulaVal;
        this.formulaValDesc;
    };

    //处理键值对
    function HashKey(){
        var data = {};
        this.set = function(key,value){   //set方法
            data[key] = value;
        };
        this.unset = function(key){     //unset方法
            delete data[key];
        };
        this.get = function(key){     //get方法
            return data[key] || "";
        }
        this.returnKey = function(){
            //获得对象所有属性的数组
            return Object.getOwnPropertyNames(data);
        }
    }
</script>


<script type="text/html" id="areaBlockTpl">
    <a iconcls="icon-ok"
       class="easyui-linkbutton l-btn l-btn-plain"
       plain="true" onclick="selectArea(this)"  data-code="{{d.code}}"  data-name="{{d.name}}" data-type="{{d.type}}">
    <span class="l-btn-left">
    <span class="l-btn-text icon-ok l-btn-icon-left">{{d.name}}</span>
    </span>
    </a>
</script>
<script type="text/html" id="formulaBlockTpl">
    <div style="display: table;">
			返利条件<input type="hidden" name='formula_con' style="width: 200px" value="{{d.con}}" readonly/>
			<textarea name="formula_con_desc" readonly="readonly"  style="width:200px;height:55px;vertical-align:top;resize:vertical;" >{{d.con_desc}}</textarea>

			返利公式<input type="hidden" name='formula_val' style="width: 200px" value="{{d.val_}}" readonly/>
			<textarea name="formula_val_desc" readonly="readonly" style="width:200px;height:55px;vertical-align:top;resize:vertical;" >{{d.val_desc_}}</textarea>
			<a iconcls="icon-remove" class="easyui-linkbutton l-btn l-btn-plain"
			   plain="true" href="javascript:;" style="float:right" onclick="remove(this)">
				<span class="l-btn-left">
					<c:if test="${!view}">
						<span class="l-btn-text icon-remove l-btn-icon-left">删除</span>
					</c:if>
				</span>
			</a>
    </div>
</script>

<script type="text/javascript">
    var areaArr=new Array();
    var proArr=new Array();
    var formulaArr=new Array();
	var includeArea = [];
	var excludedArea = [];
	var formulaReb = [];
    //公式
    var formulaMap =new Map();
	//产品
	var productMap = new Map();

	//包含
	// 经销商
	var includeCustMap = new Map();
	//组织
	var includeOrgMap = new Map();

	//非包含
	//经销商
	var excludeCustMap = new Map();
	//组织
	var excludeOrgMap = new Map();

	//公共的map集合定义
	var mapList = {
		includeCustMap : includeCustMap,
		includeOrgMap : includeOrgMap,
		excludeOrgMap : excludeOrgMap,
		excludeCustMap : excludeCustMap,
		productMap : productMap,
		formulaMap :formulaMap
	};

	//选择组织
	function openOrg(containerElement) {

        $.dialog({
            title : "组织管理",
            content : "url:/page/tmApiOrgController/goOrgListMainPage?singleSelect=false&clickFunctionId=${clickFunctionId}",
            lock : true,
            width : "500",
            height : "400",
            zIndex : 10000,
            parent : windowapi,
            ok : function() {
                iframe = this.iframe.contentWindow;
                var rows = iframe.$("#orgListMain").datagrid('getSelections');
                putAreaBlock(containerElement, rows, "codeText", "nameText","org");
            },
            cancelVal : '关闭',
            cancel : true
        });
	}

	//选择产品
	function openProduct(id) {
        safeShowDialog({
            content:'url:/page/payPolicyFormulaController/goSelectWareForm?singleSelect=false',
            title:'商品管理',
            ok:function () {
                var iframe = this.iframe.contentWindow;
                var rows = iframe.getSelections();
                if(!rows){
                    return false;
                }
                if(id == "dg_merge_product") {
                    selectProductLevel(null, false);
                    selectProduct(null, false);
                }
                var getRows = $('#' + id).datagrid("getRows");
                $.each(rows, function (index, item) {
                    var insertFlag = true;

                    $.each(getRows, function (index2, item2) {
                        if(item2.productCode == item.wareCode) {
                            insertFlag = false;
                        }
                    });

                    if(insertFlag == true) {
                        $('#' + id).datagrid('appendRow',{
                            productCode:item.wareCode,
                            productName:item.wareName,
                            ratio:1
                        });
                    }
                });
            },
            cancelVal:'关闭'
        })


	}

	function productDelete(id) {
        if (editIndex == undefined){return}
        $('#' + id).datagrid('cancelEdit', editIndex)
            .datagrid('deleteRow', editIndex);
        editIndex = undefined;
    }

    function productDelete2(id) {
        if (editIndex2 == undefined){return}
        $('#' + id).datagrid('cancelEdit', editIndex2)
            .datagrid('deleteRow', editIndex2);
        editIndex2 = undefined;
    }

    function putAreaBlock(containerElement, json, code, name, type) {
        var map = mapList[containerElement + "Map"];
        $(json).each(function (e, v) {
			console.log(e);
			console.log(v);
            var areaBlockTpl = $("#areaBlockTpl").html();
            if(v[name] || v[code]){
                v.name = v[name];
                v.code = v[code];
                v.type = type;
                //判断是否存在
                var flag = map.containsKey(v.code);
                if (!flag) {
                    map.put(v.code, v.name);
                    laytpl(areaBlockTpl).render(v, function (html) {
                        $("#" + containerElement).append(html);
                    });
                } else {
                    tip("已经选择了" + v.code + "," + v.name);
                }
            }
        });
    }
	/**
	 * 查询经销商
	 */
    function  openCust(containerElement) {

        var map = mapList[containerElement + "Map"];
        var customerCodes="";
        var ojb = $("#includeCust").find(
            "a[data-code]").each(
            function (index, obj) {

                var areain = new TdPolicyAreaVo();
                areain.customerCode = $(obj).attr("data-code");
                areain.customerName = $(obj).attr("data-name");
                customerCodes = customerCodes + "," +areain.customerCode+"";
            });

        safeShowDialog({
            content:"url:/page/payPolicyFormulaController/goSelectCustomerForm?1=1&customerCodes="+customerCodes+"&clickFunctionId=${clickFunctionId}",
            lock:true,
            title:'选择',
            width:1000,
            height:450,
            left:'85%',
            cache:false,
            ok : function() {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#customerList').datagrid('getSelections');
                putAreaBlock(containerElement, rowsData, "customerCode", "customerName","customer");
                return true;
            },
            cancelVal : '关闭',
            cancel : true
        });

    }

	function selectArea(obj) {
		$(obj).toggleClass("selectArea");
	}

	function areaDelete(id) {
		var map = mapList[id + "Map"];
		var obj = $("#" + id + " .selectArea");
		obj.each(function(index, object) {
			//var key = object.dataset;
			map.remove($(object).attr("data-code"));
		});
		$("#" + id + " .selectArea").remove();
	}
	//添加公式
    function addFormula(containerElement) {
        createwindowExt('添加返利',
            '/page/payPolicyFormulaController/goPolicyFormula?1=1', "1000", "400", {
                ok: function () {

                    iframe = this.iframe.contentWindow;//formula_con
                    if (!iframe.beforCheckFomula()) {
                        return false;
                    }
                    var formulaArray = [];
                    iframe.$("body").find("input[name='formula_con']").each(
                        function (index, obj) {
                            formulaArray.push({
                                "con": $(obj).val(),
                                "val_": $(obj).parent().find("[name='formula_val']").val(),
								"con_desc":$(obj).parent().find("[name='formula_con_desc']").val(),
                                "val_desc_":$(obj).parent().find("[name='formula_val_desc']").val(),
                            })
                        });
                    putFormulaBlock(containerElement, formulaArray, "con", "val_","con_desc","val_desc_");
                }
            });
    }

    function putFormulaBlock(containerElement, json, con, val_,con_desc,val_desc_) {
        var map = mapList[containerElement + "Map"];
        var formulaBlockTpl = $("#formulaBlockTpl").html();
        $(json).each(function (e, v) {
            v.con = v[con];
            v.val_ = v[val_];
            v.con_desc = v[con_desc];
            v.val_desc_ = v[val_desc_];
            //判断是否存在
            var flag = map.containsKey(v.con);
            if (!flag) {
                map.put(v.con, v.val_);
                laytpl(formulaBlockTpl).render(v, function (html) {
                    $("#formulaTplContainer").append(html);
                });
            } else {
                tip("已经选择了" + v.con + "," + v.val_);
            }
        });
    }

    /**
     * 移除规则
     * @param obj
     */
    function remove(obj) {
//        if (formulaCheckCount()) {
//            tip("不能删除，至少需要一条公式");
//        } else {
            $(obj).parent().remove();
			var con = $(obj).parent().find("[name='formula_con']").val();
			mapList.formulaMap.remove(con);
//        }
    }

    //公式条数检测
    function formulaCheckCount() {
        var rules = $("#formulaTplContainer").find("div");
        if (rules.length >= 1) {
            return true;
        } else {
            return false;
        }
    }

    function cleanPolicy(isDmsCost){
        var dmsChecked =$("[name='enableDmsCost']").is(":checked");
        var tpmChecked =$("[name='enableTpmCost']").is(":checked");
        if(dmsChecked&&tpmChecked){
            return;
		}
		if(dmsChecked){
            $("#tpmCostAccountName").val('');
            $("#tpmCostAccountCode").val('');
            $("#tpmCostTypeCode").val('');
            $("#tpmCostTypeName").val('');
            $("#tpmCostPaymentCode").val('');
            $("#formulaTplContainer").html('');
            $("#tpmCostRate").val('');
            $("#tpmCostRateStr").val('');

		}else{

            $("#dmsCostAccountName").val('');
            $("#dmsCostAccountCode").val('');
            $("#dmsCostTypeCode").val('');
            $("#dmsCostTypeName").val('');
            $("#dmsCostPaymentCode").val('');
            $("#dmsCostBuyQuantity").val('');
            $("#dmsCostGiveQuantity").val('');
            $("#dmsCostDiscountPrice").val('');
            $("#dmsCostRate").val('');
            $("#dmsCostRateStr").val('');
            $("#dmsCostPrice").val('');
            $("#dmsStandardPrice").val('');
            $("#dmsActualCostRate").val('');
            $("#dmsActualCostRateStr").val('');
		}
	}


    function buildJson() {
        cleanPolicy();
        endEditing();
        endEditing2();
        var tempobj = new Object();
        var areaArr_din = new Array();
        var areaArr_dex = new Array();
        var areaArr_ain = new Array();
        var areaArr_aex = new Array();
        var proArr_pro = new Array();
        var mergeProArr_pro = new Array();
        var formulaArr = new Array();
        var id=$("#id").val();
        var productPolicyName=$("#productPolicyName").val();
        //公式
        $("#formulaTplContainer").find(
            "input[name='formula_con']").each(
            function (index, obj) {
                var fm = new TdPolicyFormulaVo();
                fm.rebId = $("#id").val();
                fm.formulaCon = $(obj).val();
                fm.formulaVal = $(obj).parent().find("[name='formula_val']").val();
                fm.formulaConDesc = $(obj).parent().find("[name='formula_con_desc']").val();
                fm.formulaValDesc = $(obj).parent().find("[name='formula_val_desc']").val();
                formulaArr.push(fm);
            });
        // $("input[name='rebFormulasJson']").val(JSON.stringify(formulaArr));
//        经销商
        $("#includeCust").find(
            "a[data-code]").each(
            function (index, obj) {

                var areain = new TdPolicyAreaVo();
				areain.customerCode = $(obj).attr("data-code");
				areain.customerName = $(obj).attr("data-name");
                areain.protype = 1;
                areaArr_din.push(areain);
            });
        $("#excludeCust").find(
            "a[data-code]").each(
            function (index, obj) {
                var areainex = new TdPolicyAreaVo();
				areainex.customerCode = $(obj).attr("data-code");
				areainex.customerName = $(obj).attr("data-name");
                areainex.protype = 0;
                areaArr_dex.push(areainex);
            });
        $("#includeOrg").find(
            "a[data-code]").each(
            function (index, obj) {
                var areain = new TdPolicyAreaVo();
                areain.orgCode = $(obj).attr("data-code");
                areain.orgName =  $(obj).attr("data-name");
                areain.protype = 1;
                areaArr_ain.push(areain);
            });
        $("#excludeOrg").find(
            "a[data-code]").each(
            function (index, obj) {
                var areainex = new TdPolicyAreaVo();
                areainex.orgCode = $(obj).attr("data-code");
                areainex.orgName =  $(obj).attr("data-name");
                areainex.protype = 0;
                areaArr_aex.push(areainex);
            });
        //关联考核产品
		var errMsg = "";
		var productRows = $("#dg_relation_product").datagrid("getRows");
        $.each(productRows, function (index, item) {
            var prop = new TdAssessmentProductVo();
            prop.productCode = item.productCode;
            prop.productName = item.productName;
            prop.ratio = item.ratio;
            if(item.ratio == null || item.ratio == "") {
                errMsg += "第" + (index+1) + "行,";
			}
            proArr_pro.push(prop);
        });

        if(errMsg != "") {
            tip("关联产品，" + errMsg + "系数必填");
            return false;
		}

        //合并考核产品
        var mergeProductRows = $("#dg_merge_product").datagrid("getRows");
        $.each(mergeProductRows, function (index, item) {
            var prop = new TdAssessmentProductVo();
            prop.productCode = item.productCode;
            prop.productName = item.productName;
            prop.ratio = item.ratio;
            if(item.ratio == null || item.ratio == "") {
                errMsg += "第" + (index+1) + "行,";
            }
            mergeProArr_pro.push(prop);
        });

        if(errMsg != "") {
            tip("考核产品，" + errMsg + "系数必填");
            return false;
        }

       var enableDmsCost = $('[name="enableDmsCost"]').val();
       var enableTpmCost = $('[name="enableTpmCost"]').val();
       var dmsCostPaymentCode = $("#dmsCostPaymentCode").val();
       if(dmsCostPaymentCode == "" && "Y" == enableDmsCost) {
           tip("随车支付方式必填");
           return false;
	   }

	   var _productCode = $("#productCode").val();
       var _productName = $("#fullName").val();
       if(_productCode && _productCode != null && _productCode != "")
	   {
           var giftProductCode = $('[name="giftProductCode"]').val();
           if(giftProductCode && giftProductCode != null && giftProductCode != '')
           {}else{
               $('[name="giftProductCode"]').val(_productCode);
               $('[name="giftProductName"]').val(_productName);
           }
	   }else{
           $('[name="giftProductCode"]').val("");
           $('[name="giftProductName"]').val("");
	   }

	   var tpmCostPaymentCode = $("#tpmCostPaymentCode").val()
       if(tpmCostPaymentCode == "" && "Y" == enableTpmCost) {
            tip("后返支付方式必填");
            return false;
	   }
        // $("input[name='rebateProItemsJson']").val(JSON.stringify(proArr));
        // $("input[name='rebAreaItemsJson']").val(JSON.stringify(areaArr));
        tempobj.policyAreaItemsJson_din = areaArr_din;
        tempobj.policyAreaItemsJson_dex = areaArr_dex;
        tempobj.policyAreaItemsJson_ain = areaArr_ain;
        tempobj.policyAreaItemsJson_aex = areaArr_aex;
        tempobj.assessmentProItemsJson = proArr_pro;
        tempobj.assessmentMergeProItemsJson = mergeProArr_pro;
        tempobj.policyFormulasJson = formulaArr;
        $("input[name='policyJson']").val(JSON.stringify(tempobj));
        if (formulaArr.length==0 ){
            tip("请添加返利公式");
            return false;
		}
    }

    function selectProductLevel(obj, isMerge) {
        if(isMerge == undefined) {
            $('#dg_merge_product').datagrid('loadData', {total:0,rows:[]});
		}
    }

    function selectProduct(obj, isMerge) {
        if(isMerge == undefined) {
            $('#dg_merge_product').datagrid('loadData', {total:0,rows:[]});
        }
    }

    function setProductCodeStandardPrice(productCode){
        var price_ = 0.00;
	}

    function selectGiftProduct(obj,isMerge){
        if(obj){
            if( obj.giftProductCode && obj.giftProductCode.length > 0){
                setGiftProductCodeStandardPrice(obj.giftProductCode[0]);
			}else{
                $("#giftProductCode").val("");
                $("#giftProductName").val("");
                $("#giftProductCodePrice").val(0.00);
			}
		}else{
            $("#giftProductCode").val("");
            $("#giftProductName").val("");
            $("#giftProductCodePrice").val(0.00);
		}
        if(isMerge == undefined) {
            $('#dg_merge_product').datagrid('loadData', {total:0,rows:[]});
        }
	}

    function setGiftProductCodeStandardPrice(productCode){
        var price_ = 0.00;
    }
    
    function selectDMSAccount(obj) {
		$("#dmsCostAccountCode").val(obj.dmsCostAccountCode);
        $("#dmsCostAccountName").val(obj.accountName);
        $("#dmsCostTypeCode").val(obj.costTypeCode);
        $("#dmsCostTypeName").val(obj.costTypeName);
        //根据所选科目查询支付方式
        $("#dmsCostPaymentCode").val("");
        $("#cbdmsCostPaymentCode").val("");
        initDMSPaymentComboBox(obj.dmsCostAccountCode);
    }

    //根据所选科目查询支付方式
    function initDMSPaymentComboBox(accountCode){
//        $("#cbdmsCostPaymentCode").combobox("reload","ttCostAccountController.do?findPaymentComboxByAccountCode&costAccountCode="+accountCode);
    }

    function selectTPMAccount(obj) {
        $("#tpmCostAccountCode").val(obj.tpmCostAccountCode);
        $("#tpmCostAccountName").val(obj.accountName);
        $("#tpmCostTypeCode").val(obj.costTypeCode);
        $("#tpmCostTypeName").val(obj.costTypeName);
        $("#tpmCostPaymentCode").val("");
        $("#cbtpmCostPaymentCode").val("");
        initTPMPaymentComboBox(obj.tpmCostAccountCode);
    }

    //根据所选科目查询支付方式
    function initTPMPaymentComboBox(accountCode){
//        $("#cbtpmCostPaymentCode").combobox("reload","ttCostAccountController.do?findPaymentComboxByAccountCode&costAccountCode="+accountCode)
    }


    var editIndex = undefined;
    var editIndex2 = undefined;

    function endEditing(){
        if (editIndex == undefined){return true}
        if ($('#dg_relation_product').datagrid('validateRow', editIndex)){
            $('#dg_relation_product').datagrid('endEdit', editIndex);
            editIndex = undefined;
            return true;
        } else {
            return false;
        }
    }

    function endEditing2(){
        if (editIndex2 == undefined){return true}
        if ($('#dg_merge_product').datagrid('validateRow', editIndex2)){
            $('#dg_merge_product').datagrid('endEdit', editIndex2);
            editIndex2 = undefined;
            return true;
        } else {
            return false;
        }
    }

    function onClickCell(index, field){
        if (editIndex != index){
            if (endEditing()){
                $('#dg_relation_product').datagrid('selectRow', index)
                    .datagrid('beginEdit', index);
                var ed = $('#dg_relation_product').datagrid('getEditor', {index:index,field:field});
                if (ed){
                    ($(ed.target).data('textbox') ? $(ed.target).textbox('textbox') : $(ed.target)).focus();
                }
                editIndex = index;
            } else {
                setTimeout(function(){
                    $('#dg_relation_product').datagrid('selectRow', editIndex);
                },0);
            }
        }
    }

    function onClickCell2(index, field){
        if (editIndex2 != index){
            if (endEditing2()){
                $('#dg_merge_product').datagrid('selectRow', index)
                    .datagrid('beginEdit', index);
                var ed = $('#dg_merge_product').datagrid('getEditor', {index:index,field:field});
                if (ed){
                    ($(ed.target).data('textbox') ? $(ed.target).textbox('textbox') : $(ed.target)).focus();
                }
                editIndex2 = index;
            } else {
                setTimeout(function(){
                    $('#dg_merge_product').datagrid('selectRow', editIndex2);
                },0);
            }
        }
    }


    //选择前期活动数据
    function chooseEarlyPolicyCodes(){
        var earlyPolicyCode = $('#earlyPolicyCode').val();
//        createwindowExt('前期活动选择','ttProductPolicyController.do?goEarlyPolicySelectMain&earlyPolicyCode='+earlyPolicyCode,900,500,{
//            okVal :'确定',
//            ok : function () {
//                iframe = this.iframe.contentWindow;
//                var earlyPolicyCode = iframe.getHasSelectedEarlyPolicyStr();
//                $('#earlyPolicyCode').val(earlyPolicyCode);
//            },
//            cancelVal : '关闭',
//            cancel : true,
//            left :'85%',
//            top :'65%'
//        });
    }
</script>
<script type="text/javascript">
    $(function () {
        if('${vo.enableRelationProduct}' == 'Y'){
            $("#relationAddId").css('visibility', 'visible');
            $("#relationDelId").css('visibility', 'visible');
            $("#relation_product").css('visibility', 'visible');
		}

        var pro = ${vo.assessmentProItemsJson};
        var mergePro = ${vo.assessmentMergeProItemsJson};
        var ain = ${vo.policyAreaItemsJson_ain};
        var aex = ${vo.policyAreaItemsJson_aex};
        var din = ${vo.policyAreaItemsJson_din};
        var dex = ${vo.policyAreaItemsJson_dex};
        var formula = ${vo.policyFormulasJson};
        //赋值关联考核产品
        appendProduct(pro, "dg_relation_product");
        //赋值合并考核产品
        appendProduct(mergePro, "dg_merge_product");
		//包含赋值区域
		putAreaBlock("includeOrg", ain, "orgCode", "orgName","org");
		//非包含赋值区域
		putAreaBlock("excludeOrg", aex, "orgCode", "orgName","org");
		//经销商
		putAreaBlock("includeCust", din, "customerCode", "customerName","customer");
		//非包含经销商
		putAreaBlock("excludeCust", dex, "customerCode", "customerName","settlement");
		//公式
		putFormulaBlock("formula", formula, "formulaCon", "formulaVal", "formulaConDesc", "formulaValDesc");
    });

    function appendProduct(json, id) {
        $(json).each(function (index, item) {
            $('#' + id).datagrid('appendRow',{
                productCode:item.productCode,
                productName:item.productName,
                ratio:item.ratio
			});
        });
	}

</script>
</html>
