<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>识别详情</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <style>
        body {
            background: #f3f3f3;
        }

        .distinguish-detail {
            padding: 15px 15px 0 15px;
        }

        .panel {
            background: #ffffff;
            border-radius: 5px;
            padding: 0 15px 15px 15px;
            box-sizing: border-box;
            margin-bottom: 15px;
        }

        .panel-title {
            line-height: 40px;
            color: #333333;
        }

        .num-list-item {
            background: #F1F8FF;
            border-radius: 6px;
            padding: 15px 0;
        }

        .num-text {
            color: #1578E3;
            font-size: 20px;
        }

        .num-name {
            color: #666666;
            font-size: 12px;
            margin-top: 5px;
        }

        .field-row {
            height: 32px;
        }

        .progress-bar {
            position: relative;
            width: 100%;
            height: 10px;
            border-radius: 6px;
            background: #f3f3f3;
        }

        .progress-bar-active {
            position: absolute;
            left: 0;
            top: 0;
            width: 0;
            height: 10px;
            border-radius: 6px;
            transition: all .3s;
        }

        .progress-bar-blue {
            background: #0092EF;

        }

        .progress-bar-yellow {
            background: #F7B500;
        }

        .field-label {
            color: #333333;
            font-size: 14px;
            width: 80px;
            box-sizing: border-box;
        }

        .field-content {
            color: #999999;
            font-size: 14px;
        }

        .field-info {

            text-align: right;
            box-sizing: border-box;
        }

        .progress-percent {
            font-size: 14px;
        }

        .progress-percent-blue {
            color: #0092EF;
        }

        .progress-percent-yellow {
            color: #F7B500;
        }

        .tag-red {
            border: 1px solid #F26262;
            border-radius: 6px;
            color: #F26262;
            font-size: 10px;
            padding: 2px 5px;
        }

        .tag-green {
            border: 1px solid #40B797;
            border-radius: 6px;
            color: #40B797;
            font-size: 10px;
            padding: 2px 5px;
        }

        .c-red {
            color: #F26262;
        }

        .c-green {
            color: #40B797;
        }

        .panel-display {
            border-bottom: 1px solid #e4e4e4;
        }

        .bp-item {
            border-bottom: 1px solid #e4e4e4;
        }

        .jp-item {
            border-bottom: 1px solid #e4e4e4;
        }

        .panel-img-list {
            width: 100%;
            box-sizing: border-box;

        }

        .panel-img-item {
            width: 33.3333%;
            height: 20vw;
            margin-bottom: 15px;
            padding: 0 5px;
            box-sizing: border-box;
            border-radius: 5px;
        }

        .panel-img-item img {
            width: 100%;
            height: 100%;
        }

        .price-tag-item {
            font-size: 14px;
            color: #999999;
        }

        .price-tag-item .price {
            width: 50px;
            text-align: right;
        }
    </style>
</head>

<body>
<div id="app" v-cloak>
    <div class="distinguish-detail">
        <div class="panel panel-dis" v-if="distinguish.display">
            <div class="panel-display">
                <div class="panel-title">陈列识别</div>
                <div class="num-list flex">
                    <div class="num-list-item flex-1 flex flex-column flex-align-items-center mr10">
                        <span class="num-text">{{distinguish.productTypeNum||0}}</span>
                        <span class="num-name">本品种类</span>
                    </div>
                    <div class="num-list-item flex-1 flex flex-column flex-align-items-center mr10">
                        <span class="num-text">{{distinguish.productNum||0}}</span>
                        <span class="num-name">本品数量</span>
                    </div>
                    <div class="num-list-item flex-1 flex flex-column flex-align-items-center">
                        <span class="num-text">{{distinguish.productCompeting||0}}</span>
                        <span class="num-name">竞品数量</span>
                    </div>
                </div>
                <div class="field-row mt10 flex flex-align-items-center">
                    <div class="field-label flex-none">POC分销率</div>
                    <div class="field-content progress-bar width0 flex-auto mh10">
                        <div class="progress-bar-active progress-bar-blue" :style="{width:distinguish.distributionRate+'%'}"></div>
                    </div>
                    <div class="field-info flex-none">
                            <span
                                    class="progress-percent progress-percent-blue mr10">{{distinguish.distributionRate||0}}</span>
                        <span v-if="distinguish.distributionResult" :class="distinguish.distributionResult=='不合格'?'tag-red':'tag-green'">{{distinguish.distributionResult}}</span>
                    </div>
                </div>
                <div class="field-row flex flex-align-items-center">
                    <div class="field-label flex-none">陈列占有率</div>
                    <div class="field-content progress-bar width0 flex-auto mh10">
                        <div class="progress-bar-active progress-bar-yellow" :style="{width:distinguish.displayRate+'%'}"></div>
                    </div>
                    <div class="field-info flex-none">
                            <span
                                    class="progress-percent progress-percent-yellow mr10">{{distinguish.displayRate||0}}</span>
                        <span v-if="distinguish.distributionResult" :class="distinguish.displayResult=='不合格'?'tag-red':'tag-green'">{{distinguish.displayResult}}</span>
                    </div>
                </div>
                <div class="field-row flex flex-align-items-center">
                    <div class="field-label flex-none">陈列类型</div>
                    <div class="field-content width0 flex-auto">
                        {{distinguish.displayType||'展柜'}}
                    </div>
                </div>
                <div class="field-row flex flex-align-items-center">
                    <div class="field-label flex-none">促销物料</div>
                    <div class="field-content width0 flex-auto">
                        {{distinguish.haveProm||"有展示"}}
                    </div>
                </div>
            </div>
            <div class="panel-bp">
                <div class="panel-title">本品</div>
                <div class="bp-list">
                    <div class="bp-item" v-for="(b,index) in distinguish.prodetails" :key="index">
                        <div v-if="b.productType=='10'">
                            <div class="field-row flex flex-align-items-center">
                                <div class="field-label flex-none">名称</div>
                                <div class="field-content width0 flex-auto mh10 text-right text-ellipsis">
                                    {{b.productName}}
                                </div>
                            </div>
                            <div class="field-row flex flex-align-items-center">
                                <div class="field-label flex-none">陈列数</div>
                                <div class="field-content width0 flex-auto pv10 text-right text-ellipsis">
                                    <span>{{b.displayNum}}</span><span class="c-green">{{'('+b.displayStandNum+')'}}</span><span
                                        class="ml20" :class="distinguish.displayResult=='不合格'?'tag-red':'tag-green'">{{b.displayResult}}</span>
                                </div>
                            </div>
                            <div class="field-row flex flex-align-items-center">
                                <div class="field-label flex-none">层数</div>
                                <div class="field-content width0 flex-auto pv10 text-right text-ellipsis">
                                    <span>{{b.layerNum}}</span><span class="c-green">{{'('+b.layerStandNum+')'}}</span><span
                                        class="ml20" :class="distinguish.layerResult=='不合格'?'tag-red':'tag-green'">{{b.layerResult}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="panel-jp">
                <div class="panel-title">竞品</div>
                <div class="jp-list">
                    <div class="jp-item" v-for="(j,index) in distinguish.prodetails" :key="index">
                        <div v-if="j.productType=='30'">
                            <div class="field-row flex flex-align-items-center">
                                <div class="field-label flex-none">名称</div>
                                <div class="field-content width0 flex-auto mh10 text-right text-ellipsis">
                                    {{j.productName}}
                                </div>
                            </div>
                            <div class="field-row flex flex-align-items-center">
                                <div class="field-label flex-none">陈列数</div>
                                <div class="field-content width0 flex-auto pv10 text-right text-ellipsis">
                                    <span>{{j.displayNum}}</span>
                                </div>
                            </div>
                            <div class="field-row flex flex-align-items-center">
                                <div class="field-label flex-none">层数</div>
                                <div class="field-content width0 flex-auto pv10 text-right text-ellipsis">
                                    <span>{{j.layerNum}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="panel-img">
                <div class="panel-title">图片</div>
                <div class="panel-img-list flex flex-align-items-center flex-wrap">
                    <div class="panel-img-item" v-for="(p,index) in distinguish.disPicList" :key="index">
                        <img :src="p" alt="">
                    </div>
                </div>
            </div>
        </div>
        <div class="panel panel-member" v-if="distinguish.person">
            <div class="panel-title">人员识别</div>
            <div class="field-row flex flex-align-items-center">
                <div class="field-label flex-none">人员数量</div>
                <div class="field-content width0 flex-auto mh10 text-right text-ellipsis">
                    {{distinguish.personNum}}
                </div>
            </div>
            <div class="panel-title">图片</div>
            <div class="panel-img-list flex flex-align-items-center flex-wrap">
                <div class="panel-img-item" v-for="(p,index) in distinguish.personPicList" :key="index">
                    <img :src="p" alt="">
                </div>
            </div>
        </div>
        <div class="panel panel-store" v-if="distinguish.terminal">
            <div class="panel-title">门头识别</div>
            <div class="field-row flex flex-align-items-center">
                <div class="field-label flex-none">门头名称</div>
                <div class="field-content width0 flex-auto mh10 text-right text-ellipsis">
                    {{distinguish.terminalName}}
                </div>
            </div>
            <div class="panel-title">图片</div>
            <div class="panel-img-list flex flex-align-items-center flex-wrap">
                <div class="panel-img-item" v-for="(p,index) in distinguish.terminalPicList" :key="index">
                    <img :src="p" alt="">
                </div>
            </div>
        </div>
        <div class="panel panel-speed" v-if="distinguish.highSpeed">
            <div class="panel-title">高速大牌识别</div>
            <div class="field-row flex flex-align-items-center">
                <div class="field-label flex-none">位置</div>
                <div class="field-content width0 flex-auto mh10 text-right text-ellipsis">
                    {{distinguish.address}}
                </div>
            </div>
            <div class="field-row flex flex-align-items-center">
                <div class="field-label flex-none">大牌状况</div>
                <div class="field-content width0 flex-auto mh10 text-right text-ellipsis">
                    {{distinguish.bigResult}}
                </div>
            </div>
            <div class="panel-title">图片</div>
            <div class="panel-img-list flex flex-align-items-center flex-wrap">
                <div class="panel-img-item" v-for="(p,index) in distinguish.bigPicList" :key="index">
                    <img :src="p" alt="">
                </div>
            </div>
        </div>
        <div class="panel panel-price" v-if="distinguish.price">
            <div class="panel-title">价签识别</div>
            <div class="price-tag-list">
                <div class="flex flex-align-items-center">
                    <div class="flex-auto">本品名称</div>
                    <div class="flex-none">价格</div>
                </div>
                <div class="price-tag-item mt10 flex flex-align-items-center"
                     v-for="(price,index) in distinguish.pricedetails" :key="index">
                    <div class="flex-auto width0 text-ellipsis">{{price.productName}}</div>
                    <div class="price flex-none">{{price.price}}</div>
                </div>
            </div>
            <div class="panel-title">图片</div>
            <div class="panel-img-list flex flex-align-items-center flex-wrap">
                <div class="panel-img-item" v-for="(p,index) in distinguish.pricePicList" :key="index">
                    <img :src="p" alt="">
                </div>
            </div>
        </div>
    </div>
</div>

<script src="/resources/sfa/js/vue.min.js"></script>
<script src="/resources/sfa/js/common.js"></script>
<script src="/resources/sfa/js/jquery.min.js"></script>

<script>
    var vm = new Vue({
        el: "#app",
        name: "",
        data: function () {
            return {
                token: "",
                id: "",
                distinguish: {
                    display:false,
                    person:false,
                    terminal:false,
                    highSpeed:false,
                    price:false,
                    prodetails:[],
                    disPicList:[],
                }
            }
        },
        created: function () {
            this.token = getParameterByName("token");
            this.id = getParameterByName("id");
            this.loadData();
        },
        methods: {
            loadData: function () {
                var this_ = this;
                $.ajax({
                    url: SERVER +
                    "/sfaapi/ai/tsTerminalController/getAICheckDetail?id="+this_.id,
                    type: "post",
                    dataType: "json",
                    headers: {
                        'loginUserToken': this_.token
                    },
                    success: function (res) {
                        if (res.success) {
                            this_.distinguish = res.obj;
                        }else{
                            showError(res.msg)
                        }
                    }
                })
            },
        }
    })
</script>
</body>

</html>