<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete" extendUrlKey="actDetailReportsMain"></t:base>
<div id="quota_list" class="easyui-layout" fit="true">
    <div region="center">
        <t:datagrid name="ttActDetaillist" controllerTarget="actDetailReportsController" methedTarget="findActDetailReports" tagConf="${clickFunctionId}" idField="id" queryMode="group" fit="true" fitColumns="false"
                    actionUrl="/pay/actDetailReportsController/findActDetailReports?clickFunctionId=${clickFunctionId}" pagination="true">
            <t:dgCol title="主键" field="id"  hidden="true"></t:dgCol>
            <t:dgCol title="扩展字段1" field="extChar1"  hidden="true" query="false"></t:dgCol>
            <t:dgCol title="扩展字段2" field="extChar2"  hidden="true" query="false"></t:dgCol>
            <t:dgCol title="扩展字段3" field="extChar3"  hidden="true" query="false"></t:dgCol>
            <t:dgCol title="扩展字段4" field="extChar4"  hidden="true" query="false"></t:dgCol>
            <t:dgCol title="扩展字段5" field="extChar5"  hidden="true" query="false"></t:dgCol>
            <t:dgCol title="活动类型" field="actType" dictionary="act_type" sortable="false" width="200"/>
            <t:dgCol title="活动编号" field="actCode" sortable="false" width="200"/>
            <t:dgCol title="活动名称" field="actName" sortable="false" width="200"/>
            <t:dgCol title="活动明细编号" field="actDetailCode" sortable="false" width="200"/>
            <t:dgCol title="申请费用金额" field="amount" sortable="false" width="80"/>
            <t:dgCol title="已核销金额" field="auditAmount" sortable="false" width="80"/>
            <t:dgCol title="支付方式" field="payType" sortable="false" width="80" dictionary="pay_type"/>
            <t:dgCol title="状态" field="auditStatus" sortable="false" width="80" dictionary="audit_status"/>
            <t:dgCol title="活动开始时间" field="beginDate" sortable="false" width="200"/>
            <t:dgCol title="活动结束时间" field="endDate" sortable="false" width="200"/>
            <t:dgCol title="活动细类" field="actSubclassName" sortable="false" width="100"/>
            <t:dgCol title="活动细类编码" field="actSubclassCode" sortable="false"  width="100"/>
            <t:dgCol title="客户" field="customerName" sortable="false" width="200"/>
            <t:dgCol title="客户编号" field="customerCode" hidden="true" sortable="false" width="200"/>
            <t:dgCol title="门店" field="terminalName" sortable="false" width="150"/>
            <t:dgCol title="门店编号" field="terminalCode"  sortable="false" width="150"/>
            <t:dgCol title="创建人" field="createName"  sortable="false" width="150"/>
            <t:dgCol title="申请人" field="applyUserName"  sortable="false" width="150"/>
            <t:dgCol title="流程编号" field="processKey"  sortable="false" width="150"/>
            <t:dgToolBar operationCode="endAudit" title="结束核销" icon="icon-enable" width="1200" height="500" url="/page/ttAuditController/goUpdateOrAdd?clickFunctionId=${clickFunctionId}"
                         funname="endAudit"></t:dgToolBar>
            <t:dgToolBar operationCode="enddepartuse" title="结束领用" icon="icon-enable" width="1200" height="500" url="/page/ttAuditController/goUpdateOrAdd?clickFunctionId=${clickFunctionId}"
                         funname="enddepartuse"></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut" excelName="费用预算" excelSheetName="费用预算"
                         url="/pay/commonExcelController/excel" funname="excelCommonExport"></t:dgToolBar>
            <t:dgToolBar operationCode="style" title="个性设置" icon="icon-add" url="/page/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500"     funname="addSelect"></t:dgToolBar>

        </t:datagrid>
    </div>
</div>

<script>
    function endAudit() {
        var rowsDatas = $('#ttActDetaillist').datagrid('getSelections');
        if(rowsDatas.length==0){
            tip("至少选择一条数据")
            return;
        }
        var actDetailCodes = new Array();
        for(var i=0;i<rowsDatas.length;i++){
            if(rowsDatas[i].auditStatus=="1"){
                tip("完全核销状态不能操作该功能");
                return;
            }
            actDetailCodes.push(rowsDatas[i].actDetailCode);
        }
        console.log(actDetailCodes)
        $.messager.confirm('操作提示', "确定结束核销？", function (r) {
            if(r) {
                $.ajax({
                    url: "/pay/actDetailReportsController/endAudit",
                    type: "post",
                    dataType: "json",
                    async: false,
                    data: JSON.stringify(actDetailCodes),
                    contentType: "application/json",
                    complete: function () {
                        closeProgressTop();
                    },
                    beforeSend: function () {
                        openProgressTop();
                    },
                    success: function (res) {
                        tip(res.msg)
                        if (res.success) {
                            ttActDetaillistsearch();
                        }
                    },
                    error: function () {
                        closeProgressTop();
                    }
                });
            }
        });
    }

    function enddepartuse() {
        var rowsDatas = $('#ttActDetaillist').datagrid('getSelections');
        if(rowsDatas.length==0){
            tip("至少选择一条数据")
            return;
        }
        var actDetailCodes = new Array();
        for(var i=0;i < rowsDatas.length;i++){
            if(rowsDatas[i].auditStatus=="1"){
                tip("完全核销状态不能操作该功能");
                return;
            }
            actDetailCodes.push(rowsDatas[i].actDetailCode);
        }

        $.messager.confirm('操作提示', "确定结束领用？", function (r) {
            if(r) {
                $.ajax({
                    url: "/pay/actDetailReportsController/enddepartuse",
                    type: "post",
                    dataType: "json",
                    async: false,
                    data: JSON.stringify(actDetailCodes),
                    contentType: "application/json",
                    complete: function () {
                        closeProgressTop();
                    },
                    beforeSend: function () {
                        openProgressTop();
                    },
                    success: function (res) {
                        tip(res.msg)
                        if (res.success) {
                            ttActDetaillistsearch();
                        }
                    },
                    error: function () {
                        closeProgressTop();
                    }
                });
            }
        });
    }
</script>
