<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools" extendUrlKey="taskDetailForm"></t:base>
<head>
    <style>
        html {
            background: #ffffff;
        }

        .classTable {
            width: 99%;
            height: auto;
            margin: 0 auto;
            table-layout: fixed;
        }
        .classTable th, .classTable td{
            word-break: break-all;
        }

        .classTable tbody tr:nth-child(even) {
            background-color: #f6f6f6;
        }

        td {
            padding-left: 5px;
            height: 35px;
        }

        th {
            background-color: #f6f6f6;
            width: 143px;
            height: 35px;
        }

        .classKeyIndicators {
            height: 30px;
            line-height: 30px;
            font-weight: bold
        }

        ._display {
            display: none;
        }

        .bolded {
            color: #345;
            /* font-weight: bold; */
            padding-left: 5px;
        }

        .formtable {
            margin-bottom: 10px;
            width: 100%;
        }

        .formtable td {
            height: 30px;
            border-collapse: collapse;
            background-color: #e8f0ff;
        }

        .formtable td.section {
            text-align: center;
            color: #345;
            font-size: 16px;
            font-weight: bold;
            height: 33px;
        }

        .formtable td.value {
            background-color: #fff;
        }

        .formtable td.approval {
            width: 20%;
            text-align: center;
        }

        .formtable td.approval div, .formtable td.approval hr {
            margin: 10px;
        }

        .data-table {
            line-height: 30px;
            text-align: center;
            width: 98%;
            margin: 10px 1%;
            background: #c8c8c8;
            border-collapse: collapse;
        }

        .data-table td {
            border: solid 1px #c8c8c8;
            border-collapse: collapse;
            border-spacing: 1px;
        }

        .data-table thead td {
            background: #ddd;
        }

        .data-table tbody td {
            background: #fff;
            word-break: break-all;
        }

        .centerdivBtn {
            text-align: center;
            line-height: 35px;
            margin: 10px 20px;
            background: #ccc;
            cursor: pointer;
        }

        .centerdivBtn:hover {
            background: #bbb;
        }

        .formtable .download td {
            padding: 0 10px;
        }

        /*业务关键指标样式*/
        .target-table {
            overflow: auto;
        }

        .target-table table {
            /*width: auto;*/
            table-layout: fixed;
            border-collapse: collapse;
            box-sizing: border-box;

        }

        .target-table table thead th {
            font-size: 14px;
            color: #000;
            text-align: center;
            height: 35px;
            line-height: 35px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
            font-weight: 600;
            border: none;
        }

        .target-table table tbody td {
            font-size: 14px;
            color: #333333;
            text-align: center;
            height: 35px;
            line-height: 35px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
            border: none;
        }

        .target-table tbody tr:nth-child(even) {
            background-color: #f6f6f6;
        }

        .target-table p {
            text-align: center;
        }
    </style>
    <script src="/resources/tools/downloadCommon.js"></script>
</head>

<div class="classKeyIndicators">业务关键指标</div>
<br/>
<div class="target-table mb10" id="targetTable">

</div>

<div class="flex flex-align-items-start flex-justify-content-between">
    <div class="flex-auto flex">
        <div class="flex-none">业务数据添加的文件：</div>
        <div class="flex-auto">
            <c:if test="${!booView }">
                <div id="uploadAttmentsFile">
                    <div class="dtci_bottom">
                        <div id="sureFilesDetail"></div>
                        <div class="flex">
                            <t:uploadH5 name="file_upload" buttonText="选择文件" onUploadSuccess="sureUpload" dialog="false"
                                        callback=""
                                        uploader="/upload/uploadController/uploadFileold?1=1" extend="*.*"
                                        id="file_upload"
                                        formData=""></t:uploadH5>
                            <div class="dtci_bottom_a ml20">
                                <a href="javascript:" class="easyui-linkbutton" plain="true" id="btn_sub"
                                   iconCls="icon-upload" onclick="upload()">确定上传</a>
                            </div>
                        </div>
                        <div id="filediv"></div>
                        <div id="returnInfo"></div>
                        <input name="fileJson" id="fileJson" hidden="hidden" value="">
                    </div>
                </div>
            </c:if>
            <c:forEach items="${attachment}" var="a">
                <div>
                    <a href="#">
                            <span>
                                    ${a.attachmentTitle }.${a.extend }&nbsp;&nbsp;
                            </span>
                    </a>
                    <span class='delpart'>
                    <c:if test="${currPositionCode eq a.positionCode && !booView}">

							   <a href="#" onclick="deleteFile(this,'${a.id}');"
                                  style="color:red; font-size:12px;">删除</a>
                    </c:if>
                    <a href="#" onclick="commonDownload('${a.fileId}');"
                       style="color:blue; font-size:12px;">下载</a>
					</span>
                </div>
            </c:forEach>
        </div>

    </div>
    <div class="flex-none flex">
        <a iconcls="icon-see" class="easyui-linkbutton l-btn" href="#" onclick="openCheckTheBusinessData()">查看业务数据</a>
        <a iconcls="icon-see" class="easyui-linkbutton l-btn" href="#" onclick="openCheckTheWorkFlowImp()">查看流程图</a>
    </div>
</div>

<div class="classKeyIndicators">审批详情</div>
<br/>
<table cellpadding="1" cellspacing="1" class="formtable">
    <tr>
        <c:if test="${isCommunicate eq 'Y'}">
            <td rowspan="2" class="bolded approval">
                <div>沟通意见：</div>
                <hr/>
                <div>沟通内容：<span style="color: #f00">${communicateContent}</span></div>
            </td>
        </c:if>
        <c:if test="${isCommunicate eq 'N'}">
            <td rowspan="2" class="bolded approval">处理意见</td>
        </c:if>
        <td class="value" style="height: 100%; padding: 10px;"><textarea
                id="comment" name="comment"
                style="width: 100%; height: 100%; min-height: 100px;"></textarea></td>
    </tr>
    <tr>
        <td class="value"><span style="float: left">
				<c:if test="${!booView }">
                    <c:if test="${nodeAuth.btn1 == 'Y'}">
						<a iconcls="icon-edit" class="easyui-linkbutton l-btn" href="#"
                           id="approval" onclick="approval()">审批通过</a>
                    </c:if>
                    <c:if test="${nodeAuth.btn2 == 'Y'}">
						<a iconcls="icon-edit"
                           class="easyui-linkbutton l-btn" href="#" id="communicate"
                           onclick="communicate()">沟通</a>
                    </c:if>
                    <c:if test="${nodeAuth.btn3 == 'Y'}">
						<a iconcls="icon-check_back"
                           class="easyui-linkbutton l-btn" href="#" id="reassign"
                           onclick="reassign()">转办</a>
                    </c:if>

                    <c:if test="${nodeAuth.btn4 == 'Y'}">
                        <a iconcls="icon-edit"
                           class="easyui-linkbutton l-btn" href="#" id="circulation"
                           onclick="circulation()">传阅</a>
                    </c:if>
                </c:if>
			    <c:if test="${isCommunicate eq 'Y' }">
                    <input type="hidden" id="communicateId" value="${communicateId}">
                    <a iconcls="icon-edit"
                       class="easyui-linkbutton l-btn" href="#" id="sureCommunicate"
                       onclick="sureCommunicate()">确认沟通</a>
                </c:if>
				<%--<c:if test="${!booView }">--%>
                    <%--<c:if test="${nodeAuth.btn5 == 'Y'}">--%>
                        <%--<a iconcls="icon-edit" class="easyui-linkbutton l-btn" href="javascript:hideNode()" id="back">意见隐藏</a>--%>
                    <%--</c:if>--%>
                <%--</c:if>--%>
		</span> <span style="float: right">
		<!-- <a iconcls="icon-putout" class="easyui-linkbutton l-btn" href="#" id="back">驳回上一人</a> -->
                <c:if test="${!booView }">
                    <c:if test="${hasRejectNodes eq true}">
                        <c:if test="${nodeAuth.btn6 == 'Y'}">
                            <label>是否返回本节点：
                                <input id="returnThisNode" name="returnThisNode" type="checkbox" value="Y"/>
                            </label>
                        </c:if>
                    </c:if>
                    <c:if test="${nodeAuth.btn7 == 'Y'}">
						<label id="couldJumpNodelb">
						<select id="couldJumpNode"
                                name="couldJumpNode">
								<option value="">---选择驳回节点---</option>
								<c:forEach items="${processNode }" var="node">
                                    <option value="${node.id }">${node.name }</option>
                                </c:forEach>
						</select></label>
                        <!-- <label id="isBackThisNodelb"><input type="checkbox" id="isBackThisNode" name="isBackThisNode" value="4"> 驳回后返回本节点</label> -->
                        <a iconcls="icon-putout" class="easyui-linkbutton l-btn" href="javascript:reject()"
                           id="back">驳回</a>
                    </c:if>
                    <c:if test="${nodeAuth.btn8 == 'Y'}">
						<a iconcls="icon-put" class="easyui-linkbutton l-btn" href="javascript:rejectToApply()"
                           id="stop">驳回发起人</a>
                    </c:if>
                </c:if>
		</span></td>
    </tr>
</table>

<div class="classKeyIndicators">其他人审批意见</div>
<br/>
<table class="classTable" cellpadding="0" cellspacing="0">
    <thead>
    <tr>
        <th class="classTd_right classTh" style="width:5%">序号</th>
        <th class="classTd_right classTh" style="width:12%">审批时间</th>
        <th class="classTd_right classTh" style="width:15%">审批人角色/职位</th>
        <th class="classTd_right classTh" style="width:8%">审批人账号</th>
        <th class="classTd_right classTh" style="width:8%">审批人姓名</th>
        <th class="classTd_right classTh" style="width:6%">审批类型</th>
        <th class="classTd_right classTh" style="width:45%">审批意见</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${log }" var="lg" varStatus="vs">
        <tr>
            <td style="text-align:center;width:5%" class="classTh">${vs.index+1 }</td>
            <td style="text-align:center;width:12%" class="classTh">${lg.createDate }</td>
            <td style="text-align:center;width:15%" class="cx classTh">${lg.roleName }</td>
            <td style="text-align:center;width:8%" class="cx classTh">${lg.account }</td>
            <td style="text-align:center;width:8%" class="cx classTh">${lg.name }</td>
            <td style="text-align:center;width:6%" class="classTh">${lg.type }</td>
                <%--<td  class="classTh"><pre style="white-space: pre-wrap;">${lg.content }</pre></td>--%>
            <td style="width:45%" class="classTh">${lg.content }</td>
        </tr>
    </c:forEach>
    </tbody>
</table>

<c:if test="${not empty includeJsp}">
    <jsp:include page="${includeJsp}" flush="true"/>
</c:if>

<script>
    //文件行index
    var file_index = 0;

    /**
     *  每个文件传输后信息数据
     * @param d --data
     * @param file file
     * @param response
     */
    function sureUpload(d, file, response) {
        var array = d.obj;
        setFileDataInfo(array);
    }

    function setFileDataInfo(datas) {
        var array = datas;
        for (var i in array) {
            createView(array[i]);
        }
    }

    function createView(obj, file, response) {
        var urlPath = obj.urlPath;
        var fileName = obj.fileName;
        var realPath = obj.realPath;
        var extend = obj.extend;
        var fileObj = {
            urlPath: urlPath,
            fileName: fileName,
            realPath: realPath,
            extend: extend
        };
        var taskId = '${taskId}';
        var processInstanceId = '${processInstanceId}';
        var businessKey = '${businessKey}';
        var fileKey = "";
        //保存上传图片到数据库
        $.ajax({
            url: "/activiti/taAttachmentController/saveFiles",
            data: {
                urlPath: urlPath,
                fileName: fileName,
                realPath: realPath,
                extend: extend,
                taskId: taskId,
                processInstanceId: processInstanceId,
                fileId: obj.id,
                businessKey: businessKey
            },
            dataType: 'json',
            type: 'post',
            async: false,
            success: function (data) {
                if (data.success) {
                    fileKey = data.attributes.fileKey;
                }
            }
        })

        var fileDivId = fileKey;
        var info =
            '<div id="' + fileDivId + '">'
            + '<span style="display: none" id=urlPath' + fileDivId + '>' + urlPath + '</span>'
            + '<span style="display: none" id=extend' + fileDivId + '>' + extend + '</span>'
            + '<a href="' + urlPath + '" download="' + fileName + '">'
            + '<span id=fileName' + fileDivId + '>' + fileName + '</span>'
            + '</a>'
            + '<span style="display: none" id=realPath' + fileDivId + '>' + realPath + '</span>'
            + '<span> <a group="del" href="javascript:;" style="color:red;" class="close" onclick="removeFileById(\'' + fileDivId + '\')">X</a></span>'
            + '<span> <a href="' + urlPath + '" style="color:blue;" download="' + fileName + '">下载</a></span>'
            + '</div>';
        $('#returnInfo').append(info);
    }

    function deleteFile(obj, fileKey) {
        $.ajax({
            url: "/activiti/taAttachmentController/delObjFile",
            dataType: "json",
            async: true,
            data: {"fileKey": fileKey},
            type: "POST",
            success: function (req) {
                if (req.success) {
                    $(obj).parent().parent().remove();
                }
            }
        });
    }

    //移除文件控件
    function removeFileById(fileKey) {
        $("#" + fileKey).remove();
        $.ajax({
            url: "/activiti/taAttachmentController/delObjFile",
            dataType: "json",
            async: true,
            data: {"fileKey": fileKey},
            type: "POST",
            success: function (req) {
                if (req.success) {
                    $(obj).parent().parent().remove();
                }
            }
        });
    }

    //去除字符串尾部空格或指定字符
    //去除字符串尾部空格或指定字符
    String.prototype.trimEnd = function (c) {
        if (c == null || c == "") {
            var str = this;
            var rg = new RegExp(c);
            var i = str.length;
            while (rg.test(str.charAt(--i))) ;
            return str.slice(0, i + 1);
        } else {
            var str = this;
            var rg = new RegExp(c);
            var i = str.length;
            while (rg.test(str.charAt(--i))) ;
            return str.slice(0, i + 1);
        }
    };
    $(function () {
        loadTarget();
        var list = document.getElementsByClassName("cx");

        for (var i = 0; i < list.length; i++) {
            var tmp = list[i].innerHTML;
            if (tmp != null && tmp != undefined) {
                tmp = tmp.toString().trimEnd(",");

                list[i].innerHTML = tmp;
            }
        }
    });
    /*===================业务关键指标================================*/
    //加载指标
    function loadTarget() {
        $.ajax({
            url: "/activiti/actTargetConfigController/getTargetConfigJson/" +${processInstanceId},
            type: "get",
            dataType: "json",
            success: function (res) {
                if (res.success) {
                    var data = res.obj;
                    renderTable("targetTable", data);
                } else {
                    $("#targetTable").html("<p>暂未设置关键指标</p>")
                }
            }
        })
    }

    //渲染表格
    function renderTable(tableId, tableData) {
        if (!tableData) {
            return false;
        } else {
            var head = tableData.head;
            var body = tableData.items;
            var _table = $("<table>");
            var _tbody = $("<tbody>");
            let totalWidth = 0;
            var htmlHeader = renderThead(head);
            $.each(body, function (index, item) {
                var _tr = $("<tr>");
                $.each(head, function (i, h) {
                    if (h.isShow == 1) {
                        var _td = $("<td>");
                        _td.text(item[h.filed]);
                        _tr.append(_td.prop("outerHTML"));
                    }
                });
                _tbody.append(_tr.prop("outerHTML"));
            });
            _table.append(htmlHeader);
            _table.append(_tbody.prop("outerHTML"));
            $("#" + tableId).html(_table.prop("outerHTML"));
            // 获取宽度，每列的宽度，根据是否超过容器分别处理
            // head.map(col => {
            //改成 $.each吧，IE浏览器中上面的写法执行不过去，导致审批不了
            $.each(head, function (index, col) {
                if (+col.isShow === 1) {
                    totalWidth += +col.width
                }
            });
            if (totalWidth < $('#targetTable').width()) {
                $('#targetTable>table').css('width', '100%');
            } else {
                $('#targetTable>table').css('width', '');
            }
        }
    }

    //渲染表格头
    function renderThead(head) {
        var _thead = $("<thead>");
        var _tr = $("<tr>");
        $.each(head, function (index, item) {
            if (item.isShow == 1) {
                var _th = $("<th>");
                _th.text(item.name);
                _th.css("width", item.width);
                _th.attr("filed", item.filed);
                _tr.append(_th.prop("outerHTML"));
            }
        });
        _thead.append(_tr.prop("outerHTML"));
        return _thead.prop("outerHTML");
    }


    function _displayShow() {
        $("#booView").hide();
        $("._display").show();
    }

    function _displayHide() {
        $("#booView").show();
        $("._display").hide();
    }

    /*===================查看业务数据star================================*/
    var openCheckTheBusParams = {
        exeTheFun: defaultOpenCheckTheBusinessData
    };

    function initTheOpenCheckTheBusParams(obj) {

        if (!checkIsNotUndefinedAndNullAndNullValue(obj)) {
            return;
        }

        if (typeof (obj) != "object") {
            tip('请用object类型传输初始化参数');
            return;
        }

        for (var name in obj) {
            openCheckTheBusParams[name] = obj[name];
        }
    }

    function defaultOpenCheckTheBusinessData() {
        var b = "";
        if (document.getElementById("approval") ||
            document.getElementById("reassign") ||
            document.getElementById("circulation") ||
            document.getElementById("communicate") ||
            document.getElementById("sureCommunicate") ||
            document.getElementById("back") ||
            document.getElementById("returnThisNode")
        ) {
            b = "1";
        }
        createwindowExt(
            '业务数据展示',
            '/page/taTaskController/goTaskBusinessForm?taskId=${taskId}&processInstanceId=${processInstanceId }&&isdetail=' + b,
            "", "", {
                lock: true,
                parent: windowapi,
                zIndex: 11000,
                width: 1200,
                height: 500,
                button: [{
                    name: '取消',
                    callback: function () {
                    }
                }]
            }
        );
    }

    function openCheckTheBusinessData() {
        //openwindow("业务数据展示",'taTaskController.do?goTaskBusinessForm&taskId=${taskId }&processInstanceId=${processInstanceId }',null,1200,500);
        openCheckTheBusParams.exeTheFun();
    }

    /*===================查看业务数据end================================*/

    /*===================查看附件数据star================================*/
    function openCheckTheBusinessFile() {
        var extendServiceFlag = '${extendServiceFlag}';
        if (extendServiceFlag) {
            var url = "/page/tbAttachmentController/goTbAttachmentWorkFlowMain&taskId=" + '${taskId}'
                + "&extendService=tbAttachmentExtendsActService&processInstanceId=" + '${processInstanceId }';
            createwindowExt('查看附件数据', url, null, null, {
                ok: false,
                cancelVal: '关闭',
                cancel: true
            });
        } else {
            tip("ttActAndAuditBillMainExtendService方法未实现!");
        }
    }

    /*===================查看附件数据end================================*/


    function circulation() {
        var processInstanceId = '${processInstanceId }';
        var targetUrl = '/page/taCarbonCopyController/goAddCirculationMain?processInstanceId='
            + processInstanceId;
        //弹出窗口
        createwindowExt('传阅', targetUrl, "", "", {
            lock: true,
            parent: windowapi,
            zIndex: 5000,
            width: 1000,
            height: 600,
            button: [
                {
                    name: '确定',
                    callback: function () {
                        //回调事件
                        iframe = this.iframe.contentWindow;
                        var rowsData = iframe.$('#sendCopyList').datagrid(
                            'getRows');
                        var content = iframe.$('#content').val();
                        var codes = [];
                        var names = [];
                        var fullNames = [];
                        for (var i = 0; i < rowsData.length; i++) {
                            codes.push(rowsData[i].positionCode);
                            names.push(rowsData[i].positionName);
                            fullNames.push(rowsData[i].fullname);
                        }
                        var result = callAjax(codes, names, fullNames, content, iframe);
                        return result;
                    },
                    focus: true
                }, {
                    name: '取消',
                    callback: function () {
                    }
                }]
        });
    }

    function communicate() {
        var taskId = '${taskId }';
        var targetUrl = '/page/taCommunicateController/goAddCommunicateMain?taskId='
            + taskId;
        //弹出窗口
        createwindowExt('沟通', targetUrl, "", "", {
            lock: true,
            parent: windowapi,
            zIndex: 5000,
            width: 1000,
            height: 600,
            button: [
                {
                    name: '确定',
                    callback: function () {
                        //回调事件
                        iframe = this.iframe.contentWindow;
                        var rowsData = iframe.$('#sendCommunicateList').datagrid(
                            'getRows');
                        var content = iframe.$('#content').val();
                        if (content == "" || content == null
                            || content == undefined) {
                            top.tip("请填写沟通内容");
                            return false;
                        }
                        var forceReplyFlag = iframe.$('#forceReplyFlag').val();
                        var codes = [];
                        var names = [];
                        var fullNames = [];
                        for (var i = 0; i < rowsData.length; i++) {
                            codes.push(rowsData[i].positionCode);
                            names.push(rowsData[i].positionName);
                            fullNames.push(rowsData[i].fullname);
                        }
                        var result = callCommunicateAjax(codes, names, fullNames, content, forceReplyFlag, iframe);
                        return result;
                    },
                    focus: true
                }, {
                    name: '取消',
                    callback: function () {
                    }
                }]
        });
    }

    //转办
    function reassign() {
        var taskId = '${taskId }';
        var targetUrl = '/page/taTaskController/goReassignForm?taskId='
            + taskId;
        //弹出窗口
        createwindowExt('转办', targetUrl, "", "", {
            lock: true,
            width: 420,
            height: 300,
            zIndex: 2000,
            parent: 'reassignForm',
            button: [
                {
                    name: '确定',
                    callback: function () {
                        iframe = this.iframe.contentWindow;

                        var positionId = iframe.$('#id').val();
                        var reassignComment = iframe.$('#reassignComment').val();

                        if (positionId == "" || positionId == null
                            || positionId == undefined) {
                            iframe.tip("请选择转办人");
                            return false;
                        }

                        if (reassignComment == "" || reassignComment == null
                            || reassignComment == undefined) {
                            iframe.tip("请填写转办内容");
                            return false;
                        }

                        var flag = callReassignAjax(positionId, reassignComment);

                        return flag;
                    },
                    focus: true
                }, {
                    name: '取消',
                    callback: function () {
                    }
                }]
        });
    }

    function callReassignAjax(positionId, reassignComment) {
        var taskId = '${taskId}';
        var flag = true;

        window.top.$.messager.progress({
            text: "处理中...",
            interval: 200
        });

        $.ajax({
            url: "/activiti/taTaskController/reassign",
            type: "post",
            data: {
                taskId: taskId,
                id: positionId,
                reassignComment: reassignComment
            },
            success: function (data) {
                window.top.$.messager.progress('close');
                if (data.success) {
                    if (typeof (parent.windowapi.opener.handleSearch) != "undefined")
                        parent.windowapi.opener.handleSearch();
                    if (typeof (parent.windowapi.opener.copySearch) != "undefined")
                        parent.windowapi.opener.copySearch();
                    if (typeof (parent.windowapi.opener.rejectSearch) != "undefined")
                        parent.windowapi.opener.rejectSearch();
                    if (typeof (parent.windowapi.opener.initAllTable) != "undefined")
                        parent.windowapi.opener.initAllTable();
                    parent.windowapi.opener.$("#myTaskList").datagrid("reload");

                    if (typeof (parent.windowapi.opener.tip) != "undefined")
                        parent.windowapi.opener.tip(data.msg);

                    parent.windowapi.close();
                } else {
                    tip(data.msg);
                    return false;
                }
            }
        });

        return false;
    }

    function sureCommunicate() {
        var communicateId = $("#communicateId").val();
        var comment = $("#comment").val();
        if (comment == "" || comment == null || comment == undefined) {
            tip("请填写意见");
            return;
        }
        $.ajax({
            url: '/activiti/taCommunicateController/saveSureCommunicate?communicateId=' + communicateId,
            type: "post",
            data: {content: comment},
            async: false,
            success: function (d) {
                if (d.success) {
                    var msg = d.msg;
                    top.tip(msg);
                    if (typeof (parent.windowapi.opener.handleSearch) != "undefined")
                        parent.windowapi.opener.handleSearch();
                    if (typeof (parent.windowapi.opener.copySearch) != "undefined")
                        parent.windowapi.opener.copySearch();
                    if (typeof (parent.windowapi.opener.rejectSearch) != "undefined")
                        parent.windowapi.opener.rejectSearch();
                    if (typeof (parent.windowapi.opener.initAllTable) != "undefined")
                        parent.windowapi.opener.initAllTable();
                    parent.windowapi.opener.$("#myTaskList").datagrid(
                        "reload");
                    parent.windowapi.close();
                } else {
                    tip(msg);
                }
            }
        });
    }

    function callAjax(codes, names, fullNames, content, iframe) {
        var processInstanceId = '${processInstanceId}';
        var flag = true;
        $.ajax({
            url: "/activiti/taCarbonCopyController/saveCirculation",
            type: "post",
            data: {
                codes: codes.join(','),
                names: names.join(','),
                fullNames: fullNames.join(','),
                content: content,
                processInstanceId: processInstanceId
            }, async: false,
            success: function (d) {
                var msg = d.msg;
                if (d.success) {
                    tip(msg);
                    if (typeof (parent.windowapi.opener.handleSearch) != "undefined") parent.windowapi.opener.handleSearch();
                    if (typeof (parent.windowapi.opener.copySearch) != "undefined") parent.windowapi.opener.copySearch();
                    if (typeof (parent.windowapi.opener.rejectSearch) != "undefined") parent.windowapi.opener.rejectSearch();
                    if (typeof (parent.windowapi.opener.initAllTable) != "undefined") parent.windowapi.opener.initAllTable();
                    parent.windowapi.opener.$("#useSendCopyList").datagrid("reload");
//                    parent.windowapi.close();
                } else {
                    iframe.tip(msg);
                    flag = false;
                }
            }
        });
        return flag;
    }

    function callCommunicateAjax(codes, names, fullNames, content, forceReplyFlag, iframe) {
        var taskId = '${taskId}';
        var flag = true;
        $.ajax({
            url: "/activiti/taCommunicateController/saveCommunicate",
            type: "post",
            data: {
                codes: codes.join(','),
                names: names.join(','),
                fullNames: fullNames.join(','),
                content: content,
                forceReplyFlag: forceReplyFlag,
                taskId: taskId
            }, async: false,
            success: function (d) {
                var msg = d.msg;
                if (d.success) {
                    tip(msg);
                    window.location.reload();
//                    parent.windowapi.close();
                } else {
                    iframe.tip(msg);
                    flag = false;
                }
            }
        });
        return flag;
    }

    function approval() {
        var taskId = '${taskId}';
        var comment = $("#comment").val();
        if (comment == "" || comment == null || comment == undefined) {
            //tip("请填写意见");
            //return;
            comment = "同意";
        }
        var processInstanceId = '${processInstanceId}';
        var formData = {
            taskId: taskId,
            comment: comment,
            processInstanceId: processInstanceId
        };
        openProgressTop("处理中.......");
        $.ajax({
            cache: false,
            type: 'POST',
            data: formData,
            datatype: 'json',
            url: "/activiti/taTaskController/saveComplete",// 请求的action路径
            error: function () {// 请求失败处理函数
                closeProgressTop();
            },
            success: function (data) {
                closeProgressTop();
                if (data.success) {
                    if (typeof (parent.windowapi.opener.handleSearch) != "undefined")
                        parent.windowapi.opener.handleSearch();
                    if (typeof (parent.windowapi.opener.copySearch) != "undefined")
                        parent.windowapi.opener.copySearch();
                    if (typeof (parent.windowapi.opener.rejectSearch) != "undefined")
                        parent.windowapi.opener.rejectSearch();
                    if (typeof (parent.windowapi.opener.initAllTable) != "undefined")
                        parent.windowapi.opener.initAllTable();
                    parent.windowapi.opener.$("#myTaskList").datagrid("reload");

                    if (typeof (parent.windowapi.opener.tip) != "undefined")
                        parent.windowapi.opener.tip(data.msg);

                    parent.windowapi.close();
                } else {
                    tip(data.msg);
                    return false;
                }
            }
        });
    }

    //驳回任意节点
    function reject() {
        var taskId = '${taskId}';//任务id
        var comment = $("#comment").val();//审批意见
        var returnThisNode = $("input:checkbox:checked").val();
        var node = $("#couldJumpNode").val();
        if (comment == "" || comment == null || comment == undefined) {
            tip("请填写意见");
            return;
        }
        if (node == "" || node == null || comment == node) {
            tip("请选择驳回节点");
            return;
        }

        var processInstanceId = '${processInstanceId}';
        var formData = {
            taskId: taskId,
            comment: comment,
            processInstanceId: processInstanceId,
            taskDefKey: node,
            returnThisNode: (returnThisNode == undefined || returnThisNode == "" || returnThisNode == null) ? "N" : returnThisNode
        };
        $.ajax({
            type: "post",
            data: formData,
            url: "/activiti/taTaskController/saveReject",
            error: function () {
            },
            success: function (d) {
                if (d.success) {
                    var msg = d.msg;
                    top.tip(msg);
                    if (typeof (parent.windowapi.opener.handleSearch) != "undefined")
                        parent.windowapi.opener.handleSearch();
                    if (typeof (parent.windowapi.opener.copySearch) != "undefined")
                        parent.windowapi.opener.copySearch();
                    if (typeof (parent.windowapi.opener.rejectSearch) != "undefined")
                        parent.windowapi.opener.rejectSearch();
                    if (typeof (parent.windowapi.opener.initAllTable) != "undefined")
                        parent.windowapi.opener.initAllTable();
                    parent.windowapi.opener.$("#myTaskList").datagrid(
                        "reload");
                    parent.windowapi.close();
                } else {
                    tip(d.msg);
                }
            }
        });
    }

    function rejectToApply(state) {
        var taskId = '${taskId}';//任务id
        var comment = $("#comment").val();//审批意见
        if (comment == "" || comment == null || comment == undefined) {
            tip("请填写意见");
            return;
        }
        var processInstanceId = '${processInstanceId}';
        var formData = {
            taskId: taskId,
            comment: comment,
            processInstanceId: processInstanceId
        };
        openProgressTop("正在驳回处理……");
        $.ajax({
            type: "post",
            data: formData,
            url: "/activiti/taTaskController/saveRejectToApply",
            dataType: 'json',
            error: function () {
            },
            success: function (data) {
                closeProgressTop();
                if (data.success) {
                    var msg = data.msg;
                    top.tip(msg);
                    if (typeof (parent.windowapi.opener.handleSearch) != "undefined")
                        parent.windowapi.opener.handleSearch();
                    if (typeof (parent.windowapi.opener.copySearch) != "undefined")
                        parent.windowapi.opener.copySearch();
                    if (typeof (parent.windowapi.opener.rejectSearch) != "undefined")
                        parent.windowapi.opener.rejectSearch();
                    if (typeof (parent.windowapi.opener.initAllTable) != "undefined")
                        parent.windowapi.opener.initAllTable();
                    parent.windowapi.opener.$("#myTaskList").datagrid(
                        "reload");
                    parent.windowapi.close();
                } else {
                    tip(data.msg);
                }
            }
        });
    }

    /*===================查看流程图star================================*/
    function openCheckTheWorkFlowImp() {
        //openwindow("流程图",'taProcessInstanceController.do?goProcessPicInfoForm&view=${view }&processInstanceId=${processInstanceId }',null,1200,300);
        createwindowExt(
            '流程图',
            '/page/taProcessInstanceController/goProcessPicInfoForm?isView=${booView }&processInstanceId=${processInstanceId }',
            "", "", {
                lock: true,
                parent: windowapi,
                zIndex: 9000,
                width: 1200,
                height: 500,
                button: [{
                    name: '取消',
                    callback: function () {
                    }
                }]
            });
    }

    /*===================查看流程图end================================*/

    //跳转隐藏页面配置项
    function hideNode() {
        var processInstanceId = '${processInstanceId}';
        var taskId = '${taskId}';
        createwindowExt(
            '配置',
            '/page/taHideNodeController/goTaHidenNodeConfigMain?processInstanceId=' + processInstanceId + "&taskId=" + taskId,
            "", "", {
                lock: true,
                parent: windowapi,
                zIndex: 9000,
                width: 1200,
                height: 500,
                button: [
                    {
                        name: '确定',
                        callback: function () {
                            iframe = this.iframe.contentWindow;
                            var trs = iframe.$("#ttSplitCostTerminalList").find("tr");
                            var hideNode = [];
                            var hideName = [];
                            $.each(trs, function (i, k) {
                                var isCheck = $(this).find("input[type=checkbox]").is(':checked');
                                if (isCheck == true) {
                                    var toHideNodes = $(this).find("td[name='pnc']").text();
                                    var toHideNames = $(this).find("td[name='pnn']").text();
                                    hideNode.push(toHideNodes);
                                    hideName.push(toHideNames);
                                }
                            });
                            var isCopyCir = iframe.$("#isCopyCir").is(":checked");
                            var isCommunicate = iframe.$("#isCommunicate").is(":checked");
                            var url = "${activitiRoot}taHideNodeController/saveHideNode";
                            $.ajax({
                                url: url,
                                type: "post",
                                data: {
                                    toHiddenNodeCodes: hideNode.join(","),
                                    toHiddenNodeNames: hideName.join(","),
                                    isCopyCir: isCopyCir == false ? "0" : "1",
                                    isCommunicate: isCommunicate == false ? "0" : "1",
                                    processInstanceId: processInstanceId,
                                    taskId: taskId
                                }, success: function (data) {
                                    var d = $.parseJSON(data);
                                    tip(d.msg);
                                }
                            });
                        }
                    },
                    {
                        name: '取消',
                        callback: function () {
                        }
                    }]
            });
    }
</script>
