<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <title>预算变更</title>
    <t:base type="jquery,easyui,tools" extendUrlKey="feeBudgetAdjustAmount"></t:base>
    <style>
        input[readonly]{
            background: #efefef;
        }
    </style>
</head>
<body class="easyui-layout" fit="true">
<div data-options="region:'west',title:'调出方',split:true" style="width:400px;">
    <t:formvalid action="" layout="div"  dialog="true" formid="fiscalForm" >
        <t:dgFormList>
            <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                            defaultVal="${vo.id }"/>
            <t:dgFormColumn field="budgetCode" hidden="false" dataType="*"  formClass="form"
                            defaultVal="${vo.budgetCode}" readOnly="true"
                            labelName="预算编码" optionType="input" required="true" />
            <t:dgFormColumn field="subjectsGroupName" hidden="false"   formClass="form"
                            defaultVal="${vo.subjectsGroupName}" readOnly="true"
                            labelName="分组" optionType="input" required="false" />
            <t:dgFormColumn field="budgetYear" hidden="false" formClass="form" labelName="年份" optionType="input" required="true"
                            defaultVal="${vo.budgetYear}" readOnly="true"/>
            <t:dgFormColumn field="budgetMonth" hidden="false" dataType="*" typeGroupCode="month" formClass="form"
                            defaultVal="${vo.budgetMonth}" readOnly="true"
                            labelName="月份" optionType="select" required="true" />
            <t:dgFormColumn field="budgetDepartId" hidden="true" dataType="*"  formClass="form"
                            defaultVal="${vo.budgetDepartId}" readOnly="true"
                            labelName="组织" optionType="input" required="false" />
            <t:dgFormColumn field="budgetDepartName" hidden="false"   formClass="form"
                            defaultVal="${vo.budgetDepartName}" readOnly="true"
                            labelName="组织" optionType="input" required="false" />
            <t:dgFormColumn field="budgetSubjectsCode" hidden="true"   formClass="form"
                            defaultVal="${vo.budgetSubjectsCode}" readOnly="true"
                            labelName="科目编码" optionType="input" required="false" />
            <t:dgFormColumn field="budgetSubjectsName" hidden="false" formClass="form" labelName="科目" optionType="input" required="true"
                            defaultVal="${vo.budgetSubjectsName}" readOnly="true" />
            <t:dgFormColumn field="vkorgName" hidden="false"  formClass="form"
                            defaultVal="${vo.vkorgName}" readOnly="true"
                            labelName="渠道" optionType="input" required="false" />
            <t:dgFormColumn field="productName" hidden="false" readOnly="true" formClass="form" labelName="物料" optionType="input" required="false"
                            defaultVal="${vo.productName}"/>
            <t:dgFormColumn field="custCode" hidden="true" formClass="form" labelName="客户编码" optionType="input" required="true"
                            defaultVal="${vo.custCode}" readOnly="true"/>
            <t:dgFormColumn field="custName" hidden="false" formClass="form" readOnly="true" labelName="客户" optionType="input" required="true"
                            defaultVal="${vo.custName}" />
            <t:dgFormColumn field="initAmount" hidden="false"   formClass="form"
                            defaultVal="${vo.initAmount}" readOnly="true"
                            labelName="期初金额" optionType="input"  required="false" />
            <t:dgFormColumn field="amount" hidden="false"   formClass="form"
                            defaultVal="${vo.amount}" readOnly="true"
                            labelName="可用余额" optionType="input"  required="false" />
            <t:dgFormColumn field="amountUpdate" hidden="false"   formClass="form" readOnly="false"
                            labelName="调出金额" optionType="input" dataType="/^(([1-9][0-9]*)|(([0]\.\d{1,2}|[1-9][0-9]*\.\d{1,2})))$/" required="true" />
            <t:dgFormColumn field="afterAmount" hidden="false"   formClass="form" readOnly="true"
                            labelName="调出后金额" optionType="input"  required="false" />
            <t:dgFormColumn field="notes" hidden="false" formClass="form" labelName="调出说明" required="false"
                            defaultVal="${vo.notes}" optionType="textarea" rows="2" cols="50"/>
        </t:dgFormList>
    </t:formvalid>
</div>
<div data-options="region:'center',title:'调入方'" style="padding:5px;">
    <input id="id_1" type="hidden" value="" >
    <t:formvalid action="" layout="div"  dialog="true" formid="budgetForm1">
        <t:dgFormList>
            <t:dgFormColumn field="budgetCode_1" hidden="false"   formClass="form"
                            readOnly="true"
                            labelName="预算编码" optionType="choseDialog" required="true" onclick="choseFeeBuget();"/>
            <t:dgFormColumn field="subjectsGroupName_1" hidden="true"   formClass="form"
                             readOnly="true"
                            labelName="分组" optionType="input" required="false" />
            <t:dgFormColumn field="budgetYear_1" hidden="true" formClass="form" labelName="年份" optionType="input" required="false"
                             readOnly="true"/>
            <t:dgFormColumn field="budgetMonth_1" hidden="true"  typeGroupCode="month" formClass="form"
                             readOnly="true"
                            labelName="月份" optionType="select" required="false" />
            <t:dgFormColumn field="budgetDepartName_1" hidden="true"   formClass="form"
                            readOnly="true"
                            labelName="组织" optionType="input" required="false" />
            <t:dgFormColumn field="budgetSubjectsCode_1" hidden="true"   formClass="form"
                             readOnly="true"
                            labelName="科目编码" optionType="input" required="false" />
            <t:dgFormColumn field="budgetSubjectsName_1" hidden="true" formClass="form" labelName="科目" optionType="input" required="false"
                             readOnly="true" />
            <t:dgFormColumn field="vkorgName_1" hidden="true"  formClass="form"
                             readOnly="true"
                            labelName="渠道" optionType="input" required="false" />
            <t:dgFormColumn field="productName_1" hidden="true" readOnly="true" formClass="form" labelName="物料" optionType="input" required="false"
                            />
            <t:dgFormColumn field="custCode_1" hidden="true" formClass="form" labelName="客户编码" optionType="input" required="false"
                             readOnly="true"/>
            <t:dgFormColumn field="custName_1" hidden="true" formClass="form" readOnly="true" labelName="客户" optionType="input" required="false"
                            defaultVal="${vo.custName}" />
            <t:dgFormColumn field="initAmount_1" hidden="true"   formClass="form"
                             readOnly="true"
                            labelName="期初金额" optionType="input"  required="false" />
            <t:dgFormColumn field="amount_1" hidden="true"   formClass="form"
                             readOnly="true"
                            labelName="可用余额" optionType="input"  required="false" />
            <t:dgFormColumn field="amount_2" hidden="true"   formClass="form"
                            readOnly="true"
                            labelName="调入后余额" optionType="input"  required="false" />

        </t:dgFormList>
    </t:formvalid>
</div>
<script>
    $("#budgetMonth").attr("disabled","disabled");
    $("#budgetMonth_1").attr("disabled","disabled");
    function  removeHidden(id) {
        $("#"+id).find("[class*=hidden]").removeClass("hidden");
    }

    $("#amountUpdate").bind('input propertychange',function () {
        //调出金额
        var amountUpdate = $("#amountUpdate").val();
        //调出方可用余额
        var amount = $("#amount").val();
        //调出后金额=可用金额-调出金额
        var afterAmount = accSub(amount,amountUpdate);
        $("#afterAmount").val(afterAmount);
        //调入方可用余额
        var amount_1 = $("#amount_1").val();
        //调入后余额=可用余额+调出方的调出余额
        var amount_2 = numAdd(amount_1,amountUpdate);
        $("#amount_2").val(amount_2);
    })

    /** 选择费用预算 */
    function choseFeeBuget(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId){
        url = "/page/ttApiBudgetController/goSelectMain";
        width = 1000;
        height = 450;
        id = "feeBudgetSelectList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            parent:'bugetSelectId',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请选择一条数据");
                        return false;
                    }
                } else {
                    var myobj=eval(rowsData);
                    $("#id_1").val(myobj[0].id);
                    $("#budgetCode_1").val(myobj[0].budgetCode);
                    $("#subjectsGroupName_1").val(myobj[0].subjectsGroupName);
                    $("#budgetYear_1").val(myobj[0].budgetYear);
                    $("#budgetMonth_1").val(myobj[0].budgetMonth);
                    $("#budgetDepartName_1").val(myobj[0].budgetDepartName);
                    $("#budgetSubjectsCode_1").val(myobj[0].budgetSubjectsCode);
                    $("#budgetSubjectsName_1").val(myobj[0].budgetSubjectsName);
                    $("#vkorgName_1").val(myobj[0].vkorgName);
                    $("#productName_1").val(myobj[0].productName);
                    $("#custCode_1").val(myobj[0].custCode);
                    $("#custName_1").val(myobj[0].custName);
                    $("#initAmount_1").val(myobj[0].initAmount);
                    $("#amount_1").val(myobj[0].amount);;
                    $("#amount_2").val(myobj[0].amount);
                    removeHidden("budgetForm1");
                    $('#amountUpdate').trigger("propertychange");
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /**
     * 重写保存提交方法
     */
    function saveData() {
        var  srcId = $("#id").val();
        var  tarId = $("#id_1").val();
        var  amountUpdate = $("#amountUpdate").val();
        var  notes = $("#notes").val();
        var reg=/^(([1-9][0-9]*)|(([0]\.\d{1,2}|[1-9][0-9]*\.\d{1,2})))$/
        if (!reg.test(amountUpdate)){
            tip("请输入大于0的数据");
            return;
        }
        if($.trim(tarId).length==0){
            tip("请选择调入方预算");
            return;
        }
        var dataPram = {
            srcId:srcId,
            tarId:tarId,
            amountUpdate:amountUpdate,
            notes:notes
        };

        if(typeof saveDataBefore != 'undefined'){
            if(!eval('saveDataBefore();')){
                return false;
            }
        }

        $.ajax({
            type: "POST",
            url: "/budget/ttFeeBudgetController/adjustAmount",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(dataPram),
            success: function(data){
                var api = frameElement.api, W = api.opener;
                if (data.success) {
                    W.tip(data.msg);
                    W.fiscalListsearch();
                    api.close();
                }else{
                    tip(data.msg);
                }
            }
        });
    }

    //加法
    function numAdd(num1, num2) {
        var baseNum, baseNum1, baseNum2;
        try {
            baseNum1 = num1.toString().split(".")[1].length;
        } catch (e) {
            baseNum1 = 0;
        }
        try {
            baseNum2 = num2.toString().split(".")[1].length;
        } catch (e) {
            baseNum2 = 0;
        }
        baseNum = Math.pow(10, Math.max(baseNum1, baseNum2));
        return (num1 * baseNum + num2 * baseNum) / baseNum;
    };

    //减法
    function accSub(arg1, arg2) {
        var r1, r2, m, n;
        try { r1 = arg1.toString().split(".")[1].length } catch (e) { r1 = 0}
        try { r2 = arg2.toString().split(".")[1].length } catch (e) { r2 = 0}
        m = Math.pow(10, Math.max(r1, r2));
        n = (r1 >= r2) ? r1 : r2;
        return ((arg1 * m - arg2 * m) / m).toFixed(n);
    }
</script>
</body>

</html>