<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div  class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="productLevelList"  title="产品层级管理" idField="id"
                    queryMode="group"  fit="true" fitColumns="true"   singleSelect="true"
                    actionUrl="/mdm-api/mdmApi/productLevelApiCotroller/findProductListByPage" pagination="true" onLoadSuccess="findProductList" onClick="findProductList">
            <t:dgCol title="主键" field="id" treefield="id" hidden="true"></t:dgCol>
            <t:dgCol title="产品层级编码" field="productCode"  query="true"></t:dgCol>
            <t:dgCol title="产品层级名称" field="productName"  query="true"></t:dgCol>
        </t:datagrid>
    </div>
    <div data-options="region:'east',split:true" style="width:650px;">
        <t:datagrid name="productList"  title="商品信息" idField="id"
                    queryMode="group"  fit="true" fitColumns="true"  singleSelect="true" autoLoadData="false"
                    actionUrl="/mdm-api/mdmApi/tmWareInfoApiController/findTmWareInfoPageByCode" pagination="true">
            <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="商品编码" field="wareCode" query="true"></t:dgCol>
            <t:dgCol title="商品名称" field="wareName" query="true"></t:dgCol>
            <t:dgCol title="条形编码" field="barCode" query="true"></t:dgCol>
            <t:dgCol title="产品层级编码" field="productLevelCode" hidden="true"></t:dgCol>
            <t:dgCol title="产品层级名称" field="productLevelName" hidden="true"></t:dgCol>
            <t:dgCol title="销售单位" field="saleUnit" dictionary="sale_unit" query="true"></t:dgCol>
            <t:dgCol title="计量单位" field="meterUnit" dictionary="meter_unit" query="true"></t:dgCol>
            <t:dgCol title="规格" field="specification" query="true"></t:dgCol>
        </t:datagrid>
    </div>
</div>

<script>
    function findProductList() {
        var productCode = "";
        var leveList = $('#productLevelList').datagrid('getSelections');
        if(leveList.length>0){
            productCode = leveList[0].productCode;
        }
        var options = {
            url:'/mdm-api/mdmApi/tmWareInfoApiController/findTmWareInfoPageByCode',
            queryParams:{
                code:productCode
            }
        };
        $('#productList').datagrid(options);
    }
    
    function getData() {
        var leveList = $('#productLevelList').datagrid('getSelections');
        if(leveList.length==0){
            return null;
        }
        var dataArr = new Array();
        var data = {};
        data.productLevel = leveList[0].productCode;
        data.productLevelName = leveList[0].productName;
        data.accountProductCode = '';
        data.accountProductName = '';
        var productList = $('#productList').datagrid('getSelections');
        if(productList.length>0){
            data.accountProductCode = productList[0].wareCode;
            data.accountProductName = productList[0].wareName;
        }
        dataArr.push(data);
        return dataArr;
    }
</script>

