<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
<div id="collectioninfo_list" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="collectioninfoList" tagConf="${clickFunctionId}" controllerTarget="ttCollectionInfoController" methedTarget="getMaiListPage" idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/budget/ttCollectionInfoController/getMaiListPage" pagination="true">
            <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="编码" field="code" query="true"></t:dgCol>
            <t:dgCol title="名称" field="name" query="true" ></t:dgCol>
            <t:dgCol title="描述" field="remarks" ></t:dgCol>
            <t:dgCol title="创建人" field="createName"></t:dgCol>
            <t:dgCol title="创建时间" field="createDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
            <t:dgCol title="最近更新人" field="updateName" treefield="updateName"></t:dgCol>
            <t:dgCol title="最近更新时间" field="updateDate" treefield="updateDate" formatter="yyyy-MM-dd"></t:dgCol>

            <t:dgToolBar title="添加" operationCode="add" icon="icon-add" url="/page/ttCollectionInfoController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="add" height="450" width="500"></t:dgToolBar>
            <t:dgToolBar title="修改" operationCode="edit" icon="icon-edit" url="/page/ttCollectionInfoController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="update" height="450" width="500"></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look" icon="icon-look" url="/page/ttCollectionInfoController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="detail" height="450" width="500"></t:dgToolBar>
            <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="/budget/ttCollectionInfoController/delete"
                         funname="deleteALLSelect"></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut"
                         url="/budget/commonExcelController/excel" excelName="采集资料" excelSheetName="采集资料" funname="excelCommonExport"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="/page/knlLogController/goShowLog"
                         width="1000" height="500" funname="update"></t:dgToolBar>
            <t:dgToolBar title="个性设置" operationCode="style" icon="icon-add" url="/page/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500"     funname="addSelect"></t:dgToolBar>
            <%--<t:dgToolBar title="示例" operationCode="file" onclick="budgetFile()" url="" icon="icon-attach"></t:dgToolBar>--%>
        </t:datagrid>
    </div>
</div>
<script src="/resources/act/attachment/js/attachment.js"></script>

<script>
    function budgetFile() {
        var row = $("#collectioninfoList").datagrid('getSelections');
        if (row.length==0 ) {
            tip("请至少选择一条数据");
        }else{
            addBudgetAttach(row[0].id);
        }
    }
</script>