<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>

<body>
<div class="easyui-layout" fit="true">
    <div region="center" style="width:300px;">
        <div tools="#tt" class="easyui-panel" style="" fit="true" border="false" id="function-panel">
            <t:datagrid name="sendCopyList" title="已选项" actionUrl="" autoLoadData="false" checkbox="false" idField=""
                 fit="true" fitColumns="true" queryMode="group" pagination="false" singleSelect="false">
                <t:dgCol title="角色/职位编码" field="code" width="100"></t:dgCol>
                <t:dgCol title="角色/职位名称" field="name" width="110"></t:dgCol>
                <t:dgCol title="类型" field="state" replace="角色_0,职位_1"></t:dgCol>
                <t:dgCol title="过滤条件" field="chooseCondition" replace="职位_0,当前组织_1,组织及组织以上_2,角色下所有职位_3"></t:dgCol>
                <t:dgToolBar title="移除" icon="icon-remove" url="" funname="delCC"></t:dgToolBar>
                <t:dgToolBar title="提交抄送" icon="icon-save" url="" funname="commitList"></t:dgToolBar>
            </t:datagrid>

        </div>
    </div>
    <div region="west" style="width:380px;" split="true">
        <div id="useSendCopyListtb">

            <div class="datagrid-toolbar-but">
				<span style="float:left;">
                    <a href="#" id="addXpsact" class="easyui-linkbutton" plain="true" icon="icon-add"
                       onclick="saveSendCopyList()">添加</a>
				</span>
                <span style="float: right;">
                    <a href="#" id="addXpsact" class="easyui-linkbutton" icon="icon-search" onclick="loadData()">查询</a>
                    <a href="#" id="addXpsact" class="easyui-linkbutton" icon="icon-search"
                       onclick="resetQuery()">重置</a>
                </span>
            </div>
            <div class="datagrid-toolbar-search">
                <form id="useSendCopyListForm">
                    <div>
                        <label>抄送类型</label>
                        <select name="sendType" title="抄送类型" onchange="divShow()">
                            <option value="">---请选择---</option>
                            <option value="0">按角色</option>
                            <option value="1">按职位</option>
                        </select>
                    </div>
                    <div id="departDiv" style="display:none">
                        <label title="所属组织">所属组织</label>
                        <input style="width:100px" onkeypress="EnterPress(event)" onkeydown="EnterPress()" type="text"
                               id="orgName" name="orgName" class="inuptxt"/>
                    </div>
                    <div id="posDiv" style="display:none;height: 100px">
                        <div>
                            <label>职位编码</label>
                            <input type="text" name="posCode" id="posCode">
                        </div>
                        <div>
                            <label>职位名称</label>
                            <input  type="text" name="posName" id="posName"/>
                        </div>
                        <div>
                            <label>用户名</label>
                            <input  type="text" name="fullname" id="fullname"/>
                        </div>
                    </div>
                    <div id="chooseCondition" style="display:none">
                        <label>筛选条件</label>
                        <select name="chooseCondition" id="chooseCondition" style="width:100px">
                            <option value="1">当前组织</option>
                            <option value="2">当前组织及以上</option>
                            <option value="3">角色下所有职位</option>
                        </select>
                    </div>
                    <div id="roleDiv" style="display:none">
                        <div>
                            <label>角色编码</label>
                            <input type="text" name="roleCode" id="roleCode">
                        </div>
                        <div>
                            <label>角色名称</label>
                            <input type="text" name="roleName" id="roleName"/>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <t:datagrid title="备选项" name="useSendCopyList"
                    actionUrl="/activiti/taCarbonCopyController/getRolesOrPositions?1=1"
                    idField="id" fit="true" fitColumns="true" queryMode="group" checkbox="false"
                    autoLoadData="false" singleSelect="false">
            <t:dgCol title="id" field="id" hidden="true"/>
            <t:dgCol title="角色/职位编码" field="roleCode" query="true" width="120"/>
            <t:dgCol title="角色/职位名称" field="roleName" query="true" width="120"/>
        </t:datagrid>
    </div>
</div>
<script type="text/javascript">
    $(function () {
        //FIXME 替换成通用的接口
        // $("#orgTree").combotree({
        //     url: 'tmOrgController.do?getParentOrg',
        //     onSelect: function (node) {
        //         $("#orgTree").val(node.id);
        //     }
        // });
    });

    function saveSendCopyList() {
        var chooseCon = $('#chooseCondition option:selected').val();
        var rowsData = $('#useSendCopyList').datagrid('getSelections');

        if (!rowsData || rowsData.length == 0) {
            tip('至少选中一条');
            return;
        }
        var sendCopyList = $('#sendCopyList').datagrid('getRows');
        var sendCopyMap = {};
        for(var i = 0; i < sendCopyList.length; i++){
            var sendCopy = sendCopyList[i];
            sendCopyMap[sendCopy.code + '_' + sendCopy.state] = sendCopy;
        }
        var sendType = $("[name='sendType']").val();
        for (var i = 0; i < rowsData.length; i++) {
            var code , name;
            if (sendType == 0) {
                code = rowsData[i].roleCode;
                name = rowsData[i].roleName;
            } else {
                code = rowsData[i].positionCode;
                name = rowsData[i].positionName;
            }
            if(sendCopyMap[code + '_' + sendType]){
                continue;
            }
            var row = {code: code, name: name, state: sendType, chooseCondition: chooseCon};
            $("#sendCopyList").datagrid('appendRow', row);
        }

    }

    function delCC() {
        //获取所有选中的行
        var rowsData = $('#sendCopyList').datagrid('getSelections');
        if(rowsData.length > 0) {
            for (var i = 0; i < rowsData.length; i++) {
                //获取行的编号
                var index = $('#sendCopyList').datagrid('getRowIndex', rowsData[i]);
                $('#sendCopyList').datagrid('deleteRow', index);
            }
        }
    }
    function delAll() {
        //获取所有选中的行
        var rowsData = $('#sendCopyList').datagrid('getRows');
        if(rowsData.length > 0) {
            for (; rowsData.length > 0; ) {
                //获取行的编号
                var index = $('#sendCopyList').datagrid('getRowIndex', rowsData[0]);
                $('#sendCopyList').datagrid('deleteRow', index);
            }
        }
    }
    function commitList() {
        //获取所有选中的行
        var rowsData = $('#sendCopyList').datagrid('getRows');
        if(rowsData.length > 0) {
            var processInstanceId = "${processInstanceId}", processDefinitionId = "${processDefinitionId}";
            $.ajax({
                url: "/activiti/taCarbonCopyController/manualCarbonCopy",
                type: "POST",
                contentType: "application/json; charset=utf-8",
                data: JSON.stringify({
                    processInstanceId: processInstanceId,
                    processDefinitionId: processDefinitionId,
                    ccs: rowsData
                }),
                dataType:"json",
                cache: false,
                async: false,
                beforeSend: function () {

                    $.messager.progress({
                        title: '提示',
                        msg: '请稍候……',
                        text: ''
                    });
                },

                success: function (d) {
                    var msg = d.msg;
                    tip(msg);
                    $.messager.progress('close');
                    if (d.success) {
                        delAll()
                    }
                }
            });
        }else{
            tip('请添加需要抄送的角色/职位。');
        }
    }

    /**
     * 选择抄送类型。根据值显示相关的div
     */
    function divShow() {
        $("#posCode").val("");
        $("#posName").val("");
        $("#roleCode").val("");
        $("#roleName").val("");
        loadData();
        var sendType = $("[name='sendType']").val();
        if (sendType == "") {
            tip('请选择抄送类型!');
            return;
        }
        if (sendType == 0) {
            $("#departDiv").hide();
            $("#posDiv").hide();
            $("#roleDiv").show();
            $("#chooseCondition").show();
        } else {
            $("#departDiv").show();
            $("#posDiv").show();
            $("#roleDiv").hide();
            $("#chooseCondition").hide();
        }
    }

    function resetQuery() {
        var sendType = $("[name='sendType']").val();
        $("#posCode").val("");
        $("#posName").val("");
        $("#roleCode").val("");
        $("#roleName").val("");
        $("#orgTree").combotree('setValue', '');
        if (sendType == 0) {
            $("#useSendCopyList").datagrid({
                url: "/activiti/taCarbonCopyController/getRolesOrPositions",
                queryParams: {
                    sendType: sendType,
                    field: "id,roleCode,roleName"
                },
                columns: [[
                    {field: 'id', title: 'id', hidden: true},
                    {field: 'roleCode', title: '角色编码', width: 120},
                    {field: 'roleName', title: '角色名称', width: 120}
                ]]
            });
        } else {
            $("#orgName").val("");
            $("#useSendCopyList").datagrid({
                url: "/activiti/taCarbonCopyController/getRolesOrPositions",
                queryParams: {
                    sendType: sendType,
                    field: "id,roleCode,roleName"
                },
                columns: [[
                    {field: 'id', title: 'id', hidden: true},
                    {field: 'positionCode', title: '职位编码', width: 120},
                    {field: 'positionName', title: '职位名称', width: 120},
                    {field: 'orgName', title: '组织名称', width: 120}
                ]]
            });
        }
    }

    /**当选择了抄送类型后加载相应的数据*/
    function loadData() {

        var sendType = $("[name='sendType']").val();
        if (sendType == "") {
            tip('请选择抄送类型!');
            return;
        }
        if (sendType == 0) {
            $("#useSendCopyList").datagrid({
                url: "/activiti/taCarbonCopyController/getRolesOrPositions",
                queryParams: {
                    sendType: sendType,
                    roleName: $("#roleName").val(),
                    roleCode: $("#roleCode").val(),
                    orgId: '',
                    positionName: '',
                    field: "id,roleCode,roleName"
                },
                columns: [[
                    {field: 'id', title: 'id', hidden: true},
                    {field: 'roleCode', title: '角色编码', width: 120},
                    {field: 'roleName', title: '角色名称', width: 120}
                ]]
            });
        } else {
            $("#useSendCopyList").datagrid({
                url: "/activiti/taCarbonCopyController/getRolesOrPositions",
                queryParams: {
                    sendType: sendType,
                    roleName: '',
                    orgName: $("#orgName").val(),
                    positionName: $("#posName").val(),
                    positionCode: $("#posCode").val(),
                    fullname:$("#fullname").val(),
                    field: "id,roleCode,roleName,fullname"
                },
                columns: [[
                    {field: 'id', title: 'id', hidden: true},
                    {field: 'positionCode', title: '职位编码', width: 120},
                    {field: 'positionName', title: '职位名称', width: 120},
                    {field: 'orgName', title: '组织名称', width: 120}
                ]]
            });
        }
    }
</script>
</body>
