<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<style>
    .search {
        background: #0F467C;
        color: #ffffff;
        font-size: 12px;
        border: none;
        outline: none;
        height: 22px;
    }
</style>
<t:base type="jquery,easyui,tools,autocomplete,DatePicker"></t:base>

<div id="agencyApprovalMain" class="easyui-layout" fit="true">


    <div data-options="region:'west',split:true,border:false" style="width:600px">
        <t:datagrid name="noAnyAgencyApprovalList" title="企业用户" fit="true" fitColumns="true"
                    singleSelect="false" actionUrl="/activiti/activitiApiUserController/getTmUserList" idField="id" queryMode="group" pagination="false">
            <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="用户账号" field="username" query="true"></t:dgCol>
            <t:dgCol title="用户名" field="fullname" query="true"></t:dgCol>
            <t:dgCol title="职位编码" field="posCode" query="true"></t:dgCol>
            <t:dgCol title="职位名称" field="posName" query="true"></t:dgCol>
            <t:dgToolBar title="添加"  icon="icon-add" url="/activiti/taTaskController/addAgencyApproval" funname="addAgencyApproval"></t:dgToolBar>
        </t:datagrid>
    </div>

    <div data-options="region:'center',border:false,split:true">
        <div class="easyui-layout" fit="true">
            <div data-options="region:'north',split:true" style="height:50px;">
                <div class="p10">
                    <span style="font-size: 12px">开始时间</span>
                    <input name="beginTime" id="beginTime" class="Wdate" style="width: 150px;"
                           onclick="WdatePicker({dateFmt:'yyyy-MM-dd',maxDate:'#F{$dp.$D(\'endTime\')}'})"
                           readonly="readonly" value="${vo.beginTime}" />
                    <span style="font-size: 12px">结束时间</span>
                    <input name="endTime" id="endTime" class="Wdate" style="width: 150px;"
                           onclick="WdatePicker({dateFmt:'yyyy-MM-dd',minDate:'#F{$dp.$D(\'beginTime\')}'})"
                           readonly="readonly" value="${vo.endTime}"/>
                    <button class="search" onclick="saveTime();">保存</button>
                </div>
            </div>

            <div data-options="region:'center',border:false,split:true" style="height:300px">
                <t:datagrid name="thisAgencyApprovalList" title="已添加代理审批的用户" fit="true" fitColumns="true"
                            singleSelect="false" actionUrl="/activiti/taTaskController/findAgencyApprovalPage" idField="id" queryMode="group" pagination="false">
                    <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
                    <t:dgCol title="用户账号" field="username" ></t:dgCol>
                    <t:dgCol title="用户名" field="fullname" ></t:dgCol>
                    <t:dgCol title="职位编码" field="agentPositionCode" ></t:dgCol>
                    <t:dgCol title="职位名称" field="agentPositionName" ></t:dgCol>
                    <t:dgToolBar title="移除"  icon="icon-remove" url="/activiti/taTaskController/deleteAgencyApproval" funname="deleteAgencyApproval"></t:dgToolBar>
                </t:datagrid>
            </div>

            <div data-options="region:'south',split:true,border:false" style="height: 300px">
                <t:datagrid name="thisProcessSelect" title="选择流程" fit="true" fitColumns="true"
                            singleSelect="false" actionUrl="/activiti/taTaskController/findAgencyApprovalProcessPage" idField="id" queryMode="group">
                    <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
                    <t:dgCol title="流程KEY" field="processKey" ></t:dgCol>
                    <t:dgCol title="流程名称" field="processName" ></t:dgCol>
                    <t:dgToolBar title="添加" icon="icon-add" url="/page/activitiApiProcessController/goTaApiProcessMain"
                                 funname="addProcess"></t:dgToolBar>
                    <t:dgToolBar title="移除"  icon="icon-remove" url="/activiti/taTaskController/deleteAgencyApprovalProcess" funname="deleteAgencyApprovalProcess"></t:dgToolBar>
                </t:datagrid>
            </div>

        </div>
    </div>
</div>
<script type="text/javascript">

    function saveTime() {
        var beginTime = $("#beginTime").val();
        if (beginTime == "") {
            tip("请选择开始时间");
            return false;
        }

        var endTime = $("#endTime").val();
        if (endTime == "") {
            tip("请选择结束时间");
            return false;
        }
        $.ajax({
            url : "/activiti/taTaskController/saveAgencyApprovalTime",
            type : 'post',
            data : {
                beginTime : beginTime,
                endTime : endTime
            },
            cache : false,
            success : function(data) {
                var d = data;
                var msg = d.msg;
                if (d.success) {
                    tip(msg,'info');
                    // reloadDataGrid();
                }else{
                    tip(msg,'error');
                    return;
                }
            },
            error:function(){
                tip("客户端请求错误",'error');
                return false;
            }
        });
    }

    function addAgencyApproval(title, url, gname, width, height, params) {
        var rows = $("#" + gname).datagrid("getSelections");
        if(rows == null || rows == ""){
            tip("请至少选择一条数据");
            return false;
        }
        var beginTime = $("#beginTime").val();
        if (beginTime == "") {
            tip("请选择开始时间");
            return false;
        }

        var endTime = $("#endTime").val();
        if (endTime == "") {
            tip("请选择结束时间");
            return false;
        }
        var ids = [];
        for ( var i = 0; i < rows.length; i++) {
            ids.push(rows[i].id);
        }

        $.ajax({
            url : url,
            type : 'post',
            data : {
                userIds : ids.join(','),
                beginTime : beginTime,
                endTime : endTime
            },
            cache : false,
            success : function(data) {
                var d = data;
                var msg = d.msg;
                if (d.success) {
                    tip(msg,'info');
                    reloadDataGrid();
                }else{
                    tip(msg,'error');
                    return;
                }
            },
            error:function(){
                tip("客户端请求错误",'error');
                return false;
            }
        });
    }

    function deleteAgencyApproval(title, url, gname, width, height, params) {
        var rows = $("#" + gname).datagrid("getSelections");
        if(rows == null || rows == ""){
            tip("请至少选择一条数据");
            return false;
        }

        var ids = [];
        for ( var i = 0; i < rows.length; i++) {
            ids.push(rows[i].id);
        }

        getSafeJq().dialog.confirm("你确定移除该数据吗?", function(r) {
            if (r) {
                $.ajax({
                    url : url,
                    type : 'post',
                    data : {ids : ids.join(',')},
                    cache : false,
                    success : function(data) {
                        var d = data;
                        var msg = d.msg;
                        if (d.success) {
                            tip(msg,'info');
                            reloadDataGrid();
                        }else{
                            tip(msg,'error');
                            return;
                        }
                    },
                    error:function(){
                        tip("客户端请求错误",'error');
                        return false;
                    }
                });
            }
        });
    }

    function deleteAgencyApprovalProcess(title, url, gname, width, height, params) {
        var rows = $("#" + gname).datagrid("getSelections");
        if(rows == null || rows == ""){
            tip("请至少选择一条数据");
            return false;
        }

        var ids = [];
        for ( var i = 0; i < rows.length; i++) {
            ids.push(rows[i].id);
        }

        getSafeJq().dialog.confirm("你确定移除该数据吗?", function(r) {
            if (r) {
                $.ajax({
                    url : url,
                    type : 'post',
                    data : {ids : ids.join(',')},
                    cache : false,
                    success : function(data) {
                        var d = data;
                        var msg = d.msg;
                        if (d.success) {
                            tip(msg,'info');
                            reloadDataGrid();
                        }else{
                            tip(msg,'error');
                            return;
                        }
                    },
                    error:function(){
                        tip("客户端请求错误",'error');
                        return false;
                    }
                });
            }
        });
    }


    function reloadDataGrid() {
        $("#noAnyAgencyApprovalList").datagrid("reload");
        $("#thisAgencyApprovalList").datagrid("reload");
        $("#thisProcessSelect").datagrid("reload");
    }
    
    function addProcess() {

        url = "/page/activitiApiProcessController/goTaApiProcessMain";
        width = 500;
        height = 400;
        id = "taApiProcessList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if (rowsData == '' || rowsData == null) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }
                } else {
                    //提交数据到后台表里
                    $.ajax({
                        url : "/activiti/activitiApiProcessController/saveTaAgencyApprovalProcess",
                        type : 'post',
                        data : {"datas":JSON.stringify(rowsData)},
                        cache : false,
                        success : function(data) {
                            tip(data.msg);
                            if (!data.success) {
                                tip(data.msg);
                                return false;
                            }
                            reloadDataGrid();
                        }
                    });
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
</script>