<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>目标统计</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <link rel="stylesheet" href="/resources/sfa/css/LCalendar.css">
    <style>
        body {
            background: #f3f3f3;
        }

        .panel {
            border-radius: 5px;
            padding: 10px;
            background: #fff;
            box-sizing: border-box;
        }

        .goal-panel {
            height: 40px;
            padding: 0 10px;
        }

        .panel-title {
            font-weight: 600;
        }

        .panel-tabs {
            font-size: 0;
        }

        .panel-tabs span {
            padding: 0 8px;
            color: #333;
            background: #fff;
            font-size: 14px;
            height: 20px;
            line-height: 20px;
            transition: all .3s;
            display: inline-block;
            border-style: solid;
            border-width: 1px 0 1px 1px;
            border-color: #c5c5c5;
        }

        .panel-tabs span:first-child {
            border-right: 0;
            border-radius: 3px 0 0 3px;
        }

        .panel-tabs span:last-child {
            border-width: 1px 1px 1px 1px;
            border-radius: 0 3px 3px 0;
        }

        .panel-tabs span.active {
            color: #fff;
            background: #0188FB;
            border-color: #0188FB;
        }

        .panel-date input {
            width: 70px;
            background: transparent;
            border: none;
        }

        .goal-info {
            margin-top: 15px;
        }

        .goal-info-item span:first-child {
            color: #c5c5c5;
            margin-bottom: 5px;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="goal">
            <div class="goal-panel flex flex-align-items-center flex-justify-content-between">
                <div class="panel-tabs">
                    <span @click="handleTab('day')" :class="activeTab==='day'?'active':''">日</span>
                    <span @click="handleTab('week')" :class="activeTab==='week'?'active':''">周</span>
                    <span @click="handleTab('month')" :class="activeTab==='month'?'active':''">月</span>
                    <span @click="handleTab('quarter')" :class="activeTab==='quarter'?'active':''">季</span>
                    <span @click="handleTab('year')" :class="activeTab==='year'?'active':''">年</span>
                </div>
                <div class="panel-date flex flex-align-items-center flex-justify-content-between">
                    <span>&lt</span>
                    <input type="text" id="goalDate" v-model="goalDate" readonly="" name="input_date" />
                    <span>&gt</span>
                </div>
            </div>
            <div class="panel">
                <div class="panel-title">我的目标</div>
                <div class="goal-info flex flex-align-items-center">
                    <div class="goal-info-item flex-1 flex flex-column flex-align-items-center">
                        <span>目标</span>
                        <span>500个</span>
                    </div>
                    <div class="goal-info-item flex-1 flex flex-column flex-align-items-center">
                        <span>完成</span>
                        <span>350个</span>
                    </div>
                    <div class="goal-info-item flex-1 flex flex-column flex-align-items-center">
                        <span>完成率</span>
                        <span>70%</span>
                    </div>
                </div>
                <div ref="myBar" style="width: 100%;height:300px;box-sizing: border-box;"></div>
            </div>
            <div class="panel mt10">
                <div class="panel-title">部门目标</div>
                <div class="goal-info flex flex-align-items-center">
                    <div class="goal-info-item flex-1 flex flex-column flex-align-items-center">
                        <span>目标</span>
                        <span>4000个</span>
                    </div>
                    <div class="goal-info-item flex-1 flex flex-column flex-align-items-center">
                        <span>完成</span>
                        <span>3622个</span>
                    </div>
                    <div class="goal-info-item flex-1 flex flex-column flex-align-items-center">
                        <span>完成率</span>
                        <span>84%</span>
                    </div>
                </div>
                <div ref="groupBar" style="width: 100%;height:300px;box-sizing: border-box;"></div>
            </div>
        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/LCalendar.js"></script>
    <script src="/resources/sfa/js/echarts.min.js"></script>

    <script>
        var vm = new Vue({
            el: "#app",
            name: "",
            data: function () {
                return {
                    activeTab: "week",
                    goalDate: "",
                    myBar: null,
                    groupBar: null
                }
            },
            created: function () {

            },
            mounted: function () {
                var calendar = new LCalendar();
                calendar.init({
                    'trigger': '#goalDate', //标签id
                    'type': 'ym', //date 调出日期选择 datetime 调出日期时间选择 time 调出时间选择 ym 调出年月选择
                });
                this.initMyGoal();
                this.initGroupGoal();
            },
            computed: {

            },
            methods: {
                handleTab: function (tab) {
                    this.activeTab = tab;
                },
                initMyGoal: function () {
                    this.myBar = echarts.init(this.$refs.myBar);
                    var option = {
                        color: ['#1890ff', '#1047a9'],
                        tooltip: {
                            show: true,
                            trigger: 'axis',
                            axisPointer: {
                                type: 'shadow'
                            }
                        },
                        legend: {
                            data: ['目标', '完成'],
                            top: 10
                        },
                        xAxis: {
                            type: 'category',
                            data: [1, 2, 3, 4, 5, 6, 7]
                        },
                        yAxis: {
                            type: 'value'

                        },
                        series: [{
                            data: [10, 20, 50, 500, 80, 40, 100],
                            type: 'bar',
                            name: "目标",
                        }, {
                            data: [200, 400, 250, 300, 600, 500, 400],
                            type: 'bar',
                            name: "完成"
                        }]
                    };
                    this.myBar.setOption(option);
                },
                initGroupGoal: function () {
                    this.groupBar = echarts.init(this.$refs.groupBar);
                    var option = {
                        color: ['#1890ff', '#f18e1f'],
                        tooltip: {
                            show: true,
                            trigger: 'axis',
                            axisPointer: {
                                type: 'shadow'
                            }
                        },
                        legend: {
                            data: ['目标', '完成'],
                            top: 10
                        },
                        xAxis: {
                            type: 'category',
                            data: [1, 2, 3, 4, 5, 6, 7]
                        },
                        yAxis: {
                            type: 'value'
                        },
                        series: [{
                            name: "目标",
                            data: [10, 20, 50, 500, 80, 40, 100],
                            stack: "num",
                            type: 'bar',
                        }, {
                            name: "完成",
                            data: [250, 250, 250, 250, 250, 250, 250],
                            stack: "num",
                            type: 'bar',
                        }]
                    };
                    this.groupBar.setOption(option);
                }
            }
        })
    </script>
</body>

</html>