<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete" extendUrlKey="incomeBudgetMain"></t:base>
<div id="coding_rules_List" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="fiscalList" tagConf="${clickFunctionId}" controllerTarget="ttIncomeBudgetController" methedTarget="getMaiListPage"  idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/budget/ttIncomeBudgetController/getMaiListPage" pagination="true" checkbox="true" singleSelect="false" pageSize="30">
            <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="扩展字段1" field="extChar1"  hidden="true" query="true"></t:dgCol>
            <t:dgCol title="扩展字段2" field="extChar2"  hidden="true" query="true"></t:dgCol>
            <t:dgCol title="扩展字段3" field="extChar3"  hidden="true" query="true"></t:dgCol>
            <t:dgCol title="扩展字段4" field="extChar4"  hidden="true" query="true"></t:dgCol>
            <t:dgCol title="扩展字段5" field="extChar5"  hidden="true" query="true"></t:dgCol>
            <t:dgCol title="预算编号" field="budgetCode" query="true"></t:dgCol>
            <t:dgCol title="年份" field="budgetYear"  query="true" ></t:dgCol>
            <t:dgCol title="月份" field="budgetMonth" dictionary="month"></t:dgCol>
            <t:dgCol title="分组" field="subjectsGroupCode" dictionary="imcome_group"></t:dgCol>
            <t:dgCol title="收入预算类型" field="budgetType" dictionary="budget_type"></t:dgCol>
            <t:dgCol title="金额" field="initAmount" hidden="false"></t:dgCol>
            <t:dgCol title="组织" field="budgetDepartName"></t:dgCol>
            <t:dgCol title="产品层级" field="productLevelName"></t:dgCol>
            <t:dgCol title="职位编码" field="posCode"></t:dgCol>
            <t:dgCol title="职位名称" field="posName"></t:dgCol>
            <t:dgCol title="客户编码" field="custCode"></t:dgCol>
            <t:dgCol title="客户名称" field="custName"></t:dgCol>
            <t:dgCol title="客户组织编码" field="custOrgCode"></t:dgCol>
            <t:dgCol title="客户组织名称" field="custOrgName"></t:dgCol>
            <t:dgCol title="门店编码" field="terminalCode"></t:dgCol>
            <t:dgCol title="门店名称" field="terminalName"></t:dgCol>
            <t:dgCol title="物料" field="productName"></t:dgCol>
            <t:dgCol title="创建人" field="createName"></t:dgCol>
            <t:dgCol title="创建时间" field="createDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
            <t:dgCol title="最近更新人" field="updateName" treefield="updateName"></t:dgCol>
            <t:dgCol title="最近更新时间" field="updateDate" treefield="updateDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>

            <t:dgToolBar title="添加" operationCode="add" icon="icon-add" url="/page/ttIncomeBudgetController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="add"></t:dgToolBar>
            <t:dgToolBar title="修改" operationCode="edit" icon="icon-edit" url="/page/ttIncomeBudgetController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="updateExtend"></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look" icon="icon-look" url="/page/ttIncomeBudgetController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="detail"></t:dgToolBar>
            <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="/budget/ttIncomeBudgetController/delete"
                         funname="deleteALLSelectList"></t:dgToolBar>
            <c:if test="${isDisplay == '1' }">
                <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn"
                         onclick="importExcel(${importUploadUrl})"></t:dgToolBar>
            </c:if>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut" excelName="收入预算" excelSheetName="收入预算"
                         url="/budget/commonExcelController/excel" funname="excelCommonExport"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="/page/knlLogController/goShowLog"
                         width="1000" height="500" funname="update"></t:dgToolBar>
            <t:dgToolBar title="个性设置" operationCode="style" icon="icon-add" url="/page/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500"     funname="addSelect"></t:dgToolBar>

        </t:datagrid>
    </div>
</div>
<script>
    $(document).ready(function(){
        $("input[name='productLevelName']").attr("name",'productLevelId');
        $("input[name='productLevelId']").combotree({
            width:128,
            url: '/mdm-api/mdmApi/productLevelApiCotroller/getTmProductTree'
        });
    });

    //修改扩展
    function updateExtend(title,url,girdname,width,height,options){
        if(isExitsFunction('updateBefore')){
            updateBefore(title,url,girdname,width,height,options);
        }else{
            update(title,url,girdname,width,height,options);
        }
    }
</script>