<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>


<div class="easyui-layout" fit="true">
    <div region="center" style="padding:1px;">
        <t:datagrid name="visitClientDatagrid"  fitColumns="false" title="" checkbox="true" singleSelect="false"
                    actionUrl="/sfaapi/visitGroupController/findVisitClientPage?1=1&groupId=${groupId}" idField="id" fit="true"
                    queryMode="group" pageSize="20">
            <t:dgCol title="id" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="状态" field="status" hidden="true" dictionary="enable_status"></t:dgCol>
            <t:dgCol title="客户主键" field="clientId" hidden="true"></t:dgCol>
            <t:dgCol title="客户名称" field="clientName" query="true" queryMode="single" width="120"></t:dgCol>
            <t:dgCol title="客户编码" field="clientCode" query="true" queryMode="single" width="120"></t:dgCol>
            <t:dgCol title="客户类型" field="clientType" query="true" queryMode="single" width="120" dictionary="sfacust_type"></t:dgCol>


            <t:dgToolBar title="添加网点" icon="icon-add" url="" funname="addVisitClient"></t:dgToolBar>
            <t:dgToolBar title="删除网点" icon="icon-remove" url="/sfaapi/visitGroupController/delVisitClient?1=1" funname="deleteALLSelect"></t:dgToolBar>
        </t:datagrid>

    </div>
</div>

<script>

    /** 网点 */
    var visitClientVo = function() {
        this.id;
        /**网点主键*/
        this.clientId;
        /**网点编码*/
        this.clientCode;
        /**网点名称**/
        this.clientName;
        /**网点类型*/
        this.clientType;
    };


    function addVisitClient(){
        var groupId = '${groupId}';
        var url = "/page/visitGroupController/goVisitCustomerList?1=1&groupId="+groupId;
        createwindowExt("网点信息列表",url,700,400,{
            okVal:'确定',
            ok:function () {
                var iframe = this.iframe.contentWindow;
                var rows = iframe.$("#visitCustomerList").datagrid('getSelections');
                if (null == rows||rows.length == 0){
                    iframe.tip("请选择对应网点");
                    return false;
                }
                var clientArr = new Array();
                for (var i=0;i<rows.length;i++){
                    var customer = rows[i];
                    var clientVo = new visitClientVo();
                    clientVo.clientId = customer.id;
                    clientVo.clientCode = customer.customerCode;
                    clientVo.clientName = customer.customerName;
                    clientVo.clientType = customer.customerType;
                    clientArr.push(clientVo)
                }
                var clientJson = JSON.stringify(clientArr);
                $.ajax({
                    type : "POST",
                    url : "/sfaapi/visitGroupController/addVisitClient",
                    data : {
                        "groupId" : groupId,
                        "clientJson" : clientJson
                    },
                    dataType : "json",
                    success : function(data) {
                        if(!data.success){
                            tip(data.msg);
                            return false;
                        }else{
                            tip(data.msg);
                            $("#visitClientDatagrid").datagrid('reload');
                        }
                    },
                    error:function(){
                        iframe.tip("操作超时");
                    }
                });
            }
        })




    }




    
</script>

