/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.notice.controller;

import com.biz.eisp.attachment.vo.KnlAttachmentVo;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.kernel.KnlAttachmentFeign;
import com.biz.eisp.kernel.KnlDictDataFeign;
import com.biz.eisp.kernel.KnlNoticeFeign;
import com.biz.eisp.notice.entity.KnlNoticeEntity;
import com.biz.eisp.notice.vo.KnlNoticeVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/knlNoticeController"})
public class KnlNoticeController {
    @Autowired
    private KnlNoticeFeign knlNoticeFeign;
    @Autowired
    private KnlAttachmentFeign knlAttachmentFeign;
    @Autowired
    private KnlDictDataFeign knlDictDataFeign;

    @RequestMapping(value={"goKnlNoticeMain"})
    public ModelAndView goKnlNoticeMain() {
        return new ModelAndView("com/biz/eisp/kernel/notice/NoticeMain");
    }

    @RequestMapping(value={"goKnlNoticeMore"})
    public ModelAndView goKnlNoticeMore() {
        return new ModelAndView("com/biz/eisp/kernel/notice/noticeMore");
    }

    @RequestMapping(value={"goSaveOrUpdateNotice"})
    public ModelAndView goSaveOrUpdateNotice(HttpServletRequest request, KnlNoticeVo vo, String clickFunctionId) {
        if (vo != null && StringUtils.isNotBlank((CharSequence)vo.getId())) {
            KnlNoticeEntity entity = (KnlNoticeEntity)this.knlNoticeFeign.getKnlNoticeByParamObj(vo.getId()).getObj();
            request.setAttribute("vo", (Object)entity);
            KnlAttachmentVo attachmentVo = new KnlAttachmentVo();
            attachmentVo.setBusinessKey(vo.getId());
            List knlAttachmentEntities = this.knlAttachmentFeign.getKnlAttachmentList(attachmentVo).getObjList();
            request.setAttribute("knlAttachmentVos", (Object)knlAttachmentEntities);
            request.setAttribute("clickFunctionId", (Object)clickFunctionId);
        }
        return new ModelAndView("com/biz/eisp/kernel/notice/NoticeForm");
    }

    @RequestMapping(value={"goSaveOrUpdateDetail"})
    public ModelAndView goSaveOrUpdateDetail(HttpServletRequest request, KnlNoticeVo vo) {
        if (vo != null && StringUtils.isNotBlank((CharSequence)vo.getId())) {
            KnlNoticeEntity entity = (KnlNoticeEntity)this.knlNoticeFeign.getKnlNoticeByParamObj(vo.getId()).getObj();
            List dataEntities = this.knlDictDataFeign.getKnlDictDataList().getObjList();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)dataEntities)) {
                dataEntities.forEach(item -> {
                    if (entity.getNoticeType().equals(item.getDictCode())) {
                        entity.setNoticeTypeStr(item.getDictValue());
                    }
                });
            }
            request.setAttribute("vo", (Object)entity);
            KnlAttachmentVo attachmentVo = new KnlAttachmentVo();
            attachmentVo.setBusinessKey(vo.getId());
            List knlAttachmentEntities = this.knlAttachmentFeign.getKnlAttachmentList(attachmentVo).getObjList();
            request.setAttribute("knlAttachmentVos", (Object)knlAttachmentEntities);
        }
        return new ModelAndView("com/biz/eisp/kernel/notice/NoticeDetail");
    }
}

