<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>预算财年设置</title>
    <t:base type="jquery,easyui,tools" extendUrlKey="incomeBudgetForm"></t:base>
</head>
<body style="overflow-y: hidden" scroll="no">
<t:formvalid action="/budget/ttIncomeBudgetController/saveOrUpdate" layout="div" dialog="true" formid="fiscalForm">
    <t:dgFormList expandParam="${clickFunctionId}" tagConf="${clickFunctionId}">
        <t:dgFormColumn field="id" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                        defaultVal="${vo.id }"/>
        <t:dgFormColumn field="extChar1" hidden="true" formClass="form" labelName="extChar1" optionType="optionType" required="false"
                        defaultVal="${vo.extChar1 }"/>
        <t:dgFormColumn field="extChar2" hidden="true" formClass="form" labelName="extChar2" optionType="optionType" required="false"
                        defaultVal="${vo.extChar2 }"/>
        <t:dgFormColumn field="extChar3" hidden="true" formClass="form" labelName="extChar3" optionType="optionType" required="false"
                        defaultVal="${vo.extChar3 }"/>
        <t:dgFormColumn field="extChar4" hidden="true" formClass="form" labelName="extChar4" optionType="optionType" required="false"
                        defaultVal="${vo.extChar4 }"/>
        <t:dgFormColumn field="extChar5" hidden="true" formClass="form" labelName="extChar5" optionType="optionType" required="false"
                        defaultVal="${vo.extChar5 }"/>
        <t:dgFormColumn field="budgetCode" hidden="false" formClass="form"
                        defaultVal="${vo.budgetCode}"
                        labelName="预算编码" optionType="input" required="false"/>
        <t:dgFormColumn field="subjectsGroupName" hidden="true" formClass="form" labelName="id" optionType="input" required="false"
                        defaultVal="${vo.subjectsGroupName }"/>
        <t:dgFormColumn field="subjectsGroupCode" hidden="false" typeGroupCode="imcome_group" formClass="form"
                        defaultVal="${vo.subjectsGroupCode}"
                        labelName="分组" optionType="select" required="false"/>
        <t:dgFormColumn field="budgetType" hidden="false" typeGroupCode="budget_type" formClass="form"
                        defaultVal="${vo.budgetType}"
                        labelName="收入预算类型" optionType="select" required="false"/>
        <t:dgFormColumn field="budgetYear" hidden="false" formClass="form" labelName="年份" optionType="select" required="false"
                        defaultVal="${vo.budgetYear}" typeGroupCode="financial_year"/>
        <t:dgFormColumn field="budgetMonth" hidden="false" typeGroupCode="month" formClass="form"
                        defaultVal="${vo.budgetMonth}"
                        labelName="月份" optionType="select" required="false"/>
        <t:dgFormColumn field="budgetDepartCode" hidden="true" formClass="form"
                        defaultVal="${vo.budgetDepartCode}"
                        labelName="组织编码" optionType="input" required="false"/>
        <t:dgFormColumn field="budgetDepartName" hidden="false" formClass="form"
                        defaultVal="${vo.budgetDepartName}"
                        labelName="组织" required="false" optionType="choseDialog" onclick="goOrg();"/>
        <t:dgFormColumn field="budgetSubjectsCode" hidden="true" formClass="form"
                        defaultVal="${vo.budgetSubjectsCode}"
                        labelName="科目编码" optionType="input" required="false"/>
        <%--<t:dgFormColumn field="budgetSubjectsName" hidden="false" formClass="form" labelName="科目" optionType="choseDialog" required="false"
                        defaultVal="${vo.budgetSubjectsName}" onclick="goSbudgetSubjects();"/>--%>
        <t:dgFormColumn field="productLevelName" hidden="false" formClass="form" labelName="产品层级" optionType="choseDialog" required="false"
                        defaultVal="${vo.productLevelName }" onclick="selectProductLevel();"/>
        <t:dgFormColumn field="productLevelCode" hidden="true" formClass="form" labelName="产品层级编码" optionType="input" required="false"
                        defaultVal="${vo.productLevelCode}"/>
        <t:dgFormColumn field="productCode" hidden="true" formClass="form" labelName="商品编码" optionType="input" required="false"
                        defaultVal="${vo.productCode}"/>
        <t:dgFormColumn field="productName" hidden="false" formClass="form" labelName="商品名称" optionType="choseDialog" required="false"
                        defaultVal="${vo.productName}" onclick="goSelectProduct();"/>
        <t:dgFormColumn field="custCode" hidden="true" formClass="form" labelName="客户编码" optionType="input" required="false"
                        defaultVal="${vo.custCode}"/>
        <t:dgFormColumn field="custName" hidden="false" formClass="form" labelName="客户" optionType="choseDialog" required="false"
                        defaultVal="${vo.custName}" onclick="goCustomer();"/>
        <t:dgFormColumn field="posCode" hidden="true" formClass="form" labelName="职位编码" optionType="input" required="false"
                        defaultVal="${vo.posCode}"/>
        <t:dgFormColumn field="posName" hidden="true" formClass="form" labelName="职位名称" optionType="choseDialog" required="false"
                        defaultVal="${vo.posName}" onclick="goPosition();"/>
        <t:dgFormColumn field="terminalCode" hidden="true" formClass="form" labelName="门店编码" optionType="input" required="false"
                        defaultVal="${vo.terminalCode}"/>
        <t:dgFormColumn field="terminalName" hidden="false" formClass="form" labelName="门店" optionType="choseDialog" required="false"
                        defaultVal="${vo.terminalName}" onclick="selectTerminal();"/>
        <t:dgFormColumn field="custOrgCode" hidden="true" readOnly="true" formClass="form" labelName="客户组织编码" optionType="input"
                        required="false"
                        defaultVal="${vo.custOrgCode}"/>
        <t:dgFormColumn field="custOrgName" hidden="false" formClass="form" labelName="客户组织" optionType="choseDialog" required="false"
                        defaultVal="${vo.custOrgName}" onclick="goCustomerOrg();" onClean="cleanCustomerOrg();"/>
        <t:dgFormColumn field="initAmount" hidden="false" formClass="form" labelName="金额" optionType="input" required="false"
                        defaultVal="${vo.initAmount}"/>
        <t:dgFormColumn field="notes" hidden="false" formClass="form" labelName="备注" required="false"
                        defaultVal="${vo.notes}" optionType="textarea" rows="2" cols="50"/>
        <t:dgFormColumn field="saleDiscountAmount" hidden="true" formClass="form" labelName="销售折让金额" required="false"
                        defaultVal="${vo.saleDiscountAmount}" optionType="input" cols="50"/>
        <t:dgFormColumn field="productLongCode" hidden="true" formClass="form" labelName="产品长码" required="false"
                        defaultVal="${vo.productLongCode}" optionType="input" cols="50"/>
        <t:dgFormColumn field="productSbu" hidden="true" formClass="form" labelName="sbu" required="false"
                        defaultVal="${vo.productSbu}" optionType="input" cols="50"/>
        <t:dgFormColumn field="productSbuName" hidden="true" formClass="form" labelName="sbu名称" required="false"
                        defaultVal="${vo.productSbuName}" optionType="input" cols="50"/>
        <t:dgFormColumn field="customerArea" hidden="true" formClass="form" labelName="区域" required="false"
                        defaultVal="${vo.customerArea}" optionType="input" cols="50"/>
        <t:dgFormColumn field="productPrice" hidden="true" formClass="form" labelName="产品单价" required="false"
                        defaultVal="${vo.productPrice}" optionType="input" cols="50"/>
        <t:dgFormColumn field="productSpec" hidden="true" formClass="form" labelName="产品规格" required="false"
                        defaultVal="${vo.productSpec}" optionType="input" cols="50"/>
        <t:dgFormColumn field="productRate" hidden="true" formClass="form" labelName="税率" required="false"
                        defaultVal="${vo.productRate}" optionType="input" cols="50"/>
        <t:dgFormColumn field="productUnit" hidden="true" formClass="form" labelName="单位" required="false"
                        defaultVal="${vo.productUnit}" optionType="input" cols="50"/>
        <t:dgFormColumn field="productWeight" hidden="true" formClass="form" labelName="净重" required="false"
                        defaultVal="${vo.productWeight}" optionType="input" cols="50"/>
        <t:dgFormColumn field="weight" hidden="true" formClass="form" labelName="重量" required="false"
                        defaultVal="${vo.weight}" optionType="input" cols="50"/>
        <t:dgFormColumn field="saleDiscountNoRate" hidden="true" formClass="form" labelName="销售折让未税金额" required="false"
                        defaultVal="${vo.saleDiscountNoRate}" optionType="input" cols="50"/>
        <t:dgFormColumn field="discountReason" hidden="true" formClass="form" labelName="折让理由" required="false"
                        defaultVal="${vo.discountReason}" optionType="choseDialog" onclick="chooseZRLY()" cols="50"/>
        <t:dgFormColumn field="discountReasonCode" hidden="true" formClass="form" labelName="折让理由编码" required="false"
                        defaultVal="${vo.discountReasonCode}" optionType="input" cols="50"/>
        <t:dgFormColumn field="bookedAmount" hidden="true" formClass="form" labelName="立账金额" required="false"
                        defaultVal="${vo.bookedAmount}" optionType="input" cols="50"/>
        <t:dgFormColumn field="saleIncome" hidden="true" formClass="form" labelName="销售收入" required="false"
                        defaultVal="${vo.saleIncome}" optionType="input" cols="50"/>
        <t:dgFormColumn field="bookedInCome" hidden="true" formClass="form" labelName="立账收入" required="false"
                        defaultVal="${vo.bookedInCome}" optionType="input" cols="50"/>
    </t:dgFormList>
</t:formvalid>
</body>
<script type="text/javascript">
    /** 价格惯用条件 */
    let productPriceCondition='';
    $(function () {
        /** 分组添加事件 */
        $("#subjectsGroupCode").change(function () {
            $("#subjectsGroupName").val($(this).children('option:selected').text());
            firstGroup();
        });
        firstGroup();
    });

    /* 设置分组为第一个必须输入项目 */
    function firstGroup() {
        var load = '${load}';
        if (load != 'detail') {
            var subjectsGroupCode = $("#subjectsGroupCode").val();
            if (isEmpty(subjectsGroupCode)) {
                $("#budgetCode").parent().parent().hide();
                $(":input").attr("disabled", "disabled");
                $("a").hide();
                $("#subjectsGroupCode").attr("disabled", false);
            } else {
                $(":input").attr("disabled", false);
                $("a").show();
                groupChange();
            }
        } else {
            groupChange();
        }
    }

    function groupChange() {
        $.ajax({
            type: "POST",
            async: false,
            dataType: 'json',
            url: "/budget/ttIncomeBudgetController/getSubjectsGroupData",
            data: {dictCode: $("#subjectsGroupCode").val()},
            success: function (data) {
                $("#extChar1").parent().parent().hide();
                $("#extChar2").parent().parent().hide();
                $("#extChar3").parent().parent().hide();
                $("#extChar4").parent().parent().hide();
                $("#extChar5").parent().parent().hide();
                $("#budgetYear").parent().parent().hide();
                $("#budgetMonth").parent().parent().hide();
                $("#budgetDepartName").parent().parent().parent().hide();
                $("#budgetDepartName").removeAttr("datatype");
                $("#budgetDepartCode").parent().parent().hide();
                $("#budgetDepartCode").removeAttr("datatype");
                $("#productLevelName").parent().parent().parent().hide();
                $("#productLevelName").removeAttr("datatype");
                $("#productName").parent().parent().parent().hide();
                $("#productName").removeAttr("datatype");
                $("#custName").parent().parent().parent().hide();
                $("#discountReason").parent().parent().parent().hide();
                $("#discountReasonCode").parent().parent().hide();
                $("#custName").removeAttr("datatype");
                $("#posName").parent().parent().parent().hide();
                $("#posName").removeAttr("datatype");
                $("#terminalName").parent().parent().parent().hide();
                $("#terminalName").removeAttr("datatype");
                $("#custOrgName").parent().parent().parent().hide();
                $("#custCode").parent().parent().hide();
                $("#custOrgName").removeAttr("datatype");
                $("#initAmount").parent().parent().hide();
                $("#saleDiscountAmount").parent().parent().hide();
                $("#saleDiscountAmount").removeAttr("datatype");
                $("#productLongCode").parent().parent().hide();
                $("#productLongCode").removeAttr("datatype");
                $("#productSbu").parent().parent().hide();
                $("#productSbuName").parent().parent().hide();
                $("#productSbu").removeAttr("datatype");
                $("#customerArea").parent().parent().hide();
                $("#customerArea").removeAttr("datatype");
                $("#productPrice").parent().parent().hide();
                $("#productPrice").removeAttr("datatype");
                $("#productSpec").parent().parent().hide();
                $("#productSpec").removeAttr("datatype");
                $("#productRate").parent().parent().hide();
                $("#productRate").removeAttr("datatype");
                $("#productUnit").parent().parent().hide();
                $("#productUnit").removeAttr("datatype");
                $("#productWeight").parent().parent().hide();
                $("#productWeight").removeAttr("datatype");
                $("#weight").parent().parent().hide();
                $("#weight").removeAttr("datatype");
                $("#saleDiscountNoRate").parent().parent().hide();
                $("#saleDiscountNoRate").removeAttr("datatype");
                $("#bookedAmount").parent().parent().hide();
                $("#bookedAmount").removeAttr("datatype");
                $("#saleIncome").parent().parent().hide();
                $("#saleIncome").removeAttr("datatype");
                $("#bookedInCome").parent().parent().hide();
                $("#productCode").parent().parent().hide();
                // $("#bookedInCome").parent().parent().parent().hide();
                // $("#bookedInCome").removeAttr("datatype");
                for (var i = 0; i < data.objList.length; i++) {
                    var keyName = data.objList[i];
                    if (keyName == "budgetYear") {
                        $("#budgetYear").parent().parent().show();
                    } else if (keyName == "budgetMonth") {
                        $("#budgetMonth").parent().parent().show();
                    } else if (keyName == "budgetDepartName") {
                        $("#budgetDepartName").parent().parent().parent().show();
                        $("#budgetDepartName").attr("datatype", "*");
                    }else if (keyName == "budgetDepartCode") {
                        $("#budgetDepartCode").parent().parent().show();
                    } else if (keyName == "budgetSubjectsName") {
                        $("#budgetSubjectsName").parent().parent().show();
                    } else if (keyName == "productLevelName") {
                        $("#productLevelName").parent().parent().parent().show();
                    } else if (keyName == "productName") {
                        $("#productName").parent().parent().parent().show();
                    }else if (keyName == "productCode") {
                        $("#productCode").parent().parent().show();
                    } else if (keyName == "custName") {
                        $("#custName").parent().parent().parent().show();
                        $("#custName").attr("datatype", "*");
                    }else if (keyName == "custCode") {
                        $("#custCode").parent().parent().show();
                        $("#custCode").attr("datatype", "*");
                    } else if (keyName == "posCode") {
                        $("#posCode").parent().parent().show();
                    } else if (keyName == "posName") {
                        $("#posName").parent().parent().parent().show();
                        $("#posName").attr("datatype", "*");
                    } else if (keyName == "custOrgName") {
                        $("#custOrgName").parent().parent().parent().show();
                        $("#custOrgName").attr("datatype", "*");
                    } else if (keyName == "initAmount") {
                        $("#initAmount").parent().parent().show();
                        // var label1 = $("#initAmount").parent().parent().children("label");
                        // if($("#subjectsGroupCode").val() == "giftBuget" || $("#subjectsGroupCode").val() == "品尝预算" ||$("#subjectsGroupCode").val() == "tastBuget"){
                        //     $("#initAmount").parent().parent().children("label").text("金额");
                        //     label1.text("金额");
                        // }else {
                        //     $("#initAmount").parent().parent().children("label").text("销售额");
                        //     label1.text("销售额");
                        // }
                    } else if (keyName == "terminalName") {
                        $("#terminalName").parent().parent().parent().show();
                    } else if (keyName == "extChar1") {
                        $("#extChar1").parent().parent().show();
                        var label = $("#extChar1").parent().parent().children("label");
                        if($("#subjectsGroupCode").val() == "giftBuget" || $("#subjectsGroupCode").val() == "品尝预算" ||$("#subjectsGroupCode").val() == "tastBuget"){
                            $("#extChar1").parent().parent().children("label").text("数量");
                            label.text("数量");
                        }else {
                            $("#extChar1").parent().parent().children("label").text("销量");
                            label.text("销量");
                        }
                    } else if (keyName == "extChar2") {
                        $("#extChar2").parent().parent().show();
                    } else if (keyName == "extChar3") {
                        $("#extChar3").parent().parent().show();
                    } else if (keyName == "extChar4") {
                        $("#extChar4").parent().parent().show();
                    } else if (keyName == "extChar5") {
                        $("#extChar5").parent().parent().show();
                    } else if (keyName == "saleDiscountAmount"){
                        $("#saleDiscountAmount").parent().parent().show();
                    }else if (keyName == "productLongCode"){
                        $("#productLongCode").parent().parent().show();
                    }else if (keyName == "productSbu"){
                        $("#productSbu").parent().parent().show();
                    }else if (keyName == "productSbuName"){
                        $("#productSbuName").parent().parent().show();
                    }else if (keyName == "customerArea"){
                        $("#customerArea").parent().parent().show();
                    }else if (keyName == "productPrice"){
                        $("#productPrice").parent().parent().show();
                    }else if (keyName == "productSpec"){
                        $("#productSpec").parent().parent().show();
                    }else if (keyName == "productRate"){
                        $("#productRate").parent().parent().show();
                    }else if (keyName == "productUnit"){
                        $("#productUnit").parent().parent().show();
                    }else if (keyName == "productWeight"){
                        $("#productWeight").parent().parent().show();
                    }else if (keyName == "weight"){
                        $("#weight").parent().parent().show();
                    }else if (keyName == "saleDiscountNoRate"){
                        $("#saleDiscountNoRate").parent().parent().show();
                    }else if (keyName == "bookedAmount"){
                        $("#bookedAmount").parent().parent().show();
                    }else if (keyName == "saleIncome"){
                        $("#saleIncome").parent().parent().show();
                    }else if (keyName == "discountReason"){
                        $("#discountReason").parent().parent().parent().show();
                    }else if (keyName == "discountReasonCode"){
                        $("#discountReasonCode").parent().parent().show();
                    }else if (keyName == "bookedInCome"){
                        console.log("立账收入显示")
                        $("#bookedInCome").parent().parent().show();
                        // $("#bookedInCome").show();
                    }
                }
            },
            complete: function () {
                closeProgressTop();
            }
        });
    }

    /** 选择客户组织 */
    function goCustomerOrg(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "custOrgCode";
        triggerName = "custOrgName";
        url = "/page/tmApiCustOrgController/goCustOrgSelectMain?check=true";
        width = 500;
        height = 450;
        id = "customerList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;

                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].custOrgCode);
                    $("#" + triggerName).val(myobj[0].customerOrgName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    function cleanCustomerOrg() {
        $("#custOrgCode").val("");
        $("#custOrgName").val("");
    }


    /** 选择客户 */
    function goCustomer(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "custCode";
        triggerName = "custName";
        url = "/page/tmApiCustomerController/goCustomerListMain?check=true";
        width = 1000;
        height = 450;
        id = "customerList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].customerCode);
                    $("#" + triggerName).val(myobj[0].customerName);
                    $("#customerArea").val(myobj[0].area);
                    this.productPriceCondition = myobj[0].extChar20;
                    //扩展js方法
                    if(isExitsFunction('autoWriteOrg')){
                        autoWriteOrg(myobj);
                    }
                    changePrice();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /** 选择职位 */
    function goPosition(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "posCode";
        triggerName = "posName";
        url = "/page/tmApiPositionController/goPositionSelectMain?check=true";
        width = 1000;
        height = 450;
        id = "positionList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].positionCode);
                    $("#" + triggerName).val(myobj[0].positionName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /** 选择科目 */
    function goSbudgetSubjects(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "budgetSubjectsCode";
        triggerName = "budgetSubjectsName";
        url = "/budget/ttApiBudgetController/goBudgetSubjects";
        width = 1000;
        height = 450;
        id = "budgetSubjectsList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].budgetSubjectsCode);
                    $("#" + triggerName).val(myobj[0].budgetSubjectsName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /** 选择组织 */
    function goOrg(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "budgetDepartCode";
        triggerName = "budgetDepartName";
        url = "/page/tmApiOrgController/goOrgListMainPage";
        width = 1000;
        height = 450;
        id = "orgListMain";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].codeText);
                    $("#" + triggerName).val(myobj[0].nameText);

                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    //选择产品层级
    function selectProductLevel(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "productLevelCode";
        triggerName = "productLevelName";
        // valueField = "standPrice";
        url = "/page/tmApiProductLevelController/goProductListMain";
        width = 1000;
        height = 450;
        id = "productLevelList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                $("#productLevelName").focus();
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].productCode);
                    $("#" + triggerName).val(myobj[0].productName);
                    $("#productCode").val("");
                    $("#productName").val("");
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    /** 选择产品 */
    function goSelectProduct() {
        var productLevelCode = $("#productLevelCode").val();

        triggerId = "productCode";
        triggerName = "productName";
        url = "/page/tmApiWareController/goTmWareInfoListMain?productLevelCode=" + productLevelCode;
        width = 500;
        height = 450;
        id = "wareList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }
                } else {
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].wareCode);
                    $("#" + triggerName).val(myobj[0].wareName);
                    $("#productLongCode").val(myobj[0].extChar2);
                    $("#productSpec").val(myobj[0].specification);
                    $("#productWeight").val(myobj[0].extChar28);
                    $("#productRate").val(myobj[0].extChar5);
                    $("#productSbu").val(myobj[0].extChar30);
                    $("#productSbuName").val(myobj[0].extChar30Name);
                    $("#productUnit").val(myobj[0].saleUnit);
                    changePrice();
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });

    }

    //选择折让理由
    function chooseZRLY(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "discountReasonCode";
        triggerName = "discountReason";
        url = "/page/tmApiCustomerController/goDiscountReason";
        width = 1000;
        height = 450;
        id = "discountReasonList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].dictCode);
                    $("#" + triggerName).val(myobj[0].dictValue);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    //选择门店
    function selectTerminal(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
        triggerId = "terminalCode";
        triggerName = "terminalName";
        url = "/page/tmApiTerminalController/goTerminalListMain?clickFunctionId=${clickFunctionId}";
        width = 1000;
        height = 450;
        id = "terminalList";
        gridname = id;
        safeShowDialog({
            content: "url:" + url,
            lock: true,
            title: "选择",
            width: width == null ? 700 : width,
            height: height == null ? 400 : height,
            left: '85%',
            cache: false,
            ok: function () {
                iframe = this.iframe.contentWindow;
                var rowsData = iframe.$('#' + id).datagrid('getSelections');
                if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                    if (notRequired) {
                        $("#" + triggerName).val("");
                        $("#" + hiddenId).val("");
                        return true;
                    } else {
                        iframe.tip("请至少选择一条数据");
                        return false;
                    }

                } else {
                    if (validFunction != null && validFunction != "undefined") {
                        if (!validFunction(rowsData)) {
                            return false;
                        }
                    }
                    var myobj = eval(rowsData);
                    $("#" + triggerId).val(myobj[0].terminalCode);
                    $("#" + triggerName).val(myobj[0].terminalName);
                    return true;
                }
            },
            cancelVal: '关闭',
            cancel: true
        });
    }

    // $("#custCode,#productCode").change(function () {
    //     console.log("客户编码："+$("#custCode").val()+"。产品编码:"+$("#productCode").val())
    //     if ($("#custCode").val()!='' && $("#productCode").val()!=''){
    //         //获取价格
    //         changePrice();
    //     }else {
    //         $("#productPrice").val('');
    //     }
    // });
    //TODO 以下计算改为接口计算值
    $("#saleIncome").on('blur',function(){
        //计算立账收入
        if (myValidataNum($("#saleIncome").val()) && myValidataNum($("#saleDiscountNoRate").val())){
            let bookedInCome = $("#saleIncome").val() - $("#saleDiscountNoRate").val();
            $("#bookedInCome").val(bookedInCome);
        }else {
            $("#bookedInCome").val('');
        }
    });

    $("#initAmount").on('blur',function () {
        //计算单价、销量
        if (myValidataNum($("#productPrice").val()) && myValidataNum($("#initAmount").val())){
            let extChar1 = ($("#initAmount").val() / $("#productPrice").val()).toFixed(2)
            $("#extChar1").val(extChar1);
        }
        if (myValidataNum($("#extChar1").val()) && myValidataNum($("#initAmount").val())){
            let productPrice = ($("#initAmount").val() / $("#extChar1").val()).toFixed(2)
            $("#productPrice").val(productPrice);
        }
        //计算销售收入
        if (myValidataNum($("#initAmount").val()) && myValidataNum($("#productRate").val())){
            let saleIncome = ($("#initAmount").val()/(1+$("#productRate").val()/100)).toFixed(2)
            $("#saleIncome").val(saleIncome);
            $("#saleIncome").blur();
        }else {
            $("#saleIncome").val('');
            $("#saleIncome").blur();
        }
        //计算立账金额
        if (myValidataNum($("#initAmount").val()) && myValidataNum($("#saleDiscountAmount").val())){
            let bookedAmount = ($("#initAmount").val() - $("#saleDiscountAmount").val()).toFixed(2);
            $("#bookedAmount").val(bookedAmount);
        }else {
            $("#bookedAmount").val('');
        }
        //计算单价


    });
    $("#saleDiscountAmount").change(function () {
        //计算折让未税金额
        if (myValidataNum($("#productRate").val()) && myValidataNum($("#saleDiscountAmount").val())){
            console.log("税率："+$("#productRate").val()+"===折让金额："+$("#saleDiscountAmount").val()+"=====加后："+(1+$("#productRate").val()));
            let saleDiscountNoRate = ($("#saleDiscountAmount").val()/(1+$("#productRate").val()/100)).toFixed(2);
            $("#saleDiscountNoRate").val(saleDiscountNoRate);
            $("#saleDiscountNoRate").blur();
        }else {
            $("#saleDiscountNoRate").val('');
            $("#saleDiscountNoRate").blur();
        }

        //计算立账金额
        if (myValidataNum($("#initAmount").val()) && myValidataNum($("#saleDiscountAmount").val())){
            let bookedAmount = ($("#initAmount").val() - $("#saleDiscountAmount").val()).toFixed(2);
            $("#bookedAmount").val(bookedAmount);
        }else {
            $("#bookedAmount").val('');
        }

        if ($("#saleDisCOuntAmount").val()!=''){
            $("#discountReason").attr("datatype", "*");
        }else {
            $("#discountReason").val("");
            $("#discountReasonCode").val("");
            $("#discountReason").removeAttr("datatype");
        }

    });
    $("#saleDiscountNoRate").on('blur',function () {
        //计算立账收入
        if (myValidataNum($("#saleIncome").val()) && myValidataNum($("#saleDiscountNoRate").val())){
            let bookedInCome = ($("#saleIncome").val() - $("#saleDiscountNoRate").val()).toFixed(2);
            $("#bookedInCome").val(bookedInCome);
            $("#bookedInCome").blur();
        }else {
            $("#bookedInCome").val('');
            $("#bookedInCome").blur();
        }
    });

    //计算销量、单价、销售额
    $("#extChar1").change(function () {
        if (myValidataNum($("#extChar1").val()) && myValidataNum($("#productPrice").val())){
            $("#initAmount").val(($("#extChar1").val() * $("#productPrice").val()).toFixed(2));
            $("#initAmount").blur();
        }else {
            $("#initAmount").val('');
            $("#initAmount").blur();
        }
        if (myValidataNum($("#extChar1").val()) && myValidataNum($("#initAmount").val())){
            let productPrice = ($("#initAmount").val() / $("#extChar1").val()).toFixed(2)
            $("#productPrice").val(productPrice);
        }else {
            $("#productPrice").val('');
        }
        //计算总重量
        if (myValidataNum($("#extChar1").val()) && myValidataNum($("#productWeight").val())){
            var weight = (($("#extChar1").val() * $("#productWeight").val())/1000).toFixed(3)
            $("#weight").val(weight);
        }else {
            $("#weight").val('');
        }

    });
    $("#productPrice").change(function () {
        if (!myValidataNum($("#productPrice").val())){
            $("#initAmount").val('');
            $("#initAmount").blur();
            return;
        }
        if (myValidataNum($("#extChar1").val()) && myValidataNum($("#productPrice").val())){
            $("#initAmount").val(($("#extChar1").val() * $("#productPrice").val()).toFixed(2));
            $("#initAmount").blur();
        }else {
            $("#initAmount").val('');
            $("#initAmount").blur();
        }
        if (myValidataNum($("#productPrice").val()) && myValidataNum($("#initAmount").val())){
            let extChar1 = ($("#initAmount").val() / $("#productPrice").val()).toFixed(2)
            $("#extChar1").val(extChar1);
        }else {
            $("#extChar1").val('');
        }

    });

        function changePrice(){
            //计算总重量
            if (myValidataNum($("#extChar1").val()) && myValidataNum($("#productWeight").val())){
                var weight = (($("#extChar1").val() * $("#productWeight").val())/1000).toFixed(3)
                $("#weight").val(weight);
            }else {
                $("#weight").val('');
            }
            if ($("#custCode").val()=='' && $("#productCode").val()==''){
                $("#productPrice").val('');
                return;
            }
        $.ajax({
            type: "Post",
            async: true,
            dataType: 'json',
            contentType: "application/json;charset=UTF-8",
            url: "/mdm-api/mdmApi/productPriceApi/getProductPriceByPost",
            data: JSON.stringify({
                "customerCode": $("#custCode").val(),
                "productInfoCode": $("#productCode").val()
            }),
            success: function (data) {
                if (data.objList != undefined && data.objList.length !=0){
                    $("#productPrice").val(data.objList[0].unitPrice);
                }else{
                    $("#productPrice").val('');

                }
            }
        });
    }

    function myValidataNum(data){
            if (data !='' && data != null && !isNaN(data)){
                return true;
            }else {
                return false;
            }

    }
    // $("#productSbu").mouseover(function () {
    //     $('#productSbu').attr("disabled",true);
    // });
    // $("#productSbu").mouseout(function () {
    //     $('#productSbu').attr("disabled",false);
    // });

</script>

</html>
