<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete" extendUrlKey="incomeBudgetMain"></t:base>
<div id="coding_rules_List" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="fiscalList" tagConf="${clickFunctionId}" controllerTarget="ttIncomeBudgetController" methedTarget="getMaiListPage"  idField="id" queryMode="group" fit="true" fitColumns="true"
                    actionUrl="/budget/ttIncomeBudgetController/getMaiListPage" pagination="true" checkbox="true" singleSelect="false" pageSize="30">
            <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="扩展字段1" field="extChar1"  hidden="true" query="true"></t:dgCol>
            <t:dgCol title="扩展字段2" field="extChar2"  hidden="true" query="true"></t:dgCol>
            <t:dgCol title="扩展字段3" field="extChar3"  hidden="true" query="true"></t:dgCol>
            <t:dgCol title="扩展字段4" field="extChar4"  hidden="true" query="true"></t:dgCol>
            <t:dgCol title="扩展字段5" field="extChar5"  hidden="true" query="true"></t:dgCol>
            <t:dgCol title="预算编号" field="budgetCode" query="true"></t:dgCol>
            <t:dgCol title="年份" field="budgetYear"  query="true" ></t:dgCol>
            <t:dgCol title="月份" field="budgetMonth" dictionary="month"></t:dgCol>
            <t:dgCol title="分组" field="subjectsGroupCode" dictionary="imcome_group"></t:dgCol>
            <t:dgCol title="收入预算类型" field="budgetType" dictionary="budget_type"></t:dgCol>
            <t:dgCol title="金额" field="initAmount" hidden="false"></t:dgCol>
            <t:dgCol title="组织" field="budgetDepartName"></t:dgCol>
            <t:dgCol title="产品层级" field="productLevelName"></t:dgCol>
            <t:dgCol title="职位编码" field="posCode"></t:dgCol>
            <t:dgCol title="职位名称" field="posName"></t:dgCol>
            <t:dgCol title="客户编码" field="custCode"></t:dgCol>
            <t:dgCol title="客户名称" field="custName"></t:dgCol>
            <t:dgCol title="客户组织编码" field="custOrgCode"></t:dgCol>
            <t:dgCol title="客户组织名称" field="custOrgName"></t:dgCol>
            <t:dgCol title="门店编码" field="terminalCode"></t:dgCol>
            <t:dgCol title="门店名称" field="terminalName"></t:dgCol>
            <t:dgCol title="物料" field="productName"></t:dgCol>
            <t:dgCol title="创建人" field="createName"></t:dgCol>
            <t:dgCol title="创建时间" field="createDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
            <t:dgCol title="最近更新人" field="updateName" treefield="updateName"></t:dgCol>
            <t:dgCol title="最近更新时间" field="updateDate" treefield="updateDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>

            <t:dgToolBar title="添加" operationCode="add" icon="icon-add" url="/page/ttIncomeBudgetController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="add"></t:dgToolBar>
            <t:dgToolBar title="修改" operationCode="edit" icon="icon-edit" url="/page/ttIncomeBudgetController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="updateExtend"></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look" icon="icon-look" url="/page/ttIncomeBudgetController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="detail"></t:dgToolBar>
            <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="/budget/ttIncomeBudgetController/delete"
                         funname="deleteALLSelectList"></t:dgToolBar>
            <c:if test="${isDisplay == '1' }">
                <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn"
                         onclick="importExcel(${importUploadUrl})"></t:dgToolBar>
            </c:if>
            <t:dgToolBar title="变更申请" operationCode="commit" icon="icon-edit" width="900" height="500" url=""
                         funname="commit"></t:dgToolBar>
            <t:dgToolBar operationCode="bpmLog" title="流程日志" icon="icon-log" url="/page/knlLogController/goAuditTaskLogs"
                         width="1000" height="500"     funname="detail"></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut" excelName="收入预算" excelSheetName="收入预算"
                         url="/budget/commonExcelController/excel" funname="excelCommonExport"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="/page/knlLogController/goShowLog"
                         width="1000" height="500" funname="update"></t:dgToolBar>
            <t:dgToolBar title="明细" operationCode="detail" icon="icon-log"
                         url="/page/ttBudgutDetailController/goMain?type=income&clickFunctionId=${clickFunctionId}"
                         width="1000" height="500" funname="update"></t:dgToolBar>
            <t:dgToolBar title="导出明细" operationCode="detailOut" icon="icon-dataOut" url=""
                         funname="exportDetail"></t:dgToolBar>
            <t:dgToolBar title="个性设置" operationCode="style" icon="icon-add" url="/page/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500"     funname="addSelect"></t:dgToolBar>
        </t:datagrid>
    </div>
</div>
<script>
    $(document).ready(function(){
        $("input[name='productLevelName']").attr("name",'productLevelId');
        $("input[name='productLevelId']").combotree({
            width:128,
            url: '/mdm-api/mdmApi/productLevelApiCotroller/getTmProductTree'
        });
    });

    //修改扩展
    function updateExtend(title,url,girdname,width,height,options){
        var rowsDatas = $('#fiscalList').datagrid('getSelections');
        if(rowsDatas.length==1){
            for(var i=0;i<rowsDatas.length;i++){
                if(rowsDatas[i].approvalStatus!=null && (rowsDatas[i].approvalStatus=="2" || rowsDatas[i].approvalStatus=='2')){
                    console.log("预算修改时状态:"+rowsDatas[i].approvalStatus)
                    tip("该预算发起变更审批中，不能修改");
                    return;
                }
            }
        }else {
            tip("请选择一条数据进行操作");
            return;
        }

        if(isExitsFunction('updateBefore')){
            updateBefore(title,url,girdname,width,height,options);
        }else{
            update(title,url,girdname,width,height,options);
        }
    }

    /**提交工作流页面**/
    function commit(width,height) {
        if (isExitsFunction('commitextend')) {
            commitextend();
        }else {
            tip("操作失败！未获取到流程函数");
        }
    }


    function exportDetail(x1,x2,x3,x4,x5,x6) {
        var data={};
        data.budgetCode =$("[name ='budgetCode']").val()!=undefined?$("[name ='budgetCode']").val():"";
        data.budgetType =$("[name ='budgetType']").val()!=undefined?$("[name ='budgetType']").val():"";
        data.budgetYear =$("[name ='budgetYear']").val()!=undefined?$("[name ='budgetYear']").val():"";
        data.budgetMonth =$("[name ='budgetMonth']").val()!=undefined?$("[name ='budgetMonth']").val():"";
        data.subjectsGroupCode =$("[name ='subjectsGroupCode']").val()!=undefined?$("[name ='subjectsGroupCode']").val():"";
        data.custOrgCode =$("[name ='custOrgCode']").val()!=undefined?$("[name ='custOrgCode']").val():"";
        data.custOrgName =$("[name ='custOrgName']").val()!=undefined?$("[name ='custOrgName']").val():"";
        data.budgetSubjectsName =$("[name ='budgetSubjectsName']").val()!=undefined?$("[name ='budgetSubjectsName']").val():"";
        data.budgetSubjectsCode =$("[name ='budgetSubjectsCode']").val()!=undefined?$("[name ='budgetSubjectsCode']").val():"";
        data.productCode =$("[name ='productCode']").val()!=undefined?$("[name ='productCode']").val():"";
        data.productLongCode =$("[name ='productLongCode']").val()!=undefined?$("[name ='productLongCode']").val():"";
        data.custCode =$("[name ='custCode']").val()!=undefined?$("[name ='custCode']").val():"";
        data.custName =$("[name ='custName']").val()!=undefined?$("[name ='custName']").val():"";
        data.createName =$("[name ='createName']").val()!=undefined?$("[name ='createName']").val():"";
        data.enableStatus =$("[name ='enableStatus']").val()!=undefined?$("[name ='enableStatus']").val():"";
        var url = "/budget/ttInComeBudgetImportController/exportBudgetDetail";

        var form = $('<form method="Get" action="' + url + '">');
        form.append($('<input type="hidden" name="budgetCode" value="' + data.budgetCode + '">'));
        form.append($('<input type="hidden" name="budgetYear" value="' + data.budgetYear + '">'));
        form.append($('<input type="hidden" name="budgetMonth" value="' + data.budgetMonth + '">'));
        form.append($('<input type="hidden" name="subjectsGroupCode" value="' + data.subjectsGroupCode + '">'));
        form.append($('<input type="hidden" name="custOrgCode" value="' + data.custOrgCode + '">'));
        form.append($('<input type="hidden" name="custOrgName" value="' + data.custOrgName + '">'));
        form.append($('<input type="hidden" name="budgetSubjectsName" value="' + data.budgetSubjectsName + '">'));
        form.append($('<input type="hidden" name="budgetSubjectsCode" value="' + data.budgetSubjectsCode + '">'));
        form.append($('<input type="hidden" name="productCode" value="' + data.productCode + '">'));
        form.append($('<input type="hidden" name="custCode" value="' + data.custCode + '">'));
        form.append($('<input type="hidden" name="custName" value="' + data.custName + '">'));
        form.append($('<input type="hidden" name="createName" value="' + data.createName + '">'));
        form.append($('<input type="hidden" name="enableStatus" value="' + data.enableStatus + '">'));
        form.append($('<input type="hidden" name="budgetType" value="' + data.budgetType + '">'));
        form.append($('<input type="hidden" name="productLongCode" value="' + data.productLongCode + '">'));
        $('body').append(form);
        form.submit(); //自动提交
    }

</script>
