<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,DatePicker"></t:base>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <style>
        [v-cloak]{
            display: none;
        }
        .search {
            background: #0D3349;
            color: #ffffff;
            font-size: 12px;
            border: none;
            outline: none;
            height: 22px;
        }
    </style>
</head>


<body>
<div id="app" v-cloak>
    <div>
        <span style="font-size: 12px">开始时间</span>
        <input name="beginTime" id="beginTime" class="Wdate" style="width: 150px;"
               onclick="WdatePicker({dateFmt:'yyyy-MM-dd'})"
               readonly="readonly" value=""/>
        <span style="font-size: 12px">结束时间</span>
        <input name="endTime" id="endTime" class="Wdate" style="width: 150px;"
               onclick="WdatePicker({dateFmt:'yyyy-MM-dd'})"
               readonly="readonly" value=""/>
        <button class="search" @click="query">查询</button>
    </div>
    <div ref="timesLine" style="width: 100%;height:400px;box-sizing: border-box;"></div>
    <div ref="successPipe" style="width: 100%;height:400px;box-sizing: border-box;"></div>
</div>

<script src="/resources/tools/vue.min.js"></script>
<script src="/resources/echarts/echarts.min.js"></script>

<script>
    var vm = new Vue({
        el: "#app",
        name: "",
        data: function () {
            return {
                pageData: {},
                timesLine: null,
                successPipe: null
            }
        },
        created: function () {

        },
        mounted: function () {
            let now = new Date();
            let year = now.getFullYear();
            let month = now.getMonth();
            let day = now.getDate();
            let start = new Date(year, month, 1);
            let end = new Date(year, month + 1, 0);
            $("#beginTime").val(this.formatDate(start));
            $("#endTime").val(this.formatDate(end));
            this.loadData();
        },
        methods: {
            loadData: function () {
                var this_ = this;
                $.ajax({
                    url: "/kernel/knlExceptionController/getExceptionRecord",
                    type: "post",
                    dataType: "json",
                    data: {
                        beginTime: $("#beginTime").val(),
                        endTime: $("#endTime").val()
                    },
                    success: function (res) {
                        if (res.success) {
                            this_.pageData = res.obj;
                            this_.initTimesLine();
                            this_.initSuccessPipe();
                        }
                    }
                })
            },
            query: function () {
                this.loadData();
            },
            initTimesLine: function () {
                this.timesLine = echarts.init(this.$refs.timesLine);
                var option = {
                    title: {
                        text: "异常次数实时数据",
                        x: 'center'
                    },
                    tooltip: {
                        trigger: 'axis'
                    },
                    xAxis: {
                        type: 'category',
                        data: this.pageData.timeArray
                    },
                    yAxis: {
                        type: 'value'
                    },
                    series: [{
                        data: this.pageData.countArray,
                        type: 'line',
                        smooth: true,
                        lineStyle: {
                            color: "#1890ff",
                        }
                    }]
                };
                this.timesLine.setOption(option);
            },
            initSuccessPipe: function () {
                this.successPipe = echarts.init(this.$refs.successPipe);
                var option = {
                    title: {
                        text: "各模块异常次数",
                        x: 'center'
                    },
                    color: ['#f9ff0b', 'red', '#28004d', '#e49b3a', '#43c232', '#c2751c', '#d664cb','#4EAFB6','#249db6','#aea5b6','#c298ba','#dd001d','#fb934b','#F9FF0B'],
                    legend: {
                        orient: 'vertical',
                        x: '70%',
                        y: 'center',
                    },
                    series: [{
                        name: '',
                        type: 'pie',
                        center: ['50%', '50%'],
                        data: this.pageData.exceptionChartVoArray,
                    }]
                };

                this.successPipe.setOption(option);
            },
            formatDate: function (date) {
                let year = date.getFullYear();
                let month = date.getMonth() + 1;
                let day = date.getDate();
                month = month.toString().length > 1 ? month : "0" + month;
                day = day.toString().length > 1 ? day : "0" + day;
                return [year, month, day].join("-");
            },
        }
    })
</script>
</body>

</html>