<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>沟通人员列表</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <link rel="stylesheet" href="/resources/sfa/css/mescroll.min.css">
    <link rel="stylesheet" href="/resources/sfa/fontawesome/css/font-awesome.min.css">
    <style>
        body {
            background: #f3f3f3;
        }

        .search-bar {
            height: 40px;
            padding: 0 15px;
            margin: 10px 0;
            width: 100%;
            box-sizing: border-box;
            position: absolute;
            top: 0;
            z-index: 50;
        }

        .search-input {
            width: 100%;
            position: relative;
        }

        .search-input > input {
            width: 100%;
            box-sizing: border-box;
            border: 1px solid #eee;
            height: 35px;
            line-height: 35px;
            border-radius: 5px;
            font-size: 14px;
            padding: 0 10px 0 30px;
            outline: none;
        }

        .search-icon {
            position: absolute;
            left: 10px;
            top: 7px;
        }

        .search-icon > span {
            color: #aaa;
        }

        .list-wrapper {
            height: calc(100vh - 40px);
            overflow-y: hidden;
        }

        .list-content {
            list-style: none;
            padding: 0 10px;
            margin: 0;
            box-sizing: border-box;
        }

        .list-item {
            margin-bottom: 10px;
            padding: 10px;
            font-size: 14px;
            color: #333333;
            background: #ffffff;
            border-radius: 5px;
            position: relative;
        }
        .checked-flag{
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
        }
        .checked-flag span{
            font-size: 24px;
            color: #1890FF;
        }

        .list-item-title {
            width: 100%;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            font-weight: 600;
        }

        .item-label {
            font-weight: 600;
        }

        .item-value {
            color: #666666;
        }

        .mescroll {
            position: fixed;
            top: 55px;
            bottom: 40px;
            height: auto;
        }
        .submit-btn{
            position: fixed;
            bottom: 0;
            height: 35px;
            width: 100%;
            background: #1890ff;
            color: #ffffff;
            border:none;
            outline: none;
        }
        .submit-btn:active{
            opacity: .8;
        }
    </style>
</head>

<body>
<div id="app" v-cloak>
    <div class="search-bar">
        <form @submit.prevent="handleSearch">
            <div class="search-input">
                <input type="text" v-model="positionName" placeholder="请输入职位名称">
                <div class="search-icon">
                    <span class="fa fa-search"></span>
                </div>
            </div>
        </form>
    </div>
    <div ref="wrapper" class="mescroll">
        <ul class="list-content">
            <li @click="clickItem(item)" class="list-item" v-for="item in memberList" :key="item.id">
                <div class="pv5">
                    <span class="item-label">姓名：</span>
                    <span class="item-value">{{item.fullname}}</span>
                </div>
                <div class="pv5">
                    <span class="item-label">职位名称：</span>
                    <span class="item-value">{{item.positionName}}</span>
                </div>
                <div class="pv5">
                    <span class="item-label">职位编码：</span>
                    <span class="item-value">{{item.positionCode}}</span>
                </div>
                <div class="checked-flag" v-if="ids.indexOf(item.id)>-1">
                    <span class="fa fa-check-circle"></span>
                </div>
            </li>
        </ul>
    </div>
    <button class="submit-btn" @click="handleSubmit">确定</button>
</div>

<script src="/resources/sfa/js/vue.min.js"></script>
<script src="/resources/sfa/js/common.js"></script>
<script src="/resources/sfa/js/jquery.min.js"></script>
<script src="/resources/sfa/js/mescroll.min.js"></script>

<script>
    function onJsJumpWithUrl(url) {
        js.onJsJumpWithUrl(url);
    }

    var vm = new Vue({
        el: "#app",
        name: "memberList",
        data: function () {
            return {
                positionName: "",
                page: 1,
                rows: 10,
                token: "",
                taskId:"",
                processInstanceId:"",
                type:"",
                memberList: [],
                ids:[],
                scroll: null
            }
        },
        created: function () {
            this.token = getParameterByName("token");
            this.taskId = getParameterByName("taskId");
            this.processInstanceId = getParameterByName("processInstanceId");
            this.type = getParameterByName("type");
            this.loadData();
        },
        mounted: function () {
            let this_ = this;
            setTimeout(function () {
                this_.scroll = new MeScroll(this_.$refs.wrapper, {
                    down: {
                        callback: this_.downCallback
                    },
                    up: {
                        callback: this_.upCallback,
                        scrollbar: false
                    }
                });
            }, 20)

        },
        computed: {},
        filters:{
            formatDate:function(date){
                if (!date) return;
                date = date.replace(/-/g,"/");
                date = new Date(date);
                let year = date.getFullYear();
                let month = date.getMonth() + 1;
                let day = date.getDate();
                month = month + '';
                month = month[1] ? month : '0' + month;
                day = day + '';
                day = day[1] ? day : '0' + day;
                return [year, month, day].join("-");
            }
        },
        methods: {
            downCallback: function () {
                this.page = 1;
                this.loadData();
            },
            upCallback: function (page, mescroll) {
                this.page = page.num;
                this.loadData()
            },
            handleSearch: function () {
                this.page = 1;
                this.loadData();
            },
            loadData:function() {
                var this_ = this;
                $.ajax({
                    url: SERVER + "/activiti/taCarbonCopyController/getRolesOrPositions",
                    type: "post",
                    data:{
                        sendType:1,
                        page:this_.page,
                        rows:this_.rows,
                        positionName:this_.positionName
                    },
                    dataType: "json",
                    contentType: "application/x-www-form-urlencoded",
                    headers: {
                        'loginUserToken': this_.token
                    },
                    success: function (res) {
                        if (res.success) {
                            if (this_.page>1) {
                                this_.memberList = this_.memberList.concat(res.rows || []);
                                this_.scroll && this_.scroll.endByPage(res
                                    .rows.length, res.total)
                            } else {
                                this_.memberList = res.rows || [];
                                this_.scroll && this_.scroll.endByPage(res
                                    .rows.length, res.total)
                            }
                        }else{
                            showError(res.msg);
                            this_.scroll && this_.scroll.endErr();
                        }
                    },
                    error: function (error) {
                        this_.scroll && this_.scroll.endErr();
                    }
                })
            },
            clickItem:function(item){
                let id = item.id;
                let index = this.ids.indexOf(id);
                if(index>-1){
                    this.ids.splice(index,1);
                }else{
                    this.ids.push(id);
                }
            },
            handleSubmit:function() {
                if(this.ids.length===0){
                    showError("请先选择人员");
                    return;
                }
                let url = "";
                if(this.type==="communicate"){
                    url = "/page/sfaWebController/communication?ids=" + this.ids.join(",")+"&taskId="+this.taskId;
                }
                if(this.type==="cc"){
                    url = "/page/sfaWebController/cc?ids=" + this.ids.join(",")+"&processInstanceId="+this.processInstanceId;
                }
                var u = navigator.userAgent;
                var isAndroid = u.indexOf('Android') > -1 || u.indexOf('Adr') > -1; //android终端
                var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
                if(isAndroid){
                    onJsJumpWithUrl(url);
                }
                if(isiOS){
                    window.webkit.messageHandlers.onJsJumpWithUrl.postMessage(url);
                }
            }
        }
    })
</script>
</body>

</html>