<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools"/>
<div class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="myRunningProcessList" tagConf="${clickFunctionId}"
                    actionUrl="/activiti/taProcessInstanceController/findMyStartedProcessList?1=1"
                    fitColumns="true" idField="id" fit="true" queryMode="group">
            <t:dgCol title="编号" field="id" hidden="true"/>
            <t:dgCol title="流程编号" field="processInstanceId" query="true"/>
            <t:dgCol title="流程Key" field="processDefinitionKey" hidden="true"/>
            <t:dgCol title="流程名称" field="processDefinitionName" query="true"/>
            <t:dgCol title="流程标题" field="processTitle" query="true"/>
            <t:dgCol title="业务编码" field="businessObjNum" query="true"/>
            <t:dgCol title="发起人" field="startPositionCode" hidden="true"/>
            <t:dgCol title="开始时间" field="startTime"/>
            <t:dgCol title="结束时间" field="endTime"/>
            <t:dgCol title="耗时" field="spendTimes"/>
            <t:dgCol title="流程状态" field="runtimeStatus" replace="处理中_doing,完成_completed,驳回_reject,流程追回_recover"
                     query="true"/>
            <t:dgToolBar  icon="icon-look" id="processView" operationCode="look"
                         url="/page/taTaskController/goInstanceHandleTabForm?isView=true&isReadFlag=false" funname="view"
                         params="processInstanceId" title="查看" height="500" width="1200"/>
            <%--<t:dgToolBar  icon="icon-process_back" id="callbackId"--%>
                         <%--url="${activitiRoot}taProcessInstanceController/callBackProcess" exp="runtimeStatus#eq#'doing'"--%>
                         <%--funname="systemConfirm" params="processInstanceId" title="流程追回"/>--%>
            <t:dgToolBar  icon="icon-process_back" id="callbackId" operationCode="callBackProcess"
                         url="/activiti/taProcessInstanceController/callBackProcess"
                         funname="callBackProcess" params="processInstanceId" title="流程追回"/>
            <t:dgToolBar title="抄送" operationCode="manual_copy" icon="icon-check_copy" width="800" height="800" url=""
                         funname="manualCopy" ></t:dgToolBar>
            <t:dgToolBar  icon="icon-look" id="copyView" operationCode="copyView"
                         url="/page/taCarbonCopyController/goCopyPersonInfoMain?1=1" funname="view" params="processInstanceId"
                         title="查看抄送" width="600" height="400"/>
        </t:datagrid>
    </div>
<script type="text/javascript">

    function manualCopy() {
        var rowsDatas = $('#myRunningProcessList').datagrid('getSelections');
        if(rowsDatas.length!=1){
            tip("请选择一条数据");
            return;
        }
        if(rowsDatas[0].runtimeStatus !== 'completed'){
            tip("只有已完成状态的流程才可抄送。");
            return;
        }
        var addurl = "/page/taCarbonCopyController/goManualCarbonCopyMain?processInstanceId=" + rowsDatas[0].processInstanceId + "&processDefinitionId="+rowsDatas[0].processDefinitionId;
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: 800,
            height: 600,
            title: '抄送',
            opacity: 0.3,
            // parent:'addActMain',
            id:'addAct',
            cache: false,
        };
        $.dialog(myOptions);
    }
    //流程追回
    function callBackProcess(title, url, gridname) {
        var rowsData = $('#' + gridname).datagrid('getSelections');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择追回项目');
            return;
        }

        var processInstanceId = rowsData[0].processInstanceId;

        confirm(url + '?processInstanceId=' + processInstanceId, '确定追回吗？', gridname);
    }
</script>