<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker,autocomplete" extendUrlKey="feeBudgetMain"></t:base>
<div id="coding_rules_List" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="fiscalList" tagConf="${clickFunctionId}" controllerTarget="ttFeeBudgetController"
                    methedTarget="getMaiListPage" idField="id" queryMode="group" fit="true" fitColumns="false" singleSelect="false"
                    actionUrl="/budget/ttFeeBudgetController/getMaiListPage" pagination="true" checkbox="true">
            <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
            <t:dgCol title="扩展字段1" field="extChar1" hidden="true" query="false"></t:dgCol>
            <t:dgCol title="扩展字段2" field="extChar2" hidden="true" query="false"></t:dgCol>
            <t:dgCol title="扩展字段3" field="extChar3" hidden="true" query="false"></t:dgCol>
            <t:dgCol title="扩展字段4" field="extChar4" hidden="true" query="false"></t:dgCol>
            <t:dgCol title="扩展字段5" field="extChar5" hidden="true" query="false"></t:dgCol>
            <t:dgCol title="预算编号" field="budgetCode" query="true"></t:dgCol>
            <t:dgCol title="年份" field="budgetYear" query="true"></t:dgCol>
            <t:dgCol title="月份" field="budgetMonth" dictionary="month"></t:dgCol>
            <t:dgCol title="分组" field="subjectsGroupCode" dictionary="budget_group"></t:dgCol>
            <t:dgCol title="组织" field="budgetDepartName"></t:dgCol>
            <t:dgCol title="科目编码" field="budgetSubjectsCode" query="true"></t:dgCol>
            <t:dgCol title="科目名称" field="budgetSubjectsName" query="true"></t:dgCol>
            <t:dgCol title="渠道" field="vkorgCode" dictionary="channel"></t:dgCol>
            <t:dgCol title="产品层级" field="productLevelName" query="true"></t:dgCol>
            <t:dgCol title="物料" field="productName"></t:dgCol>
            <t:dgCol title="客户编码" field="custCode"></t:dgCol>
            <t:dgCol title="客户名称" field="custName"></t:dgCol>
            <t:dgCol title="客户组织" field="custOrgName" query="true"></t:dgCol>
            <t:dgCol title="门店" field="terminalName"></t:dgCol>
            <t:dgCol title="期初金额" field="initAmount"></t:dgCol>
            <t:dgCol title="当前余额" field="amount"></t:dgCol>
            <t:dgCol title="调整金额" field="adjustAmount"></t:dgCol>
            <t:dgCol title="调整后金额" field="afterAmount"></t:dgCol>
            <t:dgCol title="已使用金额" field="useMoney" formatterjs="doMath"></t:dgCol>
            <t:dgCol title="特殊区域类型" field="specialAreaCode" hidden="true"></t:dgCol>
            <t:dgCol title="特殊区域类型名称" field="specialAreaName" hidden="true"></t:dgCol>
            <t:dgCol title="状态" field="enableStatus" dictionary="enable_status" query="true"></t:dgCol>
            <t:dgCol title="备注" field="notes" hidden="true"></t:dgCol>
            <t:dgCol title="创建人" field="createName"></t:dgCol>
            <t:dgCol title="创建时间" field="createDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
            <t:dgCol title="最近更新人" field="updateName"></t:dgCol>
            <t:dgCol title="最近更新时间" field="updateDate" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>

            <t:dgCol title="业务编码" field="businessCode" hidden="true" query="false"></t:dgCol>
            <t:dgCol title="业务编码附属" field="businessCodeAttached" hidden="true" query="false"></t:dgCol>

            <t:dgToolBar title="添加" operationCode="add" icon="icon-add"
                         url="/page/ttFeeBudgetController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="add"></t:dgToolBar>
            <t:dgToolBar title="修改"  operationCode="edit" icon="icon-edit"
                         url=""
                         funname="newUpdate"></t:dgToolBar>
            <t:dgToolBar title="预算调整" operationCode="adjustAmount" icon="icon-edit"
                         url="/page/ttFeeBudgetController/goAdjustAmount?clickFunctionId=${clickFunctionId}"
                         funname="adjustAmount" height="400" width="800"></t:dgToolBar>
<%--            <t:dgToolBar title="预算变更" operationCode="updateAmount" icon="icon-edit"--%>
<%--                         url="/page/ttFeeBudgetController/goUpdateAmount?clickFunctionId=${clickFunctionId}"--%>
<%--                         funname="update" height="560" width="470"></t:dgToolBar>--%>
            <t:dgToolBar title="变更申请" operationCode="commit" icon="icon-edit" width="900" height="500" url=""
                         funname="commit"></t:dgToolBar>
            <t:dgToolBar operationCode="bpmLog" title="流程日志" icon="icon-log" url="/page/knlLogController/goAuditTaskLogs"
                         width="1000" height="500"     funname="detail"></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="look" icon="icon-look"
                         url="/page/ttFeeBudgetController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}"
                         funname="detail"></t:dgToolBar>
            <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="/budget/ttFeeBudgetController/delete"
                         funname="deleteALLSelectList"></t:dgToolBar>
            <t:dgToolBar title="停用" operationCode="stop" icon="icon-stop" url="/budget/ttFeeBudgetController/disAble"
                         funname="stopALLSelectList"></t:dgToolBar>
            <t:dgToolBar title="启用" operationCode="start" icon="icon-start" url="/budget/ttFeeBudgetController/enAble"
                         funname="startALLSelectList"></t:dgToolBar>
            <c:if test="${isDisplay == '1' }">
                <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn"
                             onclick="importExcel(${importUploadUrl})"></t:dgToolBar>
            </c:if>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut" excelName="费用预算" excelSheetName="费用预算"
                         url="/budget/commonExcelController/excel" funname="excelCommonExport"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="/page/knlLogController/goShowLog"
                         width="1000" height="500" funname="update"></t:dgToolBar>
            <t:dgToolBar title="明细" operationCode="detail" icon="icon-log"
                         url="/page/ttBudgutDetailController/goMain?type=fee&clickFunctionId=${clickFunctionId}"
                         width="1000" height="500" funname="update"></t:dgToolBar>
            <t:dgToolBar title="导出明细" operationCode="detailOut" icon="icon-dataOut" url=""
                         funname="exportDetail"></t:dgToolBar>
            <t:dgToolBar title="个性设置" operationCode="style" icon="icon-add"
                         url="/page/knlSelectListController/goSelectList?functionId=${clickFunctionId}"
                         width="600" height="500" funname="addSelect"></t:dgToolBar>
            <%--<t:dgToolBar title="申请范围-预算关系维护" operationCode="areaFeeBudgetRel" icon="icon-stores_group" width="1100" height="600"
                         url="/page/ttFeeBudgetController/goFeeBudgetBindSpecialAreaMain?functionId=${clickFunctionId}"  funname="updateFeeBudgetSpecialArea"></t:dgToolBar>--%>

        </t:datagrid>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        //     url: '/kernel/mdmProductLevelController/getTmProductNameTree'
        $("input[name='productLevelName']").attr("name", 'productLevelId');
        $("input[name='productLevelId']").combotree({
            width:128,
            url: '/mdm-api/mdmApi/productLevelApiCotroller/getTmProductTree'
        });
    });
    function doMath(value,row,index) {
        if(!value){
            return value;
        }
        return Math.abs(value)
    }
    //预算调整构建参数
    function adjustAmount(title, url, id, width, height, params) {
        title = "预算调整";
        url = "/page/ttFeeBudgetController/goAdjustAmount?clickFunctionId=${clickFunctionId}";
        height = "570";
        width = "800";
        id = "fiscalList";
        gridname = id;
        var rowsData = $('#' + id).datagrid('getSelections');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择编辑项目');
            return;
        }
        if (rowsData.length > 1) {
            tip('请选择一条记录再编辑');
            return;
        }
        if (!checkAndExecallBack_before(params, rowsData)) {
            return;
        }
        var _char = "&";
        if (url.indexOf("?") == -1) {
            _char = "?";
        }

        url += _char + 'id=' + rowsData[0].id;
        createwindowSmallOver(title, url, width, height);
    }

    //预算调整弹框处理
    function createwindowSmallOver(title, addurl, width, height, options) {
        var offsetW = window.top.document.body.offsetWidth;
        var offsetH = window.top.document.body.offsetHeight;
        width = (width && width != 'null') ? width : 700;
        height = (height && height != 'null') ? height : 400;
        if (width == "100%" || width > offsetW) {
            width = offsetW;
        }
        if (height == "100%" || height > (offsetH - 100)) {
            height = offsetH - 100;
        }
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: parseInt(width),
            height: parseInt(height),
            title: title,
            opacity: 0.3,
            parent: 'feeBudgetAdjustAmount',
            cache: false,
            /* 为true等价于function(){} */
        };
        if (typeof (options) == "undefined" || typeof (options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    // saveObj();
                    iframe.saveData();
                    return false;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }

    /**提交工作流页面**/
    function commit(width,height) {
        if (isExitsFunction('commitextend')) {
            commitextend();
        }else {
            tip("操作失败！未获取到流程函数");
        }
    }


    /**
     * 预算关联 区域
     * @param title
     * @param url
     * @param gridname
     * @param width
     * @param height
     */
    function updateFeeBudgetSpecialArea(title, url, gridname, width, height) {
        openwindow(title, url, gridname, width, height);
    }

    function exportDetail(x1,x2,x3,x4,x5,x6) {
        var data={};
        data.budgetCode =$("[name ='budgetCode']").val()!=undefined?$("[name ='budgetCode']").val():"";
        data.budgetYear =$("[name ='budgetYear']").val()!=undefined?$("[name ='budgetYear']").val():"";
        data.budgetMonth =$("[name ='budgetMonth']").val()!=undefined?$("[name ='budgetMonth']").val():"";
        data.subjectsGroupCode =$("[name ='subjectsGroupCode']").val()!=undefined?$("[name ='subjectsGroupCode']").val():"";
        data.custOrgName =$("[name ='custOrgName']").val()!=undefined?$("[name ='custOrgName']").val():"";
        data.budgetSubjectsName =$("[name ='budgetSubjectsName']").val()!=undefined?$("[name ='budgetSubjectsName']").val():"";
        data.budgetSubjectsCode =$("[name ='budgetSubjectsCode']").val()!=undefined?$("[name ='budgetSubjectsCode']").val():"";
        data.productCode =$("[name ='productCode']").val()!=undefined?$("[name ='productCode']").val():"";
        data.custCode =$("[name ='custCode']").val()!=undefined?$("[name ='custCode']").val():"";
        data.custName =$("[name ='custName']").val()!=undefined?$("[name ='custName']").val():"";
        data.createName =$("[name ='createName']").val()!=undefined?$("[name ='createName']").val():"";
        data.enableStatus =$("[name ='enableStatus']").val()!=undefined?$("[name ='enableStatus']").val():"";
        data.createDate =$("[name ='createDate']").val()!=undefined?$("[name ='createDate']").val():"";
        var url = "/budget/ttFeeBudgetExtendController/exportBudgetDetail";

        var form = $('<form method="Get" action="' + url + '">');
        form.append($('<input type="hidden" name="budgetCode" value="' + data.budgetCode + '">'));
        form.append($('<input type="hidden" name="budgetYear" value="' + data.budgetYear + '">'));
        form.append($('<input type="hidden" name="budgetMonth" value="' + data.budgetMonth + '">'));
        form.append($('<input type="hidden" name="subjectsGroupCode" value="' + data.subjectsGroupCode + '">'));
        form.append($('<input type="hidden" name="custOrgName" value="' + data.custOrgName + '">'));
        form.append($('<input type="hidden" name="budgetSubjectsName" value="' + data.budgetSubjectsName + '">'));
        form.append($('<input type="hidden" name="budgetSubjectsCode" value="' + data.budgetSubjectsCode + '">'));
        form.append($('<input type="hidden" name="productCode" value="' + data.productCode + '">'));
        form.append($('<input type="hidden" name="custCode" value="' + data.custCode + '">'));
        form.append($('<input type="hidden" name="custName" value="' + data.custName + '">'));
        form.append($('<input type="hidden" name="createName" value="' + data.createName + '">'));
        form.append($('<input type="hidden" name="enableStatus" value="' + data.enableStatus + '">'));
        form.append($('<input type="hidden" name="createDate" value="' + data.createDate + '">'));
         $('body').append(form);
        form.submit(); //自动提交
    }

    function newUpdate() {
        var rowsDatas = $('#fiscalList').datagrid('getSelections');
        if(rowsDatas.length==1){
            for(var i=0;i<rowsDatas.length;i++){
                if(rowsDatas[i].approvalStatus=='2'){
                    tip("该预算发起变更审批中，不能修改");
                    return;
                }
            }
        }else {
            tip("请选择一条数据进行操作");
            return;
        }

        var addurl = "/page/ttFeeBudgetController/goSaveOrUpdate?clickFunctionId=${clickFunctionId}&id="+rowsDatas[0].id;
        var myOptions = {
            content: 'url:' + addurl,
            lock: true,
            width: 400,
            height: 500,
            title: '编辑',
            opacity: 0.3,
            // parent:'addActMain',
            id:'addFeeBudget',
            cache: false,
        };
        if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
            $.extend(myOptions, {
                ok: function () {
                    iframe = this.iframe.contentWindow;
                    // iframe.saveData();
                    $('#btn_sub', iframe.document).click();
                    return false;
                },
                cancelVal: '关闭',
                cancel: true
            });
        }
        $.dialog(myOptions);
    }
</script>
