<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/context/mytags.jsp" %>
<t:base type="jquery"></t:base>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>列表显示</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <link rel="stylesheet" href="/resources/tools/css/common.css" type="text/css">
    <link rel="stylesheet" href="/resources/fontawesome/css/font-awesome.min.css" type="text/css">
</head>

<body>
<div class="biz-transfer flex flex-align-items-center">
    <div class="biz-transfer-left flex-1">
        <div class="biz-transfer-title pv10">隐藏字段</div>
        <ul class="left-list biz-transfer-list">

        </ul>
    </div>
    <div class="biz-transfer-center flex-none">
        <button class="biz-transfer-btn" onclick="addToRight()"><span class="fa fa-angle-right"></span></button>
        <button class="biz-transfer-btn" onclick="removeRight()"><span class="fa fa-angle-left"></span></button>
        <button class="biz-transfer-btn" onclick="addAll()"><span class="fa fa-angle-double-right"></span></button>
        <button class="biz-transfer-btn" onclick="removeAll()"><span class="fa fa-angle-double-left"></span></button>
    </div>
    <div class="biz-transfer-right flex-1">
        <div class="biz-transfer-title pv10">显示字段</div>
        <ul class="right-list biz-transfer-list" id="sortable">

        </ul>
    </div>
</div>
<script src="/resources/jquery-ui/js/jquery-ui-1.9.2.custom.min.js"></script>
<script>
    var functionId = '${functionId}';
    var leftData = '${leftData}';
    var rightData = '${rightData}';
    $(function () {
        var leftContainer = $(".left-list");
        var rightContainer = $(".right-list");
        renderList(leftContainer, JSON.parse(leftData));
        renderList(rightContainer, JSON.parse(rightData), true);
    });

    //添加
    function addToRight() {
        var selectArray = getLeftSelect();
        //移除左边选中的
        $.each(selectArray, function (index, item) {
            $(".left-list").find('li[data-field="' + item.field + '"]').remove();
        });
        addToRightList(selectArray);
    }

    //移除
    function removeRight() {
        var selectArray = getRightSelect();
        $.each(selectArray, function (index, item) {
            $(".right-list").find('li[data-field="' + item.field + '"]').remove();
        });
        addToLeftList(selectArray);
    }

    //添加全部
    function addAll() {
        var all = getLeftAll();
        $(".left-list").empty();
        addToRightList(all);
    }

    //移除全部
    function removeAll() {
        var all = getRightAll();
        $(".right-list").empty();
        addToLeftList(all);
    }

    //渲染生成列表
    function renderList(container, array, showQuery) {
        var list = "";
        $.each(array, function (index, item) {
            if(showQuery){
                list += '<li title="可进行拖动排序" data-query="' + item.isSearch + '" data-field="' + item.field + '" data-title="' + item.title + '" data-status="' + item.status + '" data-functionId="' + item.functionId + '" data-tableTags="' + item.tableTags + '" data-isSearchConf="' + item.isSearchConf + '">';
            }else{
                list += '<li data-query="' + item.isSearch + '" data-field="' + item.field + '" data-title="' + item.title + '" data-status="' + item.status + '" data-functionId="' + item.functionId + '" data-tableTags="' + item.tableTags + '" data-isSearchConf="' + item.isSearchConf + '">';
            }
            list += '<label class="mr10">';
            list += item.checked ? '<input class="transfer-input" type="checkbox" checked="checked">' : '<input class="transfer-input" type="checkbox">';
            list += '<span>' + item.title,
                list += '</span>',
                list += '</label>';
            if (showQuery) {
                list += '<label>';
                if (item.isSearchConf == 1){
                    list += '<span>查询',
                        list += '</span>',
                        list += item.isSearch==1 ? '<input class="query-input" type="checkbox" checked="checked">' : '<input class="query-input" type="checkbox">';
                }
                list += '</label>';
            }
            list += '</li>';
        });
        container.html(list);
        if (showQuery) {
            $("#sortable").sortable();
            $("#sortable").disableSelection();
        }
    }

    //添加到右边列表
    function addToRightList(array) {
        var rightAll = getRightAll();
        $.each(array, function (index, item) {
            var has = false; //判断是否已经存在
            $.each(rightAll, function (index, right) {
                if (right.field === item.field) {
                    has = true;
                    return false;
                }
            })
            if (!has) {
                var dom = "";
                dom+='<li title="可进行拖动排序"  data-isSearchConf="' + item.isSearchConf + '" data-field="' + item.field + '" data-title="' + item.title + '" data-status="' + item.status + '" data-functionId="' + item.functionId + '" data-tableTags="' + item.tableTags + '"><label class="mr10"><input class="transfer-input" type="checkbox"><span>' + item.title + '</span></label>' ;
                    if (item.isSearchConf == 1) {
                        dom +='<label><span>查询</span><input class="query-input" type="checkbox"></label>';
                    }
                dom +='</li>';
                $(".right-list").append(dom);
                $("#sortable").sortable();
                $("#sortable").disableSelection();
            }
        })
    }

    //添加到左边列表
    function addToLeftList(array) {
        var leftAll = getLeftAll();
        $.each(array, function (index, item) {
            var has = false; //判断是否已经存在
            $.each(leftAll, function (index, left) {
                if (left.field === item.field) {
                    has = true;
                    return false;
                }
            })
            if (!has) {
                var dom = '<li data-query="' + item.isSearch + '"data-isSearchConf="' + item.isSearchConf + '" data-field="' + item.field + '" data-title="' + item.title + '" data-status="' + item.status + '" data-functionId="' + item.functionId + '" data-tableTags="' + item.tableTags + '"><label><input class="transfer-input" type="checkbox"><span>' + item.title + '</span></label></li>';
                $(".left-list").append(dom);
            }
        })
    }

    //获取左边所有选中项
    function getLeftSelect() {
        var lis = $(".left-list li");
        var array = [];
        lis.each(function (index, el) {
            var checked = $(this).find('.transfer-input').prop("checked");
            if (checked) {
                var obj = {};
                obj["field"] = $(this).data("field");
                obj["title"] = $(this).data("title");
                obj["status"] = $(this).data("status");
                obj["functionId"] = $(this).data("functionId");
                obj["tableTags"] = $(this).data("tableTags");
                obj["query"] = $(this).data("query");
                obj["isSearchConf"] = $(this).data("issearchconf");
                array.push(obj)
            }
        });
        return array;
    }

    //获取右边选中项
    function getRightSelect() {
        var lis = $(".right-list li");
        var array = [];
        lis.each(function (index, el) {
            var checked = $(this).find('.transfer-input').prop("checked");
            if (checked) {
                var obj = {};
                obj["field"] = $(this).data("field");
                obj["title"] = $(this).data("title");
                obj["status"] = $(this).data("status");
                obj["functionId"] = $(this).data("functionId");
                obj["tableTags"] = $(this).data("tableTags");
                obj["isSearchConf"] = $(this).data("issearchconf");
                obj['query'] = $(this).find(".query-input").prop("checked");
                array.push(obj)
            }
        });
        return array;
    }

    //获取右边所有项
    function getRightAll() {
        var lis = $(".right-list li");
        var array = [];
        lis.each(function (index, el) {
            var obj = {};
            obj["field"] = $(this).data("field");
            obj["title"] = $(this).data("title");
            obj["status"] = $(this).data("status");
            obj["functionId"] = $(this).data("functionId");
            obj["tableTags"] = $(this).data("tableTags");
            obj["isSearchConf"] = $(this).data("issearchconf");
            obj['query'] = $(this).find(".query-input").prop("checked");
            array.push(obj)
        });
        return array;
    }

    //获取左边所有项
    function getLeftAll() {
        var lis = $(".left-list li");
        var array = [];
        lis.each(function (index, el) {
            var obj = {};
            obj["field"] = $(this).data("field");
            obj["title"] = $(this).data("title");
            obj["status"] = $(this).data("status");
            obj["functionId"] = $(this).data("functionId");
            obj["tableTags"] = $(this).data("tableTags");
            obj["query"] = $(this).data("query");
            obj["isSearchConf"] = $(this).data("issearchconf");
            array.push(obj)
        });
        return array;
    }

    //提交保存
    function save(calback) {
        $.ajax({
            url: "/page/knlSelectListController/saveSelectList",
            type: 'post',
            data: {"selectJSON": JSON.stringify(getRightAll()), "functionId": functionId},
            cache: false,
            success: function (data) {
                if (data.success) {
                    calback();  //回调处理
                } else {
                    tip(data.msg);
                }
            }
        });
    }
    /* 恢复默认设置 */
    function restSave(calback) {
        $.ajax({
            url: "/page/knlSelectListController/restSave",
            type: 'post',
            data: {"functionId": functionId},
            cache: false,
            success: function (data) {
                if (data.success) {
                    calback();  //回调处理
                } else {
                    tip(data.msg);
                }
            }
        });
    }

</script>

</body>

</html>

