<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>个人信息</title>
    <link rel="stylesheet" href="/resources/sfa/css/normalize.css">
    <link rel="stylesheet" href="/resources/sfa/css/flex.css">
    <link rel="stylesheet" href="/resources/sfa/css/spacing.css">
    <link rel="stylesheet" href="/resources/sfa/css/common.css">
    <style>
        body {
            background: #f3f3f3;
        }

        .info-title {
            height: 40px;
            line-height: 40px;
            color: #000;
            font-weight: 600;
            padding: 0 16px;
        }
    </style>
</head>

<body>
    <div id="app" v-cloak>
        <div class="user-info">
            <div class="info-title">基本信息</div>
        </div>
        <div>
            <list-cell title="账号" :value="user.username"></list-cell>
            <list-cell title="电话" :value="user.mobilephone"></list-cell>
            <list-cell title="部门" :value="user.orgName"></list-cell>
            <list-cell title="职位" :value="user.posName"></list-cell>
        </div>
    </div>

    <script src="/resources/sfa/js/vue.min.js"></script>
    <script src="/resources/sfa/js/common.js"></script>
    <script src="/resources/sfa/js/jquery.min.js"></script>

    <script>
        var vm = new Vue({
            el: "#app",
            name: "UserInfo",
            data: function () {
                return {
                    token: "",
                    user: {}
                }
            },
            created: function () {
                this.token = getParameterByName("token");
                this.loadData();
            },
            computed: {

            },
            methods: {
                loadData: function () {
                    var this_ = this;
                    $.ajax({
                        url: SERVER +
                            "/sfaapi/sfaApi/userCenterApiController/getOwnUserinfo",
                        type: "post",
                        dataType: "json",
                        contentType: 'application/x-www-form-urlencoded',
                        headers: {
                            'loginUserToken': this_.token
                        },
                        success: function (res) {
                            if (res.success) {
                                this_.user = res.objList[0];
                            }else{
                                showError(res.msg)
                            }
                        }
                    })
                },
            }
        })
    </script>
</body>

</html>